<?php
/** 
 * Copyright 2015 Local Thanks(sm), Inc.
 *
 * File: Utils.php
 *
 * Utility Class
 *
 * Inherits Connection Class for 
 * database connections.
 * USE ex.
 * $dbo = $this->connect();
 *
 * @author Michael W Hayden
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */
namespace Localthanks;

class Utils extends Connection implements Key
{
	// Constants
	const PROJECT_NAME           = 'Local Thanks';
	const PROJECT_EMAIL_NO_REPLY = 'noreply@localthanks.com';
	const PROJECT_EMAIL_INFO     = 'info@localthanks.com';
	
	const RESULTS_NO   = 'No Results :(';
	const RESULTS_YES  = 'Results Found :)';
	
	// Url and uri helpers
	const URI_SEPARATOR = '::';
	
	// Global Notices
	const NOTICE_MERCHANT_SIGNUP = 'Is this your business? Add promotions via Local Thanks!';
	const NOTICE_YOU_ARE_HERE  = 'You are here.';
	
	// GOOGLE 
	// - Analytics
	// - client and server API keys
	// - Useful URLs
	// @mwhayden, need to change to LoyaltySuperstore
	const GOOGLE_ANALYTICS_ID   = 'UA-69987455-1';
	const GOOGLE_API_KEY_SERVER = 'AIzaSyBpkTgztTfHpEZ-8KNZ6XgMuv0M9G1ASlI';
	const GOOGLE_API_KEY_CLIENT = 'AIzaSyCtEgdiaxHP7pF9NJp060I84QzyvS2q_iI';
	const GOOGLE_URL_PHOTOS     = 'https://maps.googleapis.com/maps/api/place/photo?';
	const GOOGLE_URL_PLACES     = 'https://maps.googleapis.com/maps/api/place/nearbysearch/json?';	
	const GOOGLE_URL_GEOCODE    = 'https://maps.google.com/maps/api/geocode/json?';
	const GOOGLE_URL_DIRECTIONS = 'https://maps.google.com/?'; // ?q=param

	// Sqoot 
	const SQOOT_API_KEY     = 'dx2afn';
	const SQOOT_URL_DEALS   = 'http://api.sqoot.com/v2/deals?';
	const SQOOT_URL_COUPONS = 'http://api.sqoot.com/v2/coupons?';
	
	// QR code image API
	// @param size = 300x300
	// @param data = Info to be coded.
	const CODE_QR      = 'https://api.qrserver.com/v1/create-qr-code/?';
	const CODE_QR_SIZE = '300x300';

	// Environment path functions, constants
	const DIR_LOGO          = '/cdn/images/logo.png';
	const DIR_CDN           = '/cdn';
	//const DIR_IMG_MERCHANTS = '/images/merchants'; // old
	const DIR_IMG_LIBRARY   = '/images/promo_library';
	const DIR_IMG_DEFAULT   = '/images/promo_defaults'; 
	
	// Images
	const IMG_MAX_WIDTH  = 600;
	const IMG_MAX_HEIGHT = 400;
	
	// User
	const SESSION_EXP = 'Session expired.';
	const SESSION_VALID = 'Session found.';
	
    const USR_LOGIN = 'Logged in.';
    const USR_LOGOUT = 'Logged out.';
    const USR_NONE = 'Please login.';
    const USR_INACTIVE = 'Account inactive.';
    const USR_NOT_FOUND = 'No user found.';
    const USR_SIGNUP = 'Signup now!';
    const USR_SIGNUP_WELCOME = 'Registration success. Welome! You are now logged in.';
    const USR_PASS_ERROR = 'Passwords do not match.';
    
    const USR_URL_LOGIN = 'login.html';

    const USR_RESET = 'Enter account email.';
	const USR_RESET_SENT = 'Email sent. Please verify.';
	const USR_RESET_ERROR = 'Unknown error. Please contact the administrator.';
	const USR_RESET_ERROR_MAIL = 'Mail error. Try again or contact the administrator.';  
	const USR_RESET_VERIFIED = 'Verified. Enter new credentials.';
	const USR_RESET_COMPLETE = 'Success! Password is now changed.';
	
	const USR_EMAIL_INVALID = 'Invalid email address format.';
	const USR_EMAIL_IN_USE = 'Email is already in use. Please login.';
	
	const USR_EMPTY_FIELDS = 'Please fill out all fields.';
	
	// General use
	const USR_API_CRYPT_KEY = 'hwzLgqR1vcoVVU9AQfrXet1zHGuLNHFwSXSz6UUlB6o4iedWW1BARtZIdIGgRqyD';
	
	
	
	// Path Functions
	// return domain environment from the application server
	
	// Add string to replace :tags
	public static function environment( $str=null ) {
		$env = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') ? 'https': 'http';
		$env = $env.'://'.$_SERVER['HTTP_HOST'];
		if( $str ) :
			$str = str_replace(':env',$env,$str);
			$str = str_replace(':earth',static::earth(),$str);
			$str = str_replace(':cdn',static::DIR_CDN,$str);
			$str = str_replace(':img_library',static::DIR_IMG_LIBRARY,$str);
			$str = str_replace(':img_default',static::DIR_IMG_DEFAULT,$str);
			$str = str_replace(':img_logo',static::DIR_LOGO,$str);
			$env = $str; // last
		endif;
		return $env;
	}

	// return content delivery network link
	public function contentDeliveryNetwork() {
		return static::environment().static::DIR_CDN;
	}
 
	public function dynamicImgDir( $image ) {
		// dynamic merchant image directory
		$dir =''; $i=0;
		$regex = "/:img_(\d)_merchants/";
		preg_match($regex, $image, $ltb_id);
		$sub_id=substr( $ltb_id[1], 0, 2 ); 
		
		if(!empty( $ltb_id[1] )) {
			do { 
				$dir.=(empty($dir)?'':'/').$sub_id;
				$i+=2;
				$sub_id =substr($ltb_id[1], $i, 2);
			}
			while ($sub_id && !empty( $sub_id ));
		}
		return preg_replace($regex,"/merchant-custom-files/{$dir}/_files/img",$image);
 	}
 	
	//
    // Request API param variable functions
    // Sets defaults
    	
	// @param $_REQUEST['limit']
	// Data Request Limit
	public function getLimit() {
		return ( $_REQUEST['limit'] ) ? intval($_REQUEST['limit']): 20;
	}
	
	// @param $_REQUEST['mode']
	// 0 = Promotions, default or 1 = Merchants
	public function getMode() {
		return ( $_REQUEST['mode'] ) ? intval($_REQUEST['mode']): 0;
	}
	
	// @param $_REQUEST['offset']
	// Data Request Offset
	public function getOffset() {
		return ( $_REQUEST['offset'] ) ? intval($_REQUEST['offset']): 0;
	}
	
	// @param $_REQUEST['sort']
	// Sort by 0 = Distance, default or 1 = Best Match
	public function getSort() {
		return ( $_REQUEST['sort'] ) ? intval($_REQUEST['sort']): 0;
	}
	
	// @param $_REQUEST['cat']
	// Search by (cat)egory
	public function getCat() {
		return ( $_REQUEST['cat'] ) ? urldecode($_REQUEST['cat']): '';
	}
	
	// @param $_REQUEST['term']
	// Get ltm_id's by keyword or (term)s
	public function getTerm() {
		return ( $_REQUEST['term'] ) ? urldecode($_REQUEST['term']): '';
	}

	// @param $_REQUEST['radius']
	// Radius in kilometers
	public function getRadius() {
		return ( $_REQUEST['radius'] ) ? intval($_REQUEST['radius']): 50;
	}
	
	// User location functions

	// @param $_REQUEST['lat']
	// Latitude Point
	public function getLat() {
		return $_REQUEST['lat'];
	}
	
	// @param $_REQUEST['lng']
	// Longitude Point
	public function getLng() {
		return $_REQUEST['lng'];
	}
	
	// @param $_REQUEST['ll']
	// Longitude Point
	public function getLatLng() {
		return $_REQUEST['ll'];
	}
	
	/*
	 * Search by Locality
     * @param $_REQUEST['locality']
     *
     * Check location by Google maps API
     */ 
    public function getLocality( $loc=null ) {
    	$google['address']  =  ( $loc ) ? $loc: $_REQUEST['locality'];
    	if( !empty( $google['address'] ) ) {
			$google = static::GOOGLE_URL_GEOCODE.http_build_query( $google );
			$google = json_decode(@file_get_contents( $google ));
			switch( $google->status ) {
				case            'OK' : 
					$_REQUEST[static::SEARCH_LAT] = $google->results[0]->geometry->location->lat;
					$_REQUEST[static::SEARCH_LNG] = $google->results[0]->geometry->location->lng;
					break;
				case 'UNKNOWN_ERROR' : 
					static::getLocality( $loc ); 
					break;
			}
			return $google;
		}
		return '';
	}
 
	/*
	 * Establish User Location.
	 *
	 * Lets check the request for latitude
	 * and longitude settings. If not set,
	 * check by zip code and fallback
	 * to lat, long by IP addr.
	 *
	 * @request lat, lng, ll, zip
	 * @cookie lat, lng, ll
	 */
	protected function userLocation( $ip )
	{    	
    	// Check request
    	if( empty( $_REQUEST['lat'] ) &&
    		empty( $_REQUEST['lat'] ) ) {
    		if( isset( $_REQUEST['zip'] ) )
    			$loc = static::getLocality( $_REQUEST['zip'] );
			if( $loc->status == 'OK' ) :
				$_REQUEST['lat'] = $loc->results[0]->geometry->location->lat;
				$_REQUEST['lng'] = $loc->results[0]->geometry->location->lng;
			else :
				$loc  = explode(',',static::getLocationByIP( $ip ));
				$_REQUEST['lat'] = $loc[0];
				$_REQUEST['lng'] = $loc[1];
			endif;
		}
		// ll is used for user
		$_REQUEST['ll']  = implode(',',array($_REQUEST['lat'], $_REQUEST['lng']));
		
		// Set some location cookies
		$expires = time() + ((86400 * 30) * 7); // 1 week
		//setcookie('lat', $_REQUEST['lat'], $expires, '/');
    	//setcookie('lng', $_REQUEST['lng'], $expires, '/');
    	//setcookie('ll',  $_REQUEST['ll'],  $expires, '/');
	}
	
	// Get Location by IP
	// Retrieve a Latitude and Longitude 
	// by IP using:
	//
	// http://freegeoip.net ( 1000 per hour )
	//
	// with fallback:
	// http://ipinfo.io ( 1000 req per day )
	//
	// and last falback:
	// http://ipinfodb.com (slow, have account key)
	// UN: localthanks, mike@loyaltysuperstore.com
	public static function IPLocation($ip)
	{
		if(!$ip) return NULL;
		if(!isset($_REQUEST[static::IPADDR_LAT]) 
		or !isset($_REQUEST[static::IPADDR_LNG])) {
			// Try Free Geo IP
			if ($loc=@file_get_contents("http://freegeoip.net/json/$ip")) {
				$loc=json_decode($loc);
				$arr=array($loc->latitude,$loc->longitude);
			}
			// Try IP Info
			elseif
		   	   ($loc=@file_get_contents("http://ipinfo.io/$ip")) {
				$loc=json_decode($loc);
				$arr=explode(',',$loc->loc);
			}
			// Last fallback
        	else {
        		$loc=array('ip' =>$ip,'format'=>'json',
			    'key'=>'b30da4d2c699b00ecd9ffd2f29fbceb30c40605e4a47b217c573b0a8b5d03ac8');
				$loc='http://api.ipinfodb.com/v3/ip-city/?'.http_build_query($loc);
				$ch =curl_init();
				curl_setopt($ch, CURLOPT_URL, $loc);
        		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        		$loc=json_decode(curl_exec($ch));
        		curl_close($ch);
				$arr=array($loc->latitude,$loc->longitude);
        	}
        	// Set an IP lat long cookie
        	$exp=time() + ((86400 * 30) * 6);
        	setcookie(static::IPADDR_LAT, $arr[0], $exp, '/');
        	setcookie(static::IPADDR_LNG, $arr[1], $exp, '/');
        	$_REQUEST[static::IPADDR_LAT]=$arr[0];
        	$_REQUEST[static::IPADDR_LNG]=$arr[1];
        }
	}
	
	public function searchLocation() {   	
		$searchLat=$_REQUEST[static::SEARCH_LAT];
		$searchLng=$_REQUEST[static::SEARCH_LNG];
		$ipAddrLat=$_REQUEST[static::IPADDR_LAT];
		$ipAddrLng=$_REQUEST[static::IPADDR_LNG];
		$postCode =self::getZipCode($_REQUEST[static::POSTCODE]);
		
    	if((!isset($seachLat) or !isset($searchLng)) and !empty($postCode)) {
    		$google=array('address'=>$postCode);
			$google=static::GOOGLE_URL_GEOCODE.http_build_query($google);
			$google=json_decode(@file_get_contents($google));
			switch($google->status) {
				case 'OK': 
					$searchLat=$google->results[0]->geometry->location->lat;
					$searchLng=$google->results[0]->geometry->location->lng;
					break;
				default:
					if (!empty($ipAddrLat) or !empty($ipAddrLng)) {
						$searchLat=$ipAddrLat;
						$searchLng=$ipAddrLng; 
					} 
					break;
			}
			// Set some location cookies
			$exp=time() + ((86400 * 30) * 6);
			setcookie(static::SEARCH_LAT, $searchLat, $exp, '/');
    		setcookie(static::SEARCH_LNG, $searchLng, $exp, '/');
    		$_REQUEST[static::SEARCH_LAT]=$searchLat;
    		$_REQUEST[static::SEARCH_LNG]=$searchLng;
 		}
	}


	/*
	 * Determine IP address
	 */
	public function getIP() {
   		if (getenv('HTTP_CLIENT_IP'))
        	$ip = getenv('HTTP_CLIENT_IP');
    	elseif(getenv('HTTP_X_FORWARDED_FOR'))
        	$ip = getenv('HTTP_X_FORWARDED_FOR');
    	elseif(getenv('HTTP_X_FORWARDED'))
        	$ip = getenv('HTTP_X_FORWARDED');
    	elseif(getenv('HTTP_FORWARDED_FOR'))
        	$ip = getenv('HTTP_FORWARDED_FOR');
    	elseif(getenv('HTTP_FORWARDED'))
        	$ip = getenv('HTTP_FORWARDED');
    	elseif(getenv('REMOTE_ADDR'))
        	$ip = getenv('REMOTE_ADDR');
    	else
        	$ip = false;	
		
		return filter_var( $ip, FILTER_VALIDATE_IP );
	}
	
	/*
	 * Get Location by IP
	 *
	 * Retrieve a Latitude and Longitude 
	 * by IP using:
	 *
	 * http://freegeoip.net ( 1000 per hour )
	 *
	 * with fallback:
	 * http://ipinfo.io ( 1000 req per day )
	 *
	 * and last falback:
	 * http://ipinfodb.com (slow, have account key)
	 */
	
	// IP Info API's
	const IP_URL_IPINFO       = 'http://ipinfo.io';
	const IP_URL_FREEGEOIP    = 'http://freegeoip.net/json';
	const IP_URL_IPINFODB     = 'http://api.ipinfodb.com/v3/ip-city/?';
    const IP_API_KEY_IPINFODB = 'b30da4d2c699b00ecd9ffd2f29fbceb30c40605e4a47b217c573b0a8b5d03ac8';

	protected function getLocationByIP( $ip )
	{		
		// Check ip, if not, set one.
		if( !ip ) static::getIP();
		
		// Try Free Geo IP
		$location = @file_get_contents(static::IP_URL_FREEGEOIP."/$ip");
		
		if( $location ) {
			$location = json_decode( $location );
			return implode(',',array($location->latitude,$location->longitude));
		}
		
		// Try IP Info
		$location = @file_get_contents(static::IP_URL_IPINFO."/$ip");
		
		if( $location ) {
			$location = json_decode( $location );
			return $location->loc;
		}
		// Last fallback. 
        // 
        // Note: Responds slow as shit
        // UN: localthanks, mike@loyaltysuperstore.com
        else {
        	$ipinfodb['ip']     = $ip;
			$ipinfodb['key']    = static::IP_API_KEY_IPINFODB;
			$ipinfodb['format'] = 'json';
			$ipinfodb = static::IP_URL_IPINFODB.http_build_query($ipinfodb);
			
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $ipinfodb);
        	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        	$location = json_decode(curl_exec($ch));
        	curl_close($ch);
        	
        	// Add default lat long if this messed up
        	if( $location->statusCode != 'OK' ) {
        		$location->latitude    = 26.29770909090909090;
        		$location->longitude   = -80.1776090909090909;
        	}
        	return implode(',',array($location->latitude,$location->longitude));
        }
    }


	// Useful functions 
	
	/*
	 * Sanitize data
	 * clean up data types.
	 */
	public static function sanitize( $data ) 
	{
		if( is_array($data) ) :         // array
	   		foreach ($data as $k => $v) 
			$data[$k] = static::sanitize($v);
		elseif( is_float($data) ) : 	// float
			$data = floatval($data);
		elseif( is_int($data) ) :    	// int
			$data = intval($data);
		else :                          // string
			// output cleaned html
			$data = static::sanitizeHTML( $data );
		endif;
		return $data;
	}
	
	/**
 	 * Remove HTML tags, including invisible text such as style and
 	 * script code, and embedded objects.  Add line breaks around
 	 * block-level tags to prevent word joining after tag removal.
 	 */
	public static function sanitizeHTML( $text )
	{
		// .              a single character
		// \s             a whitespace character (space, tab, newline)
		// \S             non-whitespace character
		// \d             a digit (0-9)
		// \D             a non-digit
		// \w             a word character (a-z, A-Z, 0-9, _)
		// \W             a non-word character
		// [aeiou]        matches a single character in the given set
		// [^aeiou]       matches a single character outside the given set
		// (foo|bar|baz)  matches any of the alternatives specified
		
    	$text = preg_replace(
			array(
          // Remove invisible content
        	'@<head[^>]*?>.*?</head>@siu',
            '@<style[^>]*?>.*?</style>@siu',
            '@<script[^>]*?.*?</script>@siu',
            '@<object[^>]*?.*?</object>@siu',
            '@<embed[^>]*?.*?</embed>@siu',
            '@<applet[^>]*?.*?</applet>@siu',
            '@<noframes[^>]*?.*?</noframes>@siu',
            '@<noscript[^>]*?.*?</noscript>@siu',
            '@<noembed[^>]*?.*?</noembed>@siu',
          // Add line breaks before and after blocks
            '@</?((address)|(blockquote)|(center)|(del))@iu',
            '@</?((div)|(h[1-9])|(ins)|(isindex)|(p)|(pre))@iu',
            '@</?((dir)|(dl)|(dt)|(dd)|(li)|(menu)|(ol)|(ul))@iu',
            '@</?((table)|(th)|(td)|(caption))@iu',
            '@</?((form)|(button)|(fieldset)|(legend)|(input))@iu',
            '@</?((label)|(select)|(optgroup)|(option)|(textarea))@iu',
            '@</?((frameset)|(frame)|(iframe))@iu',
            
            
        	),
        	array(
            ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
            "\n\$0", "\n\$0", "\n\$0", "\n\$0", "\n\$0", "\n\$0",
            "\n\$0", "\n\$0",
        	),
        	$text 
        );
        $text = urldecode( $text );
		$text = strip_tags( $text );
		//$text = htmlspecialchars( $text, ENT_QUOTES, 'UTF-8' );
 
		// some funky stuff from api's
		// add to preg replace!!!
		$text = str_replace(array('  ','--'),' ',$text);
		$text = str_replace(array('$','$ $','$$'),' $',$text);
		$text = str_replace(array('&amp;amp;','&AMP'),'&amp;',$text);
		$text = str_replace(array('"'),"'",$text);
		
		// limit line breaks
		$text = preg_replace( '/(?:(?:\r\n|\r|\n)\s*){2}/s', "\n\n", $text ); 
		
		return trim( $text );
	}

	// generate a random key
	public static function keygen() {
		return md5(uniqid(rand(),true)).md5(uniqid(rand(),true));
	}
	
	// generate a random code, length
	public static function codegen( $length=5 ) {
		return substr(md5(microtime()),rand(0,26),$length);
	}
	
	// cheap php object to array converter
	private static function object_to_array( $data ) {
		return json_decode(json_encode($data), true);
	}
	
	// lets make nice names
	public static function capitilize( $name ) {
		return ucwords(strtolower($name));
	}
	
	// format phone number
	// optional adds string after and inserts linebreak.
	public static function phoneFormat( $phone, $str='' ) 
	{
		$phone = preg_replace('/\D/', '', $phone);
		
		switch(strlen($phone)) {
			case  7:  $phone = preg_replace('/^(\d{3})(\d{4})$/i', '$1-$2', $phone);
			case 10:  $phone = preg_replace('/^(\d{3})(\d{3})(\d{4})$/i', '($1) $2-$3', $phone);
			case 11:  $phone = preg_replace('/^(\d{1})(\d{3})(\d{3})(\d{4})$/i', '$1 ($2) $3-$4', $phone);
			case 20:  $phone = preg_replace('/^(\d{3})(\d{3})(\d{4})(\d{3})(\d{3})(\d{4})$/i', '($1) $2-$3 or ($4) $5-$6', $phone);
			case 22:  $phone = preg_replace('/^(\d{1})(\d{3})(\d{3})(\d{4})(\d{1})(\d{3})(\d{3})(\d{4})$/i', '$1 ($2) $3-$4 or $5 ($6) $7-$8', $phone);
		}
		// Optional string at the end.
		if(!empty($str)) $phone = $phone.((!empty($phone))?"\n":'').$str;
		
		return $phone; 
	}
 
	// Vicinity Format
	// @var $address, $city, $st, $zip
	// Create best location from address parts 
	public static function vicinityFormat($address,$locality,$region,$post_code) {
		$vicinity = '';
		if(!empty($address))   $vicinity.= $address." \n";
		if(!empty($locality))  $vicinity.= $locality.' ';
		if(!empty($region))    $vicinity.= $region.' ';
		if(!empty($post_code)) $vicinity.= $post_code;
		return $vicinity;
	}
	
	// Format address for google url search
	public static function vicinityURLFormat($vicinity) 
	{
		$regex = array(
			'/[\s\t\n\r]/'       =>'+',
			'/[^A-Za-z0-9\-\+]/' =>''
		);
		return preg_replace(
			array_keys($regex),
			array_values($regex),
			$vicinity
		);
	}
	
	
	// format date
	public static function dateFormat($date, $format='M d Y h:i A') {
		$date = new \DateTime($date);
		return $date->format($format);
	}
	
	// format date
	public static function dateDiff($date) {
		$date = new \DateTime($date);
		$now  = new \DateTime(date('Y-m-d H:i:s'));
		$diff = $date->diff($now);
		return $diff->format('%R%a');
	}
 
	// Extract ZipCode from string
	public static function getZipCode( $str ) 
	{
		// Explain "/\b[A-Z]{2}\s+\d{5}(-\d{4})?\b/"
		//------------------------------------------
		// \b         # word boundary
		// [A-Z]{2}   # two letter state code
		// \s+        # whitespace
		// \d{5}      # five digit zip
		// (-\d{4})?  # optional zip extension
		// \b         # word boundary
    	$zip = preg_match( "/\b\d{5}(-\d{4})?\b/", $str, $matches );
    	return $matches[0];
	}	
	
	
	
	// Distance Calculations
	
	// Earth radius, various systems
	const RAD_REQ_UNIT = 'distance_unit';
	const RAD_EARTH_MI = 3959;
	const RAD_EARTH_KM = 6372.795477598;
	const RAD_EARTH_NM = 3440;
	
	// get earth radius 
	public static function earth() {
		switch( static::distanceUnit() ) {
			case 'km' : return static::RAD_EARTH_KM;
			case 'nm' : return static::RAD_EARTH_NM;
			case 'mi' :
			default   : return static::RAD_EARTH_MI;
		}
	}
	
	// check for distance measurement unit
	public static function distanceUnit() {
		switch( $_REQUEST[ static::RAD_REQ_UNIT ] ) {
			case 'kilometer':
			case 'km'       :
			case 'k'        : return 'km';
			case 'nautical' :
			case 'nmi'      :
			case 'nm'       :
			case 'n'        : return 'nm';
			case 'mile'     :
	        case 'miles'    :
			case 'mi'       :
			case 'm'        :
			default         : return 'mi';
		}
	}
 
	// Lat Long Geometry
	
	// Determines distance between two points on a sphere
	public static function distance( $lat1, $lon1, $lat2, $lon2, $decimal=2, $unit=null ) 
	{
		$theta = $lon1 - $lon2; // change in longitude 
		$dist  = rad2deg(
					  acos(
						sin(deg2rad($lat1)) * 
						sin(deg2rad($lat2)) + 
						cos(deg2rad($lat1)) * 
						cos(deg2rad($lat2)) * 
						cos(deg2rad($theta))
					  )
				);
		$miles = $dist * 60 * 1.1515;
		
		if( !$unit ) $unit = static::distanceUnit();
		
		switch  ( $unit ) {
			case 'km': return round(($miles * 1.609344), $decimal); // kilometers
			case 'nm': return round(($miles * 0.8684), $decimal);   // nautical miles
			case 'mi': 
			default  : return round($miles, $decimal);              // miles, default
		}
	}
 
	// Determines midpoint between two points on a sphere
	// -needs work
	public static function midpoint($lat1, $lon1, $lat2, $lon2)
	{
    	$lat1 = deg2rad($lat1);
    	$lon1 = deg2rad($lon1);
    	$lat2 = deg2rad($lat2);
    	$lon2 = deg2rad($lon2);
    	$dlng = $lon2 - $lon1;
    	
    	$Bx   = cos($lat2) * cos($dlng);
    	$By   = cos($lat2) * sin($dlng);
    	$pi   = pi();
    	
    	$lat  = (atan2( 
    				sin($lat1) + sin($lat2),
    				sqrt(
    					(cos($lat1) + $Bx) * 
    					(cos($lat1) + $Bx) + $By * $By
    				)
    			) * 180 ) / $pi;
    	$lon = ($lng1 + atan2($By, (cos($lat1) + $Bx)) * 180) / $pi;

    	return $lat.','.$lon;
	}
	
	// Min-Max, bounding box
	// Returns object array.
	//
	// Optional as return string
	// when the $str option is used.
	// Will replace string with 
	// bound :tags if used.
	public static function bounds( $lat, $lng, $radius, $str=null ) 
	{
		$earth  = static::earth();
		$center = implode(',',array( $lat, $lng ));
		$device = $_REQUEST[static::DEVICE_LAT];
		$minlat = $lat - rad2deg($radius / $earth);
		$maxlat = $lat + rad2deg($radius / $earth);
		$minlng = $lng - rad2deg($radius / $earth / cos( deg2rad($lat) ));
		$maxlng = $lng + rad2deg($radius / $earth / cos( deg2rad($lat) ));

		$bounds = (object) array(
			'lat'       => $lat,
			'lng'       => $lng,
			'radius'    => $radius,
			'center'    => $center,
			'device'    => $device,
			'minlat'    => $minlat,
			'maxlat'    => $maxlat,
			'minlng'    => $minlng,
			'maxlng'    => $maxlng,
            'northeast' => array( 
            	'lat'   => $maxlat,
                'lng'   => $maxlng
             ),
            'southwest' => array(
				'lat'   => $minlat,
                'lng'   => $minlng
             )
		);

		if( $str )
			foreach( $bounds as $k => $v )
				$str = str_replace( ":$k", $v, $str );
		
		return ( $str ) ? $str: $bounds;
	}


	// Mail system functions
	/*
	 * Email Header array
	 * optionals $Cc $Bcc
	 */
	function emailHeaders( $Cc=null, $Bcc=null ) {
		// To send HTML mail, the Content-type header must be set
		$headers   = array();
		$headers[] = 'MIME-Version: 1.0';
		$headers[] = 'Content-type: text/html; charset=iso-8859-1';
		$headers[] = 'From: '.static::PROJECT_NAME.' <'.static::PROJECT_EMAIL_NO_REPLY.'>';
		if( $Cc )
		$headers[] = "Cc: $Cc";
		if( $Bcc )
		$headers[] = "Bcc: $Bcc";
		$headers[] = 'Reply-To: '.static::PROJECT_NAME.' <'.static::PROJECT_EMAIL_INFO.'>';
		$headers[] = "Subject: $subject";
		$headers[] = 'X-Mailer: PHP/'.phpversion();
		$headers   = implode("\r\n", $headers);
		
		return $headers;
	}

/*
    
    // File server settings
    private function serverCDNFileDir() 
    {
    	return $_SERVER['DOCUMENT_ROOT'].'/cdn';
    }
    
    
	// Performance reporting
	function debugPagePerformance( $arr, $endPerformance, $ip, $output='performance.json' ) {
		$env = $this->serverCDNFileDir();
		
		$data[] = $arr;
		$data['performance'] = $endPerformance;
		$data['timestamp'] = date("Y-m-d H:i:s");
		$data['ip_address'] = $ip;
		$file = "{$env}/json/{$output}";
		$inp = file_get_contents($file);
		$tempArray = json_decode($inp);
		array_push($tempArray, $data);
		$jsonData = json_encode($tempArray);
		file_put_contents($file, $jsonData);
	}
*/
    
    // MySQL fields
	// Add string to replace :tags
	// Add tag to key, and replace to the
	// value to be replace. 
	// returns sql string. 
	protected function replaceSQL( $sql ) {
		// Rendered fields
		$sql = str_replace(':lt_member_merchants',static::memberFields(),$sql);
		$sql = str_replace(':lt_merchants',static::merchantFields(),$sql);
		$sql = str_replace(':lt_promos',static::promoFields(),$sql);
		$sql = str_replace(':tbl_consumer',static::consumerFields(),$sql);
		
		$term = static::getTerm();
		if($term || $term !='') 
			$value = 'AND (lt_merchants.ltm_company_name LIKE :term1 
						OR lt_merchants.ltm_city LIKE :term2 
						OR lt_merchants.ltm_zipcode LIKE :term3) ';
		else
			$value = '';
		$sql = str_replace(':TERM',$value,$sql);
		
		// Data Sorting
		switch( static::getSort() ) {
			case 3 : $order = 'lt_merchants.ltm_company_name DESC'; break;
			case 2 : $order = 'lt_merchants.ltm_company_name ASC'; break;
			case 1 : $order = 'distance DESC'; break;
			case 0 :
			default: $order = 'distance ASC'; break;
		}
		$sql = str_replace(':sort',$order,$sql);
		return  $sql;
	}
	
	/*
	 * SQL Merchants By ltm_id (comma delimited)
	 *
	 * @params :ltm_id, :limit, :offset
	 * @fields :lt_merchants, :lt_member_merchants, :sort
	 */
	public function selectMerchantsByID( $ltm_id ) {
		return static::replaceSQL( static::SQL_SELECT_MERCHANT_BY_ID );
	}
    const SQL_SELECT_MERCHANT_BY_ID = '
		SELECT 
			:lt_merchants,
			:lt_member_merchants
		FROM lt_merchants
		INNER JOIN lt_member_merchants 
			ON lt_member_merchants.ltb_id=lt_merchants.ltb_id 
		WHERE lt_merchants.ltm_active!=0
		AND lt_merchants.ltm_id IN (:ltm_id)
		ORDER BY :sort 
		LIMIT :limit 
		OFFSET :offset';
	
	/*
	 * SQL Merchants By location
	 *
	 * @params :ltm_id, :limit, :offset
	 * @fields :lt_merchants, :lt_member_merchants, :sort
	 * @bounds :minlat, :maxlat, :minlng, :maxlng
	 */
	public function selectMerchantsByLocation( $ltm_id ) {
		return static::replaceSQL( static::SQL_SELECT_MERCHANT_BY_LOCATION );
	}
	const SQL_SELECT_MERCHANT_BY_LOCATION = '
		SELECT 
			:lt_merchants,
			:lt_member_merchants
		FROM lt_merchants
		INNER JOIN lt_member_merchants 
			ON lt_member_merchants.ltb_id=lt_merchants.ltb_id 
		WHERE lt_merchants.ltm_active!=0
		:TERM
		AND lt_merchants.ltm_lat  
			BETWEEN :minlat AND :maxlat
		AND lt_merchants.ltm_long 
			BETWEEN :minlng AND :maxlng
		ORDER BY :sort 
		LIMIT :limit 
		OFFSET :offset';

	/*
	 * SQL Merchant Promotions By ltm_id (comma delimited)
	 *
	 * @params :ltm_id, :limit, :offset
	 * @fields :lt_merchants, :lt_member_merchants, :lt_promos, :sort
	 */
	public function selectMerchantPromotionsByID( $ltm_id ) {
		return static::replaceSQL( static::SQL_SELECT_MERCHANT_PROMOS_BY_ID );
	}
    const SQL_SELECT_MERCHANT_PROMOS_BY_ID = '
    	SELECT 
			:lt_merchants,
			:lt_member_merchants,
			:lt_promos
		FROM lt_promos 
		INNER JOIN lt_merchants 
			ON lt_promos.ltb_id=lt_merchants.ltb_id 
		INNER JOIN lt_member_merchants 
			ON lt_member_merchants.ltb_id=lt_merchants.ltb_id 
		WHERE lt_merchants.ltm_active!=0
		AND lt_merchants.ltm_id IN (:ltm_id)
		AND NOW() 
			BETWEEN lt_promos.ltp_startdate AND lt_promos.ltp_enddate
		ORDER BY :sort 
		LIMIT :limit 
		OFFSET :offset';
		
	/*
	 * SQL Member Merchant Promotions By ltm_id (comma delimited)
	 *
	 * @params :ltb_id, :sinlat, :coslat, :coslng
	 * @fields :lt_merchants, :lt_member_merchants, :lt_promos
	 */
	public function selectMemberMerchantPromotionsByID() {
		return static::replaceSQL( static::SQL_SELECT_MEMBER_MERCHANT_PROMOS_BY_ID );
	}
    const SQL_SELECT_MEMBER_MERCHANT_PROMOS_BY_ID = '
    	SELECT 
			:lt_merchants,
			:lt_member_merchants,
			:lt_promos
		FROM lt_promos 
		INNER JOIN lt_member_merchants 
			ON lt_promos.ltb_id=lt_member_merchants.ltb_id 
		INNER JOIN lt_merchants 
			ON lt_member_merchants.ltb_id=lt_merchants.ltb_id 
		WHERE lt_member_merchants.ltm_active!=0
		AND lt_member_merchants.ltb_id IN (:ltb_id)
		AND NOW() 
			BETWEEN lt_promos.ltp_startdate AND lt_promos.ltp_enddate';
			
	/*
	 * SQL Member Merchant Promotions By csm_id
	 *
	 * @params :ltb_id, :sinlat, :coslat, :coslng
	 * @fields :lt_merchants, :lt_member_merchants, :lt_promos
	 */
	public function selectMemberMerchantPromotionsByCSMID() {
		return static::replaceSQL( static::SQL_SELECT_MEMBER_MERCHANT_PROMOS_BY_CSM_ID );
	}

	const SQL_SELECT_MEMBER_MERCHANT_PROMOS_BY_CSM_ID = '
		SELECT DISTINCT 
    		:lt_merchants,
			:lt_member_merchants,
			:lt_promos
		FROM lt_promos
		INNER JOIN lt_member_merchants ON lt_promos.ltb_id=lt_member_merchants.ltb_id
		INNER JOIN lt_merchants ON lt_merchants.ltb_id=lt_member_merchants.ltb_id
    	INNER JOIN tbl_consumer 
    	    ON tbl_consumer.ltm_pick_id=lt_merchants.ltm_id
		WHERE lt_member_merchants.ltb_active 
		AND lt_merchants.ltm_active 
		AND (
	 		(NOW() < lt_promos.ltp_enddate AND NOW() > lt_promos.ltp_startdate) 
	 		OR      (lt_promos.ltp_enddate IS NULL AND lt_promos.ltp_startdate IS NULL)
		) 	
		AND lt_promos.ltp_active
		AND tbl_consumer.csm_id=:csm_id
		LIMIT 8';
	
	/*
		SELECT
    		:lt_merchants,
			:lt_member_merchants,
			:lt_promos
		FROM lt_promos
		INNER JOIN lt_member_merchants 
			ON lt_promos.ltb_id=lt_member_merchants.ltb_id
		INNER JOIN lt_merchants 
			ON lt_merchants.ltb_id=lt_member_merchants.ltb_id
		INNER JOIN tbl_consumer 
    	    ON tbl_consumer.ltm_pick_id=lt_merchants.ltm_id
		WHERE lt_member_merchants.ltb_active 
		AND lt_merchants.ltm_active 
		AND (
	 		(NOW() < lt_promos.ltp_enddate AND NOW() > lt_promos.ltp_startdate) 
	 		OR (lt_promos.ltp_enddate IS NULL AND lt_promos.ltp_startdate IS NULL)
		) 	
		AND lt_promos.ltp_active
		AND tbl_consumer.csm_id IN (:csm_id)
		LIMIT 8';
		*/
/*
    // Why does this not match with web?
    const SQL_SELECT_MEMBER_MERCHANT_PROMOS_BY_CSM_ID = '
    	SELECT
    		:lt_merchants,
			:lt_member_merchants,
			:lt_promos
			
    	FROM lt_member_merchants
    	
    	INNER JOIN lt_merchants 
    		ON lt_merchants.ltb_id=lt_member_merchants.ltb_id
    		
    	INNER JOIN tbl_consumer 
    	    ON tbl_consumer.ltm_pick_id=lt_merchants.ltm_id
    	    
    	INNER JOIN lt_promos
    	    ON lt_promos.ltb_id=lt_member_merchants.ltb_id 
    	    
		WHERE lt_promos.ltp_active!=0
		AND (
			NOW() 
			BETWEEN lt_promos.ltp_startdate 
			AND     lt_promos.ltp_enddate
		)
		AND tbl_consumer.csm_id IN (:csm_id)';
		*/
 /*

// == ORIGINAL ORLANDO ==
SELECT DISTINCT PRM.ltp_promo_type, PRM.ltp_id, PRM.ltp_headline, PRM.ltp_description, PRM.ltp_promo_code, PRM.ltp_image
	FROM lt_promos PRM
	INNER JOIN lt_member_merchants MMC ON PRM.ltb_id=MMC.ltb_id
	INNER JOIN lt_merchants MRC ON MRC.ltb_id=MMC.ltb_id
    INNER JOIN tbl_consumer CSM
    	    ON CSM.ltm_pick_id=MRC.ltm_id
	WHERE MMC.ltb_active 
	AND MRC.ltm_active 
	AND (
	 (NOW() < PRM.ltp_enddate AND NOW() > PRM.ltp_startdate) 
	 OR (PRM.ltp_enddate IS NULL AND PRM.ltp_startdate IS NULL)
	) 	
	AND PRM.ltp_active
	AND CSM.csm_id=118
	LIMIT 8
	
	AND PRM.ltp_id NOT IN ({$request['deals_id_list']})
	ORDER BY POW(POW((:customerlat-MRC.ltm_lat),2)+(POW((:customerlong-MRC.ltm_long),2)),(1/2))
	LIMIT ".$_Limit
	
*/
	
	/*
	 * SQL Promotions By ltp_id (comma delimited)
	 *
	 * @params :ltp_id, :limit, :offset
	 * @fields :lt_merchants, :lt_member_merchants, :lt_promos, :sort
	 */
	public function selectPromotionsByID( $ltp_id ) {
		return static::replaceSQL( static::SQL_SELECT_PROMOS_BY_ID );
	}
	const SQL_SELECT_PROMOS_BY_ID = '
		SELECT 
			:lt_merchants,
			:lt_member_merchants,
			:lt_promos
		FROM lt_promos 
		INNER JOIN lt_merchants 
			ON lt_promos.ltb_id=lt_merchants.ltb_id 
		INNER JOIN lt_member_merchants 
			ON lt_member_merchants.ltb_id=lt_merchants.ltb_id 
		WHERE lt_merchants.ltm_active!=0
		AND lt_promos.ltp_id IN (:ltp_id)
		AND NOW() 
			BETWEEN lt_promos.ltp_startdate AND lt_promos.ltp_enddate
		ORDER BY :sort 
		LIMIT :limit 
		OFFSET :offset';
		
	/*
	 * SQL Merchant Promotions By location
	 *
	 * @params :ltm_id, :limit, :offset
	 * @fields :lt_merchants, :lt_member_merchants, :sort
	 * @bounds :minlat, :maxlat, :minlng, :maxlng
	 */
	public function selectMerchantPromotionsByLocation( $ltm_id ) {
		return self::replaceSQL( static::SQL_SELECT_MERCHANT_PROMOS_BY_LOCATION );
	}
	const SQL_SELECT_MERCHANT_PROMOS_BY_LOCATION = '
		SELECT 
			:lt_merchants,
			:lt_member_merchants,
			:lt_promos
		FROM lt_promos 
		INNER JOIN lt_merchants 
			ON lt_promos.ltb_id=lt_merchants.ltb_id 
		INNER JOIN lt_member_merchants 
			ON lt_member_merchants.ltb_id=lt_merchants.ltb_id 
		WHERE lt_merchants.ltm_active!=0
		:TERM
		AND ((NOW() BETWEEN lt_promos.ltp_startdate AND lt_promos.ltp_enddate) OR lt_promos.ltp_enddate=NULL )
		AND lt_merchants.ltm_lat  
			BETWEEN :minlat AND :maxlat
		AND lt_merchants.ltm_long 
			BETWEEN :minlng AND :maxlng
		ORDER BY :sort 
		LIMIT :limit 
		OFFSET :offset';
	
	  
	// Common queried fields
	
    /*
     * SQL Consumer fields
     */
    public function consumerFields() {
    	return static::SQL_FIELDS_TBL_CONSUMER;
	}
    const SQL_FIELDS_TBL_CONSUMER = "
    	CONCAT('csm_',tbl_consumer.csm_id) id,
    	tbl_consumer.csm_id,
    	tbl_consumer.csm_key,
    	tbl_consumer.csm_lat,
    	tbl_consumer.csm_long,
    	tbl_consumer.csm_zip,
    	tbl_consumer.csm_password,
    	tbl_consumer.csm_active,
    	TRIM(tbl_consumer.csm_first_name) csm_first_name,
    	TRIM(tbl_consumer.csm_last_name) csm_last_name,
    	TRIM(tbl_consumer.csm_email) csm_email";
		//DATE_FORMAT(csm_add_date,'%c/%d/%Y') csm_add_date";
	
	/*
	 * SQL Promotion Queried fields
	 */
    public function promoFields() {
    	return static::environment( static::SQL_FIELDS_LT_PROMOS );
	}
    const SQL_FIELDS_LT_PROMOS = "
    	lt_promos.ltp_id,
    	CONCAT('ltb_',lt_promos.ltb_id,'ltp_',lt_promos.ltp_id) mid,
		TRIM(REPLACE(UPPER(CONCAT(IFNULL(lt_promos.ltp_headline,''),' ')),'  ',' ')) title,
		TRIM(REPLACE(REPLACE(REPLACE(REPLACE(lt_promos.ltp_description,'\n',' '),'\r',' '),'   ',' '),'  ',' ')) description,
		DATE_FORMAT(lt_promos.ltp_startdate,'%b %d %Y %h:%i %p') start_date,
		DATE_FORMAT(lt_promos.ltp_enddate,'%b %d %Y %h:%i %p') end_date,
		lt_promos.ltp_promo_code promo_code,
		CAST(lt_promos.ltp_promo_type AS UNSIGNED) type,
		TIME_FORMAT(lt_promos.ltp_time_start,'%h:%i %p') start_time,
		TIME_FORMAT(lt_promos.ltp_time_end,'%h:%i %p') end_time,
		TRIM(TRAILING ', ' FROM REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(lt_promos.ltp_weekday,1,'Mon, '),2,'Tue, '),3,'Wed, '),4,'Thurs, '),5,'Fri, '),6,'Sat, '),7,'Sun, '),'Mon, Tue, Wed, Thurs, Fri, Sat, Sun','Everyday!'),', Tue, Wed, ',' thru '),' thru Thurs, F',' thru F')) weekday,
		IFNULL(
			CONCAT(':env', IF(lt_promos.ltp_image LIKE 'unv%',':img_library/',CONCAT(':img_',lt_promos.ltb_id,'_merchants')),IF(lt_promos.ltp_image LIKE 'unv%','/','/p_120x120_'), lt_promos.ltp_image),
			CONCAT(':env:img_default/promo-default_',lt_promos.ltp_promo_type,'.jpg')
		) thumbnail,
		IFNULL(
			CONCAT(':env', IF(lt_promos.ltp_image LIKE 'unv%',':img_library/',CONCAT(':img_',lt_promos.ltb_id,'_merchants')),IF(lt_promos.ltp_image LIKE 'unv%','/','/p_600x400_'), lt_promos.ltp_image),
			CONCAT(':env:img_default/promo-default_',lt_promos.ltp_promo_type,'.jpg')
		) image,
		CONCAT(':env/cdn/promotions?id=',lt_promos.ltp_id) AS share_url";
	
	/*
	 * SQL Merchants Queried fields
	 *
	 * @params :sinlat, :coslat, :lng
	 * @fields :earth
	 */
    public function merchantFields() {
    	return static::environment( static::SQL_FIELDS_LT_MERCHANTS );
	}
	const SQL_FIELDS_LT_MERCHANTS = "
		CONCAT('ltm_',lt_merchants.ltm_id,'_ltb_',lt_merchants.ltb_id) id,
		lt_merchants.ltm_id,
		lt_merchants.ltm_google_id place_id,
		TRIM(lt_merchants.ltm_company_name) name,
		CONCAT(lt_merchants.ltm_lat,',',lt_merchants.ltm_long) location,
		lt_merchants.ltm_lat,
		lt_merchants.ltm_long,
		CONCAT(
			IFNULL(CONCAT(lt_merchants.ltm_address,' ','\n'),''),
			IFNULL(CONCAT(lt_merchants.ltm_city,' '),''),
			IFNULL(CONCAT(lt_merchants.ltm_state,', '),''),
			IFNULL(lt_merchants.ltm_zipcode,''),'\n'
		) vicinity,
		TRIM(lt_merchants.ltm_address) address,
		TRIM(lt_merchants.ltm_city) city,
		TRIM(lt_merchants.ltm_state) state,
		TRIM(lt_merchants.ltm_zipcode) zip,
		TRIM(lt_merchants.ltm_phone_number) phone_number,
		CONCAT(':env:cdn/merchants?id=',lt_merchants.ltm_id) ltm_url,
		DATE_FORMAT(lt_merchants.ltm_registerdate,'%c/%d/%Y') ltm_registerdate,
		ROUND(
			ACOS(
				SIN(RADIANS(:sinlat)) * 
				SIN(RADIANS(lt_merchants.ltm_lat)) +
				COS(RADIANS(:coslat)) *
				COS(RADIANS(lt_merchants.ltm_lat)) *
				COS(RADIANS(lt_merchants.ltm_long) - RADIANS(:coslng))
		) * :earth, 2 ) distance ";
	
	/*
	 * SQL Member Merchant Queried fields
	 */
	public function memberFields() {
    	return static::environment( static::SQL_FIELDS_LT_MEMBER_MERCHANTS );
	}
	const SQL_FIELDS_LT_MEMBER_MERCHANTS = "
		lt_member_merchants.ltb_id,
		CONCAT(':env/',lt_member_merchants.ltb_slug) AS url,
		TRIM(lt_member_merchants.ltb_description) ltb_description,
		TRIM(lt_member_merchants.ltb_web_url) ltb_web_url,
		IFNULL(CONCAT(':env:img_',lt_member_merchants.ltb_id,'_merchants','/h_600x600_',lt_member_merchants.ltb_header_image),':env:img_logo') ltb_thumbnail,
		IFNULL(CONCAT(':env:img_',lt_member_merchants.ltb_id,'_merchants','/h_250w_',lt_member_merchants.ltb_header_image),':env:img_logo') ltb_image";

 } // end class

# EOF ?>