<?php
# File: category.php
#
# ABOUT Pragma 
# - Pragma header is removed 
# should the server happen 
# to set it automatically.
# Pragma headers can make 
# browsers misbehave and 
# still ask data from the
# server. 
# 
# - This file rarely changes.
# This will update automatically
# every 30 days when it expires 
# or if deleted from the cache. 
#
# -The idea is to help save 
# consumer data 2-3kb per
# request on static category
# data. 
#
#
# ABOUT JSON 
# @param callback = JSONP
# 
# About Callback with AJAX example for JSONP
# using a jQuery ajax request.
#
# $.ajax({
#   url: 'http://url.of.my.server/submit',
#   dataType: "jsonp",
#   jsonp: 'callback',
#   jsonpCallback: 'callback'
# });
#
# Dev Notes:
# - This works with GET parameters
# and CORS does not have to be
# activated for applications that
# are using the API on other
# servers. 
#
# - The JSON encoded output
# is wrapped in a javascript 
# function with the search object.
#
# Local Thanks(sm)
# Category resource
#
# @author Michael W Hayden
##########################
require __DIR__ . '/app/autoload.php';

use Localthanks\Category;

$category = json_encode( new Category, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE );

# Set JSON header
header('Content-Type: application/json; charset=utf-8');
# Cache duration, 30 days.
$cache = 2592000; 
# Set client cache
header('Cache-Control: public,max-age='.$cache.',must-revalidate');
header('Expires: '.gmdate('D, d M Y H:i:s',($_SERVER['REQUEST_TIME'] + $cache)).' GMT');
header('Last-modified: '.gmdate('D, d M Y H:i:s',$_SERVER['REQUEST_TIME']).' GMT');

header_remove('Pragma');

echo ($_GET['callback']) ? "callback($category)": $category;

# EOF ?>