<?php $start = microtime(1);
require __DIR__ . '/app/autoload.php';
 
use Localthanks\Env;
use Localthanks\Search2;
use Localthanks\Sqoot2;

// Environment
// Direct file access gets the best IP
$ENV= new Env;
$IP = $ENV->ip();
$ENV= $ENV->info();

// Init search
$SEARCH= new Search2( $IP, $ENV );
$SEARCH->init();

// JSON request 
// JSONP support for CORS with custom alpha only callback
if(isset($_REQUEST['json'])
or isset($_REQUEST['jsonp'])) :
	header('Content-Type: application/json; charset=utf-8');
	$SEARCH=json_encode($SEARCH, JSON_PRETTY_PRINT);
	if ($jp = $_REQUEST['jsonp'])
		 echo (ctype_alpha($jp)) ? "$jp($SEARCH)": "callback($SEARCH)";
	else echo $SEARCH;
	
// HTML request
else : echo '
<!DOCTYPE html>
<!-- preprocessor: '.(microtime(true)-$start).' -->'; ?>
<html>
<head>
	<title>Search</title>
	<meta charset="utf-8" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" user-scalable="no" />
    <link rel="stylesheet" type="text/css" media="all" href="https://maxcdn.bootstrapcdn.com/bootswatch/3.3.6/united/bootstrap.min.css" />
    <link rel="stylesheet" type="text/css" media="all" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css" />
 
</head>
<body>

<style>
.navbar {
	margin-bottom:0;
}
.navbar-form {
	padding:0;
	margin:0;
	border:0;
}
.logo {
	max-width: 45px;
	margin:-10px 3px;
}
.followMeBar {
  background: #999;
  padding: 10px 20px;
  position: relative;
  z-index: 1;
  color: #fff;
}

.followMeBar.fixed {
  position: fixed;
  top: 0;
  width: 100%;
  box-sizing: border-box;
  z-index: 1;
}

.followMeBar.fixed.absolute {
  position: absolute;
}
</style>

<form class="navbar-form navbar-left" role="search">

<nav class="row navbar">
 
  
  <div class="container-fluid">
	<div class="col-lg-12 input-group">
      	<div class="input-group-btn">
        	<button style="min-width:99px"
        	 type="button" 
        	 class="btn btn-default" 
  			 data-toggle="collapse" 
             data-target="#demo">
        	<span class="glyphicon glyphicon-option-vertical" aria-hidden="true"></span> 
        		<img class="logo" 
        			 src="<?php echo $SEARCH->logo; ?>" 
        			 alt="<?php echo $SEARCH::PROVIDER; ?>" /> 
        		<!--<span class="caret"></span>-->
        	</button>
      	</div><!-- /btn-group -->
      	
      	<!-- Search terms and params -->
        <label for="<?php echo $SEARCH::TERM; ?>" class="sr-only"><?php echo $SEARCH::TERM; ?></label>
        <input type="text" name="<?php echo $SEARCH::TERM; ?>" id="<?php echo $SEARCH::TERM; ?>" class="form-control" placeholder="Search terms..." value="<?php echo $SEARCH->term; ?>">
	</div><!-- /input-group .col-lg-6 -->

   <div id="demo" class="collapse">
	<div class="col-lg-12 input-group btn-block">
      	<div class="input-group-btn">
        	<!-- submit -->
        	<button style="min-width:99px" name="search_submit" type="submit" class="btn btn-default">
        		<i class="fa fa-map-marker pull-left"></i>
        		Search
        	</button>
      	</div><!-- /btn-group -->
      	
      	<!-- search location -->
        <label for="<?php echo $SEARCH::LOCATION; ?>" class="sr-only"><?php echo $SEARCH::LOCATION; ?></label>
        <input type="text" name="<?php echo $SEARCH::LOCATION; ?>" id="<?php echo $SEARCH::LOCATION; ?>" class="form-control" placeholder="Search by location..." value="<?php echo $SEARCH->location; ?>">
        
	</div><!-- /col-lg-12 input-group -->
	
	<?php 
 
 		// HTML helpers
 		$category = new \stdClass();
		//$category->Education='<i class="fa fa-mortar-board pull-left"></i>|12,40,137,41,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152';
		$category->Entertainment='<i class="fa fa-ticket pull-left"></i>|13,43,153,50,44,65,154,155,156,157,158,125,45,159,160,161,162,163,164,165,166,167,526,168,169,170,17,171,172,173,47,48,49,174,175,176,126,177,178,179,533,180,181,182,183,535,184,71,185,186,187,42,188,189,51';
		$category->Restaurants='<i class="fa fa-cutlery pull-left"></i>|127,252,253,61,254,255,256,257,258,259,55,260,261,262,263,264,265,54,266,267,268,269,270,271,272,273,274,275,276,59,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,293,294,295,296,297,298,299,300,301,302,303,304,56,305,306,307,308,309,310,311,312,313,314,315,316,317,60,318,319,320,321,322,323,324,527';
		$category->Retail_Shopping='<i class="fa fa-heart pull-left"></i>|124,85,325,326,327,328,329,330,1,331,332,333,334,53,335,336,337,88,338,8,339,340,341,343,344,345,107,342,346,347,348,349,34,350,351,352,36,353,354,355,356,37,358,357,359,35,360,361,362,363,364,365,366,52,73,367,368,93,369,370,371,57,372,75,67,373,374,84,375,376,377,378,58,534,379,380,381,382,383,384,110,385,111,386,387,388,389,390,391,69,392,393,394,395,87,38,396,397,398,399,400,401,402,403,404,405,406,407,408,409';
        $category->Services='<i class="fa fa-calendar pull-left"></i>|26,102,114,115,116,117,118,119,120,121,122,104,123,6,2,410,411,7,412,413,414,415,416,417,418,419,420,106,421,422,423,424,425,426,427,428,429,430,431,432,433,434,435,436,72,437,438,439,440,441,442,443,444,445,103,446,64,447,448,74,449,113,66,450,451,76,130,452,453,538,539,540,541,454,455,456,457,458,459,460,461,77,462,463,525,78,464,465,466,467,468,95,469,470,471,79,472,473,474,536,475,476,477,478,479,480,80,481,482,528,483,484,485,486,487,488,82,489,490,83,491,492,493,494,495,496,497,498,499,108,537,500,501,502,503,504,505,506,507,508,509,510,511,512,513,112,514,515,516,517,518,519';
		$category->Travel='<i class="fa fa-plane pull-left"></i>|105,90,91,46,132,133,94,134,97,135,101,136';
		
		foreach($category as $k => $v) : 
			$tag=explode('|',$v);
	?>
	<div class="col-lg-12 input-group btn-block">
      	<a style="text-align:right" href="search.php?cat=<?php echo $tag[1]; ?>" class="btn btn-block btn-default">
		  <?php echo $tag[0]; ?>
		  <?php echo ucwords(str_replace(array('_','-'),' ',$k)); ?>
		</a>
	</div><!-- /col-lg-12 input-group -->
 	<?php endforeach; ?>
 	<!-- submit -->
 	<div class="col-lg-12 input-group btn-block">
      <button style="min-width:99px;text-align:right" name="cat_submit" type="submit" class="btn btn-block btn-success">
        <i class="glyphicon glyphicon-search pull-left"></i>
        Search
      </button>
    </div>
   </div>
  </div>

</nav>
    
    
 
<?php if ($SEARCH->count==0) : ?>

  <div class="container-fluid">
    <div class="col-sm-12">
      <h5>No Results Found.</h5>
      <p class="small">
        Start by adding a <strong>post code</strong> 
        or search location.
      </p>
      <!-- search location -->
      <label for="<?php echo $SEARCH::POSTCODE; ?>" 
      		 class="sr-only"><?php echo $SEARCH::POSTCODE; ?></label>
      <input type="text" 
        	 name="<?php echo $SEARCH::POSTCODE; ?>" 
        	 id="<?php echo $SEARCH::POSTCODE; ?>" 
        	 class="form-control" 
        	 placeholder="xxxxx" 
        	 value="<?php echo $SEARCH->post_code; ?>">
      <p class="small" style="opacity:.7">
      	To find local deals, enable your location settings 
      	on your device.
      </p>
   
      <button name="post_code_submit" type="submit" class="btn btn-block btn-success">
        <i class="fa fa-star"></i>
          Find Deals!
        <i class="fa fa-star"></i>
      </button>
    <?php if(empty($SEARCH->uid)) { ?>
      <a class="btn btn-block btn-primary" href="href="http://localhost/~LoyaltySuperstore/cdn/signup.php"">
        <i class="fa fa-action"></i> 
		  Signup
      </a>
      <a class="btn btn-block btn-info" href="href="http://localhost/~LoyaltySuperstore/cdn/login.php"">
        <i class="fa fa-user"></i> 
		  Login
      </a>
    <?php } ?>
    </div><!-- /.col-sm-12 -->
  </div>
  
<?php else:
	foreach($SEARCH->results as $name=>$obj) : ?>

  <div class="container-fluid followMeBar">
    <div class="col-sm-12">
      <h5 style="margin:0"><?php echo ucwords(str_replace(array('_'),' ',$name)); ?></h5>
    </div>
  </div>
  
<?php	foreach( $obj as $v ) : ?>

  <div class="col-sm-6 col-md-4">
    <div class="thumbnail">
      <?php 
      	
      	if(!is_null($v->merchant_image)) { ?>
      <div class="pull-left" style="min-height:99px">
        <img style="max-width:99px;margin-right:5px" 
        	 src="<?php echo $v->merchant_image; ?>" 
        	 alt="<?php echo $v->merchant_name; ?>" />
      </div>
      <?php }	
      
      	if(!is_null($v->merchant_name)) { ?>
	    <h4 style="color:#999;font-size:14px"><?php 
	    echo ucwords($v->merchant_name); ?></h4>
	  <?php } ?>
	  
		<p class="small" style="opacity:.7;font-size:.7em">
	  <?php 
	  	
	  	if(!is_null($v->merchant_status)) { 
	  		$color=(strpos($v->merchant_status,'lose')===false) ? 'limegreen':'red';
	  ?>
		  <strong style="color:<?php echo $color; ?>">
		  	<?php echo $v->merchant_status; ?> 
		  </strong><br />
	  <?php }	
	  	
	  	if(!is_null($v->locality)) { 
	  		$distance=(strpos($v->distance,'0.00')===false) ? ' <small>Distance</small> '.$v->distance: '';
	  	?>
	      Near <?php echo ucwords($v->locality).$distance; ?><br />
      <?php } 
      
      	if(!is_null($v->merchant_website)) { ?>
		  <small> 
			<a target="_blank" href="<?php echo  $v->merchant_website; ?>">
		    <?php echo str_replace(array('http://','https://','http://www.','https://www.'),'',$v->merchant_website); ?>
		    </a>
		  </small><br />
	  <?php } 
	   
	  	if(!is_null($v->category)) { 
	  		$list=explode(',',$v->category_list);
	  		$count=count($list);
	  		$title='Categor'.(($count>1) ? 'ies':'y'); 
	  ?>
		  <small style="color:#aaa">
		  	<?php echo '<strong class="small">'.$title.':</strong> '.$v->category; ?>
		  </small>
	  <?php } ?>
	    </p>
	    
	  <?php	/* if (is_array($v->products)) : ?>
  		<div class="row" style="clear:both">
  		  <div class="col-lg-12">
  		  	<h5>Available Deals</h5>
  		  </div>
  		<?php foreach( $v->products as $a => $b ) : ?>
		  <div class="col-md-3 col-sm-3 col-xs-3">
			<img class="img-responsive" src="<?php echo $v->products[$a]->image; ?>" />
		  </div>
          <div class="col-md-9 col-sm-9 col-xs-9">
             <?php echo $v->products[$a]->title; ?>
          </div>
          <div style="clear:both"></div>
		<?php endforeach; ?>
		</div>
	  <?php endif; */ ?>
   
	    <p class="small pull-right" style="margin-top:3px">
      <?php if(!is_null($v->merchant_phone_number)) { ?>
      	  <i class="fa fa-phone"></i>
      	  <a href="tel:<?php echo preg_replace('/\D/', '', $v->merchant_phone_number); ?>">
	  <?php echo  nl2br($v->merchant_phone_number); ?>
	  	  </a>
	  <?php } ?>
	  	    </p>
	     <p class="small pull-left">
	       <small>
      <?php if(!is_null($v->merchant_hours_of_operation)) { ?>
		  <i class="fa fa-calendar"></i> 
		  <strong>Hours of Operation</strong><br />
	  <?php echo  nl2br($v->merchant_hours_of_operation); ?>
	  <?php } ?>
	       </small>
	     </p>

	  
  <div class="small btn-group btn-group-justified" role="group" aria-label="Actions">
    <?php $count=count($v->products); ?>
	<a href="<?php echo $v->merchant_url; ?>" class="btn btn-sm btn-<?php if($count>0) echo 'primary'; else echo 'default';?>" role="button">
      <?php
      	if ($count>0) echo '<i class="fa fa-star"></i>'.$count.' deal'.(($count>1) ? 's':'');
      	else          echo 'View Merchant';
      ?>
    </a> 
    <?php if($v->get_directions) : ?>
    <a target="_blank" href="<?php echo $v->get_directions; ?>" class="btn btn-sm btn-default" role="button">
      <i class="fa fa-map-marker"></i>
      Directions
    </a>
	<?php endif; ?>
    <div class="btn-group" role="group">
      <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        <i class="fa fa-share"></i>
        Share
        <i class="caret"></i>
      </button>
      <ul class="dropdown-menu">
		<?php $share = str_replace(':','%3A',$v->merchant_url); ?>
		<li>
        	<a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo $share; ?>">
        		<i class="fa fa-facebook"></i>
        		Facebook
        	</a>
        </li>
        <li>
        	<a href="https://twitter.com/home?status=<?php echo $share; ?>">
        		<i class="fa fa-twitter"></i>
        		Twitter
        	</a>
        </li>
        <li>
        	<a href="https://plus.google.com/share?url=<?php echo $share; ?>">
        		<i class="fa fa-google"></i>
        		Google+
        	</a>
        </li>
      </ul>
    </div>
  </div>
 
    </div>
  </div>
<?php 	endforeach;
	endforeach;
endif;  ?>
 
</form><!-- /end form -->    

<div class="container small">
  <div class="row small">
	<pre class="small">
      <?php echo var_dump($SEARCH); ?>
    </pre>
  </div>
</div>

<!-- footer scripts -->
<script src="https://code.jquery.com/jquery-2.2.3.min.js"   integrity="sha256-a23g1Nt4dtEYOj7bR+vTu7+T8VP13humZFBJNIYoEJo="   crossorigin="anonymous"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/typeahead.js/0.11.1/typeahead.bundle.min.js" type="text/javascript"></script>
<script>
var stickyHeaders = (function() {

  var $window = $(window),
      $stickies;

  var load = function(stickies) {

    if (typeof stickies === "object" && stickies instanceof jQuery && stickies.length > 0) {

      $stickies = stickies.each(function() {

        var $thisSticky = $(this).wrap('<div class="followWrap" />');
  
        $thisSticky
            .data('originalPosition', $thisSticky.offset().top)
            .data('originalHeight', $thisSticky.outerHeight())
              .parent()
              .height($thisSticky.outerHeight()); 			  
      });

      $window.off("scroll.stickies").on("scroll.stickies", function() {
		  _whenScrolling();		
      });
    }
  };

  var _whenScrolling = function() {

    $stickies.each(function(i) {			

      var $thisSticky = $(this),
          $stickyPosition = $thisSticky.data('originalPosition');

      if ($stickyPosition <= $window.scrollTop()) {        
        
        var $nextSticky = $stickies.eq(i + 1),
            $nextStickyPosition = $nextSticky.data('originalPosition') - $thisSticky.data('originalHeight');

        $thisSticky.addClass("fixed");

        if ($nextSticky.length > 0 && $thisSticky.offset().top >= $nextStickyPosition) {

          $thisSticky.addClass("absolute").css("top", $nextStickyPosition);
        }

      } else {
        
        var $prevSticky = $stickies.eq(i - 1);

        $thisSticky.removeClass("fixed");

        if ($prevSticky.length > 0 && $window.scrollTop() <= $thisSticky.data('originalPosition') - $thisSticky.data('originalHeight')) {

          $prevSticky.removeClass("absolute").removeAttr("style");
        }
      }
    });
  };

  return {
    load: load
  };
})();

$(function() {
  stickyHeaders.load($(".followMeBar"));
});
</script>
</body>
</html>
<?php
echo "\n<!-- ip: ".$IP." completed: ".(microtime(true)-$start)." -->\n";
endif;

#EOF ?>