<?php session_start(); $start = microtime(1);
#
# File: app/session.php
#
# Local Thanks(sm)
# Consumer session manager.
#
# ABOUT JSON 
# @param callback = JSONP
# 
# About Callback with AJAX example for JSONP
# using a jQuery ajax request.
#
# $.ajax({
#   url: 'http://url.of.my.server/submit',
#   dataType: "jsonp",
#   jsonp: 'callback',
#   jsonpCallback: 'callback'
# });
#
# Dev Notes:
# - This works with GET parameters
# and CORS does not have to be
# activated for applications that
# are using the API on other
# servers. 
#
# - The JSON encoded output
# is wrapped in a javascript 
# function with the search object.
#
# TODO
# Consider for local saved sessions.
/*
session_save_path( "/tmp" );
if( empty( $_SESSION ) ) {
	$domain = explode( '.', $_SERVER['HTTP_HOST']);
	session_set_cookie_params(0, '/', '.'.$domain[count($domain_array)-2].'.'.$domain[count($domain_array)-1]);
	session_start();
}
*/
#
#
#
# @class SessionManager
# @author Michael W Hayden
####################################
require __DIR__ . '/app/autoload.php';
require __DIR__ . '/app/src/Localthanks/SessionManager.php';

use Localthanks\SessionManager;
use Localthanks\Utils;

# JSON
header( 'Content-Type: application/json; charset=utf-8' );

# Init Session
$utils   = new Utils;
$session = new SessionManager( $utils->getIP() );
$session->response = round(( microtime(1) - $start ), 5) . ' seconds';
$session = json_encode( $session, JSON_PRETTY_PRINT );
echo ($_GET['callback']) ? "callback($session)" : $session;

#session_unset();
#session_destroy();
# EOF ?>