<?php
require './app/function.get-subdir.php';

class _header{

	function __construct($db) { 

		$this->db = $db;
		$this->header = ''; 
		$this->css = array();
		$this->js = array();
		$this->defer_js = array();
		$this->og_meta = array();
		$this->header_layout=array('topbar,logo');

	}
	public function css($css_array){
		$this->css=$css_array;

	}
	public function js($js_array){
		$this->js=$js_array;
	}
	public function defer_js($js_array){
		$this->defer_js=$js_array;
	}
	public function og_meta($og_meta_array){
		$this->og_meta=$og_meta_array;
	}

/*
	private function get_logobar(){
		$dbo=$this->db;
		ob_start();
		include $_SERVER['DOCUMENT ROOT'].'localthanks/app/view/inc/header_merchant_logo_bar.php'; 
		return ob_get_clean();
	}

	private function get_local_menubar(){
		$dbo=$this->db;
		ob_start();
		include $_SERVER['DOCUMENT ROOT'].'localthanks/app/view/inc/local_menubar.php';
		return ob_get_clean();
	}

	private function get_national_menubar(){
		$dbo=$this->db;
		ob_start();
		include $_SERVER['DOCUMENT ROOT'].'localthanks/app/view/inc/national_menubar.php';
		return ob_get_clean();
	}
*/



	public function get_header(){


		$this->header='<!DOCTYPE html>
		<html lang="en">
		<head>		
		<meta charset="utf-8">
		<!--[if IE]><meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"><![endif]-->
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		
		<title>'.(isset($this->og_meta['title']) ? $this->og_meta['title'] : 'Local Thanks&#8480; | Loyalty Superstore&#8480;').'</title>';

		// open graph meta deta
		foreach ($this->og_meta as $k=>$v){
			$this->header .= '<meta property="og:'.$k.'" content="'.$v.'" />';
		}

		$this->header .='<meta name="description" content="Local Thanks&#8480;">
		<meta name="keywords" content="Local Thanks, small business marketing, loyalty program, rewards program">
		<link rel="shortcut icon" href="/favicon.ico">
		<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700">
		';

		//CSS
		//add optional external css to header
		$this->header.='
		<link rel="stylesheet" href="/plugins/bootstrap/css/bootstrap.css?v=3.3.7">
		<link rel="stylesheet" href="/plugins/bootstrap/css/bootstrap-theme.css">';

		foreach ($this->css as $stylesheet) { 
			$this->header.='<link rel="stylesheet" href="'.($stylesheet[0]!='/'?'/plugins/':'').$stylesheet.'">'; 
		}
		//add general in-house css to header
		
		$this->header.='<link rel="stylesheet" href="/localthanks/css/styles.php">'; // for template system that is yet to be built

		$this->header.='<link rel="stylesheet" href="/css/global.css">';
		$this->header.='<link rel="stylesheet" href="/localthanks/css/styles.css?v=3.0.0">';		
		$this->header.='<link rel="stylesheet" href="/localthanks/css/header.css?v=2.0.0">';
		$this->header.='<link rel="stylesheet" href="/localthanks/css/footer.css">';


		//JAVASCRIPT
		$this->header.='
		<script type="text/javascript" src="/plugins/jquery/jquery-1.11.1.min.js"></script>
		<script type="text/javascript" src="/plugins/bootstrap/js/bootstrap.js?v=3.3.7" defer></script>
		<script src="/plugins/check-form-inputs.js"></script>';
		//add optional external js to header
		foreach ($this->js as $jscript) { $this->header.='<script type="text/javascript" src="'.($jscript[0]!='/'?'/plugins/':'').$jscript.'"></script>'; }
		
		foreach ($this->defer_js as $jscript) { $this->header.='<script type="text/javascript" src="'.($jscript[0]!='/'?'/plugins/':'').$jscript.'" defer></script>'; }
		
		//add genearl in-house css to header
		//$this->header.='<script type="text/javascript" src="/localthanks/js/scripts.js"></script>';
		require  $_SERVER["DOCUMENT_ROOT"].'/app/model/google_analytics.php';
		$this->header .= google_analytics('UA-69987455-1') . '
		
		</head>

		<body>
		';

        //$this->header .= google_analytics('UA-69987455-1'); //included in the header

		//CHAT
		$dbo=$this->db;
		ob_start();
		//include $_SERVER['DOCUMENT ROOT'].'app/view/chat.php';
		$this->header.=ob_get_clean();


		//TOP BARS
		//$this->header.=self::get_logobar();
		//$this->header.=self::get_local_menubar();




		return $this->header;
	}



}
?>