<?php
//SETTING DEFAULT VALUES (if none set)
if(!isset($_SESSION['user']['consumer']['csm_id']))	set_csm_sessions(1);



// ------------------------------------------------------------------------------------------------------------------
function set_csm_sessions($csm_id, $appLogin = false){ //accessed by login and used to set default values if not logged in
	global $dbo;

	$sql='
	SELECT (CASE WHEN RESMALL.mall_id IS NULL THEN 1 ELSE RESMALL.mall_id END) AS res_mall_id, (CASE WHEN MALL.mall_id IS NULL THEN 1 ELSE MALL.mall_id END) AS mall_id, CSM.csm_id, CSM.ltm_id, CSM.ltm_pick_id, CSM.csm_first_name, CSM.csm_last_name, CSM.csm_email, CSM.csm_add_date, CSM.csm_lat, CSM.csm_long
	FROM tbl_consumer CSM
	INNER JOIN lt_merchants LTM ON CSM.ltm_pick_id=LTM.ltm_id
	INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=LTM.ltb_id
	INNER JOIN tbl_reseller RES ON MMR.res_id=RES.res_id
	LEFT JOIN tbl_mall RESMALL ON RESMALL.mall_id = RES.mall_id
    LEFT JOIN tbl_mall MALL ON MALL.ltb_id = MMR.ltb_id
	WHERE CSM.csm_id='.$csm_id.' LIMIT 1';
	$stmt = $dbo->prepare($sql);
	
	$stmt=execPDO($stmt);
	
	if( $stmt->rowCount() ) {
		$row = $stmt->fetch(PDO::FETCH_OBJ);
		$_SESSION['user']['consumer']['csm_id']         = $row->csm_id;
		$_SESSION['user']['consumer']['csm_first_name'] = $row->csm_first_name;
		$_SESSION['user']['consumer']['csm_last_name']  = $row->csm_last_name;
		$_SESSION['user']['consumer']['csm_email']      = $row->csm_email;
		$_SESSION['user']['consumer']['csm_add_date']   = $row->csm_add_date;
		$_SESSION['user']['consumer']['ltm_pick_id']    = $row->ltm_pick_id;
		$_SESSION['user']['consumer']['csm_lat']        = isset($_SESSION['geo_location']['csm_lat'])? $_SESSION['geo_location']['csm_lat']:$row->csm_lat;
		$_SESSION['user']['consumer']['csm_long']       = isset($_SESSION['geo_location']['csm_long'])? $_SESSION['geo_location']['csm_long']:$row->csm_long;
		$_SESSION['user']['consumer']['mall_id']        = intval($row->mall_id) > 1?  $row->mall_id: $row->res_mall_id;
		
		if ($appLogin) {
			$_SESSION['user']['consumer']['app_login']  = true;
		}
		
		return set_merchant_sessions_by_id($row->ltm_pick_id);
	}else{
		return false;
	}
}



// ------------------------------------------------------------------------------------------------------------------
function set_merchant_sessions_by_id($ltm_id){ //accessed by set_csm_sessions();
	global $dbo;
	$sql='SELECT ltm_id, LTM.ltb_id, 
	ltm_company_name, ltm_lat, ltm_long, ltm_address, ltm_city, ltm_state, ltm_zipcode, ltm_phone_number, ltb_header_image
	FROM lt_merchants LTM
	INNER JOIN lt_member_merchants LTB ON LTM.ltb_id=LTB.ltb_id 
	WHERE ltm_id='.$ltm_id.' AND ltm_active=1';
	$stmt = $dbo->prepare($sql);
	$stmt=execPDO($stmt);
	if($stmt->rowCount()){
		$row = $stmt->fetch(PDO::FETCH_OBJ);
		//user settings
		$_SESSION['user']['consumer']['ltb_id']=$row->ltb_id;
		$_SESSION['user']['consumer']['ltm_id']=$row->ltm_id;

		$_SESSION['user']['consumer']['ltb_header_image']=$row->ltb_header_image;
		$_SESSION['user']['consumer']['ltm_company_name']=$row->ltm_company_name;
		$_SESSION['user']['consumer']['country']  = 'US';

		//display settings
		$_SESSION['user']['display']['ltb_id']=$row->ltb_id;
		$_SESSION['user']['display']['ltm_id']=$row->ltm_id;
		//$_SESSION['user']['display']['ltm_lat']=$row->ltm_lat;
		//$_SESSION['user']['display']['ltm_long']=$row->ltm_long;
		$_SESSION["user"]["display"]['ltm_company_name']=$row->ltm_company_name;
		$_SESSION['user']['display']['ltb_header_image']=$row->ltb_header_image;
		$_SESSION['user']['display']['slug']='';
		return true;
	}else{ return false; }


}



// ------------------------------------------------------------------------------------------------------------------
function set_merchant_sessions_by_slug($slug){ //accessed by loader.php
	global $dbo; $_flag = false;
	$sql='
	SELECT LTM.ltm_id, LTM.ltb_id, LTM.ltm_company_name, LTM.ltm_lat, LTM.ltm_long, LTM.ltm_address, LTM.ltm_city, LTM.ltm_state, LTM.ltm_zipcode, LTM.ltm_phone_number, LTB.ltb_header_image
	FROM lt_merchants LTM  
	INNER JOIN lt_member_merchants LTB ON LTM.ltb_id=LTB.ltb_id 
	WHERE LTB.ltb_slug=:slug AND LTM.ltm_active=1 AND LTB.ltb_active=1 LIMIT 1
	';
	$stmt = $dbo->prepare($sql);
	$stmt->bindValue(":slug", $slug, PDO::PARAM_STR);  
	$stmt=execPDO($stmt);
	if( $stmt->rowCount() ) {
		$row = $stmt->fetch(PDO::FETCH_OBJ);		
		$_SESSION["user"]["consumer"]["ltm_view_id"]=$row->ltm_id;		
		$_SESSION['user']['display']['ltb_id']=$row->ltb_id;
		$_SESSION['user']['display']['ltm_id']=$row->ltm_id;
		$_SESSION['user']['display']['ltm_lat']=$row->ltm_lat;
		$_SESSION['user']['display']['ltm_long']=$row->ltm_long;
		$_SESSION["user"]["display"]['ltm_company_name']=$row->ltm_company_name;
		$_SESSION['user']['display']['ltb_header_image']=$row->ltb_header_image;
		$_SESSION['user']['display']['slug']=$slug;
		return true;
	}
	else {
		//check if someone had this slug before to redirect it to the right slug.
		$sql='
		SELECT LTB.ltb_slug, LTM.ltm_id, LTM.ltb_id, LTM.ltm_company_name, LTM.ltm_lat, LTM.ltm_long, LTM.ltm_address, LTM.ltm_city, LTM.ltm_state, LTM.ltm_zipcode, LTM.ltm_phone_number, LTB.ltb_header_image
		FROM lt_merchants LTM  
		INNER JOIN lt_member_merchants LTB ON LTM.ltb_id=LTB.ltb_id
		INNER JOIN (
			SELECT (CASE WHEN RED.301_new IS NULL THEN RED1.301_new ELSE RED.301_new END) AS 301_new 			
				FROM tbl_301_redirect RED1
				LEFT JOIN tbl_301_redirect RED ON RED.301_old = RED1.301_new AND RED.301_id > RED1.301_id
				WHERE RED1.301_old = :slug
				ORDER BY RED1.301_id DESC LIMIT 1
		) SELRED ON SELRED.301_new = LTB.ltb_slug		
		WHERE LTM.ltm_active=1 AND LTB.ltb_active=1 LIMIT 1
		';
		$stmt = $dbo->prepare($sql);
		$stmt->bindValue(":slug", $slug, PDO::PARAM_STR);  
		$stmt=execPDO($stmt);
		if( $stmt->rowCount() ) {
			$row = $stmt->fetch(PDO::FETCH_OBJ);			
			header( "Location: /{$row->ltb_slug}" ); die();
			//redirect to the right url
		}
	}
	
	return false;
	
}
?>