<?php
$csm_msgCount = 0;

// Get ltm_pick_id's ltb_id
$sql = "SELECT ltb_id AS ltm_pick_ltb_id FROM lt_merchants WHERE ltm_id = :ltm_pick_id LIMIT 1";
$stmt = $dbo->prepare($sql);
$stmt->bindValue(':ltm_pick_id', $_SESSION['user']['consumer']['ltm_pick_id'], PDO::PARAM_INT);
$stmt = execPDO($stmt);
$get_id = $stmt->fetch(PDO::FETCH_ASSOC);
//echo $get_id['ltm_pick_ltb_id'];

// Get messages where ltb_id = ltm_pick_id's ltb_id and the message date is greater than or equal to the users join date
$sql = "SELECT msg_id, msg_subject, msg_msg, msg_date, ltb_id FROM tbl_messages 
WHERE (ltb_id = :ltm_pick_ltb_id OR ltb_id IS NULL ) AND (msg_date >= :csm_join_date OR msg_date IS NULL) ORDER BY msg_id DESC LIMIT 60";
$stmt = $dbo->prepare($sql);
$stmt->bindValue(':ltm_pick_ltb_id', $get_id['ltm_pick_ltb_id'], PDO::PARAM_INT);
$stmt->bindValue(':csm_join_date', $_SESSION['user']['consumer']['csm_add_date'], PDO::PARAM_STR);
$stmt = execPDO($stmt);
$msgs = $stmt->fetchAll(PDO::FETCH_ASSOC);
if(empty($msgs)){
	$noMessages = true;
} else {

	foreach ($msgs as $msg) {

		$yourMsgs[$msg['msg_id']] = array(
			'id'=>$msg['msg_id'],
			'subject'=>$msg['msg_subject'],
			'msg'=>$msg['msg_msg'],
			'date'=>$msg['msg_date'],
			'unread'=>true,
			'ltb_id'=>$msg['ltb_id']
		);

		// Check if message has been read before
		$sql = 'SELECT msg_id, csm_id FROM tbl_msg_read WHERE msg_id=:msg_id and csm_id=:csm_id LIMIT 1';
		$stmt = $dbo->prepare($sql);
		$stmt->bindValue(":msg_id", $msg['msg_id'], PDO::PARAM_INT);
		$stmt->bindValue(":csm_id", $_SESSION['user']['consumer']['csm_id'], PDO::PARAM_INT);
		$stmt = execPDO($stmt);
		$qry = $stmt->fetchAll(PDO::FETCH_ASSOC);
		if(empty($qry)){ // This message has no record of being read
			$csm_msgCount = $csm_msgCount+1;
		} else {
			// This message has been read by this user before
			$yourMsgs[$msg['msg_id']]['unread'] = false;
		}
	}
}
define('MSG_COUNT', $csm_msgCount); //need constant value so we can include it into the header class