<?php // Messages queried and built in inc/csm_get_messages.php ?>
<div id="msg_json" style="display:none"><?php echo htmlspecialchars(json_encode($yourMsgs)); ?></div>
<h2 class="brandFG">Unread Messages</h2><hr>
<div id="unreadMessagesWrap"></div>
<h2 class="brandFG">Read Messages</h2><hr>
<div id="readMessagesWrap"></div>


<script>
$(document).ready(function(){
	var $unreadMessagesWrap = $('#unreadMessagesWrap');
	var $readMessagesWrap = $('#readMessagesWrap');
	var messages = JSON.parse($('#msg_json').text());

	// loop through each message
	$.each(messages, function(index, value){

		// set the date
		var msgDate = '';
		if (value['date'] !== null){
			msgDate = new Date(Date.parse(value['date'].replace('-','/','g'))).toLocaleString([], {month: "2-digit", day:"2-digit", year: "2-digit", hour:"2-digit", minute:"2-digit"});
		}

		// format HTML
		var printVal = '';
		printVal += '<div class="csm_msg_wrap">';
		printVal += '<table class="table table-striped table-bordered csm_msg_table '+(value['ltb_id'] == 0 ? 'global_msg':'')+'">';
		printVal += '<tr>';
		printVal += '<td class="msg-tbl-col-1">'+msgDate+'</td>';
		printVal += '<td class="msg-tbl-col-2"><strong>'+value['subject']+'</strong></td>';
		printVal += '<td class="msg-tbl-col-3 csm_msg_buttons">';
		printVal += '<button class="btn btn-primary btn-xs read-msg-btn" type="button" data-toggle="collapse" data-target="#msg_'+value['id']+'" aria-expanded="false" aria-controls="msg_'+value['id']+'">Read</button>  ';
		printVal += '<button class="btn btn-primary btn-xs mark-unread-btn" type="button" style="'+(value['unread'] ? 'display:none' : '')+'">Mark Unread</button>';
		printVal += '</td>';
		printVal += '</tr>';
		printVal += '</table>';
		printVal += '<div class="collapse" id="msg_'+value['id']+'" data-unread="'+value['unread']+'">';
		printVal += '<div class="well msg_well">';
		printVal += value['msg'];
		printVal += '</div>';
		printVal += '</div>';
		printVal += '</div>';

		// send to the proper div - unread/read
		if (value['unread']){
			$unreadMessagesWrap.prepend(printVal);
		}
		else {
			$readMessagesWrap.prepend(printVal);
		}

	});

	$('.read-msg-btn').click(function(){
		// wrapper node
		var $wrapNode = $(this).closest('.csm_msg_wrap');
		// get the msg body wrapper ID
		var msg_body_id = $(this).attr('aria-controls');
		msg_body_id = '#'+msg_body_id;

		var msg_id = $(this).attr('aria-controls').replace('msg_', '');
		var csm_id = <?php echo $_SESSION['user']['consumer']['csm_id']; ?>;
		// if the message is not currently visible, run AJAX call to set message to read
		if ($(msg_body_id).attr('aria-expanded') != 'true' && $(msg_body_id).data('unread') === true){
			$.ajax({
	            url: "ajax/ajax.csm-messages.php",
	            global: false,
	            type: "POST",       
	            dataType: "JSON",
	            data:  "csm_id="+csm_id+"&msg_id="+msg_id
	        });
	    } 
	    // else the message has been read and closed, move it to the read div
	    else if ($(msg_body_id).attr('aria-expanded') == 'true' && $(msg_body_id).data('unread') === true){
	    	// move the div
    		$wrapNode.hide(400, function(){
    			$wrapNode.prependTo('#readMessagesWrap').show(400);
    		});
    		// show the 'Mark Unread' button
    		$(this).siblings('.mark-unread-btn').show(400);
    		$(msg_body_id).data('unread', false);
	    }
	});

	$('.mark-unread-btn').click(function(){
		// wrapper node
		var $that = $(this);
		var $wrapNode = $(this).closest('.csm_msg_wrap');
		var msg_id = $(this).siblings().attr('aria-controls').replace('msg_', '');
		var csm_id = <?php echo $_SESSION['user']['consumer']['csm_id']; ?>;
		$.ajax({
            url: "ajax/ajax.csm-messages.php",
            global: false,
            type: "POST",       
            dataType: "JSON",
            data:  "csm_id="+csm_id+"&msg_id="+msg_id,
            error: function (err) { console.error(err); },
            success: function (data) { 
            	if (data.status == 'success') { 
            		// move the div
            		$wrapNode.hide(400, function(){
            			$that.hide();
		    			$wrapNode.prependTo('#unreadMessagesWrap').show(400);
		    		});
    				$('#msg_'+msg_id).data('unread', true);
            	} 
            }
        });
	});
});
</script>