<?php

//-----------------------------------
// page-directory.php
//-----------------------------------

if (isset($_REQUEST)) {
	$paramArr=array(); $_where=''; $_orderBy=' ORDER BY STE.gs_abbr ';
	//build links based on the request
	$strQuery = '
	SELECT DISTINCT STE.gs_abbr{%%city%%}{%%cat1%%}{%%cat2%%}{%%mslug%%} 
	FROM lt_m2cat M2C
	INNER JOIN lt_member_merchants MMC ON MMC.ltb_id=M2C.ltb_id
	INNER JOIN lt_merchants MRC ON MMC.ltb_id=MRC.ltb_id
	INNER JOIN geo_state STE ON STE.gs_abbr=MRC.ltm_state
	INNER JOIN geo_city CTY ON CTY.gs_id=STE.gs_id
	INNER JOIN lt_merchants MRC1 ON MRC1.ltm_id=MRC.ltm_id AND MRC.ltm_city LIKE CTY.gcty_city
	INNER JOIN tbl_category CAT2 ON M2C.cat_id=CAT2.cat_id
	INNER JOIN tbl_category CAT1 ON CAT1.cat_id=CAT2.cat_parent_id
	WHERE MMC.ltb_active 
		AND MRC.ltm_active 
		AND CAT2.cat_active 
		AND CAT1.cat_active 
		AND CAT2.cat_local 
		AND CAT1.cat_local 
		AND CAT1.cat_slug IS NOT NULL 
		AND CAT2.cat_slug IS NOT NULL  
		AND CAT1.cat_slug <> "" 
		AND CAT2.cat_slug <> ""';
		
	if (isset($_REQUEST['url2']) && $_REQUEST['url2'] != 'index'){
		//load cities in the state on $_REQUEST['url2']		
		$_where.=' AND STE.gs_abbr like :state';
		$paramArr[':state']=trim($_REQUEST['url2']);
		$_orderBy=' ORDER BY CTY.gcty_city';
		$strQuery = str_replace( '{%%city%%}', ',CTY.gcty_city', $strQuery);
	}
	if (isset($_REQUEST['city'])) {
		//load cities in the state on $_REQUEST['city']
		$_where.=' AND CTY.gcty_city like :city';
		$paramArr[':city']=trim($_REQUEST['city']);			
		$_orderBy=' ORDER BY C1Name';
		$strQuery = str_replace( '{%%cat1%%}', ',CAT1.cat_name C1Name,CAT1.cat_slug C1Slug', $strQuery);
	}
	if (isset($_REQUEST['cat1'])) {
		$_where.=' AND CAT1.cat_slug like :cat1';
		$paramArr[':cat1']=trim($_REQUEST['cat1']);
		$_orderBy=' ORDER BY C2Name';
		$strQuery = str_replace( '{%%cat2%%}', ',CAT2.cat_name C2Name,CAT2.cat_slug C2Slug', $strQuery);
	}
	if (isset($_REQUEST['cat2'])) {
		$_where.=' AND CAT2.cat_slug like :cat2';
		$paramArr[':cat2']=trim($_REQUEST['cat2']);
		$_orderBy=' ORDER BY MRC.ltm_company_name ';
		$strQuery = str_replace( '{%%mslug%%}', ',MMC.ltb_slug MSlug,MRC.ltm_company_name Name', $strQuery); 
	}
	$strQuery = str_replace( '{%%city%%}', '', $strQuery);
	$strQuery = str_replace( '{%%cat1%%}', '', $strQuery);
	$strQuery = str_replace( '{%%cat2%%}', '', $strQuery);	
	$strQuery = str_replace( '{%%mslug%%}', '', $strQuery);	
	$stmt = $dbo->prepare($strQuery.$_where.$_orderBy);
	foreach ($paramArr as $key => $val)
		$stmt->bindValue( $key, $val, PDO::PARAM_STR );		  
	$stmt->execute();
	$_Result = $stmt->fetchAll(PDO::FETCH_ASSOC);
	//echo $strQuery.$_where.$_orderBy;
	//var_dump($_Result);
	$_Output='';	
	
	foreach ($_Result as $key=>$val){
		
		if (isset($val['MSlug'], $val['Name'])) {
			
			$_Output.='<div class="col-md-3"><a href="//localthanks.'._env()['enviroment_name'] . '/' . $val['MSlug'].'">'.$val['Name'].'</a></div>';
		}
		else{			 
			$href='/directory/' . strtolower($val['gs_abbr']);
			$linkName=$val['gs_abbr'];
			if ( isset($val['gcty_city'] ) ) {
				$href.= '/' . strtolower(str_replace(' ', '+',$val['gcty_city']));
				$linkName=$val['gcty_city'];
			}	
			if ( isset($val['C1Name'], $val['C1Slug']) ) {
				$href.= '/' . strtolower($val['C1Slug']);
				$linkName=$val['C1Name'];
			}
			if ( isset($val['C2Name'], $val['C2Slug']) ) {
				$href.= '/' . strtolower($val['C2Slug']);
				$linkName=$val['C2Name'];
			}
			
			$_Output.='<div class="col-md-3"><a href="'. $href .'">'.$linkName.'</a></div>';
			
		}
		
	}
}

?>

<title>Local Thanks&#8480; | Loyalty Superstore&#8480;</title>
<meta name="description" content="Local Thanks&#8480;">
<meta name="keywords" content="Local Thanks&#8480;, merchant, sell online">
<link rel="shortcut icon" href="/favicon.ico">
<link rel="stylesheet" href="/plugins/bootstrap/css/bootstrap.css">
<link rel="stylesheet" href="/plugins/bootstrap/css/bootstrap-theme.css">
<!-- scripts -->
<script type="text/javascript" src="/plugins/jquery/jquery-1.11.1.min.js"></script>
<!--script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script-->
<script type="text/javascript" src="/plugins/bootstrap/js/bootstrap.js"></script>
<!-- global -->
<link rel="stylesheet" href="/css/global.css">
<!-- styles -->
<link rel="stylesheet" href="/localthanks/css/styles.css">
</head>
<body>
<div class="wrap" style="background: #0d7cc1; padding: 20px 0 15px;">
	<div class="container">
		<div class="row">
			<div class="col-md-4">				
				<img class="signupLTLogo" src="/images/localthanks.png">
			</div>
			<div class="col-md-8">				
				<div class="signupHeader">Search for Great Deals from Local Merchants!</div>				
			</div>			
		</div>
	</div>
</div>
	
 <div class="container">
	<nav>
		<div class="links-output row"> 
			<?php echo $_Output; ?>
		</div><!-- end row -->
	</nav>
 </div><!-- end container --> 
<style>
.links-output{
	margin-top: 100px;
}
.signupLTLogo {
	margin: 0 auto;
	display: block;
	position: absolute;
	width: 200px;
	right: 0;
	left: 0;
}
@media (max-width: 990px) {
	.signupLTLogo {
		top: inherit;
		position: inherit;
	}
}
.signupHeader {
	font-weight:bold; 
	font-size: 158%; 
	line-height: .9; 
	color:#fff; 
	text-transform: uppercase; 
	text-shadow: 0px 0px 6px rgba(0, 0, 0, 1); 
	letter-spacing: 1px;
	margin-bottom: 10px;
	text-align: center;
}
</style>
</body>
</html>