<?php
/**
 * On-the-fly CSS Compression
 *
 * In order to minimize the number and size of HTTP requests for CSS content,
 * this script combines multiple CSS files into a single file and compresses
 * it on-the-fly.
 */

/* Add your CSS files to this array */
/*
$css = array(
  $_SERVER["DOCUMENT_ROOT"].'/plugins/bootstrap/css/bootstrap-theme.css',
  $_SERVER["DOCUMENT_ROOT"].'/plugins/layerslider/css/layerslider.css',
  $_SERVER["DOCUMENT_ROOT"].'/plugins/fancybox/fancybox.css',
  $_SERVER["DOCUMENT_ROOT"].'/plugins/animate/animate.css',
  //$_SERVER["DOCUMENT_ROOT"].'/plugins/owl-carousel/version2/assets/css/foundation.min.css',
  $_SERVER["DOCUMENT_ROOT"].'/plugins/owl-carousel/version2/owlcarousel/owl.carousel.css',
  $_SERVER["DOCUMENT_ROOT"].'/plugins/owl-carousel/version2/owlcarousel/owl.theme.css',
  //$_SERVER["DOCUMENT_ROOT"].'/plugins/owl-carousel/version2/assets/js/highlight/styles/monokai_sublime.css',
  //$_SERVER["DOCUMENT_ROOT"].'/plugins/owl-carousel/version2/assets/css/demo.css',
  $_SERVER["DOCUMENT_ROOT"].'/plugins/bootstrap/datepicker/datepicker.min.css',
  $_SERVER["DOCUMENT_ROOT"].'/css/global.css',
  $_SERVER["DOCUMENT_ROOT"].'/localthanks/css/styles.css',

  $_SERVER["DOCUMENT_ROOT"].'/localthanks/css/national-home.css',
  $_SERVER["DOCUMENT_ROOT"].'/localthanks/css/national-store.css',
  $_SERVER["DOCUMENT_ROOT"].'/localthanks/css/national-stores.css',
  $_SERVER["DOCUMENT_ROOT"].'/localthanks/css/faq.css',
  $_SERVER["DOCUMENT_ROOT"].'/localthanks/css/how-it-works.css',
  $_SERVER["DOCUMENT_ROOT"].'/localthanks/css/how-to-redeem.css',

  //$_SERVER["DOCUMENT_ROOT"].'/localthanks/css/national-sidebar.css',
  $_SERVER["DOCUMENT_ROOT"].'/localthanks/css/national-menubar.css',
  $_SERVER["DOCUMENT_ROOT"].'/localthanks/css/local-menubar.css',

  $_SERVER["DOCUMENT_ROOT"].'/localthanks/css/super-deals.css',
  $_SERVER["DOCUMENT_ROOT"].'/localthanks/css/deals-car-rental.css',
  $_SERVER["DOCUMENT_ROOT"].'/localthanks/css/deals-vacation-voucher.css',

  $_SERVER["DOCUMENT_ROOT"].'/localthanks/css/header.css',
  $_SERVER["DOCUMENT_ROOT"].'/localthanks/css/footer.css'

);
*/
$css = array();


//find and load bootstrap theme chosen by merchant
require_once ('../../app/global.php');

$sql  = "SELECT `tmp_css_file` FROM `tbl_templates` TMP INNER JOIN `lt_member_merchants` LTB ON TMP.tmp_id=LTB.tmp_id WHERE `ltb_id`=:ltb_id LIMIT 1";  
$stmt = $dbo->prepare($sql);
$stmt->bindValue(':ltb_id', $_SESSION['user']['consumer']['ltb_id'], PDO::PARAM_INT);
$stmt=execPDO($stmt);

if(!$stmt->rowCount()){ 
  $css[]=ROOT_URL.'/localthanks/css/theme_default.css';
}else{
  $row = $stmt->fetch(PDO::FETCH_OBJ);
  $css[]=ROOT_URL.'/localthanks/css/'.$row->tmp_css_file.'">';
}

$buffer = "";
foreach($css as $file) {
  $buffer .= file_get_contents($file);
}

// Remove comments
//$buffer = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $buffer);

// Remove space after colons
$buffer = str_replace(': ', ':', $buffer);

// Remove whitespace
$buffer = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $buffer);

// Enable GZip encoding.
ob_start('ob_gzhandler');

// Enable caching
header('Cache-Control: public');

// Expire in one day
header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 86400) . ' GMT');

// Set the correct MIME type, because Apache won't set it for us
header('Content-type: text/css');

// Write everything out
echo $buffer;

/* EOF ?> */