<?php 
namespace App\MyStore\MemberMerchant {


	//require_once "class.promo.php";
	require_once $_SERVER['DOCUMENT_ROOT']."/app/class.member-merchant.php";
	require_once "class.mystore-promo.php";
	require_once "class.mystore-store.php";
	require_once $_SERVER['DOCUMENT_ROOT']."/app/class.variables.php";
	require_once "HTMLSyntaxChecker.php";
	
	use App\MyStore\MemberMerchant\Store as Store;
	use App\MyStore\MemberMerchant\Promo as Promo;
	use App\MemberMerchant as Merchant;
	use App\MyStore\HTMLSyntaxChecker as HTMLSyntaxChecker;
	
	class MyStoreMemberMerchant extends Merchant\MemberMerchant {
		//private properties
		private $mmDbo = null;
		
		//private functions
		private function checkPosIntList($intList) {
			if ( is_string( $intList ) ){
				$tempArr = explode(',',$intList);
				$resultFlag = true;
				if (!empty($tempArr))
					foreach ($tempArr as $v) {
						$resultFlag = $resultFlag && is_numeric($v) && intval($v) == $v;
					}
				return $resultFlag;
			}
			return false;
		}
		
		private function saveHeaderImage($imageName){
			$stmt = $this->mmDbo->prepare("UPDATE `lt_member_merchants` SET ltb_header_image=:imageName,ltb_timestamp=NOW() WHERE ltb_id=:ltbId" );
			$stmt->bindValue( ":ltbId", $this->currentMerchantId, \PDO::PARAM_INT );	
			$stmt->bindValue( ":imageName", $imageName, \PDO::PARAM_STR );	
			$stmt->execute();
		}
		
		private function loadRecords($ltbId = null, $loadPromos = false, $offset = 0) {

			$varOffset = $offset;			
			
			if ( !is_int( $varOffset ) || $varOffset <= 0) $varOffset = '0';
			if ( \NEW_DB_SWITCH )
				$packObj = new \App\Package\package( $this->mmDbo, 0 );
			$stmt = $this->mmDbo->prepare(
			( \NEW_DB_SWITCH ?
			"
				SELECT DISTINCT MMC. *, PPR.*, PACK.*, PROD.*, TMZ.*, CAT.cat_id,CAT.cat_name,CAT.cat_parent_id
				FROM lt_member_merchants MMC
				INNER JOIN tbl_package PACK ON PACK.pk_id = MMC.pk_id
				INNER JOIN tbl_product PROD ON PROD.prod_id = PACK.pk_id
				INNER JOIN (
								SELECT * FROM tbl_prod_price WHERE ppr_current_price
							) PPR ON PPR.prod_id = PROD.prod_id
				INNER JOIN tbl_timezone TMZ ON MMC.tmz_id = TMZ.tmz_id							
				INNER JOIN lt_m2cat L2C ON L2C.ltb_id=MMC.ltb_id
				INNER JOIN tbl_category CAT ON L2C.cat_id=CAT.cat_id
			"
			: 
			"
				SELECT DISTINCT MMC. *, PTY.* , PTM. *, TMZ.*, CAT.cat_id,CAT.cat_name,CAT.cat_parent_id
				FROM lt_member_merchants MMC
				INNER JOIN lt_plan_type AS PTY ON MMC.pty_id = PTY.pty_id
				INNER JOIN tbl_timezone TMZ ON MMC.tmz_id = TMZ.tmz_id			
				INNER JOIN lt_m2cat L2C ON L2C.ltb_id=MMC.ltb_id
				INNER JOIN tbl_category CAT ON L2C.cat_id=CAT.cat_id
				INNER JOIN lt_merchant_plans AS PTM ON PTM.lmp_id = MMC.lmp_id
			").( $ltbId === null? "LIMIT 100 OFFSET {$varOffset}": " WHERE MMC.ltb_id=:ltbId LIMIT 1" ) );				

			if ( $ltbId !== null )

				$stmt->bindValue( ":ltbId", $ltbId, \PDO::PARAM_INT );

			$stmt->execute();

			while ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
				
				$resultSet['Switches']= $this->gatMerchantSwitches( $resultSet['ltb_id'] );
				
				$resultSet['Plan']= \NEW_DB_SWITCH? $packObj->findBasicProductList ( $resultSet['pk_id'] ) : $this->gatPlanFeatures( $resultSet['ltb_id'], $resultSet['lmp_id'] );

				$resultSet['Store']= new Store\MystoreMerchantStore( $this->mmDbo );

				$resultSet['Store']->loadRecords( $resultSet['ltb_id'], 'ltb_id', \PDO::PARAM_INT );
				
				$resultSet['Store']->myStoreLoadConsumers();

				if ($loadPromos) {

					$resultSet['Promo'] = new Promo\MyStorePromo( $this->mmDbo, null);

					$resultSet['Promo']->loadRecords( $resultSet['ltb_id'], 'ltb_id', 'MMC', isset($resultSet['Switches']['randomize_promos']) && $resultSet['Switches']['randomize_promos']? 'random' : 'default' );

				}

				else

					$resultSet['Promo'] = null;

				$this->currentMerchantId = $resultSet['ltb_id'];				

				$this->mRecords[$resultSet['ltb_id']] = $resultSet;				
				
				$this->nationalMallJumpBasedOnRes();
			}

		}
		
		//public functions
		public function getRedeemptionCountPerUser($daysNow = 186) {
			if (isset($this->mRecords[$this->currentMerchantId]) && is_numeric($daysNow) && intval($daysNow) > 0) {
				$this->mRecords[$this->currentMerchantId]['Redemptions'] = array();		
				$stmt = $this->mmDbo->prepare("
					SELECT COUNT(RED.lpr_id) AS redemptions, MCnt.mRed, RED.csm_id
					FROM lt_promo_redemptions RED
					INNER JOIN (
						SELECT COUNT(lpr_id) AS mRed, csm_id 
						FROM lt_promo_redemptions R
						INNER JOIN lt_promos P ON P.ltp_id=R.ltp_id
						INNER JOIN lt_member_merchants M ON P.ltb_id=M.ltb_id
						WHERE DATEDIFF(NOW(), R.lpr_redeem_date) <= {$daysNow} AND M.ltb_id=:ltbId
						GROUP BY R.csm_id
					) MCnt ON MCnt.csm_id = RED.csm_id							
					GROUP BY MCnt.mRed, RED.csm_id
				");
				$stmt->bindValue(":ltbId", $this->currentMerchantId, \PDO::PARAM_INT);
				$stmt->execute();
				while ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
					$this->mRecords[$this->currentMerchantId]['Redemptions'][$resultSet['csm_id']] = $resultSet;
				}
				return $this->mRecords[$this->currentMerchantId]['Redemptions'];
			}
			return false;
		}
		
		function getPromoTrackingHistory($daysNow = 186) {
			if (isset($this->mRecords[$this->currentMerchantId]) && is_numeric($daysNow) && intval($daysNow) >= 0) {					
				$daysNowOk = intval($daysNow);
				$this->mRecords[$this->currentMerchantId]['History'] = array();		
				$stmt = $this->mmDbo->prepare("
					SELECT I.*
					FROM lt_promos P 
					INNER JOIN lt_member_merchants M ON P.ltb_id=M.ltb_id
										
					LEFT JOIN (
						SELECT SUM(lpk_impressions) AS impressions, SUM(lpk_views) AS views, SUM(lpk_shares) AS shares, lpk_scratched AS scratched, ltp_id, MONTH(lpk_date) AS lpk_month, YEAR(lpk_date) AS lpk_year
						FROM lt_promo_tracking						
						".(empty($daysNowOk)?"":"WHERE DATEDIFF(NOW(), lpk_date) <= {$daysNowOk}")."
						GROUP BY ltp_id, lpk_month, lpk_year
					) I ON P.ltp_id=I.ltp_id
					WHERE M.ltb_id=:ltbId AND I.ltp_id IS NOT NULL		
				");
				$stmt->bindValue(":ltbId", $this->currentMerchantId, \PDO::PARAM_INT);
				$stmt->execute();
				if ( $resultSet = $stmt->fetchAll( \PDO::FETCH_ASSOC ) ) {
					$this->mRecords[$this->currentMerchantId]['History'] = $resultSet;
				}
				return $this->mRecords[$this->currentMerchantId]['History'];
			}
			return false;
		}
		
		function getPromoRedemptionHistory($daysNow = 186) {
			if (isset($this->mRecords[$this->currentMerchantId]) && is_numeric($daysNow) && intval($daysNow) >= 0) {					
			    $daysNowOk = intval($daysNow);
				$this->mRecords[$this->currentMerchantId]['RedemptionHistory'] = array();		
				$stmt = $this->mmDbo->prepare("
					SELECT R.*
					FROM lt_promos P 
					INNER JOIN lt_member_merchants M ON P.ltb_id=M.ltb_id
				
					LEFT JOIN (
						SELECT COUNT(lpr_id) AS redeemed, ltp_id, MONTH(lpr_redeem_date) AS lpr_month, YEAR(lpr_redeem_date) AS lpr_year
						FROM lt_promo_redemptions					
						".(empty($daysNowOk)?"":"WHERE DATEDIFF(NOW(), lpr_redeem_date) <= {$daysNowOk}")."
						GROUP BY ltp_id, lpr_month, lpr_year
					) R ON P.ltp_id=R.ltp_id
					
					WHERE M.ltb_id=:ltbId AND R.ltp_id IS NOT NULL				
				");
				$stmt->bindValue(":ltbId", $this->currentMerchantId, \PDO::PARAM_INT);
				$stmt->execute();
				if ( $resultSet = $stmt->fetchAll( \PDO::FETCH_ASSOC ) ) {
					$this->mRecords[$this->currentMerchantId]['RedemptionHistory'] = $resultSet;
				}
				return $this->mRecords[$this->currentMerchantId]['RedemptionHistory'];
			}
			return false;
		}
		
		function getRedemptionCountPerPromo($daysNow = 186, $consumerId = 0) {
			if (isset($this->mRecords[$this->currentMerchantId]) && is_numeric($consumerId) && intval($consumerId) >= 0 && is_numeric($daysNow) && intval($daysNow) >= 0) {
			    $daysNowOk = intval($daysNow);
				$consumerIdOk = intval($consumerId);
				$this->mRecords[$this->currentMerchantId]['RedemptionCountPerPromo'] = array();		
				$stmt = $this->mmDbo->prepare("
					SELECT COUNT(RED.lpr_id) AS redemptions, PRO.ltp_id AS promoId, PRO.ltp_headline AS promoHeader
					FROM tbl_consumer CSM
					INNER JOIN lt_promo_redemptions RED ON RED.csm_id=CSM.csm_id
					INNER JOIN lt_promos PRO ON PRO.ltp_id=RED.ltp_id	
					INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=PRO.ltb_id
					WHERE ".( empty($consumerIdOk)? "": "CSM.csm_id=:userId
					AND " )."MMR.ltb_id=:ltbId			  
						  AND CSM.csm_active = 1
						  AND DATEDIFF(NOW(), RED.lpr_redeem_date) <= {$daysNowOk}
					GROUP BY promoId, promoHeader
					HAVING redemptions > 0                                                                                                                                                                                                                              
					ORDER BY promoId				
				");
				if (!empty($consumerIdOk))
					$stmt->bindValue(":userId", $consumerIdOk, \PDO::PARAM_INT);
				$stmt->bindValue(":ltbId", $this->currentMerchantId, \PDO::PARAM_INT);
				$stmt->execute();
				if ( $resultSet = $stmt->fetchAll( \PDO::FETCH_ASSOC ) ) {
					$this->mRecords[$this->currentMerchantId]['RedemptionCountPerPromo'] = $resultSet;
				}
				return $this->mRecords[$this->currentMerchantId]['RedemptionCountPerPromo'];
			}
			return false;
		}
		
		function getPromoRedemedDate($promoId, $daysNow = 186, $consumerId = 0) {
			$ltmId = $this->getCurrentStore('ltm_id');
			if (!empty($ltmId) && isset($this->mRecords[$this->currentMerchantId]) && is_numeric($promoId) && intval($promoId) > 0 && is_numeric($consumerId) && intval($consumerId) >= 0 && is_numeric($daysNow) && intval($daysNow) >= 0) {
			    $daysNowOk = intval($daysNow);
				$consumerIdOk = intval($consumerId);
				$promoIdOk = intval($promoId);
				$this->mRecords[$this->currentMerchantId]['PromoRedemedDate'] = array(); 		
				$stmt = $this->mmDbo->prepare("
					SELECT RED.lpr_redeem_date AS redeemedDate, (CASE WHEN CSM.ltm_pick_id = :ltmId THEN 1 ELSE 0 END) AS Picked, CSM.ltm_pick_id AS pick_id, CSM.csm_id AS id, CSM.csm_first_name AS fname, CSM.csm_last_name AS lname, CSM.csm_email AS email, CSM.csm_cell_number AS phone, CSM.csm_zip AS zip, DATE_FORMAT(CSM.csm_add_date,'%c/%d/%Y') as date_joined
					FROM tbl_consumer CSM
					INNER JOIN lt_promo_redemptions RED ON RED.csm_id=CSM.csm_id
					INNER JOIN lt_promos PRO ON PRO.ltp_id=RED.ltp_id	
					INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=PRO.ltb_id
					WHERE RED.ltp_id=:promoId
						  AND MMR.ltb_id=:ltbId
						  " . ( empty($consumerIdOk)? "" : "AND CSM.csm_id = :userId" ) . "
						  AND CSM.csm_active = 1
						  AND DATEDIFF(NOW(), RED.lpr_redeem_date) <= {$daysNowOk}                                                                                                                                                                                                                              
					ORDER BY redeemedDate");
				if (!empty($consumerIdOk))
					$stmt->bindValue(":userId", $consumerIdOk, \PDO::PARAM_INT);
				$stmt->bindValue(":promoId", $promoIdOk, \PDO::PARAM_INT);
				$stmt->bindValue(":ltmId", $ltmId, \PDO::PARAM_INT);
				$stmt->bindValue(":ltbId", $this->currentMerchantId, \PDO::PARAM_INT);
				$stmt->execute();
				if ( $resultSet = $stmt->fetchAll( \PDO::FETCH_ASSOC ) ) {
					$this->mRecords[$this->currentMerchantId]['PromoRedemedDate'] = $resultSet;
				}
				return $this->mRecords[$this->currentMerchantId]['PromoRedemedDate'];
			}
			return false;
		}		
		
		function getUserCountThatRedemedPromo($promoId, $daysNow = 186, $consumerIdList = '0') {			
			if ( $this->checkPosIntList($consumerIdList) && isset($this->mRecords[$this->currentMerchantId]) && is_numeric($promoId) && intval($promoId) > 0 && is_numeric($daysNow) && intval($daysNow) >= 0 ) {
			    $daysNowOk = intval($daysNow);				
				$promoIdOk = intval($promoId);
				$this->mRecords[$this->currentMerchantId]['UserCountThatRedemedPromo'] = array(); 		
				$stmt = $this->mmDbo->prepare("
					SELECT 
						COUNT(RED.csm_id) AS month_amount, 
						PRO.ltp_headline AS headLine, 
						MONTH(RED.lpr_redeem_date) AS month_red, 
						YEAR(RED.lpr_redeem_date) AS year_red 
					FROM lt_promo_redemptions RED
					INNER JOIN lt_promos PRO ON PRO.ltp_id=RED.ltp_id	
					INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=PRO.ltb_id 
					WHERE 
						MMR.ltb_id = :ltbId 
						AND PRO.ltp_id=:promoId  
						AND RED.csm_id IN ({$consumerIdList}) 
						AND DATEDIFF(NOW(), RED.lpr_redeem_date) <= {$daysNowOk}  
					GROUP BY headLine, month_red, year_red
					ORDER BY month_red, year_red");
				$stmt->bindValue(":promoId", $promoIdOk, \PDO::PARAM_INT);				
				$stmt->bindValue(":ltbId", $this->currentMerchantId, \PDO::PARAM_INT);
				$stmt->execute();
				if ( $resultSet = $stmt->fetchAll( \PDO::FETCH_ASSOC ) ) {
					$this->mRecords[$this->currentMerchantId]['UserCountThatRedemedPromo'] = $resultSet;
				}
				return $this->mRecords[$this->currentMerchantId]['UserCountThatRedemedPromo'];
			}
			return false;
		}
		
		function getRedemedCountOfUserOnPromo($consumerId, $promoId, $daysNow = 186) {			
			if ( is_numeric($promoId) && intval($promoId) > 0 && isset($this->mRecords[$this->currentMerchantId]) && is_numeric($consumerId) && intval($consumerId) > 0 && is_numeric($daysNow) && intval($daysNow) >= 0 ) {
			    $daysNowOk = intval($daysNow);				
				$consumerIdOk = intval($consumerId);
				$promoIdOk = intval($promoId);
				$this->mRecords[$this->currentMerchantId]['RedemedCountOfUserOnPromo'] = array(); 		
				$stmt = $this->mmDbo->prepare("
					SELECT 
						COUNT(CSM.csm_id) AS amount, 
						CSM.csm_first_name AS fName, 
						CSM.csm_last_name AS lName, 
						DAY(RED.lpr_redeem_date) AS day_red, 
						MONTH(RED.lpr_redeem_date) AS month_red, 
						YEAR(RED.lpr_redeem_date) AS year_red 
					FROM lt_promo_redemptions RED
					INNER JOIN tbl_consumer CSM ON RED.csm_id=CSM.csm_id
					INNER JOIN lt_promos PRO ON PRO.ltp_id=RED.ltp_id	
					INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=PRO.ltb_id 
					WHERE
						CSM.csm_id = :userId
						AND MMR.ltb_id = :ltbId
						AND PRO.ltp_id = :promoId
						AND DATEDIFF(NOW(), RED.lpr_redeem_date) <= {$daysNowOk}
					GROUP BY fName, lName, day_red, month_red, year_red
					ORDER BY day_red, month_red, year_red");
				$stmt->bindValue(":promoId", $promoIdOk, \PDO::PARAM_INT);	
				$stmt->bindValue(":userId", $consumerIdOk, \PDO::PARAM_INT);				
				$stmt->bindValue(":ltbId", $this->currentMerchantId, \PDO::PARAM_INT);
				$stmt->execute();
				if ( $resultSet = $stmt->fetchAll( \PDO::FETCH_ASSOC ) ) {
					$this->mRecords[$this->currentMerchantId]['RedemedCountOfUserOnPromo'] = $resultSet;
				}
				return $this->mRecords[$this->currentMerchantId]['RedemedCountOfUserOnPromo'];
			}
			return false;
		}
		
		function getRedemedCountOfUser($consumerId, $daysNow = 186, $promoIdList = '0') {			
			if ( $this->checkPosIntList($promoIdList) && isset($this->mRecords[$this->currentMerchantId]) && is_numeric($consumerId) && intval($consumerId) > 0 && is_numeric($daysNow) && intval($daysNow) >= 0 ) {
			    $daysNowOk = intval($daysNow);				
				$consumerIdOk = intval($consumerId);
				$this->mRecords[$this->currentMerchantId]['PromoCountRedemedByUser'] = array(); 		
				$stmt = $this->mmDbo->prepare("
					SELECT 
						COUNT(RED.lpr_id) AS amount, 
						CSM.csm_first_name AS fName, 
						CSM.csm_last_name AS lName, 
						PRO.ltp_id AS promoId, 
						PRO.ltp_headline AS promoHeader, 
						MONTH(RED.lpr_redeem_date) AS month_red, 
						YEAR(RED.lpr_redeem_date) AS year_red 
					FROM lt_promo_redemptions RED
					INNER JOIN lt_promos PRO ON PRO.ltp_id=RED.ltp_id	
					INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=PRO.ltb_id 
					INNER JOIN tbl_consumer CSM ON CSM.csm_id=RED.csm_id 
					WHERE 
						MMR.ltb_id = :ltbId 
						AND RED.csm_id = :userId 
						AND PRO.ltp_id IN ({$promoIdList}) 
						AND DATEDIFF(NOW(), RED.lpr_redeem_date) <= {$daysNowOk}  
					GROUP BY promoHeader, month_red, year_red, fName, lName
					ORDER BY month_red, year_red");
				$stmt->bindValue(":userId", $consumerIdOk, \PDO::PARAM_INT);				
				$stmt->bindValue(":ltbId", $this->currentMerchantId, \PDO::PARAM_INT);
				$stmt->execute();
				if ( $resultSet = $stmt->fetchAll( \PDO::FETCH_ASSOC ) ) {
					$this->mRecords[$this->currentMerchantId]['PromoCountRedemedByUser'] = $resultSet;
				}
				return $this->mRecords[$this->currentMerchantId]['PromoCountRedemedByUser'];
			}
			return false;
		}

		function getRedemedCountOfUserList($daysNow = 186, $promoIdList = '0') {			
			if ( $this->checkPosIntList($promoIdList) && isset($this->mRecords[$this->currentMerchantId]) && is_numeric($daysNow) && intval($daysNow) >= 0 ) {
			    $daysNowOk = intval($daysNow);				
				
				$this->mRecords[$this->currentMerchantId]['RedemedCountOfUserList'] = array(); 		
				$stmt = $this->mmDbo->prepare("
					SELECT 
						COUNT(RED.csm_id) AS month_amount, 
						PRO.ltp_headline AS promoHeader, 
						PRO.ltp_id AS promoId, 
						MONTH(RED.lpr_redeem_date) AS month_red, 
						YEAR(RED.lpr_redeem_date) AS year_red 
					FROM lt_promo_redemptions RED 
					INNER JOIN lt_promos PRO ON PRO.ltp_id=RED.ltp_id	
					INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=PRO.ltb_id 
					WHERE 
						MMR.ltb_id = :ltbId
						AND DATEDIFF(NOW(), RED.lpr_redeem_date) <= {$daysNowOk}
						AND PRO.ltp_id IN ({$promoIdList})
					GROUP BY promoId, promoHeader, MONTH(RED.lpr_redeem_date), YEAR(RED.lpr_redeem_date)");				
				$stmt->bindValue(":ltbId", $this->currentMerchantId, \PDO::PARAM_INT);
				$stmt->execute();
				if ( $resultSet = $stmt->fetchAll( \PDO::FETCH_ASSOC ) ) {
					$this->mRecords[$this->currentMerchantId]['RedemedCountOfUserList'] = $resultSet;
				}
				return $this->mRecords[$this->currentMerchantId]['RedemedCountOfUserList'];
			}
			return false;
		}	
		
		function getPromoRedemptions($promoId, $consumerId, $daysNow = 186) {
			$ltmId = $this->getCurrentStore('ltm_id');
			if (!empty($ltmId) && isset($this->mRecords[$this->currentMerchantId]) && is_numeric($promoId) && intval($promoId) > 0 && is_numeric($consumerId) && intval($consumerId) >= 0 && is_numeric($daysNow) && intval($daysNow) >= 0) {
			    $daysNowOk = intval($daysNow);
				$consumerIdOk = intval($consumerId);
				$promoIdOk = intval($promoId);
				$this->mRecords[$this->currentMerchantId]['PromoRedemedDate'] = array(); 		
				$stmt = $this->mmDbo->prepare("
					SELECT COUNT(RED.lpr_id) AS redemptions, (CASE WHEN CSM.ltm_pick_id = :ltmId THEN 1 ELSE 0 END) AS Picked, CSM.ltm_pick_id AS pick_id, CSM.csm_id AS id, CSM.csm_first_name AS fname, CSM.csm_last_name AS lname, CSM.csm_email AS email, CSM.csm_cell_number AS phone, CSM.csm_zip AS zip, DATE_FORMAT(CSM.csm_add_date,'%c/%d/%Y') as date_joined
					FROM tbl_consumer CSM
					INNER JOIN lt_promo_redemptions RED ON RED.csm_id=CSM.csm_id
					INNER JOIN lt_promos PRO ON PRO.ltp_id=RED.ltp_id	
					INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=PRO.ltb_id
					WHERE RED.ltp_id=:promoId
						  AND MMR.ltb_id=:ltbId
						  " . ( empty($consumerIdOk)? "" : "AND CSM.csm_id = :userId" ) . "
						  AND CSM.csm_active = 1
						  AND DATEDIFF(NOW(), RED.lpr_redeem_date) <= {$daysNowOk}                                                                                                                                                                                                                              
					GROUP BY Picked, pick_id, id, fname, lname, email, phone, zip, date_joined
					HAVING redemptions > 0                                                                                                                                                                                                                              
					ORDER BY id");
				if (!empty($consumerIdOk))
					$stmt->bindValue(":userId", $consumerIdOk, \PDO::PARAM_INT);
				$stmt->bindValue(":promoId", $promoIdOk, \PDO::PARAM_INT);
				$stmt->bindValue(":ltmId", $ltmId, \PDO::PARAM_INT);
				$stmt->bindValue(":ltbId", $this->currentMerchantId, \PDO::PARAM_INT);
				$stmt->execute();
				if ( $resultSet = $stmt->fetchAll( \PDO::FETCH_ASSOC ) ) {
					$this->mRecords[$this->currentMerchantId]['PromoRedemedDate'] = $resultSet;
				}
				return $this->mRecords[$this->currentMerchantId]['PromoRedemedDate'];
			}
			return false;
		}
		
		function getAllowPromoCount () {
			if ( is_array( $this->mRecords[$this->currentMerchantId]['Plan'] ) ) {
				foreach ( $this->mRecords[$this->currentMerchantId]['Plan'] as $prodId => $valArr ) {					
					//var_dump($valArr['Data']['prod_keyword']);					
					if ( strcmp( $valArr['Data']['prod_keyword'], 'LT_PROMO_SPACES' ) === 0 ) {
						return intval($valArr['Data']['p2p_count']);
					}
				}
			}
			return 0;
		}
		
		function promoImageResize ( $uploadImageArr, $sizesArray, $isItLogo = false ) {
			$this->getMerchantSubDir('../merchant-custom-files/', true);
			$merchSubDir = $this->getMerchantSubDir('');
			$imagickObj = new \Imagick($uploadImageArr["tmp_name"]);
			$type = str_replace( 'image/', '.', strtolower($uploadImageArr['type']) );
			list( $im_w, $im_h ) = getimagesize( $uploadImageArr['tmp_name'] );
			
			if (!$isItLogo){			   
				$perpname='p'; 
				$uid = uniqid();				
				$name = $uid . '_' . preg_replace( "/[^a-zA-Z0-9_\-]/", "", str_replace(array( '.jpg', '.jpeg', '.png', '.gif' ), '', strtolower( $uploadImageArr['name'] ) )  ) . $type;
				// save source file
				$path = '../merchant-custom-files/'.$merchSubDir.'/_files/img/'.'source_'.$name;
				$img_d = $imagickObj->getImageGeometry();
				//scale down to 1200px wide
				if ($img_d['width'] > 1200){
					$imagickObj->scaleImage(1200, 0);  
				}
				$imagickObj->writeImage($path);			
			}
			else{
				$perpname = 'h';				 
				$name = 'header' . $type;
				$u = $this->getCurrent( 'ltb_header_image' );
				if( !empty( $u ) ) {
					foreach ( glob( '../merchant-custom-files/'.$merchSubDir.'/_files/img/h_*_'.$u ) as $f ) unlink( $f );
				}	
				$this->saveHeaderImage($name); 
			}    	
			
			foreach($sizesArray as $Key=>$Value){
			 
			 $path = '../merchant-custom-files/'.$merchSubDir.'/_files/img/'."{$perpname}_{$Key}".($Value=='auto'||$Key==250?'w':"x{$Value}").'_'.$name;	 

			 if ($Value=='auto'){
			  $imagickObj->scaleImage($Key , 0);
			  $imagickObj->writeImage($path);
			 }
			 else{
			  if ($isItLogo){
			   $im_d = $imagickObj->getImageGeometry(); 
			   $im_w = $im_d['width']; 
			   $im_h = $im_d['height'];
			   if ($im_w>$im_h){
				$imagickObj->scaleImage($Key, 0);
			   }
			   else{	   
				$imagickObj->scaleImage(0, $Value);
			   }	
				$im_d = $imagickObj->getImageGeometry(); 
				$im_w = $im_d['width']; 
				$im_h = $im_d['height']; 

				$watermark = new \Imagick();
				$watermark->readImage("images/water_mark.png");
				
				$watermark_d = $watermark->getImageGeometry();
				$watermark_w = $watermark_d['width'];
				$watermark_h = $watermark_d['height'];

				$margin_W = abs(round(($watermark_w-$im_w)/2));
				$margin_H = abs(round(($watermark_h-$im_h)/2));

				$watermark->compositeImage($imagickObj, \imagick::COMPOSITE_OVER, $margin_W, $margin_H);
				
				$watermark->writeImage($path);			   
			  }
			  else{
			   if (!isset($img_d))
				$img_d = $imagickObj->getImageGeometry();
				
			   if ($img_d['width']!=$Key && $img_d['height']!=$Value){ 	   
				$imagickObj->cropImage( $Key , $Value , abs(round(($img_d['width']-$Key)/2)) , abs(round(($img_d['height']-$Value)/2)) );		
			   } 
			   $imagickObj->writeImage($path);
			  }
			 }
			} 		
		}
		
		function buildMyStorePromoLayouts( $envExt ) {
			$Result='';
			if (isset($this->mRecords[$this->currentMerchantId])) {
				$merchantURL = $this->getMerchantSubDir('../merchant-custom-files'); $i = 1;				
				foreach ($this->mRecords[$this->currentMerchantId]['Promo']->promoRecords as $key=>$val) {
					$this->mRecords[$this->currentMerchantId]['Promo']->currentPromoId = $val['ltp_id'];
					$Result .= $this->mRecords[$this->currentMerchantId]['Promo']->buildMyStorePromoLayOut($merchantURL, $i++, $this->getCurrent('ltb_slug'), $envExt);					
				}
			}
			return $Result;
		}
		
		function loadPromos ($orderBy = 'default'){			
			$this->mRecords[$this->currentMerchantId]['Promo'] = new Promo\MyStorePromo( $this->mmDbo );			
			if (isset($this->mRecords[$this->currentMerchantId])) {
				return $this->mRecords[$this->currentMerchantId]['Promo']->loadRecords($this->currentMerchantId, 'ltb_id', 'MMC', $orderBy);				
			}
			return array();
		}
		
		function loadThisPromo ($anId, &$imgType){
			$imgType = '';
			if (isset($this->mRecords[$this->currentMerchantId]) && is_numeric($anId)) {	
				$this->mRecords[$this->currentMerchantId]['Promo'] = new Promo\MyStorePromo( $this->mmDbo );			
				$this->mRecords[$this->currentMerchantId]['Promo']->loadPromo(intval($anId));
				$this->mRecords[$this->currentMerchantId]['Promo']->findMyStoreImageURL($this->getMerchantSubDir(''), $imgType);
			}
		}
		
		function getAvailablePromoTypes() {
			$stmt = $this->mmDbo->prepare("SELECT lpt_id, lpt_name, lpt_description FROM lt_promo_types WHERE lpt_active=1 ORDER BY lpt_order ASC");
			$stmt->execute();
			return $stmt->fetchAll(\PDO::FETCH_ASSOC);
		}
		
		function getCurrentPromoImgType (){
			$imgType = false;
			if (isset($this->mRecords[$this->currentMerchantId]['Promo'])) {					
				$this->mRecords[$this->currentMerchantId]['Promo']->findMyStoreImageURL($this->getMerchantSubDir(''), $imgType);
			}
			return $imgType;
		}
		
		function getCurrentPromoTrackingHistory(){
			$Result = array();
			if (isset($this->mRecords[$this->currentMerchantId]['Promo'])) {					
				return $this->mRecords[$this->currentMerchantId]['Promo']->getCurrent('TrackingHistory');
			}
			return $Result;
		}
		
		function getCurrentPromoList (){
			if (isset($this->mRecords[$this->currentMerchantId]) && !empty($this->mRecords[$this->currentMerchantId]['Promo']) )								
				return $this->mRecords[$this->currentMerchantId]['Promo']->promoRecords;
			return array();
		}
		
		function createCrossPromo($promoId, $storePromoted){		
			if ($this->validData($cData, $promoId, $fileType='wnu_ltp_id_r')){
				$promoIdOk = $cData['ltp_id'];
				if ($this->validData($cData, $storePromoted, $fileType='wnu_ltm_id_r')) {
					$storePromotedOk = $cData['ltm_id'];
					// cross promotion - update cross promo table
					$sql= "INSERT INTO lt_cross_promotions (ltm_id, ltp_id) VALUES (:ltm_id, :ltp_id)";
					$stmt = $this->mmDbo->prepare($sql);
					$stmt->bindValue(':ltm_id', $storePromotedOk, \PDO::PARAM_INT);
					$stmt->bindValue(':ltp_id', $promoIdOk, \PDO::PARAM_INT);
					$stmt->execute();
					return true;
				}
			}
			return false;
		}
		
		function checkPromoType ($promoTypeId) {
			$promoTypeIdOk = 0;
			if ( is_numeric( $promoTypeId ) ) {
				$promoTypeIdTemp = intval($promoTypeId);				
				if ($promoTypeIdTemp  == $promoTypeId) {
					$stmt = $this->mmDbo->prepare("
					SELECT lpt_id FROM lt_promo_types 
					WHERE `lpt_id`=:id AND `lpt_active`=1
					LIMIT 1" );	
					$stmt->bindValue( ":id", $promoTypeIdTemp, \PDO::PARAM_INT );
					$stmt->execute();
					if ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {						
						$promoTypeIdOk = (int) $resultSet['lpt_id'];
					}					
				}
			}
		
			return $promoTypeIdOk;			
		}
		
		function formatTimeZones($timeZonesQry, $tmzId = 0){
			$_timeZones = '';
			if (!empty($timeZonesQry)) {
				foreach ($timeZonesQry as $ind => $tmz) {		
					$_timeZones .= '<option '. ($tmz['tmz_id']==$tmzId?'selected':'') .' value="'. $tmz['tmz_id'] .'">' . $tmz['tmz_name'] . '</option>';
				}
			}
			return $_timeZones;	
		}
		
		function getTimeZones () {
			$stmt = $this->mmDbo->prepare("
				SELECT TMZ.*
				FROM tbl_timezone TMZ" );				
			$stmt->execute();
			if ( $resultSet = $stmt->fetchAll( \PDO::FETCH_ASSOC ) ) {						
				return $resultSet;
			}
			return array();
		}
		
		function getParentCategory ($catId) {
			if ($this->validData( $clean, $catId, 'wnu_cat_id_r' )) {
				$stmt = $this->mmDbo->prepare("
					SELECT CAT.cat_name
					FROM tbl_category CAT
					WHERE cat_id=:id" );									
				$stmt->bindValue(':id',$clean['cat_id'], \PDO::PARAM_INT);	
				$stmt->execute();				
				if ( $resultSet = $stmt->fetchAll( \PDO::FETCH_ASSOC ) ) {
					return $resultSet;
				}
			}
			return array();
		}
		
		function getParentCategories ($areLocals = 1, $areActives = 1) {			
			$areLocalsOk = $areLocals?1:0; $areActivesOk = $areActivesOk?1:0;			
			$stmt = $this->mmDbo->prepare("
				SELECT * 
				FROM tbl_category
				WHERE
				cat_local={$areLocalsOk}
				AND cat_parent_id=0
				AND cat_active={$areActives}
				ORDER BY cat_name" );
			$stmt->execute();				
			if ( $resultSet = $stmt->fetchAll( \PDO::FETCH_ASSOC ) ) {
				return $resultSet;
			}		
			return array();
		}
		
		function getCurrentKeywords(){
			$stmt = $this->mmDbo->prepare("
				SELECT DISTINCT key_id 
				FROM lt_member_merchants MMC
				INNER JOIN tbl_m2keyword M2K ON MMC.ltb_id = M2K.ltb_id
				WHERE MMC.ltb_id = :ltbId" );									
			$stmt->bindValue(':ltbId',$this->currentMerchantId, \PDO::PARAM_INT);	
			$stmt->execute();				
			if ( $resultSet = $stmt->fetchAll( \PDO::FETCH_ASSOC ) ) {
					$current_keys = array();
					foreach($resultSet as $key=>$value){
						array_push($current_keys, $value['key_id']);
					
					}
					return $current_keys;
			}
			return array(0);
		}
		
		function updateCurrentPromo($promoRec, $promoId){			
			if ($this->validData($cData, $promoId, $fileType='wnu_ltp_id_r')){
				$promoIdOk = $cData['ltp_id'];
				$valueFlag = true; $valueQueryArr = array();

				foreach ($promoRec as $valueArr) {
					if (strcmp($valueArr['Name'], 'ltp_description') === 0) {
						$checker = new HTMLSyntaxChecker\HTMLSyntaxChecker($valueArr['Value'], "BLOCK");
						$tmpVal =  strip_tags($valueArr['Value']);
						$valueFlag = $this->validData($cData, $tmpVal, $valueArr['Type']) && $checker->succeeded();
						$cData[$valueArr['Name']] = str_replace('<a ','<a target="_blank" ',str_replace('target="_blank" ','',$valueArr['Value']));
							
					}
					else
						$valueFlag = $this->validData($cData, $valueArr['Value'], $valueArr['Type']) || (substr($valueArr['Type'], -2) != '_r' && $valueArr['Value'] === null);
					
					//var_dump($valueFlag);
					
					if (!$valueFlag) break;	
					$valueQueryArr[':'.$valueArr['Name']] = array( 'Name'=>$valueArr['Name'], 'Value' => isset($cData[$valueArr['Name']]) && $cData[$valueArr['Name']] != ''? ($valueArr['PDO_Param'] == \PDO::PARAM_INT ? intval($cData[$valueArr['Name']]) : $cData[$valueArr['Name']]): null, 'PDO_Param' => $valueArr['PDO_Param'] );					
					
				}
				if ($valueFlag) {
					$tempStr = '';
					foreach ($valueQueryArr as $k=>$v) {
						$tempStr .= (empty($tempStr)?'':',').$v['Name'].'='.$k;
					}
					// cross promotion - update cross promo table
					$sql= "
						UPDATE lt_promos 
						SET {$tempStr}
						WHERE ltp_id=:ltp_id";
					$stmt = $this->mmDbo->prepare($sql);
					$stmt->bindValue(':ltp_id', $promoIdOk, \PDO::PARAM_INT);
					foreach ($valueQueryArr as $k=>$v) {
						if (($v['Name'] == 'ltp_startdate' && !empty($v['Value'])) || ($v['Name'] == 'ltp_enddate' && !empty($v['Value']))) {
							$v['Value'] = date_create_from_format("m/d/Y", $v['Value']);
							$v['Value'] = date_format($v['Value'],"Y-m-d");
						}
						if (($v['Name'] == 'ltp_time_start' && !empty($v['Value'])) || ($v['Name'] == 'ltp_time_end' && !empty($v['Value']))) {
							$v['Value'] = \DateTime::createFromFormat('H:i a', $v['Value']);
							$v['Value'] = $v['Value']->format( 'H:i:s' );
						}
						if ($v['Name'] == 'ltp_image' && substr($v['Value'], 0, 13) == 'promo-default' ){		
							$v['Value'] = null;
						}
						$stmt->bindValue($k, $v['Value'], $v['PDO_Param']);
					}
					
					$stmt->execute();
					return $stmt->rowCount() > 0;					
				}
			}
			return false;
		}
		
		function getStdPromoObj($promoTypeId = 0){
			$object = new \stdClass;
			$object->lpt_id = $promoTypeId?$promoTypeId:7; // default promo -> product
			$object->ltp_image = 'promo-default_'.$object->lpt_id.'.jpg';; //used to signify were creating a promo
			$object->ltp_id = 0; //used to signify were creating a promo
			$object->ltp_punchcard = 0;
			$object->ltp_headline = "Enter a Headline";
			$object->ltp_description = $object->ltp_disclaimers = $object->ltp_promo_code="";
			$object->ltp_max_redemptions_global = 0; // set redeemable switch to off			
			return $object;
		}
		
		function addPromo($promoRec) {
			$valueFlag = true; $valueQueryArr = array();
			foreach ($promoRec as $valueArr) {
				if (strcmp($valueArr['Name'], 'ltp_description') === 0) {
					$checker = new HTMLSyntaxChecker\HTMLSyntaxChecker($valueArr['Value'], "BLOCK");
					$tmpVal =  strip_tags($valueArr['Value']);
					$valueFlag = $this->validData($cData, $tmpVal, $valueArr['Type']) && $checker->succeeded();
					$cData[$valueArr['Name']] = $valueArr['Value'];	
				}
				else
					$valueFlag = $this->validData($cData, $valueArr['Value'], $valueArr['Type']) || (substr($valueArr['Type'], -2) != '_r' && $valueArr['Value'] === null);
				if (!$valueFlag) break;
				$valueQueryArr[':'.$valueArr['Name']] = array( 'Name'=>$valueArr['Name'], 'Value' => isset($cData[$valueArr['Name']]) && $cData[$valueArr['Name']] != ''? $cData[$valueArr['Name']]: null, 'PDO_Param' => $valueArr['PDO_Param'] );				
			}
			if ($valueFlag) {
				$vStr='';$pStr='';
				foreach ($valueQueryArr as $k=>$v) {
					$pStr .= (empty($pStr)? '':',').$v['Name'];
					$vStr .= (empty($vStr)? '':',').$k;
				}
				// adding promo
				$sql= "
					INSERT INTO lt_promos ({$pStr})
					VALUES ({$vStr})";
					
				$stmt = $this->mmDbo->prepare($sql);
				foreach ($valueQueryArr as $k=>$v) {
					if (($v['Name'] == 'ltp_startdate' && !empty($v['Value'])) || ($v['Name'] == 'ltp_enddate' && !empty($v['Value']))) {
						$v['Value'] = date_create_from_format("m/d/Y", $v['Value']);
						$v['Value'] = date_format($v['Value'],"Y-m-d");
					}
					if (($v['Name'] == 'ltp_time_start' && !empty($v['Value'])) || ($v['Name'] == 'ltp_time_end' && !empty($v['Value']))) {
						$v['Value'] = \DateTime::createFromFormat('H:i a', $v['Value']);
						$v['Value'] = $v['Value']->format( 'H:i:s' );
					}
					if ($v['Name'] == 'ltp_image' && substr($v['Value'], 0, 13) == 'promo-default' ){		
						$v['Value'] = null;
					}					
					if ($v['Name'] == 'ltp_punchcard'){		
						$v['Value'] = intval($v['Value']);
					}					
					$stmt->bindValue($k, $v['Value'], $v['PDO_Param']);
				}
				
				$stmt->execute();
				return $this->mmDbo->lastInsertId();					
			}
			return 0;
		}
		
		function updateCrossPromo($promoId, $storePromoted){		
			if ($this->validData($cData, $promoId, $fileType='wnu_ltp_id_r')){
				$promoIdOk = $cData['ltp_id'];
				if ($this->validData($cData, $storePromoted, $fileType='wnu_ltm_id_r')) {
					$storePromotedOk = $cData['ltm_id'];
					// cross promotion - update cross promo table
					$sql= "UPDATE lt_cross_promotions SET ltm_id=:ltm_id WHERE ltp_id=:ltp_id";
					$stmt = $this->mmDbo->prepare($sql);
					$stmt->bindValue(':ltm_id', $storePromotedOk, \PDO::PARAM_INT);
					$stmt->bindValue(':ltp_id', $promoIdOk, \PDO::PARAM_INT);
					$stmt->execute();
					return true;
				}
			}
			return false;
		}
		
		function updateCurrentPromoSlug($promoHeader, $promoId = 0) {
			if (isset($this->mRecords[$this->currentMerchantId]) && !empty($this->mRecords[$this->currentMerchantId]['Promo']) ) {
				
				if (is_numeric($promoId)) {
					$this->mRecords[$this->currentMerchantId]['Promo']->currentPromoId = intval($promoId);
					$this->mRecords[$this->currentMerchantId]['Promo']->updateSlug($promoHeader);
					return true;
				}
			}
			return false;
		}
		
		//cunstructs
		function __construct($dbObj, $loadRecords=true, $ltbId=null, $loadPromos=false){	
			$this->mmDbo=$dbObj;
			parent::__construct($dbObj, false);
			if ($loadRecords && $this->validData($clean, $ltbId, $fileType='wnu_ltb_id_r' ))
				$this->loadRecords($clean['ltb_id'], $loadPromos);			
			
		}		
		
	}
}
?>