<?php
namespace App\MyStore\MemberMerchant\Promo {
	require_once "../app/class.promo.php";
	require_once "../app/class.variables.php";

	use App\MemberMerchant\Promo as Promo;
	
	class MyStorePromo extends Promo\MerchantPromo {
		
		//private properties
		private $mpDbo;
		
		//private functions
		private function array_to_obj($array, &$obj) {
			foreach ($array as $key => $value){
				if (is_array($value)){
					$obj->$key = new \stdClass();
					$this->array_to_obj($value, $obj->$key);
				}
				else{
					$obj->$key = $value;
				}
			}
			return $obj;
		}		

		private function getTrackingHistory() {
			$sql  = "SELECT lpk_id FROM lt_promo_tracking WHERE `ltp_id`=:id LIMIT 1";	
			$stmt = $this->mpDbo->prepare($sql);
			$stmt->bindValue(':id', $this->currentPromoId, \PDO::PARAM_INT);			
			$stmt->execute();
			return $stmt->fetchAll(\PDO::FETCH_ASSOC);
		}
		
		//public functions
		function updateSlug($aHeader) {
			$promoSlug = strtolower(str_replace(" ", "-", preg_replace("/[^A-Za-z0-9 ]/", '', strtoupper(trim($aHeader)))));
			if ( empty($promoSlug) )
				$promoSlug = $this->currentPromoId;
			// cross promotion - update cross promo table
			$sql= "UPDATE IGNORE `lt_promos` SET ltp_slug=:ltpslug WHERE ltp_id=:ltpid";
			$stmt = $this->mpDbo->prepare( $sql ); 
			$stmt->bindValue( ':ltpid', $this->currentPromoId, \PDO::PARAM_INT );
			$stmt->bindValue( ':ltpslug', $promoSlug, \PDO::PARAM_STR );
			$stmt->execute();
			if ( !$stmt->rowCount() && $promoSlug !== $this->currentPromoId ) {			
				$sql= "UPDATE `lt_promos` SET ltp_slug=:ltpslug WHERE ltp_id=:ltpid";
				$stmt = $this->mpDbo->prepare( $sql );
				$stmt->bindValue( ':ltpid', $this->currentPromoId, \PDO::PARAM_INT );
				$stmt->bindValue( ':ltpslug', $promoSlug . '-' . $this->currentPromoId, \PDO::PARAM_STR );
				$stmt->execute();
			}
		}		
		
		function currentRecordToObject(){
			$object = new \stdClass;
			$object->ltp_id = 0; //used to signify were creating a promo
			$object->ltp_headline = "Enter a Headline";
			$object->ltp_description = $object->ltp_disclaimers = $object->ltp_promo_code="";
			$object->ltp_max_redemptions_global = 0; // set redeemable switch to off
			$object->lpt_id = 7; // default promo -> product
			$object->ltp_punchcard = 0;
			if (isset($this->promoRecords[$this->currentPromoId]))
				return $this->array_to_obj($this->promoRecords[$this->currentPromoId], $object); 
			return $object;
		}
		
		function setCurrent($fieldName, $fieldData){
			//Here we could, in the future, check the data is being set.
			if (isset($this->mRecords[$this->currentMerchantId][$fieldName])) {				
				 $this->mRecords[$this->currentMerchantId][$fieldName] = $fieldData;
				 return true;
			}
			return false;
		}
		
		function findMyStoreImageURL ($merchantDir, &$imgType){
			$imgType='default';
			if (isset($this->promoRecords[$this->currentPromoId]['ltp_image']) /*&& $this->promoRecords[$this->currentPromoId]['ltp_promo_type'] != 5*/){
				$check_img = explode('_', $this->promoRecords[$this->currentPromoId]['ltp_image']);
				$check_img = $check_img[0];
				if ($check_img == 'unv'){
					$imgType = 'library'; // uncropped image from our universal library 
					$img_dir = '../images/promo_library/'; 
				} else {
					$imgType = 'gallery'; // image from merchant's gallery
					$img_dir = '../merchant-custom-files/'.$merchantDir.'/_files/img/p_600x400_';
				}
			} else {
				switch ($this->promoRecords[$this->currentPromoId]['ltp_promo_type']){
					// case 5:
					// 	$imgType = 'cross_promotion';
					// 	$sql  = "SELECT LTM.ltb_id, LTM.ltm_company_name, LTB.ltb_header_image FROM lt_merchants LTM INNER JOIN lt_cross_promotions CPR ON LTM.ltm_id = CPR.ltm_id INNER JOIN lt_member_merchants LTB ON LTM.ltb_id = LTB.ltb_id WHERE CPR.ltp_id=:ltp_id LIMIT 1";
					// 	$stmt = $dbo->prepare($sql);
					// 	$stmt->bindValue(':ltp_id', $this->promoRecords[$this->currentPromoId]['ltp_id'], PDO::PARAM_STR);
					// 	$stmt=execPDO($stmt);
					// 	$qry = $stmt->fetchAll(PDO::FETCH_ASSOC);
					// 	$cross_promo_ltb = (is_null($qry[0]['ltb_header_image']) ? 1 : $qry[0]['ltb_id']);
					// 	$this->promoRecords[$this->currentPromoId]['ltp_image'] = (is_null($qry[0]['ltb_header_image']) ? 'header.png' : $qry[0]['ltb_header_image']);
					// 	$img_dir = '../merchant-custom-files/'.getMerchantSubDir($cross_promo_ltb, '../merchant-custom-files').'/_files/img/h_250w_';
					// 	break;
					default:
						$imgType = 'default'; // no image set, use the default for that promo type
						$this->promoRecords[$this->currentPromoId]['ltp_image'] = 'promo-default_'.$this->promoRecords[$this->currentPromoId]['ltp_promo_type'].'.jpg';
						$img_dir = '../images/promo_defaults/';
						break;
				}
			}
			return $img_dir;
		}
		
		function buildMyStorePromoLayOut($merchantUrl, $index, $merchantSlug, $siteExt){			
			$echo_var = '';
			$promo_link = '<a href="promo_form.php?ltp_id='.$this->promoRecords[$this->currentPromoId]['ltp_id'].'">';

			$echo_var .= ' 
			<div class="col-xs-12 col-sm-6 col-md-3">
				<div class="promo_wrap '.($this->promoRecords[$this->currentPromoId]['ltp_active'] == 0 ? 'promo-inactive':'').'">';

				$echo_var .= '
					<div class="promo_image" style="background: url('.$this->findMyStoreImageURL($merchantUrl, $imgType).$this->promoRecords[$this->currentPromoId]['ltp_image'].'?'.date(strtotime('now')).') top center no-repeat #ffffff; background-size: './*($imgType == 'cross_promotion' ? 'contain':*/'cover'/*)*/.'">	
						'.$promo_link.'<img src="../images/trans_3x2.gif" class="img-responsive"></a>	
					</div>';
				
				if ($this->promoRecords[$this->currentPromoId]['ltp_enddate'] != null) {					
					$d = ' use by ' . date('M d', strtotime($this->promoRecords[$this->currentPromoId]['ltp_enddate']));
					$useByDate = '<img style="margin-right: 1px;" width="16" src="/localthanks/images/icon_date_range.svg"/> ' . $d;
				}

				$echo_var .= '
					<div class="promo_details">
						<div class="promo_headline">'.$promo_link.$this->promoRecords[$this->currentPromoId]['ltp_headline'].'</a></div>
						<div class="promo_use_by">
							' . (isset($useByDate) ? $useByDate : '') . '
						</div>
						<div class="promo_punchcard">
							'.($this->promoRecords[$this->currentPromoId]['ltp_punchcard'] == 1? '<img width="15" height="15" alt="Punch Card Icon" src="/localthanks/images/icon-punchcard.svg"/> Count as a punch' : '').'
						</div>
						<div class="promo_merchant">
							'.$this->promoRecords[$this->currentPromoId]['ltm_company_name'].'
						</div>
						<div class="promo_city">
							<span class="glyphicon glyphicon-globe"></span> '.ucwords($this->promoRecords[$this->currentPromoId]['ltm_city']).'
						</div>
						<div class="promo_price">
							'.($this->promoRecords[$this->currentPromoId]['ltp_price'] == 0 ? '': '<span class="promo_dollar_sign">$</span>'. str_replace('.00', '', $this->promoRecords[$this->currentPromoId]['ltp_price'])).'
						</div>
					</div>
				</div>';

				$echo_var .= '<div class="redemptionsLeft">';
				if (isset($this->promoRecords[$this->currentPromoId]['redemptions_left'])) {
					$echo_var .= '<a href="/mystore/stats.php?mystats=promo-redemptions&promo_id=' . $this->promoRecords[$this->currentPromoId]['ltp_id'] . '">' . ($this->promoRecords[$this->currentPromoId]['redemptions_left'] === 'Unlimited' ? 'Unlimited redemptions' : $this->promoRecords[$this->currentPromoId]['redemptions_left'].' redemptions left') . '</a>';
				}
				$echo_var .= '</div>';

				$echo_var .= '
				<div  class="promo-options">
					<form class="promo-status" id="'.$this->promoRecords[$this->currentPromoId]['ltp_id'].'">
						<div class="promo-opt-wrap">'.(!isset($this->promoRecords[$this->currentPromoId]['max_redemptions_reached']) ? '
							<input type="checkbox" name="ltp_active" id="ltp_active_on-'.$index.'" value="1" '.($this->promoRecords[$this->currentPromoId]['ltp_active'] == 1?' checked':'').'>
							<div class="promo-status-wrap">Status: '.($this->promoRecords[$this->currentPromoId]['ltp_active'] == 1?' Enabled':'Disabled').'</div>
							' : '<button class="disabled btn btn-default">Sold Out</button><div class="promo-status-wrap">Status: '.($this->promoRecords[$this->currentPromoId]['ltp_active'] == 1?' Enabled':'Disabled').'</div>').'
						</div>
					</form>
					<div class="promo-opt-wrap">
						<a href="promo_form.php?ltp_id='.$this->promoRecords[$this->currentPromoId]['ltp_id'].'" class="btn btn-primary ltp_edit"><span class="glyphicon glyphicon-wrench" aria-hidden="true"></span></a>
						<div class="promo-edit-label">Edit</div>
					</div>
					<div class="promo-opt-wrap">
						<button'.(isset($this->promoRecords[$this->currentPromoId]['redemption_count']) && intval($this->promoRecords[$this->currentPromoId]['redemption_count']) > 0? " disabled":"" ).' class="btn btn-danger ltp_delete"><span class="glyphicon glyphicon-trash"></span></button>
						<div class="promo-delete-label">Delete</div>
					</div>
					<div class="promo_share-div-wrapper" '.($this->isCurrentActive()? '': 'style="display:none;"').'>
						<h4 class="mystore-share-h4">Share on Social Media</h4>					
						<div class="promo_share-div">
							<img width="30" data-title="'.$this->getCurrent('ltp_headline').'" data-href="' . 'https://localthanks.' . $siteExt . '/' . $merchantSlug . '/deals/' . $this->getCurrent('ltp_slug') . '" title="Share Promo on Facebook" class="promoFacebookShare" height="30" src="/localthanks/images/icon_share_facebook.svg" alt="Facebook Share"/>						
							<a target="_blank" href="http://www.linkedin.com/shareArticle?url=https://localthanks.' . $siteExt . '/' . $merchantSlug . '/deals/' . $this->getCurrent('ltp_slug') . '" type="IN/Share"><img width="30" title="Share Promo on Linkdin" class="promoLinkdinShare" height="30" src="/localthanks/images/icon_share_linkdin.svg" alt="Linkdin Share"/></a>
							<a href="https://twitter.com/intent/tweet?url=https://localthanks.' . $siteExt . '/' . $merchantSlug . '/deals/' . $this->getCurrent('ltp_slug') . '"><img width="30" title="Share Promo on Twitter" class="promoTwitterShare" height="30" src="/localthanks/images/icon_share_twitter.svg" alt="Twitter Share"/></a>
							<a target="_blank" href="https://plus.google.com/share?url=https://localthanks.' . $siteExt . '/' . $merchantSlug . '/deals/' . $this->getCurrent('ltp_slug') . '"><img width="30" title="Share Promo on Google Plus" class="promoGooglePlusShare" height="30" src="/localthanks/images/icon_share_googleplus.svg" alt="Google Plus Share"/></a>						
						</div>
					</div>
					
					
				</div>
			</div>';
			
			return $echo_var;
		}
		
		function loadRecords( $anId, $fieldName = 'ltb_id', $tableName = 'MMC', $orderBy = 'default' ) {
				
				switch ($orderBy) {
					case 'random':
						$oBy = 'ORDER BY RAND()';						
					break;
					case 'activeDesc':
						$oBy = 'ORDER BY PRM.ltp_active DESC, PRM.ltp_id DESC';
					break;
					default:
						$oBy = 'ORDER BY PRM.ltp_id';
				}
			
				$stmt = $this->mpDbo->prepare("

				SELECT DISTINCT PRR.redemption_count, (CASE WHEN PRM.ltp_max_redemptions_global IS NULL THEN (CASE WHEN PRM.ltp_id IS NULL THEN NULL ELSE 'Unlimited' END) ELSE PRM.ltp_max_redemptions_global-PRR.redemption_count END) AS redemptions_left, PRM.*, PRT.*, MRC.ltm_company_name, MRC.ltm_city, (CASE WHEN ((NOW() < PRM.ltp_enddate AND NOW() > PRM.ltp_startdate) OR (PRM.ltp_enddate IS NULL AND PRM.ltp_startdate IS NULL)) THEN 1 ELSE 0 END) AS ltp_active_by_date 

				FROM lt_member_merchants MMC

				INNER JOIN lt_merchants MRC ON MRC.ltb_id=MMC.ltb_id

				LEFT JOIN lt_promos PRM ON PRM.ltb_id=MMC.ltb_id	

				LEFT JOIN lt_promo_types PRT ON PRM.ltp_promo_type=PRT.lpt_id

				LEFT JOIN (
					SELECT COUNT(PRD.ltp_id) AS redemption_count, PRM.ltp_id
					FROM lt_promos PRM
					INNER JOIN lt_promo_redemptions PRD ON PRD.ltp_id = PRM.ltp_id
					GROUP BY PRM.ltp_id
				) PRR ON PRR.ltp_id = PRM.ltp_id
		
				WHERE {$tableName}.{$fieldName}=:Id
				
				{$oBy}");

				$stmt->bindValue(":Id", $anId, \PDO::PARAM_INT);

				$stmt->execute();

				while ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
					
					if (!empty($resultSet['ltp_id'])) {
						if (is_numeric($resultSet['redemption_count']) && is_numeric($resultSet['ltp_max_redemptions_global']) && (int) $resultSet['ltp_max_redemptions_global'] <= (int) $resultSet['redemption_count']){
							$resultSet['max_redemptions_reached'] = true;
						}
						
						$this->promoRecords[$resultSet['ltp_id']] = $resultSet;
						
						$this->currentPromoId = $resultSet['ltp_id'];
					}
				}

				return $this->promoRecords;

		}
		
		function getRedeemptionCount($promoId) {		
			if (isset($this->promoRecords[$promoId]['RedemptionsCount'])) {
				return $this->promoRecords[$promoId]['RedemptionsCount'];				
			}			
			$sql  = "SELECT COUNT(ltp_id) AS redCount FROM lt_promo_redemptions WHERE `ltp_id`=:id";	
			$stmt = $this->mpDbo->prepare($sql);
			$stmt->bindValue(':id', $promoId, \PDO::PARAM_INT);
			$stmt->execute();
			$this->promoRecords[$promoId]['RedemptionsCount'] = 0;
			if ($Result = $stmt->fetch(\PDO::FETCH_ASSOC))
				$this->promoRecords[$promoId]['RedemptionsCount'] = $Result["redCount"];			
			return $this->promoRecords[$promoId]['RedemptionsCount'];
		}
		
		function loadPromo($anId){
			$stmt = $this->mpDbo->prepare("
			CALL GetPromoByID(:Id)");
			$stmt->bindValue(":Id", $anId, \PDO::PARAM_INT);
			$stmt->execute();
			if ( $resultSet = $stmt->fetchAll( \PDO::FETCH_ASSOC ) ) {
				$this->promoRecords[$resultSet[0]['ltp_id']] = $resultSet[0];
				$this->currentPromoId = $resultSet[0]['ltp_id'];
				unset($stmt);
				if ($resultSet[0]['ltp_promo_type'] == 5) {	
					$this->promoRecords[$resultSet[0]['ltp_id']]['CrossPromoMerchantId'] = $this->getCrossPromoData();
				}				
				$this->promoRecords[$resultSet[0]['ltp_id']]['TrackingHistory'] = $this->getTrackingHistory();				
			}
			return isset($this->promoRecords[$this->currentPromoId])?$this->promoRecords[$this->currentPromoId]:array();
		}
		
		function __construct( $dbObj, $ltpId = null, $loadRandom = false ) {
			$this->mpDbo = $dbObj;
			parent::__construct($dbObj, null);			
		}

	}
}
?>