<?php
namespace App\MyStore\MemberMerchant\Store {	
	require_once "../app/class.variables.php";
	//require_once "class.mystore-member-merchant.php";
	//use App\MyStore\MemberMerchant as Merchant;	
	require_once "../app/class.store.php";
	use App\MemberMerchant\Store as Store;
	
	class MystoreMerchantStore extends Store\MerchantStore{
		
		// Private Properties		
		private $ssDbo;
		
		//private functions
		private function runBasicQuery ($aQueryString, $arrayName, $defaultValue) {			
			if (isset($this->storeRecords[$this->currentStoreId])) {
				if (isset($this->storeRecords[$this->currentStoreId][$arrayName]))
					return $this->storeRecords[$this->currentStoreId][$arrayName];
				else{
					$stmt = $this->ssDbo->prepare($aQueryString);				
					$stmt->bindValue(":ltm_id", $this->currentStoreId, \PDO::PARAM_INT);
					$stmt->execute();
					$this->storeRecords[$this->currentStoreId][$arrayName] = $defaultValue;
					if ( $resultSet = $stmt->fetchAll( \PDO::FETCH_ASSOC ) ) {					
						$this->storeRecords[$this->currentStoreId][$arrayName] = $resultSet;
					}					
					return $this->storeRecords[$this->currentStoreId][$arrayName];
				}
			}
			else return false;
		}
		
		//public functions
		function getInStoreConsumers () {
			$queryString = "SELECT csm_id AS id, csm_first_name AS fname, csm_last_name AS lname, csm_email AS email, csm_cell_number AS phone, csm_zip AS zip, DATE_FORMAT(csm_add_date,'%c/%d/%Y') as date_joined 
							FROM tbl_consumer 
							WHERE ltm_pick_id = :ltm_id AND csm_active = 1 
							ORDER BY csm_id LIMIT 100";
			return $this->runBasicQuery ($queryString, 'InStoreConsumers', array());			
		}		
		
		function getInStoreConsumerCount () {
			$queryString = "SELECT COUNT(csm_id) AS amount 
							FROM tbl_consumer 
							WHERE ltm_pick_id = :ltm_id 
							AND csm_active = 1";
			$temp = $this->runBasicQuery ($queryString, 'InStoreConsumersCount', array());
			return isset($temp[0]['amount'])? intval($temp[0]['amount']): 0;
		}
		
		function getInStoreMonthlyConsumerCount ($daysNow = 186) {
			if (is_numeric($daysNow) && intval($daysNow) > 0) {		
				$queryString = "SELECT COUNT(csm_id) AS month_amount, MONTH(csm_add_date) AS month_joined, YEAR(csm_add_date) AS year_joined 
								FROM tbl_consumer 
								WHERE ltm_pick_id = :ltm_id 
									AND DATEDIFF(NOW(), csm_add_date) <= {$daysNow} 
								GROUP BY MONTH(csm_add_date), YEAR(csm_add_date)";
				return $this->runBasicQuery ($queryString, 'InStoreMonthlyConsumers', array());				
			}
			else return false;
		}
		
		function getPunchCardHistoryPerUser (){
			
			$queryString = "SELECT PHY.*, DATE_FORMAT(PHY.dph_date,'%c/%d/%Y') as dph_date
							FROM tbl_consumer CSM
							INNER JOIN tbl_punch_history PHY ON PHY.csm_id = CSM.csm_id
							WHERE CSM.ltm_pick_id = :ltm_id
							ORDER BY PHY.dph_id";
			$temp = $this->runBasicQuery ($queryString, 'punchCardHistoryPerUser', array());	
			foreach ($temp as $index=>$v) {
				if ( isset($temp[$index]['dph_id']) ) {					
					if (!isset($temp['Total_Punches'][$v['csm_id']]))
						$temp['Total_Punches'][$v['csm_id']] = 0;
					if (!isset($temp['Total_Redeemed'][$v['csm_id']]))
						$temp['Total_Redeemed'][$v['csm_id']] = 0;
					if (!isset($temp['Total_Subscribed'][$v['csm_id']]))
						$temp['Total_Subscribed'][$v['csm_id']] = 0;
					if (!isset($temp['Last_Action'][$v['csm_id']]))
						$temp['Last_Action'][$v['csm_id']] = '';
					if (!isset($temp['Last_Action'][$v['csm_id']]))
						$temp['Last_Action_Date'][$v['csm_id']] = '';
					$temp['Last_Action_Date'][$v['csm_id']] = $v['dph_date'];
					$temp['Last_Action'][$v['csm_id']] = $v['dph_task'];
					switch ($v['dph_task']) {
						case 'subscribe':
							$temp['Total_Subscribed'][$v['csm_id']]++;
						break;
						case 'punch':
							$temp['Total_Punches'][$v['csm_id']]++;
						break;
						case 'redeem':
							$temp['Total_Redeemed'][$v['csm_id']]++;
						break;
					}
				}				
			}
			
			return $temp;
			
		}
		
		function getConsumerTextStatus ($daysNow = 186) {
			if (is_numeric($daysNow) && intval($daysNow) >= 0) {		
				$daysNowOk = intval($daysNow);
				$queryString = "SELECT csm_id AS id, csm_first_name AS fname, csm_last_name AS lname, csm_email AS email, csm_cell_number AS phone, csm_zip AS zip, DATE_FORMAT(csm_add_date,'%c/%d/%Y') as date_joined, csm_txt_status as txt_status
								FROM tbl_consumer 
								WHERE ltm_pick_id=:ltm_id 
									AND csm_cell_number IS NOT NULL 
									AND csm_cell_number != ''
									AND csm_txt_status IS NOT NULL 	
									AND csm_active=1 
									".( empty($daysNowOk)? "" : "AND DATEDIFF(NOW(), csm_txt_status_date) <= {$daysNowOk}" )."
								ORDER BY csm_id
								LIMIT 100";
				$tempStatus = $this->runBasicQuery ($queryString, 'ConsumerTextStatus', array());								
				
				if ( is_array($tempStatus) ) {
					
					$tempStatus['SubscribedUsers'] =  array(); $tempStatus['UnSubscribedUsers'] = array();
					
					foreach ($tempStatus as $k=>$v) {
						if ($v['txt_status'] == '1')
							array_push($tempStatus['SubscribedUsers'], $v);
						elseif($v['txt_status'] == '0') 
							array_push($tempStatus['UnSubscribedUsers'], $v);
					}
				}
				
				return $tempStatus;
				
			}
			else return false;
		}
		
		function getTextStatusCountByMonth ($daysNow = 186) {
			if (is_numeric($daysNow) && intval($daysNow) >= 0) {		
				$daysNowOk = intval($daysNow);
				$queryString = "SELECT COUNT(csm_id) AS month_amount, MONTH(csm_txt_status_date) AS month_status_updated, YEAR(csm_txt_status_date) AS year_status_updated, csm_txt_status
								FROM tbl_consumer 
								WHERE ltm_pick_id = :ltm_id
									AND csm_cell_number IS NOT NULL 
									AND csm_cell_number <> ''
									AND csm_active
									AND csm_txt_status IS NOT NULL 	
									".( empty($daysNowOk)? "" : "AND DATEDIFF(NOW(), csm_txt_status_date) <= {$daysNowOk}" )."
								GROUP BY csm_txt_status, MONTH(csm_txt_status_date), YEAR(csm_txt_status_date)";
				$tempStatus = $this->runBasicQuery ($queryString, 'ConsumerTextStatusByMonth', array());			
								
				if ( is_array($tempStatus) ) {
					$tempStatus['SubscriptionCount'] = 0; $tempStatus['UnSubscriptionCount'] = 0;
					foreach ($tempStatus as $k=>$v) {
						if ($v['csm_txt_status'] == '1')
							$tempStatus['SubscriptionCount'] += $v['month_amount'];
						elseif($v['csm_txt_status'] == '0') 
							$tempStatus['UnSubscriptionCount'] += $v['month_amount'];
					}
				}
				
				return $tempStatus;
			}
			else return false;
		}
		
		function updatePunchCard($dataSet) {			
			if ( 
				$this->currentStoreId 
				&& isset(
					$dataSet['wnu_dpc_id_r'], 
					$dataSet['txt1000_dpc_disclaimer'], 
					$dataSet['txt70_dpc_intro'], 
					$dataSet['txl50_dpc_header_r'], 
					$dataSet['wnu_dpc_required_punches'], 
					$dataSet['wnu4_dpc_pincode_r']) 
				) {
				
				$fieldKeys = array(
								'wnu_dpc_id_r',
								'txt1000_dpc_disclaimer', 
								'txt70_dpc_intro', 
								'txl50_dpc_header_r', 
								'wnu_dpc_required_punches', 
								'wnu4_dpc_pincode_r', 
								'bit_dpc_active');
				$optionalFields = isset($dataSet['bit_image_switch'], $dataSet['img128_dpc_image'])? array('img128_dpc_image'): array();				
				
				$newDataSet=array();
				foreach ( $dataSet as $key => $val ) {
					if ( !in_array( $key, $fieldKeys ) && in_array($key, $optionalFields) ) {
						array_push( $fieldKeys, $key );
						if (strcmp($key, 'bit_dpc_active') === 0)
							$newDataSet[$key] = 1;
						else
							$newDataSet[$key] = $val;
					}
					elseif (in_array( $key, $fieldKeys ))	$newDataSet[$key] = $val;
				}
				
				if (!isset($newDataSet['bit_dpc_active'])) $newDataSet['bit_dpc_active'] = 0;
				
				if ($this->validateData($cleanData, $dataErrors, $newDataSet, $fieldKeys )){					
					
					foreach ( $cleanData as $k=>$v ) if ( empty( $v ) && $v !== 0) $cleanData[$k] = null;
					
					if (!isset($cleanData['dpc_image'])) $cleanData['dpc_image'] = null;
					
					$str = '';
					foreach ($cleanData as $k => $v) $str .= ( strcmp($k,'dpc_id')===0? '' : (empty($str) ? '' : ',') . "{$k}=:{$k}" );
					$stmt = $this->ssDbo->prepare("UPDATE tbl_punch_card SET {$str} WHERE dpc_id = :dpc_id");
					
					foreach ($cleanData as $k => $v)
						$stmt->bindValue(":{$k}", strcmp($k,'dpc_active') === 0? intval($v) : $v, strcmp($k,'dpc_active') === 0 || strcmp($k,'dpc_id') === 0 || strcmp($k,'ltm_id') === 0? \PDO::PARAM_INT : \PDO::PARAM_STR);
					$stmt->execute();
					return $stmt->rowCount()? true : false;
				}
				else{
					return $dataErrors;
				}	
			}
			return false;
		}
		
		function createPunchCard($dataSet) {
			
			if ( 
				$this->currentStoreId 
				&& isset(
					$dataSet['txt1000_dpc_disclaimer'], 
					$dataSet['txt70_dpc_intro'], 
					$dataSet['txl50_dpc_header_r'], 
					$dataSet['wnu_dpc_required_punches'], 
					$dataSet['wnu4_dpc_pincode_r']) 
				) {
				
				$fieldKeys = array(
								'txt1000_dpc_disclaimer', 
								'txt70_dpc_intro', 
								'txl50_dpc_header_r', 
								'wnu_dpc_required_punches', 
								'wnu4_dpc_pincode_r',
								'bit_dpc_active');
				$optionalFields = isset($dataSet['bit_image_switch'], $dataSet['img128_dpc_image'])? array('img128_dpc_image'): array();
				$newDataSet=array();
				foreach ( $dataSet as $key => $val ) {
					if ( !in_array( $key, $fieldKeys ) && in_array($key, $optionalFields) ) {
						array_push( $fieldKeys, $key );
						if (strcmp($key, 'bit_dpc_active') === 0)
							$newDataSet[$key] = 1;
						else
							$newDataSet[$key] = $val;
					}
					elseif (in_array( $key, $fieldKeys ))	$newDataSet[$key] = $val;
				}
				
				if (!isset($newDataSet['bit_dpc_active'])) $newDataSet['bit_dpc_active'] = 0;
				
								
				if ($this->validateData( $cleanData, $dataErrors, $newDataSet, $fieldKeys ) ) {
					foreach ( $cleanData as $k=>$v ) if ( empty( $v ) && $v !== 0 ) $cleanData[$k] = null;
					if (!isset($cleanData['dpc_image'])) $cleanData['dpc_image'] = null; 
					if (!isset($cleanData['ltm_id'])) $cleanData['ltm_id'] = $this->currentStoreId;
					
					$str = ''; $values = '';
					
					foreach ($cleanData as $k => $v) {
						$str .= ( strcmp($k,'dpc_id')===0? '' : (empty($str) ? '' : ',') . "{$k}" );
						$values .= ( strcmp($k,'dpc_id')===0? '' : (empty($values) ? '' : ',') . ":{$k}" );
					}
					
					$stmt = $this->ssDbo->prepare("INSERT INTO tbl_punch_card ({$str}) VALUES ({$values})");
					
					foreach ($cleanData as $k => $v)
						$stmt->bindValue(":{$k}", strcmp($k,'dpc_active') === 0? intval($v): $v, strcmp($k,'dpc_active')===0 || strcmp($k,'dpc_id')===0 || strcmp($k,'ltm_id')===0? \PDO::PARAM_INT : \PDO::PARAM_STR);				
					$stmt->execute();					
					if ( $this->ssDbo->lastInsertId() ) {					
						return true;
					}										
					else return false;
				}				
				else					
					return $dataErrors;
			}
			return false;			
		}
		
		function getEmailUnsubscribedMembers ($daysNow = 186) {
			if (is_numeric($daysNow) && intval($daysNow) >= 0) {		
				$daysNowOk = intval($daysNow);
				$queryString = "SELECT csm_id AS id, csm_first_name AS fname, csm_last_name AS lname, csm_email AS email, csm_cell_number AS phone, csm_zip AS zip, DATE_FORMAT(csm_add_date,'%c/%d/%Y') as date_joined, csm_txt_status as txt_status
								FROM tbl_consumer 
								WHERE ltm_pick_id=:ltm_id 
									AND csm_unsubscribed_date IS NOT NULL
									AND csm_active
									".( empty($daysNowOk)? "" : "AND DATEDIFF(NOW(), csm_unsubscribed_date) <= {$daysNowOk}" )."
								ORDER BY csm_id
								LIMIT 100";
				return $this->runBasicQuery ($queryString, 'EmailUnsubscribedMembers', array());			
	
			}
			else return false;
		}
		
		function getEmailUnsubscriptionsByMonth ($daysNow = 186) {
			if (is_numeric($daysNow) && intval($daysNow) >= 0) {		
				$daysNowOk = intval($daysNow);
				$queryString = "SELECT COUNT(csm_id) AS month_amount, MONTH(csm_unsubscribed_date) AS month_updated, YEAR(csm_unsubscribed_date) AS year_updated
								FROM tbl_consumer 
								WHERE ltm_pick_id = :ltm_id
									AND csm_unsubscribed_date IS NOT NULL		
									AND csm_active
									".( empty($daysNowOk)? "" : "AND DATEDIFF(NOW(), csm_unsubscribed_date) <= {$daysNowOk}" )."
								GROUP BY month_updated, year_updated";
				$tempEmaUnsubs = $this->runBasicQuery ($queryString, 'EmailUnsubscriptionsByMonth', array());
								
				if ( is_array($tempEmaUnsubs) ) {
					$tempEmaUnsubs['EmailUnsubscriptionTotal'] = 0;
					foreach ($tempEmaUnsubs as $k=>$v) {
						$tempEmaUnsubs['EmailUnsubscriptionTotal'] += $v['month_amount'];
					}
				}
				
				return $tempEmaUnsubs;				
	
			}
			else return false;
		}
		
		function myStoreLoadConsumers(){
			foreach ( $this->storeRecords as $k=>$v ) {				
				$this->storeRecords[$k]['Consumer'] = new Store\Consumer\storeConsumer( $this->ssDbo, null, $k );
			}	
		}
		
		//constructors
		function __construct( $dbObj, $ltmId=null ) {
			$this->ssDbo=$dbObj;
			parent::__construct($this->ssDbo, $ltmId);			
		}
		
	}
}	
?>