<?php

require '../../app/start_session.php';

require '../../app/function.connect.php';

header( 'Content-Type: application/json; charset=utf-8' );

if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_SESSION['user']['merchant']['ltm_id'], $_REQUEST['wnu_offset_r'], $_REQUEST['wnu_limit_r'])) {

	require '../../app/class.variables.php';

	$cv = new _variables(); // new instance

	$cv->varible_in('wnu_offset_r'); 

	$cv->varible_in('wnu_limit_r');	
	
	if (isset($_POST['txt_search_r']))

		$cv->varible_in('txt_search_r');
	
	if (isset($_POST['bit_email_unsubscription']))

		$cv->varible_in('bit_email_unsubscription');	

	if (isset($_POST['bit_subscription']))

		$cv->varible_in('bit_subscription');	

	if (isset($_POST['wnu_period']))

		$cv->varible_in('wnu_period');

	$request = $cv->get_cleaned_variables();

	$errors = $cv->get_bad_variables();

	if ( empty( $errors ) ) {

		$sql = "

		SELECT csm_id AS id, csm_first_name AS fname, csm_last_name AS lname, csm_email AS email, csm_cell_number AS phone, csm_zip AS zip, DATE_FORMAT(csm_add_date,'%c/%d/%Y') as date_joined 

		FROM tbl_consumer 

		WHERE ltm_pick_id = :ltm_id AND csm_active " . (isset($request['search'])?' AND ( INSTR( csm_email, :search) > 0 OR INSTR( csm_last_name, :search) > 0 OR INSTR( csm_first_name, :search) > 0 OR INSTR( csm_cell_number, :search) > 0 OR INSTR( csm_zip, :search) > 0 ) ' : '') . (isset($request['email_unsubscription'])?' AND csm_unsubscribed_date IS NOT NULL ' : '') . (isset($request['period'])?' AND DATEDIFF(NOW(), csm_txt_status_date) <= ' . $request['period'] : '') . (isset($request['subscription'])?' AND csm_cell_number IS NOT NULL AND csm_cell_number <> "" AND csm_txt_status = '.$request['subscription']:'')."

		ORDER BY csm_id 

		LIMIT {$request['limit']} OFFSET {$request['offset']}";

		$qry = $dbo->prepare( $sql );
		
		if (isset($request['search']))
			
			$qry->bindValue( ':search', $request['search'], PDO::PARAM_STR );	
	
		$qry->bindValue( ':ltm_id', $_SESSION['user']['merchant']['ltm_id'], PDO::PARAM_INT );

		$qry->execute();

		$response = $qry->fetchAll( PDO::FETCH_ASSOC );
		
		$sql = "SELECT dpc_required_punches
				FROM tbl_punch_card
				WHERE ltm_id = :ltmId LIMIT 1";
		$stmt = $dbo->prepare( $sql );		
		$stmt->bindValue( ':ltmId', $_SESSION['user']['merchant']['ltm_id'], PDO::PARAM_INT );
		$stmt=execPDO($stmt);
		$reqPunches = $stmt->fetchAll(PDO::FETCH_ASSOC);
		
		foreach ($response as $k=>$v){
			// get redemptions
			$sql = "SELECT COUNT(lpr_id) AS redemptions FROM lt_promo_redemptions WHERE csm_id=:csm_id";
			$stmt = $dbo->prepare( $sql );
			$stmt->bindValue(':csm_id', $v['id'], PDO::PARAM_INT);
			$stmt=execPDO($stmt);
			$res=$stmt->fetchAll(PDO::FETCH_ASSOC);
			$response[$k]['redemptions'] = $res[0]['count'];
			
			
			// get punch cards
			$sql = "SELECT PHY.*
					FROM tbl_consumer CSM
					INNER JOIN tbl_punch_history PHY ON PHY.csm_id = CSM.csm_id
					WHERE CSM.ltm_pick_id = :ltm_id AND CSM.csm_id = :csm_id
					ORDER BY PHY.dph_id";
			$stmt = $dbo->prepare( $sql );
			$stmt->bindValue(':csm_id', $v['id'], PDO::PARAM_INT);
			$stmt->bindValue( ':ltm_id', $_SESSION['user']['merchant']['ltm_id'], PDO::PARAM_INT );
			$stmt=execPDO($stmt);
			$res=$stmt->fetchAll(PDO::FETCH_ASSOC);
			
			$Punches = 0;
			$Redeemed = 0;
			$Subscribed = 0;
			$Action = '';
			$actionDate = '';
			if ( isset($res[0]['dph_id']) ) {				
				foreach ($res as $index=>$v) {					
					$Action = $v['dph_task'];
					$actionDate = $v['dph_date'];
					switch ($v['dph_task']) {
						case 'subscribe':
							$Subscribed++;
						break;
						case 'punch':
							$Punches++;
						break;
						case 'redeem':
							$Redeemed++;
						break;
					}
				}				
			}
			
			$response[$k]['punchcard'] = empty($Action)? '0':( strcmp($Action, 'redeem') === 0? 'REDEEM' : ( isset($reqPunches['dpc_required_punches'])? $Punches . '/' . $reqPunches['dpc_required_punches'] : '0') );
			if (strcmp($Action, 'redeem') === 0)
				$response[$k]['punchRedeemDate'] = $actionDate;
			else
				$response[$k]['punchRedeemDate'] = '-';
		}
	}

	//else{var_dump($errors);}

	echo json_encode(!isset($response)?array( 'status' => 'empty' ):$response);

	

}

else

	echo json_encode( array( 'status' => 'empty' ) );

?>