<?php

require '../../app/start_session.php';
require '../../app/function.connect.php';
header( 'Content-Type: application/json; charset=utf-8' );
$error = array();
$response['status'] = '';
if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ema_ltb_email_r'], $_POST['psw_ltb_password_r'], $_POST['psw_ltb_password2_r'])) {
	
	require '../../app/class.variables.php';

	$cv= new _variables(); // new instance
	$cv_array = array('psw_ltb_password_r', 'psw_ltb_password2_r', 'ema_ltb_email_r');
	foreach($cv_array as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop
	$request=$cv->get_cleaned_variables();
	$error=$cv->get_bad_variables();	
	
	if (!count($error)){
		// check if email already exists
		$_SQL=('SELECT ltb_email from lt_member_merchants WHERE ltb_id!=:id AND ltb_email=:ltb_email');
		$q = $dbo->prepare($_SQL);
		$q->bindValue( ':id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_STR );
		$q->bindValue( ':ltb_email', $request['ltb_email'], PDO::PARAM_STR );
		$q->execute();
		$results = $q->fetchAll( PDO::FETCH_ASSOC );
		if (count($results)){
			$response['status'] = 'Email already in use.';
		} else {
			// password encryption
			require '../../app/model/crypt.php';
			$c = new Crypt($request['ltb_email']);

			// update the email in our database
			$_SQL=('UPDATE `lt_member_merchants` SET ltb_email=:ltb_email, ltb_password=:pass, ltb_timestamp=NOW() WHERE ltb_id=:id');
			$q = $dbo->prepare($_SQL);
			$q->bindValue( ':id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_STR );
			$q->bindValue( ':ltb_email', $request['ltb_email'], PDO::PARAM_STR );
			$q->bindValue( ':pass', $c->encode( $request['ltb_password'] ), PDO::PARAM_STR );
			$q->execute();
            $response['ltb_password'] = $response['ltb_password2'] = '';

            // update the email in cakemail if the account has already been created
            $_SQL=('SELECT cml_user_key, cml_user_id FROM tbl_cakemail_login WHERE ltm_id=:id');
			$q = $dbo->prepare($_SQL);
			$q->bindValue( ':id', $_SESSION['user']['merchant']['ltm_id'], PDO::PARAM_STR );
			$q->execute();
			$results = $q->fetchAll( PDO::FETCH_ASSOC );
			if (count($results)){
				require '../../app/class.cakemail.php';
				
				$CakeAPI = new CakeMail('828108c6dc7cafe6bac1a669aefe006b');
				$_Params = array();
				$_Params['Requires'] = array(
						'user_key'=>$results['cml_user_key'],
						'user_id'=>$results['cml_user_id']
					);
				$_Params['Optionals'] = array(
						'email'=>$request['ltb_email']
					);
				$CakeAPI->call_API('Client_SetInfo', $_Params, true);
			}

			$response['status'] = 'Success';
		}
	}
	echo json_encode($response);
}

?>