<?php

require '../../app/start_session.php';
require '../../app/function.connect.php';
header( 'Content-Type: application/json; charset=utf-8' );
$error = array();
$request = array();

if($_SERVER['REQUEST_METHOD'] === 'POST'){
	require '../../app/class.variables.php';
	$cv= new _variables(); //new instance
	$cv_array=array('wnu_tmz_id_r', 'wnu_ltm_id_r', 'nam_ltm_city_r', 'txt64_ltm_nickname_r', 'txt_ltm_address_r', 'pho_ltm_phone_number_r', 'abc_ltm_state_r', 'zip_ltm_zipcode_r', 'wnu_ltm_hide_address_r');
	foreach($cv_array as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop
	$request= array_merge($request, $cv->get_cleaned_variables());
	$error=$cv->get_bad_variables();
	if( isset($request['ltm_zipcode']) ) $request['ltm_zipcode']=explode('-',$request['ltm_zipcode'])[0];
	if( isset($request['ltm_phone_number']) ) $request['ltm_phone_number']=preg_replace('/\D/', '', $request['ltm_phone_number']);
	// Get lat and long by address
	$prep = str_replace(' ','+',"{$request['ltm_address']} {$request['ltm_city']} {$request['ltm_zipcode']}");
	$geo  = file_get_contents('https://maps.google.com/maps/api/geocode/json?key=AIzaSyAL3gq7mq6CJGxFVtZCzqavimeUUkOc7PU&address='.$prep);
	$out  = json_decode($geo);
	// echo var_dump($out->results);
	if (count($out->results)){

		$addressArr = explode(',', $out->results[0]->formatted_address);
		$addressArr[2] = explode(' ', trim($addressArr[2]));
		$addressArr[3] = $addressArr[2][1];
		$addressArr[2] = $addressArr[2][0];
		// $addressArr[0] // street address
		// $addressArr[1] // city
		// $addressArr[2] // state
		// $addressArr[3] // zip code // will be NULL if only general address is found, ex: "Boca Raton, FL 33433, USA"

		if (is_null($addressArr[3])) {
			array_push($error, 'Address not found.');
		} else {
			$request['ltm_lat'] = $out->results[0]->geometry->location->lat;
			$request['ltm_long'] = $out->results[0]->geometry->location->lng;
			$request['ltm_address'] = trim($addressArr[0]);
			$request['ltm_city'] = trim($addressArr[1]);
			$request['ltm_state'] = trim($addressArr[2]);
			$request['ltm_zipcode'] = trim($addressArr[3]);
		}

	} else {
		array_push($error, 'Address not found.');
	}

	function getTimeZone($_txid){
	  global $dbo;
	  $sql = "SELECT tmz_name FROM `tbl_timezone` WHERE tmz_id=:tzid LIMIT 1";
	  $qry = $dbo->prepare( $sql );	  
	  $qry->bindValue( ':tzid', $_txid, PDO::PARAM_INT );
	  $qry->execute();
	  $qry = $qry->fetch( PDO::FETCH_ASSOC );
	  return $qry['tmz_name'];  
	}
	
	if ( !count($error) ){

		// $vallArr=array();
		// $_SQL='';
		// foreach( $request as $k => $v ) {
		// 	if($k != 'ltm_id') {
		// 		$char='MRC';
		// 		array_push( $vallArr, $v );
		// 		$i = count( $vallArr ) - 1;
		// 		$_SQL.=( empty( $_SQL )?"":"," )."{$char}.{$k}=:val{$i}";
		// 	}
		// }
		// $qry = $dbo->prepare(" UPDATE lt_merchants MRC
		// 					   SET {$_SQL}
		// 					   WHERE MRC.ltm_id=:id " );				   
		// for ( $j=0; $j <= $i; $j++ ) $qry->bindValue( ":val{$j}", $vallArr[$j], PDO::PARAM_STR );
		// $qry->bindValue( ':id', $request['ltm_id'], PDO::PARAM_INT );
		// $qry->execute();
		// $request['tmz_id'] = getTimeZone($request['tmz_id']);
		// $request['status'] = 'success';
		// echo json_encode( $request );

		$sql = "UPDATE `lt_merchants` 
				SET ltm_hide_address=:ltm_hide_address, ltm_lat=:ltm_lat,ltm_long=:ltm_long,ltm_address=:ltm_address,ltm_city=:ltm_city,ltm_state=:ltm_state,ltm_zipcode=:ltm_zipcode,ltm_phone_number=:ltm_phone_number
				WHERE ltm_id=:id";
		$qry = $dbo->prepare( $sql );
		$qry->bindValue(':id', $request['ltm_id'], PDO::PARAM_INT );
		$qry->bindValue(':ltm_hide_address', $request['ltm_hide_address'] == 1 ? 1 : 0, PDO::PARAM_INT );
		$qry->bindValue(':ltm_lat', $request['ltm_lat'], PDO::PARAM_STR);
		$qry->bindValue(':ltm_long', $request['ltm_long'], PDO::PARAM_STR);
		$qry->bindValue(':ltm_address', $request['ltm_address'], PDO::PARAM_STR);
		$qry->bindValue(':ltm_city', $request['ltm_city'], PDO::PARAM_STR);
		$qry->bindValue(':ltm_state', $request['ltm_state'], PDO::PARAM_STR);
		$qry->bindValue(':ltm_zipcode', $request['ltm_zipcode'], PDO::PARAM_STR);
		$qry->bindValue(':ltm_phone_number', $request['ltm_phone_number'], PDO::PARAM_STR);    
		$qry->execute();
		$request['tmz_id'] = getTimeZone($request['tmz_id']);
		$request['status'] = 'success';
		echo json_encode( $request );
	}
	else {
		echo json_encode( $error );
	}

}

?>