<?php
require '../../app/start_session.php';
require '../../app/function.connect.php';
header( 'Content-Type: application/json; charset=utf-8' );
$error = array();
$response = array();
$response['status'] = 'EMPTY';

if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['store-hours'], $_POST['ltm_id']) && is_numeric($_POST['ltm_id'])){

  // confirm the ltm_id posted belongs to the logged in merchant
  $sql = 'SELECT ltm_id FROM lt_merchants WHERE ltm_id = :ltm_id AND ltb_id = :ltb_id LIMIT 1';
  $qry = $dbo->prepare( $sql );
  $qry->bindValue(':ltm_id', $_POST['ltm_id'], PDO::PARAM_INT);
  $qry->bindValue(':ltb_id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_INT);
  $qry=execPDO($qry);
  $storeConfirmed = (count($qry->fetchAll(PDO::FETCH_ASSOC)) > 0); // true if found - false if not

  if ($storeConfirmed === false){
    // bad ltm_id posted
    $response['status'] = 'error';
  } 
  else {  
    // good ltm_id posted
    $storeHours = $_POST['store-hours'] = json_decode($_POST['store-hours']);
    $sql = "DELETE FROM lt_merchant_hours WHERE ltm_id=:ltm_id; OPTIMIZE TABLE lt_merchant_hours";
    $qry = $dbo->prepare($sql);
    $qry->bindValue(':ltm_id', $_POST['ltm_id'], PDO::PARAM_INT);
    $qry=execPDO($qry);
    $qry->closeCursor();

    // add store hours
    $last_open=$last_close='';
    $range_start=1;
    for ($i=1; $i<=8; $i++) {
      $open = $storeHours[$i-1]->timeFrom;
      if($open!='') $open = date("H:i", strtotime($storeHours[$i-1]->timeFrom));
      $close = date("H:i", strtotime($storeHours[$i-1]->timeTill));
      $appointmentOnly = ($storeHours[$i-1]->appointmentOnly ? 1 : 0);
      // group days together if their hours match the previous day's hours
      if (($open != $last_open || $close != $last_close || $appointmentOnly != $last_appt || $i==8) && $i>1) {
        $firstday = $range_start;
        $lastday = $i - 1;
        $opentime = $last_open;
        $closetime = $last_close;
        $apptOnly = $last_appt;
        
        if ($opentime != ''){
          //echo $firstday . ' - ' . $lastday . ' open: ' . $opentime . ' closed: ' . $closetime . '<br>';
          $sql = "INSERT INTO `lt_merchant_hours` (ltm_id,lth_open,lth_close,lth_start_day_num,lth_end_day_num,lth_appointment_only) VALUES (:ltm_id,:opentime,:closetime,:firstday,:lastday,:apptOnly)";
          $qry = $dbo->prepare( $sql );
          $qry->bindValue(':ltm_id', $_POST['ltm_id'], PDO::PARAM_INT);
          $qry->bindValue(':opentime', $opentime, PDO::PARAM_STR);
          $qry->bindValue(':closetime', $closetime, PDO::PARAM_STR);
          $qry->bindValue(':firstday', $firstday, PDO::PARAM_INT);
          $qry->bindValue(':lastday', $lastday, PDO::PARAM_INT);
          $qry->bindValue(':apptOnly', $apptOnly, PDO::PARAM_INT);
          $qry=execPDO($qry);
        }
        $range_start = $i;
      }
      $last_open=$open;
      $last_close=$close;
      $last_appt=$appointmentOnly;
    }
    // get store hours
    $sql = 'SELECT lth_open, lth_close, lth_start_day_num, lth_end_day_num, lth_appointment_only FROM lt_merchant_hours WHERE ltm_id = :ltm_id ORDER BY lth_start_day_num ASC';
    $qry = $dbo->prepare( $sql );
    $qry->bindValue(':ltm_id', $_POST['ltm_id'], PDO::PARAM_INT);
    $qry=execPDO($qry);
    $qry = $qry->fetchAll(PDO::FETCH_ASSOC);
    $hours = $qry;
    
    $response['ltm_id'] = $_POST['ltm_id'];
    $response['hours'] = $hours;
    $response['status'] = 'success';
  }
}
  echo json_encode($response);
?>