<?php

require '../../app/start_session.php';

require '../../app/function.connect.php';

header( 'Content-Type: application/json; charset=utf-8' );

	

if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_SESSION['user']['merchant']['ltm_id'])) {

	

	function get_TimeZone($_DBConnecion, $ltb_id){

		$sql = '

		SELECT TMZ.*

		FROM lt_member_merchants MMC

		INNER JOIN tbl_timezone TMZ ON MMC.tmz_id=TMZ.tmz_id

		WHERE MMC.ltb_id = :ltb_id LIMIT 1';

		$qry = $_DBConnecion->prepare( $sql );

		$qry->bindValue(':ltb_id', $ltb_id, PDO::PARAM_INT);

		$qry->execute();

		$qry = $qry->fetchAll( PDO::FETCH_ASSOC );		

		return $qry;

	}

	

	function get_History($_DBConnecion, $ltb_id){

		$sql = '

		SELECT DISTINCT TMS.txt_id, TMS.txt_msg, TMS.txt_date, CSM.csm_first_name, CSM.csm_last_name, TMZ.tmz_hours_offset 

		FROM tbl_text2cust T2C 

		INNER JOIN tbl_consumer CSM ON T2C.csm_id = CSM.csm_id 

		INNER JOIN tbl_text_msgs TMS ON TMS.txt_id = T2C.txt_id

		INNER JOIN lt_member_merchants MMC ON MMC.ltb_id=TMS.ltb_id

		INNER JOIN tbl_timezone TMZ ON MMC.tmz_id=TMZ.tmz_id

		WHERE TMS.ltb_id = :ltb_id ORDER BY TMS.txt_date DESC LIMIT 100';



		$qry = $_DBConnecion->prepare( $sql );



		$qry->bindValue(':ltb_id', $ltb_id, PDO::PARAM_INT);



		$qry->execute();



		$qry = $qry->fetchAll( PDO::FETCH_ASSOC );

		

		$_textHistory = array();

		

		foreach ( $qry as $key => $value ) {



			if (!isset($_textHistory[$value['txt_id']]))	

				$_textHistory[$value['txt_id']] = array(

					'txt_id'     => $value['txt_id'],

					'txt_msg'    => $value['txt_msg'],

					'txt_date'   =>  date('M-d-Y h:i A',  strtotime(((int)(($value['tmz_hours_offset']))>=0?'+' . (int)(($value['tmz_hours_offset'])): (int)(($value['tmz_hours_offset']))) . " hours", strtotime($value['txt_date']) ) ),

					'recipients' => array()

				);

				

			if (!in_array($value['csm_first_name'] . ' ' . $value['csm_last_name'], $_textHistory[$value['txt_id']]['recipients']))

				array_push($_textHistory[$value['txt_id']]['recipients'], $value['csm_first_name'] .' '. $value['csm_last_name']);        

			

		}

		return $_textHistory;

	}

	function get_remainingTexts($ltb_id, $dbo) {
		$sql = 'SELECT lfc_count FROM lt_feature_cnt WHERE lpf_id = 14 AND ltb_id = :ltb_id LIMIT 1';
		$q = $dbo->prepare( $sql );
		$q->bindValue(':ltb_id', $ltb_id, PDO::PARAM_INT);
		$q=execPDO($q);
		$q=$q->fetch( PDO::FETCH_ASSOC );
		return intval($q['lfc_count']);	
	}
	

	require '../../app/class.variables.php';

	$cv = new _variables(); // new instance

	

	if (isset($_REQUEST['wnu_offset_r'], $_REQUEST['wnu_limit_r'])) {

		$cv->varible_in('wnu_offset_r'); $cv->varible_in('wnu_limit_r');

		$request = $cv->get_cleaned_variables();

		$errors = $cv->get_bad_variables();

		if ( empty( $errors ) ) {

			$sql = "

			SELECT csm_id, csm_first_name, csm_last_name, csm_cell_number

			FROM tbl_consumer 

			WHERE ltm_pick_id=:ltm_id

				AND csm_txt_status=1 

				AND csm_cell_number IS NOT NULL 

				AND csm_cell_number <> '' 

				AND csm_active=1

			ORDER BY csm_id 

			LIMIT {$request['limit']} OFFSET {$request['offset']}";

			$qry = $dbo->prepare( $sql );

			$qry->bindValue( ':ltm_id', $_SESSION['user']['merchant']['ltm_id'], PDO::PARAM_INT );

			$qry->execute();

			$response = $qry->fetchAll( PDO::FETCH_ASSOC );	

		}

		//else{var_dump($errors);}

		echo json_encode(!isset($response)?array( 'status' => 'empty' ):$response);

	}

	

	elseif ( isset( $_POST['txt138_msg_content_r'], $_SESSION['user']['merchant']['ltb_id'], $_POST['action'] ) ) {

		$remaining_sms_texts = get_remainingTexts($_SESSION['user']['merchant']['ltb_id'], $dbo);
		

		if (!isset($_POST['recipient'])) {

			//get all consummers for this merchant				

			$qry = $dbo->prepare("

			SELECT CONCAT(csm_cell_number, '_', csm_id) AS Pho_Id

			FROM tbl_consumer 

			WHERE ltm_pick_id = :ltm_id 

				AND csm_cell_number IS NOT NULL 

				AND csm_cell_number != '' 

				AND csm_active=1

				AND csm_txt_status=1

			ORDER BY csm_id");

			$qry->bindValue( ':ltm_id', $_SESSION['user']['merchant']['ltm_id'], PDO::PARAM_INT );

			$qry->execute();

			$recipients = array();

			

			while ($Res = $qry->fetch( PDO::FETCH_ASSOC )) {

				array_push($recipients, $Res['Pho_Id']);

			}

		}

		else{

			$recipients = $_POST['recipient'];

		}

		if ( count($recipients) <= $remaining_sms_texts ) { 



			$fields=array('txt138_msg_content_r');



			//check the values of passed variables



			foreach($fields as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop



			$_v=$cv->get_cleaned_variables();



			$errors=$cv->get_bad_variables();

            

			if (isset($_POST['scheduled-time'], $_POST['timezone']) && $_POST['action'] == 'schedule_text' &&  is_numeric($_POST['timezone']) && !empty($_POST['scheduled-time']))

			

				$dateVar = @date('Y-m-d H:i:s', strtotime("+{$_POST['timezone']} hours", strtotime($_POST['scheduled-time']) ) );

				

			

			if ( !count($errors) ){				

				

				$recipList = array(); $_msg = $_v['msg_content'] . ' Reply STOP to end msgs';

				foreach ( $recipients as $k=>$v ) {

					$recipient = explode('_', $v);

					if ( $recipient[0][0]!=='1' ) {

						array_push( $recipList, '1'.$recipient[0] );

					} else {

						array_push( $recipList,$recipient[0] );

					}

				}

				

				if ( isset($dateVar) && !empty($dateVar) ){

					$msgSend = 'Success';

				}

				else{

					if ($_POST['action'] == 'send_text'){

						require_once '../../app/function.send-text.php'; //_appSendText();										

						$msgSend = _appSendText($_msg, $recipList);

					}

					else{

						$msgSend = 'Action not found.';

					}

				}	

					

				if ($msgSend === 'Success') {

					// update remaining SMS text field

					$new_remaining_texts = (intval($remaining_sms_texts) - count($recipList));

					$qry = $dbo->prepare("UPDATE lt_feature_cnt SET lfc_count=:new_remaining_texts WHERE ltb_id=:ltb_id AND lpf_id = 14");

					$qry->bindValue(':new_remaining_texts', $new_remaining_texts, PDO::PARAM_INT);

					$qry->bindValue(':ltb_id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_INT);

					$qry = execPDO($qry);



					// insert to tbl_text_msgs

					

					if (isset($dateVar) && !empty($dateVar)){

						$qry = $dbo->prepare( "INSERT INTO `tbl_text_msgs` ( txt_msg, ltb_id , txt_date, txt_scheduled) VALUES ( :txt_msg, :ltb_id, :txt_date, 1)" );

						$qry->bindValue(':txt_date', $dateVar, PDO::PARAM_STR);

					}

					else {

						$qry = $dbo->prepare( "INSERT INTO `tbl_text_msgs` ( txt_msg, ltb_id, txt_date ) VALUES ( :txt_msg, :ltb_id, :txt_date )" );	

						$qry->bindValue(':txt_date', date('Y-m-d H:i:s', strtotime('now') ), PDO::PARAM_STR);		

					}	

					$qry->bindValue(':txt_msg', $_v['msg_content'], PDO::PARAM_STR);

					$qry->bindValue(':ltb_id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_STR);

					$qry = execPDO($qry);

					$last_id = $dbo->lastInsertId();



					// loop & insert to tbl_text2cust

					

					$phone_numbers = ''; $str = '';



					foreach($recipients as $key => $value) {



						$value = explode( '_', $value ); // [0] = phone [1] = csm_id



						$str.= ($str == ''?'':',') . "(:txt_id, :csm_id{$key})";



						$phone_numbers .= $value[0] . ',';



					}

					

					$qry = $dbo->prepare( "INSERT INTO `tbl_text2cust` (txt_id, csm_id) VALUES {$str}" );



					$qry->bindValue(':txt_id', $last_id, PDO::PARAM_STR);

					

					foreach($recipients as $key => $value){



						$value = explode( '_', $value );



						$qry->bindValue(":csm_id{$key}", $value[1], PDO::PARAM_STR);



					}						



					$qry = execPDO($qry);

					

					$textHistory = get_History($dbo, $_SESSION['user']['merchant']['ltb_id']);					

					

					$remaining_sms_texts = get_remainingTexts($_SESSION['user']['merchant']['ltb_id'], $dbo);
					

					echo json_encode( array( 'leftemail'=>$remaining_sms_texts, 'data'=>$textHistory, 'msg'=>(isset($dateVar) && !empty($dateVar)?"Message scheduled":"Message sent") ) );

					

					

				} else {

					$errors['send_text_error'] = $msgSend;

				}	

			}

		} else {

			$errors['remaining_texts'] = 'You selected '.count($recipients).' recipients, but you only have '.number_format($remaining_sms_texts).' texts left.';				

		}

		

		if (!empty($errors))			

			echo json_encode($errors);			

	}	

	

	else /*( isset( $_SESSION['user']['merchant']['ltb_id'], $_POST['wnu_tzid_r'] ) )*/ {

		$textHistory = get_History($dbo, $_SESSION['user']['merchant']['ltb_id']);

		$tz=get_TimeZone($dbo, $_SESSION['user']['merchant']['ltb_id']);

		echo json_encode( array( 'data'=>$textHistory, 'tz'=>$tz ) );

		/*

		$fields=array('wnu_tzid_r');

		//check the values of passed variables

		foreach($fields as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop

		$_v=$cv->get_cleaned_variables();

		$errors=$cv->get_bad_variables();

		if (empty($errors)) {

			$sql = 'UPDATE lt_member_merchants SET tmz_id = :tmz_id WHERE ltb_id = :ltb_id';

			$q = $dbo->prepare( $sql );

			$q->bindValue(':ltb_id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_INT);

			$q->bindValue(':tmz_id', $_v['tzid'], PDO::PARAM_INT);

			$q->execute();

			echo json_encode(array( 'tmz_id' => $_v['tzid'] ));			

		}

		else {

			echo json_encode($errors);

		}

		*/

	}

}

else

	echo json_encode( array( 'status' => 'empty' ) );

?>