<?php
require '../../app/start_session.php';
require '../../app/function.connect.php';
header( 'Content-Type: application/json; charset=utf-8' );
$error = array();
$response = array();
$response['error'] = '';
$response['status'] = '';
// {"csm_first_name":"dan","csm_last_name":"test","csm_email":"dantest123@yahoo.com","csm_cell_number":"","csm_zip":"33445","csm_id":"388","latitude":"26.4647478","longitude":"-80.109357"

if($_SERVER['REQUEST_METHOD'] == 'POST' || $_SERVER['REQUEST_METHOD'] == 'GET' && isset($_SESSION['user']['merchant']['ltb_id'])){

  //check the values of passed variables
  require '../../app/class.variables.php';
  $cv= new _variables(); // new instance
  $cv_array=array('wnu_csm_id_r','dec_csm_long','dec_csm_lat','ema64_email_r', 'nam64_f_name_r', 'nam64_l_name_r', 'wnu_zip_code_r', 'pho_cell_phone'); //list all varibles to be check in array
  foreach($cv_array as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop
  $request=$cv->get_cleaned_variables();
  $errors=$cv->get_bad_variables();
 
  if (empty($errors)){
    // check if email is in use
    $sql=('SELECT csm_email FROM tbl_consumer WHERE csm_id!=:id AND csm_email=:email');
    $q = $dbo->prepare($sql);
    $q->bindValue( ':id', $request['csm_id'], PDO::PARAM_INT);
    $q->bindValue( ':email', $request['email'], PDO::PARAM_STR );
    $q->execute();
    $results = $q->fetchAll( PDO::FETCH_ASSOC );
    if (count($results)){
      $response['status'] = 'error';
      $response['error'] = array('ema64_email_r'=>'email already in use');
    } else {
      // update consumer
      $sql=('UPDATE IGNORE `tbl_consumer` SET csm_first_name=:fname, csm_last_name=:lname, csm_email=:email, csm_cell_number=:phone, csm_zip=:zip, csm_lat=:lat, csm_long=:long WHERE csm_id=:id');
      $q = $dbo->prepare($sql);
      $q->bindValue( ':id', $request['csm_id'], PDO::PARAM_INT);
      $q->bindValue( ':fname', $request['f_name'], PDO::PARAM_STR );
      $q->bindValue( ':lname', $request['l_name'], PDO::PARAM_STR );
      $q->bindValue( ':email', $request['email'], PDO::PARAM_STR );
      $q->bindValue( ':phone', $request['cell_phone'], PDO::PARAM_STR );
      $q->bindValue( ':zip', $request['zip_code'], PDO::PARAM_INT );
      $q->bindValue( ':lat', $request['csm_lat'], PDO::PARAM_INT );
      $q->bindValue( ':long', $request['csm_long'], PDO::PARAM_INT );
      $q->execute();
      $response['status'] = 'success';
    }

  } else {
    // return errors
    $response['status'] = 'error';
    $response['error'] = $errors;
  }
  $response['updates'] = $_REQUEST;
}
echo json_encode($response);
?>