<?php
require '../../app/start_session.php';
require '../../app/function.connect.php';
require '../../app/function.get-subdir.php';

header( 'Content-Type: application/json; charset=utf-8' );
$response['status'] = '';
if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['uploaded_img']) ) {
	
	$validImageFileFlag = @exif_imagetype($_FILES['uploaded_img']['tmp_name']);
	if ($validImageFileFlag === false) {
		$response['status'] = 'Incorrect image file.';//<script>alert("Please upload image smaller than 500KB")</script>
	}
	else {
		include 'function.image-upload.php'; //image upload function

		list( $orig_w, $orig_h ) = getimagesize( $_FILES['uploaded_img']['tmp_name'] );

		$ltb_id = $_SESSION['user']['merchant']['ltb_id'];

		$valid = array('jpeg', 'jpg', 'png', 'gif'); // allowed extensions

		$sizes = array( 600 => 'auto', 250 => 'auto', 120 => 120 );

		if ($orig_w < 250 || $orig_h < 250){

			$response['status'] = 'Image must be at least 250px wide and 250px tall.'; 

		}

		else{

			if( $_FILES['uploaded_img']['size'] < ( 1024 * 1000 ) ) { // max upload is 1000kb			

				$ext = strtolower(pathinfo($_FILES['uploaded_img']['name'], PATHINFO_EXTENSION)); // get file extension

				if(in_array($ext, $valid)){
					appResize( $sizes, true ); // resize image function
					$response['status'] = 'Success';

					$sql = 'SELECT ltb_header_image FROM lt_member_merchants WHERE ltb_id=:id LIMIT 1';
					$qry = $dbo->prepare($sql);
					$qry->bindValue( ':id',$ltb_id, PDO::PARAM_INT );
					$qry->execute();
					$qry = $qry->fetchAll( PDO::FETCH_ASSOC );

					$path = "../merchant-custom-files/".getMerchantSubDir($ltb_id, '../merchant-custom-files')."/_files/img/h_250w_".$qry[0]['ltb_header_image'];

					$response['path'] = $path;
				}
				else{

					$response['status'] = 'Unsupported or empty file.';//<script>alert("Unsupported or empty file")</script>

				}
			}
			else {

				$response['status'] = 'Image must be smaller than 1000KB.';//<script>alert("Please upload image smaller than 500KB")</script>

			}
		} 
	}
}
	echo json_encode($response);
?>