<?php

// --- GET MEMBERS --- //

$members = $thisMerchant->callStoreFunction(getEmailUnsubscribedMembers, 186); 

$memberUnsCount = 0;

if ( count($members) > 0 ) {
	
	$membersMonth = $thisMerchant->callStoreFunction(getEmailUnsubscriptionsByMonth, 186); 

	if ( !empty($membersMonth) ) {

		$memberUnsCount = $membersMonth['EmailUnsubscriptionTotal'];

	}

	$first = strtotime( 'now' );

	$months_numArr = array();

	$months_strArr = array();
	
	$years_strArr = array();

	for ($i = 5; $i >= 0; $i--) {

	  array_push( $years_strArr, date( 'Y', strtotime( "-$i month", $first ) ) );
	  
	  array_push( $months_numArr, date( 'm', strtotime( "-$i month", $first ) ) );

	  array_push( $months_strArr, '"'.date('M', strtotime("-$i month", $first)).'"' );

	}

	$join_totalsUns = ''; $months_str = ''; 

	if ( !empty( $membersMonth ) ) {

		foreach ( $months_numArr as $key => $valNum ) {

			$foundFlagUns = false; 

			reset( $membersMonth ); 

			$qryVal = current( $membersMonth );

			while ( !$foundFlagUns && $qryVal) {				
			
				if ($years_strArr[$key] ==  $qryVal['year_updated'] && $months_numArr[$key] == $qryVal['month_updated']) {

					$months_str .= ( $months_str===''?'':', ' ) . $months_strArr[$key];

					$join_totalsUns .= ( $join_totalsUns===''?'':', ' ) . $qryVal['month_amount'];				

					$foundFlagUns = true;			

				}	
				
				$qryVal = next($membersMonth);
			}

			if ( !$foundFlagUns ) {

				$months_str .= ( $months_str===''?'':', ' ) . $months_strArr[$key]; 

				$join_totalsUns .= ( $join_totalsUns===''?'0':', 0' );

			}

		}	

	}

}

?>

<style>

	td > span > input[type="text"].form-control {

    	width: 100%;

	}

	.csm-edit-btn, .csm-save-btn {

		cursor: pointer;

	}

	.dropdown{

		float:right;

		margin-top:10px;

		margin-bottom:10px;

	}

	.dropdown a{

		cursor: pointer;

	}

</style>

<?php if ( count($members) > 0 ) { ?>

<div class="mystats_subhead">Email Unsubscription by Month</div>

<div id="legendDiv"></div>

<canvas id="memberChart"></canvas><br><br>

<div class="row">

 <div id="table-div" class="col-md-12">

  <table class="table mystats_table table-striped" id="mystats_msg_table">

	<thead>		

		<th>First Name</th>

		<th>Last Name</th>

		<th>Email</th>

		<th>Phone</th>

		<th>Zip</th>

		<th>Date Joined</th>

	</thead>

	<?php

	foreach($members as $key => $value){

		echo '

			<tr id="'.$value['id'].'">				

				<td><span class="abc64_f_name_r">'.$value['fname'].'</span></td>

				<td><span class="abc64_l_name_r">'.$value['lname'].'</span></td>

				<td><span class="ema64_email_r">'.$value['email'].'</span></td>

				<td><span class="pho_cell_phone">'.$value['phone'].'</span></td>

				<td><span class="wnu_zip_code_r">'.$value['zip'].'</span></td>

				<td>'.$value['date_joined'].'</td>

			</tr>

		';

	}

	?>

  </table>

 </div> 

</div>

<script>
var memberOBJ = {
	table: {},
	currentAmountUns : <?php echo count($members);?>,
	tempFlag: true,
	runAjax : <?php echo ( count( $members ) < $memberUnsCount?"true":"false" );?>,
	labels: [<?php echo "{$months_str}"; ?>],
	data: [<?php echo $join_totalsUns; ?>]
};
</script> 

<script src="js/mystats_emailunsubscriptions.js"></script>

<?php } else { echo "<h3><span class='label label-primary'>You have no members to track</span></h3><br>";}?>
 
