<?php
$noData = false;
$promoId = (isset($_GET['promo_id']) && is_numeric($_GET['promo_id'])?intval($_GET['promo_id']):0);
$userId = (isset($_GET['user_id']) && is_numeric($_GET['user_id'])?intval($_GET['user_id']):0);

/*Neither a promo nor an user was selected, listing all redemable promos (Default)*/

$mainHeader = 'Redemption Count by Promo';
$tableHeader = 'Redeemed Promo Count: ';
$tableInnerHeader = 'Redeemed Promos';
$graphType = 'Bar';
$showTable = '1';	
if ($promoId == 0 && $userId > 0) {
	/*An user was selected*/
	$data = $thisMerchant->getRedemptionCountPerPromo(186, $userId);	
}		
elseif ($promoId > 0 && $userId == 0) {
	/*A prmotion was selected*/
	$mainHeader = 'Redemption Count by Month';
	$tableHeader = 'User Count: ';
	$data = $thisMerchant->getPromoRedemptions($promoId, 0, 186);
}		
elseif ($promoId > 0 && $userId > 0) {
	/*A prmotion and an user was selected*/
	$data = $thisMerchant->getPromoRedemedDate($promoId, 186, $userId);
}
else {
	$data = $thisMerchant->getRedemptionCountPerPromo(); //$qry->fetchAll( PDO::FETCH_ASSOC );
}

$data_count = count($data);

if ($data_count > 0) {
	$first  = strtotime('now');
	$months_numArr = array();
	$months_strArr = array();
	$years_numArr = array();
	for ($i = 5; $i >= 0; $i--) {
	  array_push($months_numArr, date('m', strtotime("-$i month", $first)));
	  array_push($years_numArr, date('Y', strtotime("-$i month", $first)));
	  array_push($months_strArr, '"'.date('M', strtotime("-$i month", $first)).'"');
	}
	if ($promoId > 0 && $userId == 0) {
		$graphType = 'Line';
		$foundUserId = '0';
		foreach ($data as $var)
			if (isset($var['id']))
				$foundUserId.=','.$var['id'];
			
		$uCount = $thisMerchant->getUserCountThatRedemedPromo($promoId, 186, $foundUserId);		
		$months_str = ''; $dataTotals = '';$promoName='';
		if ( !empty($uCount) ) {
			foreach ($months_numArr as $key => $valNum) {
				$foundFlag = false; reset($uCount); $qryVal = current($uCount);
				while (!$foundFlag && $qryVal) {
					if ( $qryVal['month_red'] == $valNum && $years_numArr[$key] == $qryVal['year_red'] ) {
						if (empty($promoName)) { $promoName = $qryVal['headLine']; }
						$months_str .= ($months_str===''?'':', ') . $months_strArr[$key];
						$dataTotals .= ($dataTotals===''?'':', ') . $qryVal['month_amount'];				
						$foundFlag = true;
					}
					$qryVal = next($uCount);
				}
				if (!$foundFlag) {				
					$months_str .= ($months_str===''?'':', ') . $months_strArr[$key];
					$dataTotals .= ($dataTotals===''?'0':', 0');
				}
			}	
		}
		$tableInnerHeader = 'Redeemed Promo: '.$promoName;
		$i=0;$tableObj='labels: ['.$months_str.'],
		datasets: [';
		$tableObj.='
		
				{
					label: "'. $promoName  .'",
					fillColor: "rgba(80,171,210,0.2)",
					strokeColor: "rgba(80,171,210,1)",
					pointColor: "rgba(80,171,210,1)",
					pointStrokeColor: "#fff",
					pointHighlightFill: "#fff",
					pointHighlightStroke: "rgba(80,171,210,1)",
					data:  ['.$dataTotals.']
			}],
		';
		
	}
	
	elseif ($promoId == 0 && $userId > 0) {		
		$foundPromoId = '0';
		foreach ($data as $var)
			if (isset($var['promoId']))
				$foundPromoId.=','.$var['promoId'];
		$rCount = $thisMerchant->getRedemedCountOfUser($userId, 186, $foundPromoId);		

		$months_str = ''; $userName=''; $dataTotals = array(); $promoIdArr = array(); $promoName = array();
		if ( !empty($rCount) ) {
			foreach ($months_numArr as $key => $valNum) {
				reset($rCount); $qryVal = current($rCount);
				while ($qryVal) {										
					if ( $qryVal['month_red'] == $valNum  && $years_numArr[$key] == $qryVal['year_red'] ) {					
						if (!isset($dataTotals[$qryVal['promoId']]))
							$dataTotals[$qryVal['promoId']] = '';
						if (!isset($promoName[$qryVal['promoId']]))
							$promoName[$qryVal['promoId']] = $qryVal['promoHeader'] . ' (' . $qryVal['promoId'] . ')';						
						if (!isset($promoIdArr[$qryVal['promoId']]))
							$promoIdArr[$qryVal['promoId']] = $qryVal['promoId'];
						if (empty($userName))
							$userName = $qryVal['fName'] . ' ' . $qryVal['lName'];
						
						$dataTotals[$qryVal ['promoId']] = $qryVal['amount'];						
					}
					$qryVal = next($rCount);
				}
										
			}
			
			$mainHeader = $userName.'\'s Redemptions By Promo';
			$tableInnerHeader = 'Promos Redeemed By: '.$userName;
			$months_str = '"'.implode('","', $promoIdArr).'"'; 
			$i=0;$tableObj='labels: ['.$months_str.'],
			datasets: [';
			$tableObj.='
			
					{
						label: "'. implode(', ', $promoName ).'",
						fillColor: "rgba(80,171,210,0.2)",
						strokeColor: "rgba(80,171,210,1)",
						pointColor: "rgba(80,171,210,1)",
						pointStrokeColor: "#fff",
						pointHighlightFill: "#fff",
						pointHighlightStroke: "rgba(80,171,210,1)",
						data:  ['.implode(',', $dataTotals).']
				}],
			';
		}
		
	}
	elseif ($promoId > 0 && $userId > 0) {
		$rCount = $thisMerchant->getRedemedCountOfUserOnPromo($userId, $promoId, 186);
		$dateStr = ''; $dataTotals = '';$userName='';
		if ( !empty($rCount) ) {
			reset($rCount); 
			$qryVal = current($rCount);
			while ($qryVal) {
				if (empty($userName)) { $userName = $qryVal['fName'] . ' ' . $qryVal['lName']; }
				$dateStr .= ($dateStr===''?'':'", "') . $qryVal['month_red'] . '/' . $qryVal['day_red'] . '/' . $qryVal['year_red'];
				$dataTotals .= ($dataTotals===''?'':', ') . $qryVal['amount'];				
				$qryVal = next($rCount);
			}			
		}
		$mainHeader = 'User Redemptions by Date';
		$showTable=0;
		$i=0;$tableObj='labels: ["'.$dateStr.'"],
		datasets: [';
		$tableObj.='
				{
					label: "'. $userName  .'",
					fillColor: "rgba(80,171,210,0.2)",
					strokeColor: "rgba(80,171,210,1)",
					pointColor: "rgba(80,171,210,1)",
					pointStrokeColor: "#fff",
					pointHighlightFill: "#fff",
					pointHighlightStroke: "rgba(80,171,210,1)",
					data:  ['.$dataTotals.']
			}],
		';
		
	}
	else {
		$foundUserId = '0';
		foreach ($data as $var)
			if (isset($var['promoId']))
				$foundUserId.=','.$var['promoId'];
		$rCount = $thisMerchant->getRedemedCountOfUserList(186, $foundUserId);
		$months_str = ''; $dataTotals = array(); $promoIdArr = array(); $promoName = array();
		if ( !empty($rCount) ) {
			foreach ($months_numArr as $key => $valNum) {
				reset($rCount); $qryVal = current($rCount);
				while ($qryVal) {										
					if ( $qryVal['month_red'] == $valNum  && $years_numArr[$key] == $qryVal['year_red'] ) {					
						if (!isset($dataTotals[$qryVal['promoId']]))
							$dataTotals[$qryVal['promoId']] = '';
						if (!isset($promoName[$qryVal['promoId']]))
							$promoName[$qryVal['promoId']] = $qryVal['promoHeader'] . ' (' . $qryVal['promoId'] . ')';						
						if (!isset($promoIdArr[$qryVal['promoId']]))
							$promoIdArr[$qryVal['promoId']] = $qryVal['promoId'];
						
						$dataTotals[$qryVal ['promoId']] = $qryVal['month_amount'];						
					}
					$qryVal = next($rCount);
				}
										
			}
			$months_str = '"'.implode('","', $promoIdArr).'"'; 
			$i=0;$tableObj='labels: ['.$months_str.'],
			datasets: [';
			$tableObj.='
			
					{
						label: "'. implode(', ', $promoName ).'",
						fillColor: "rgba(80,171,210,0.2)",
						strokeColor: "rgba(80,171,210,1)",
						pointColor: "rgba(80,171,210,1)",
						pointStrokeColor: "#fff",
						pointHighlightFill: "#fff",
						pointHighlightStroke: "rgba(80,171,210,1)",
						data:  ['.implode(',', $dataTotals).']
				}],
			';
		}
	}
}
else {
	$noData = true;
}
/*
function getNewColor($color, $round) {
	$tempArr=explode (',', $color);
	foreach ($tempArr as $ind => $c){
		$tempArr[$ind] = intval($c) - $round * 30;
		if ($tempArr[$ind] < 0) $tempArr[$ind] = 250 + $tempArr[$ind];
	}
	return (string) implode(',', $tempArr);
}
*/
?>
<style>
	td > span > input[type="text"].form-control {
    	width: 100%;
	}
	.csm-save-btn {
		cursor: pointer;
	}
</style>
<?php if (!$noData){ ?>

<div class="mystats_subhead"><?php echo $mainHeader; ?></div>
<div id="legendDiv"></div>
<canvas id="memberChart"></canvas>
<?php if ($showTable) { ?>
  <h3><span class="label label-primary"><?php echo $tableHeader.$data_count; ?></span></h3> 
<?php } ?>  
<br>
<br>
<div class="row">
 <div id="table-div" class="col-md-12">
 <?php if ($showTable) { ?>
  <table class="table mystats_table table-striped" id="mystats_members_table">
	<?php if ( ( $promoId > 0 && $userId == 0 ) ) { ?>
		<thead>			
			<th>First Name</th>
			<th>Last Name</th>
			<th>Email</th>
			<th>Phone</th>
			<th>Zip</th>
			<th>Redemptions</th>
			<th>Date Joined</th>		
		</thead>
	
	<?php
		$hRef='/mystore/stats.php?mystats=promo-redemptions&promo_id='.$promoId.($userId > 0?'&user_id='.$userId:'');
	
		foreach($data as $key => $value){
			
			echo '
				<tr id="'.$value['id'].'">
					<td><span>'.$value['fname'].'</span></td>
					<td><span>'.$value['lname'].'</span></td>
					<td><span>'.($value['Picked']?$value['email']:'').'</span></td>
					<td><span>'.($value['Picked']?$value['phone']:'').'</span></td>
					<td><span>'.$value['zip'].'</span></td>
					<td><a href="'.$hRef.'&user_id='.$value['id'].'"><span>'.$value['redemptions'].'</span></a></td>
					<td>'.($value['Picked']?$value['date_joined']:'').'</td>
				</tr>
			';
		}
	}
	else {
	?>
		<thead>			
			<th>Promo</th>
			<th>Redemption Count</th>		
		</thead>
	<?php 
		foreach($data as $key => $value){
			echo '
				<tr id="'.$value['promoId'].'">
					<td><a href="/mystore/promo_form.php?ltp_id='.$value['promoId'].'"><span>'.$value['promoHeader'].'</span></a></td>
					<td><a href="/mystore/stats.php?mystats=promo-redemptions&promo_id='.$value['promoId'].($userId > 0? '&user_id='.$userId:'').'"><span>'.$value['redemptions'].'</span></a></td>
				</tr>
			';
		}
	} 
	
	?>
  </table>
 <?php } ?> 
 </div> 
</div>
<script>
var memberOBJ = {
	rowId: 0,
	table: {},
	tableData: {<?php echo $tableObj;?>},
	currentAmount : <?php echo count($data);?>,
	tempFlag: true,
	runAjax : <?php echo ( count($data) < $data_count?"true":"false" );?>
}

var generalUseObj = {
	graphType : '<?php echo $graphType; ?>',
	showTable : <?php echo $showTable; ?>
}
</script>
<script src="js/mystats_promo-redemptions.js"></script>
<?php } else { echo "<h3><span class='label label-primary'>There is no data to be displayed</span></h3>"; 
 } ?>

