<?php 
// --- GET PROMOS --- //
$promoList = $thisMerchant->loadPromos ($orderBy = 'activeDesc');
$areTherePromos = true;
if(empty($promoList)){ 
	$areTherePromos = false;
} 

if ($areTherePromos){
	// -- GET PROMO STATS BY MONTH (for graph) -- //
	// build list of past 6 months
	$first = strtotime("now");
	$months_num = array();
	$months_str = array();
	$year_num = array();	
	
	for ($i = 5; $i >= 0; $i--) {
	  array_push($months_num, date('m', strtotime("-$i month", $first)));
	  array_push($months_str, '"'.date('M', strtotime("-$i month", $first)).'"');
	  array_push($year_num, date('Y', strtotime("-$i month", $first)));
	}
	
	$promoTracking = $thisMerchant->getPromoTrackingHistory (0);
	$promoRedemption = $thisMerchant->getPromoRedemptionHistory(0);
	
	foreach ($months_num as $key => $value) {		
			$monthInt = intval($value);
			$yearInt = intval($year_num[$key]);
			
			$mon_totals[$value]['impressions'] = 0;
			$mon_totals[$value]['opens'] = 0;
			$mon_totals[$value]['shares'] = 0;
			$mon_totals[$value]['scratches'] = 0;
			$mon_totals[$value]['redeemed'] = 0;
			
			if (!empty($promoTracking)) {
				foreach ($promoTracking as $i=>$t) {
					if (intval($t['lpk_month']) === $monthInt && intval($t['lpk_year']) === $yearInt) {
						$mon_totals[$value]['impressions'] += intval($t['impressions']);
						$mon_totals[$value]['opens'] += intval($t['views']);
						$mon_totals[$value]['shares'] += intval($t['shares']);
						$mon_totals[$value]['scratches'] += intval($t['scratched']); 
					}
					
				}
			}
			
			if (!empty($promoRedemption)) {
				foreach ($promoRedemption as $i=>$t) {
					if (intval($t['lpr_month']) === $monthInt && intval($t['lpr_year']) === $yearInt) {
						$mon_totals[$value]['redeemed'] += intval($t['redeemed']);
					}
				}
			}
	}
	
	foreach ($mon_totals as $key => $value) {
		//echo '<br>'.$key .'<br>'; print_r($value);
		$impr_totals[$key] = ($impr_totals[$key] + $value['impressions']);
		$open_totals[$key] = ($open_totals[$key] + $value['opens']);
		$share_totals[$key] = ($share_totals[$key] + $value['shares']);
		$scra_totals[$key] = ($scra_totals[$key] + $value['scratches']);
		$redem_totals[$key] = ($redem_totals[$key] + $value['redeemed']);
	}
	
	//print_r($impr_totals);
	$impressions = implode(', ', $impr_totals);
	$opens = implode(', ', $open_totals);
	$shares = implode(', ', $share_totals);
	$scratches = implode(', ', $scra_totals);
	$redemptions = implode(', ', $redem_totals);
	$months_str = implode(', ', $months_str);

	// --- INDIVIDUAL PROMO TRACKING (for table) --- //
	foreach ($promoList as $key => $value) {
		$promoList[$key]['impressions'] 	= 0;
		$promoList[$key]['views'] 			= 0;
		$promoList[$key]['shares'] 		    = 0;
		$promoList[$key]['scratched'] 		= 0;
		if (!isset($promoList[$key]['month']))
			$promoList[$key]['month']		= 0;
		$promoList[$key]['redeemed'] 		= 0;

		if (!empty($promoTracking)) {
			foreach ($promoTracking as $i=>$t) {
				if (intval($t['ltp_id']) === intval($promoList[$key]['ltp_id'])) {
					$promoList[$key]['impressions'] += intval($t['impressions']);
					$promoList[$key]['views'] += intval($t['views']);
					$promoList[$key]['shares'] += intval($t['shares']);
					$promoList[$key]['month'] = $t['shares'];
					$promoList[$key]['scratched'] += intval($t['scratched']); 
				}
				
			}
		}
		
		if (!empty($promoRedemption)) {
			foreach ($promoRedemption as $i=>$t) {
				if (intval($t['ltp_id']) === intval($promoList[$key]['ltp_id'])) {
					$promoList[$key]['redeemed'] += intval($t['redeemed']);
				}
			}
		}
	}
}

if ($areTherePromos){ ?>
	<div class="mystats_subhead">Promotion Performance by Month</div>
	<div id="legendDiv"></div>
	<canvas id="promoChart"></canvas>
	<br><br>
	<table class="table mystats_table table-striped" id="mystats_promos_table">
		<thead>
			<th>Edit</th>
			<th>Headline</th>
			<th>Opens</th>
			<th>Redeemed</th>
			<th>Scratches</th>
			<th>Active?</th>
		</thead>
		<?php
		foreach($promoList as $key => $value){
			echo '
				<tr>
					<td><a href="promo_form.php?ltp_id='.$promoList[$key]['ltp_id'].'">edit</a></td>
					<td>'.$promoList[$key]['ltp_headline'].'</td>
					<td>'.$promoList[$key]['views'].'</td>
					<td>'.($promoList[$key]['ltp_max_redemptions_global'] == NULL || $promoList[$key]['ltp_max_redemptions_global'] > 0 ? $promoList[$key]['redeemed'] : 'N/A' ).'</td>
					<td>'.($promoList[$key]['ltp_promo_type'] == 6 ? $promoList[$key]["scratched"]:'N/A').'</td>
					<td>'.($promoList[$key]['ltp_active'] == 1 ? "<a href='promo_list.php' style='color:green'>Yes</a>":"<a href='promo_list.php' style='color:red'>No</a>").'</td>
				</tr>
			';
		}
		?>
	</table>
<?php } else { echo 'You have no promotions to track. <a href="promo_list.php">Click here to create a promotion.</a>'; } ?>
<script>
var mystatsPromoObj = {
	labelArr: [<?php echo $months_str; ?>],
	scratchArr: [<?php echo $scratches; ?>],
	openArr: [<?php echo $opens; ?>],
	redemptionArr: [<?php echo $redemptions; ?>]
};
</script>
<script src="js/mystats_promos.js"></script>

