$(document).ready(function(){
	memberOBJ.table = $('#members_table').dataTable({
		"order": [[ 4, 'desc' ]],
		"bFilter": true,
		'fnCreatedRow': function (nRow) {
			if (!memberOBJ.tempFlag)
				$(nRow).attr('id', memberOBJ.rowId); 
		},
		"dom": '<"#statsTableWrap"l<"#memberTableTitle">f><t><ip>'
	});
	$('#memberTableTitle').append("<div class='mystats_subhead'>Customer List</div>");	  
    $('#members_table_filter input').unbind();
    $('#members_table_filter input').bind('keyup', function(e) {	   
	   if(e.keyCode == 13) {
		memberOBJ.searchStr = this.value.trim();   
		searchMembers (true);
	   }
    });   
})

function searchMembers (clearTable) {
	if (memberOBJ.runAjax && memberOBJ.tempFlag) {
		var oSettings = memberOBJ.table.fnSettings();		
		
		var dataStr = "wnu_offset_r="+(clearTable? '0': memberOBJ.currentAmount+oSettings._iDisplayLength)+"&wnu_limit_r="+(clearTable? '100' : oSettings._iDisplayLength);
		
		if (memberOBJ.searchStr != '') {
			dataStr += "&txt_search_r="+memberOBJ.searchStr;			
		}
		
		$.ajax({
			url: "inc/api.get-members.php",
			global: false,
			type: "POST",		   
			dataType: "html",		   
			data: dataStr, 
			success: function (response) {
				var myArray = jQuery.parseJSON(response);
				if (myArray.status != undefined && myArray.status == "empty") {
					if (memberOBJ.searchStr == '')
						memberOBJ.runAjax=false;
				}
				else {
					memberOBJ.tempFlag = false;
					var current = memberOBJ.table.api().page();					
					if (clearTable) {memberOBJ.table.fnClearTable();}
					for (var i=0; i < myArray.length; i++){	
						memberOBJ.rowId = myArray[i]['id'];						
						var rows = ['<a class="csm-edit-btn" href="/mystore/member.php?csm_id='+myArray[i]['id']+'">view</a>',
									'<span class="abc64_f_name_r">'+myArray[i]['fname']+'</span>',
									'<span class="abc64_l_name_r">'+myArray[i]['lname']+'</span>',
									'<span class="ema64_email_r">'+myArray[i]['email']+'</span>',
									'<span class="pho_cell_phone">'+(!myArray[i]['phone']?'':myArray[i]['phone'])+'</span>',
									'<span class="wnu_zip_code_r">'+myArray[i]['zip']+'</span>',									
									myArray[i]['date_joined']
									];
						 memberOBJ.table.fnAddData(rows, true);					 
					}
					memberOBJ.currentAmount += oSettings._iDisplayLength;
					
					oSettings._iDisplayStart = current * oSettings._iDisplayLength;
					$(oSettings.oInstance).trigger('page', oSettings);
					oSettings.oApi._fnCalculateEnd( oSettings );
					oSettings.oApi._fnDraw( oSettings );					
					
					memberOBJ.tempFlag = true;
					
					if (clearTable)
						memberOBJ.table.fnFilter(memberOBJ.searchStr);
					
					
				}
			}						
		})
	}
}

$("#members_table").on('page.dt', function(e) {
	searchMembers (false);
});