function loadMembers(useDefault, dataType, dataPeriod){

	var oSettings = memberOBJ.table.fnSettings();	

	$.ajax({

			url: "inc/api.get-members.php",

			global: false,

			type: "POST",		   

			dataType: "html",		   

			data: "wnu_offset_r="+(useDefault?memberOBJ.currentAmount+oSettings._iDisplayLength:'0')+"&wnu_limit_r="+(useDefault?oSettings._iDisplayLength:'100')+(dataType != undefined?'&bit_email_unsubscription='+dataType:'')+(dataPeriod != undefined?'&wnu_period='+dataPeriod:''), 

			success: function (response)

			{

				var myArray = jQuery.parseJSON(response);

				//console.log(myArray);

				if (myArray.status != undefined && myArray.status == "empty") {

					memberOBJ.runAjax=false;

				}

				else {

					memberOBJ.tempFlag = false;

					if (useDefault){

						var current = memberOBJ.table.api().page();

					}

					else{

						memberOBJ.table.fnClearTable();

					}

					for (var i=0; i < myArray.length; i++){	

						//memberOBJ.rowId = myArray[i]['id'];						

						var rows = [

									'<span class="abc64_f_name_r">'+myArray[i]['fname']+'</span>',

									'<span class="abc64_l_name_r">'+myArray[i]['lname']+'</span>',

									'<span class="ema64_email_r">'+myArray[i]['email']+'</span>',

									'<span class="pho_cell_phone">'+(!myArray[i]['phone']?'':myArray[i]['phone'])+'</span>',

									'<span class="wnu_zip_code_r">'+myArray[i]['zip']+'</span>',

									myArray[i]['date_joined']

									];

						 memberOBJ.table.fnAddData(rows, true);						 

					}

					

					if (useDefault){

						memberOBJ.currentAmount += oSettings._iDisplayLength;					

						oSettings._iDisplayStart = current * oSettings._iDisplayLength;

						$(oSettings.oInstance).trigger('page', oSettings);

						oSettings.oApi._fnCalculateEnd( oSettings );

						oSettings.oApi._fnDraw( oSettings );					

					}

					else{

						memberOBJ.currentAmount = myArray.length;

					}

					memberOBJ.tempFlag = true;

					

				}

			}						

		})

	

}



$("#mystats_msg_table").on('page.dt', function(e) {	

	if (memberOBJ.runAjax && memberOBJ.tempFlag) {

		loadMembers(true, '1', '186');

	}

});



$(document).ready(function(){

	// data for the charts

	var data = {

	    labels: memberOBJ.labels,

	    datasets: [

	        {

				label: "Unsubscribed Members",

	            fillColor: "rgba(240,67,54, 0.2)",

	            strokeColor: "rgba(240,67,54,1)",

	            pointColor: "rgba(240,67,54,1)",

	            pointStrokeColor: "#fff",

	            pointHighlightFill: "#fff",

	            pointHighlightStroke: "rgba(240,67,54,1)",

	            data:  memberOBJ.data

	        }

	    ]

	};

	// Get context with jQuery - using jQuery's .get() method.

	var ctx = $("#memberChart").get(0).getContext("2d");

	// This will get the first returned node in the jQuery collection.

	var memberChart = new Chart(ctx).Line(data);

	document.getElementById("legendDiv").innerHTML =  memberChart.generateLegend();

	memberOBJ.table = $('#mystats_msg_table').dataTable({

		"order": [[ 4, 'desc' ]],

		"dom": '<"#statsTableWrap"l<"#msgTableTitle">f><t><ip>'

	});

	$('#msgTableTitle').append("<div class='mystats_subhead'>Unsubscribed Members</div>");



});