$("#mystats_members_table").on('page.dt', function(e) { 
    searchMembers (false);	
});

function searchMembers (clearTable) {
	if (memberOBJ.runAjax && memberOBJ.tempFlag) {
		var oSettings = memberOBJ.table.fnSettings();
		var dataStr = "wnu_offset_r="+(clearTable? '0': memberOBJ.currentAmount+oSettings._iDisplayLength)+"&wnu_limit_r="+(clearTable? '100' : oSettings._iDisplayLength);
		
		if (memberOBJ.searchStr != '') {
			dataStr += "&txt_search_r="+memberOBJ.searchStr;			
		}
		$.ajax({
			url: "inc/api.get-members.php",
			global: false,
			type: "POST",		   
			dataType: "html",		   
			data: dataStr, 
			success: function (response)
			{
				var myArray = jQuery.parseJSON(response);								
				if (myArray.status != undefined && myArray.status == "empty") {
					memberOBJ.runAjax=false;
				}
				else {					
					memberOBJ.tempFlag = false;
					var current = memberOBJ.table.api().page();	
					if (clearTable) {memberOBJ.table.fnClearTable();}	
					for (var i=0; i < myArray.length; i++){	
						memberOBJ.rowId = myArray[i]['id'];						
						var rows = ['<a class="csm-edit-btn" href="/mystore/member.php?csm_id='+myArray[i]['id']+'">view</a>',
									'<span class="abc64_f_name_r">'+myArray[i]['fname']+'</span>',
									'<span class="abc64_l_name_r">'+myArray[i]['lname']+'</span>',
									'<span class="ema64_email_r">'+myArray[i]['email']+'</span>',
									'<span class="pho_cell_phone">'+(!myArray[i]['phone']?'':myArray[i]['phone'])+'</span>',
									'<span class="wnu_zip_code_r">'+myArray[i]['zip']+'</span>',
									myArray[i]['redemptions'],
									myArray[i]['punchcard'],									
									myArray[i]['punchRedeemDate'],									
									myArray[i]['date_joined']
									];
						 memberOBJ.table.fnAddData(rows, true);						 
					}
					memberOBJ.currentAmount += oSettings._iDisplayLength;
					
					oSettings._iDisplayStart = current * oSettings._iDisplayLength;
					$(oSettings.oInstance).trigger('page', oSettings);
					oSettings.oApi._fnCalculateEnd( oSettings );
					oSettings.oApi._fnDraw( oSettings );					
					
					memberOBJ.tempFlag = true;
					if (clearTable)
						memberOBJ.table.fnFilter(memberOBJ.searchStr);
				}
			}						
		})
	}
}

$(document).ready(function(){
	/*
	//edit a member
	$('#mystats_members_table').on('click', "a.csm-edit-btn", function(){
		var row = $(this).closest('tr');
		var row_id = row.attr('id');
		var row_spans = $('#'+row_id+' > td > span');
		var the_button = $(this);		
		
		if (!the_button.hasClass('csm-save-btn')){
			// turn edit button into save button
			the_button.addClass('csm-save-btn').text('save'); 			
			
			// console.log(row_spans[0]['className']);			
			
			$.each(row_spans, function(index, value){
				// console.log(row_spans[index]['className']);
				var the_node = $('#'+row_id+' .'+row_spans[index]['className']);
				the_node.html('<input type="text" value="'+the_node.text()+'" class="form-control">');
			});
			
		} else { 
			// destroy previous error tooltips
			$('[data-toggle="tooltip"]').tooltip('destroy').attr('data-toggle', '').attr('title', ''); 
			// save the changes
			var save_changes = {};
			$.each(row_spans, function(index, value){
				// console.log(row_spans[index]['className']);
				var the_input = $('#'+row_id+' .'+row_spans[index]['className']+' input');
				var the_name = row_spans[index]['className'];
				save_changes[the_name] = the_input.val();
				// console.log(row_spans[index]['className'] +' : '+the_input.val());				
			});
			//console.log(save_changes);
			save_changes['wnu_csm_id_r'] = row_id;
			// console.log('csm_id: '+row_id);

			// get lat and long from zip
			var bad_zip = false;
			$.ajax({
				url: "https://maps.googleapis.com/maps/api/geocode/json",
				global: false,
				type: "GET",		   
				dataType: "html",		   
				data: "address="+save_changes['csm_zip'], 
				success: function (response)
				{
					var myArray = jQuery.parseJSON(response);
					if (myArray.status=="OK" && myArray.results.length>0){
						save_changes['dec_csm_lat'] = myArray.results[0]["geometry"]["location"].lat;
						save_changes['dec_csm_long'] = myArray.results[0]["geometry"]["location"].lng;
					}
					else{
						bad_zip = true;
						alert('Invalid zip code entered');	  
					}
				}						
			}).done(function(){
				if (!bad_zip) {
					// console.log(save_changes);
					$.ajax({
						url: "inc/api.update-consumer-info.php",
						global: false,
						type: "GET",		   
						dataType: "html",		   
						data: save_changes, 
						success: function (response)
						{
							var myArray = jQuery.parseJSON(response);
							// console.log(response);
							if (myArray['error'] !== ''){
								$.each(myArray['error'], function(index, value){
									// console.log(index+' : '+value);
									$('#'+row_id+' .'+index).attr('data-toggle', 'tooltip').attr('title', value);
								});
								// init error tooltips
								$(function () {
								  $('[data-toggle="tooltip"]').tooltip('show');
								});
							} else {
								$.each(myArray['updates'], function(index, value){
									$('#'+row_id+' .'+index).html(value);
								});
								// turn save button into edit button
								the_button.removeClass('csm-save-btn').text('edit'); 
							}
						}						
					});
				}
			});
		}
	});
	*/
	// data for the charts
	var data = {
	    labels: memberOBJ.tableLabels,
	    datasets: [
	        {
	            label: "New Customer Joined",
	            fillColor: "rgba(80,171,210,0.2)",
	            strokeColor: "rgba(80,171,210,1)",
	            pointColor: "rgba(80,171,210,1)",
	            pointStrokeColor: "#fff",
	            pointHighlightFill: "#fff",
	            pointHighlightStroke: "rgba(80,171,210,1)",
	            data:  memberOBJ.tableData
	        }
	    ]
	};
	// Get context with jQuery - using jQuery's .get() method.
	var ctx = $("#memberChart").get(0).getContext("2d");
	// This will get the first returned node in the jQuery collection.
	var memberChart = new Chart(ctx).Line(data);
	document.getElementById("legendDiv").innerHTML =  memberChart.generateLegend();

	memberOBJ.table = $('#mystats_members_table').dataTable({
		"order": [[ 4, 'desc' ]],
		'fnCreatedRow': function (nRow) {
			if (!memberOBJ.tempFlag)
				$(nRow).attr('id', memberOBJ.rowId); 
		},
		"dom": '<"#statsTableWrap"l<"#memberTableTitle">f><t><ip>'
	});
	$('#memberTableTitle').append("<div class='mystats_subhead'>Full Customer Details</div>");
	$('#mystats_members_table_filter input').unbind();
    $('#mystats_members_table_filter input').bind('keyup', function(e) {	   
	   if(e.keyCode == 13) {
		memberOBJ.searchStr = this.value.trim(); 
		searchMembers (true);
	   }
    }); 
});