$(document).ready(function(){
	var $htmlAndBody = $('html, body');
	
	var $prevTutorialItemBtn = $('.prevTutorialItemBtn');
	var $nextTutorialItemBtn = $('.nextTutorialItemBtn');
	var $beginTutorialBtn 	 = $('#beginTutorialBtn');
	var $endTutorialBtn   	 = $('#endTutorialBtn');

	var $tutorialItemsLength    = $('[data-tutorial-item]').length;
	var $tutorialItemText       = $('#tutorialItemText');
	var $theOverlay		  		= $('#tutorialOverlay');
	var $pageFooter             = $('footer');
	var $pageBody				= $('body');
	var $mystoreTopBar          = $('.mystore-home-topbar');

	var arrowIconLeft  = '<img src="images/tutorial-arrow.png" class="tutorial-arrow tutorial-arrow-left">';
	var arrowIconRight = '<img src="images/tutorial-arrow.png" class="tutorial-arrow tutorial-arrow-right">';
	var $guideIcon     = $('#mystore-manual-icon');
	var $guideIconYellow     = $('#mystore-manual-icon-yellow');

	var $currentItem;
	var currentItem = 0;

	// begin the tutorial
	$beginTutorialBtn.on('click', function(){
		showOverlay();

		// show the first item
		handleItemChange('next');

		// hide this button
		$beginTutorialBtn.hide();

		// show skip tutorial button
		$endTutorialBtn.show();

		// hide white icon
		$guideIcon.hide();

		// show yellow icon
		$guideIconYellow.show();
	});

	// end the tutorial
	$endTutorialBtn.on('click', function(){
		endTutorial();
	});

	// goto next item
	$nextTutorialItemBtn.on('click', function(){
		handleItemChange('next');
	});

	// goto previous item
	$prevTutorialItemBtn.on('click', function(){
		handleItemChange('prev');
	});

	// listen for escape and arrow keys
	$(document).keyup(function(e) {
		if (!window.isMenuOpened) {
	    switch(e.which) {
	        case 37: // left arrow
	        	// previous
	        	handleItemChange('prev');
	        break;

	        case 39: // right arrow
	        	// next
	        	handleItemChange('next');
	        break;

	        case 27: // escape
	        	// close
	        	endTutorial();
	        break;

	        default: return; // exit this handler for other keys
	    }
	    e.preventDefault(); // prevent the default action (scroll / move caret)
		}
	});

	function endTutorial(){
		// remove arrows
		removeArrows();

		// hide the overlay
		hideOverlay();

		// remove selected class from current item
		deselectCurrentItem();

		// reset the current item variable
		currentItem = 0;

		// hide end tutorial button
		$endTutorialBtn.hide();

		// show start tutorial button
		$beginTutorialBtn.show();

		// hide yellow icon
		$guideIconYellow.hide();

		// show white icon
		$guideIcon.show();

		// scroll back to top
		$htmlAndBody.animate({ scrollTop: 0 }, 300);
	}

	function showOverlay(){
		$theOverlay.addClass('show-overlay');
		$pageBody.addClass('show-overlay');
		$pageFooter.addClass('show-overlay');
		$mystoreTopBar.addClass('mystore-home-topbar-active');
	}

	function hideOverlay(){
		$theOverlay.removeClass('show-overlay');
		$pageBody.removeClass('show-overlay');
		$pageFooter.removeClass('show-overlay');
		$mystoreTopBar.removeClass('mystore-home-topbar-active');
	}

	function handleItemChange(direction){
		// deselect current item
		if (currentItem != 0){
			deselectCurrentItem();
		}

		// remove any arrows that may be attached to a selected item
		removeArrows();

		// figure out which direction were going
		if (direction === 'next' && $tutorialItemsLength != currentItem){
			// if $tutorialItemsLength == currentItem then were at the last item
			currentItem++;
		} else if (direction === 'prev' && currentItem != 1) {
			// if currentItem == 1, were on the first item, so we cannot go back
			currentItem--;
		}

		// set current item
		$currentItem = $('[data-tutorial-item="'+currentItem+'"]');
		
		// select the item
		$currentItem.addClass('tutorialSelectedItem');

		// add the arrow icons to ONLY THE FIRST ITEM
		if (currentItem === 1){
			$currentItem.append(arrowIconLeft);
			$currentItem.append(arrowIconRight);
		}

		// now they would like to highlight a second portion of the screen only on the 2nd item
		if (currentItem === 2){
			$('.chat_container').addClass('tutorialSelectedItem');
			$('.mystoreTutorialChat').append(arrowIconLeft).append(arrowIconRight);
		}

		// change the button text on the last item
		if ($tutorialItemsLength === currentItem){
			$('.skip-close-text').text('Close Tutorial');
		} else {
			$('.skip-close-text').text('Skip Tutorial');
		}

		// scroll to the item
		$htmlAndBody.animate({ scrollTop: $currentItem.offset()? $currentItem.offset().top - 80: 0 }, 300);

		// show the item's text
		var itemText = $currentItem.data('tutorialText');
		$tutorialItemText.html(itemText);

		// check if we should disable the btns
		handleDisableControls();
	}

	function handleDisableControls(){
		// check if we should disable the next or prev btns
		if ($tutorialItemsLength === currentItem){
			$nextTutorialItemBtn.prop('disabled', true).addClass('disabled');
		} else {
			$nextTutorialItemBtn.prop('disabled', false).removeClass('disabled');
		}

		if (currentItem === 1){
			$prevTutorialItemBtn.prop('disabled', true).addClass('disabled');	
		} else {
			$prevTutorialItemBtn.prop('disabled', false).removeClass('disabled');
		}
	}

	function deselectCurrentItem(){
		$('.tutorialSelectedItem').removeClass('tutorialSelectedItem');
	}

	function removeArrows(){
		$('.tutorial-arrow').remove();
	}
});