/* settings slide in menu */
(function(window) {

  'use strict';

  /**
   * Extend Object helper function.
   */
  function extend(a, b) {
    for(var key in b) { 
      if(b.hasOwnProperty(key)) {
        a[key] = b[key];
      }
    }
    return a;
  }

  /**
   * Each helper function.
   */
  function each(collection, callback) {
    for (var i = 0; i < collection.length; i++) {
      var item = collection[i];
      callback(item);
    }
  }

  /**
   * my_Menu Constructor.
   */
  function my_Menu(options) {
    this.options = extend({}, this.options);
    extend(this.options, options);
    this._init();
  }

  /**
   * my_Menu Options.
   */
  my_Menu.prototype.options = {
    wrapper: '#my-index-wrap',          // The content wrapper
    type: 'slide-right',             // The my_Menu type
    my_MenuOpenerClass: '.c-button',   // The my_Menu opener class names (i.e. the buttons)
    maskId: '#my_Menu_mask'               // The ID of the mask
  };

  /**
   * Initialise my_Menu.
   */
  my_Menu.prototype._init = function() {
    this.body = document.body;
    this.wrapper = document.querySelector(this.options.wrapper);
    this.mask = document.querySelector(this.options.maskId);
    this.my_Menu = document.querySelector('#my_Menu--' + this.options.type);
    this.closeBtn = this.my_Menu.querySelector('.my_Menu__close');
    this.my_MenuOpeners = document.querySelectorAll(this.options.my_MenuOpenerClass);
    this._initEvents();
  };

  /**
   * Initialise my_Menu Events.
   */
  my_Menu.prototype._initEvents = function() {
    // Event for clicks on the close button inside the my_Menu.
    this.closeBtn.addEventListener('click', function(e) {
      e.preventDefault();
      this.close();
    }.bind(this));

    // Event for clicks on the mask.
    this.mask.addEventListener('click', function(e) {
      e.preventDefault();
      this.close();
    }.bind(this));
  };

  /**
   * Open my_Menu.
   */
  my_Menu.prototype.open = function() {
	window.isMenuOpened = true;  
    this.body.classList.add('has-active-my_Menu');
    this.wrapper.classList.add('has-' + this.options.type);
    this.my_Menu.classList.add('is-active');
    this.mask.classList.add('is-active');
    this.disablemy_MenuOpeners();
    initialiseMap();
  };

  /**
   * Close my_Menu.
   */
  my_Menu.prototype.close = function() {
	window.isMenuOpened = false;  
    this.body.classList.remove('has-active-my_Menu');
    this.wrapper.classList.remove('has-' + this.options.type);
    this.my_Menu.classList.remove('is-active');
    this.mask.classList.remove('is-active');
    this.enablemy_MenuOpeners();
  };

  /**
   * Disable my_Menu Openers.
   */
  my_Menu.prototype.disablemy_MenuOpeners = function() {
    each(this.my_MenuOpeners, function(item) {
      item.disabled = true;
    });
  };

  /**
   * Enable my_Menu Openers.
   */
  my_Menu.prototype.enablemy_MenuOpeners = function() {
    each(this.my_MenuOpeners, function(item) {
      item.disabled = false;
    });
  };
  
  /**
   * Add to global namespace.
   */
  window.my_Menu = my_Menu;

})(window);

window.isMenuOpened = false;

var slideRight = new my_Menu({
  wrapper: 'body',
  type: 'slide-right',
  my_MenuOpenerClass: '.c-button',
  maskId: '#my_Menu_mask'
});

// index button
var slideRightBtn = document.querySelector('.my-settings-trigger');
if (slideRightBtn){
  slideRightBtn.addEventListener('click', function(e) {
    e.preventDefault;
    slideRight.open();
  });
}
// header button
var slideRightBtn2 = document.querySelector('.my-settings-trigger2');
if (slideRightBtn2){
  slideRightBtn2.addEventListener('click', function(e) {
    e.preventDefault;
    slideRight.open();
  });
}


/** Form Validation */
/*
function appVerify(elem){
  var val, err, arr = [],
      btn = $("#save-company-info"),
    form = $("#my-settings-form").serializeArray();

  $.each(form,function(k,v){  
  val  = $.trim(v.value);
  $err = $("."+v.name);
  // console.log($err);
  if     (val!="" && $err.hasClass("alphanum") && !appRegex(val,/^[ A-Za-z0-9_@./!#()$?,\"'"%&+-]*$/i)) arr.push({"span":v.name,"text":"Alpha-numeric and -@,%$()?\'.!/#&+ only."});
  else if(val!="" && $err.hasClass("code")     && !appRegex(val,/^[\w]*$/)) arr.push({"span":v.name,"text":"Alpha-numeric only, no spaces."});
  else if(val!="" && $err.hasClass("email")    && !appRegex(val,/^[\w._%+-]+@[\w.-]+.[a-zA-Z]{2,4}$/)) arr.push({"span":v.name,"text":"Please enter a valid email address."});
  else if(val!="" && $err.hasClass("url")      && !appRegex(val,/^((http|https)?(:\/\/)?)?[\w-]+(\.[\w-]+)+([\w.,@?^=%&amp;:\/~+#-]*[\w@?^=%&amp;\/~+#-])?$/)) arr.push({"span":v.name,"text":"Invalid format."});
  else if(val!="" && $err.hasClass("zip")      && !appRegex(val,/(^\d{5}$)|(^\d{5}-\d{4}$)/)) arr.push({"span":v.name,"text":"Invalid format."});
  else if(val!="" && $err.hasClass("phone")    && !appRegex(val,/^(?=.*[0-9])[- +()0-9]+$/)) arr.push({"span":v.name,"text":"Invalid format."});
    else if(val!="" && $err.hasClass("phone")    && !appPhoneLen(val)) arr.push({"span":v.name,"text":"Please enter a 10, or 11 Digit Number."});
    else if(val!="" && $err.hasClass("max25")    && appMaxChar(val,25)) arr.push({"span":v.name,"text":"Maximum 25 characters."});
    else if(val!="" && $err.hasClass("max64")   && appMaxChar(val,64)) arr.push({"span":v.name,"text":"Maximum 64 characters."});
    else if(val!="" && $err.hasClass("max255")   && appMaxChar(val,255)) arr.push({"span":v.name,"text":"Maximum 255 characters."});
  else if(val=="" && $err.hasClass("required")) arr.push({"span":v.name,"text":"Required field."});
  else if($err.hasClass("time")     && appTimeCheck(form)) arr.push({"span":v.name,"text":"Cannot start before end."});
  else if($err.hasClass("datetime") && appDateCheck(form)) arr.push({"span":v.name,"text":"Cannot start before end."});
  else $("span."+v.name).hide().empty().prev("."+v.name).css({"border-color":"#ccc"});
  });

  if(arr.length===0){
    btn.removeAttr("disabled");
  return true;
  }
  else{
    // btn.prop("disabled","disabled").addClass('disabled');
  $.each(arr,function(k,v){
    if(v.span == elem.context.name) $("span."+v.span).text(v.text).fadeIn().prev("."+v.span).css({"border-color":"#f88"})
  });
  return false;
  }
}
*/
/** Character Counter */
/*
function appMaxChar(val,num){
  var txt = "", $max = $(".max"+num), ct = $max.val().length;

  if( ct!= 1 ) txt = "s";
  
  if( ct >= num ) {
    $max.next(".notify").css({"display":"none"});
  } else {
    $max.next(".notify").text((num-ct) +" character"+txt+" left").fadeIn();
  }

  return ct > num ? true : false;
}
*/
/** Regex Checker */
/*
function appRegex(v,x){
  var a = new RegExp(x), b = a.test(v); 
  return b;
}
 format displayed phone numbers 
function appPhoneFormat(p){
  var num = p.length;
  switch(num){
    //case 7:  return p.replace(/(\d{3})(\d{3})(\d{4})/, "$1-$2"); break;
  case 10: return p.replace(/(\d{3})(\d{3})(\d{4})/, "($1) $2-$3"); break;
  case 11: return p.replace(/(\d{1})(\d{3})(\d{3})(\d{4})/, "$1 ($2) $3-$4"); break;
    default: return p;
  }
}

// check phone number length 
function appPhoneLen(val){
  var len = val.replace(/[^0-9]/g,"").length;
  switch(len){
    case 10: case 11: return true; break;
  default: return false; break;
  }
}
*/

// hide info, show input
hideCompanyInfo = function (){
  $('#my-company-info').hide("slide", { direction: "left" },  function(){
      $('#my-company-input').show("slide", { direction: "left" }, function(){
      });
  });
}
// hide input, show info
hideCompanyInput = function (){
  $('#my-company-input').hide("slide", { direction: "left" }, function(){
    $('#my-company-info').show("slide", { direction: "left" }, function(){
    });
  });
}
// user clicked edit settings button hide company info, show inputs
$('#edit-company-info, #settings-logo-btn').on('click', function(){
  hideCompanyInfo();
});
// cancel editing
$('#cancel-company-info').on('click', function(){
  hideCompanyInput();
});



// hide info, show input
hideLocationInfo = function (){
  $('#my-location-info').hide("slide", { direction: "left" },  function(){
      $('#my-location-input').show("slide", { direction: "left" }, function(){
      });
  });
}
// hide input, show info
hideLocationInput = function (){
  $('#my-location-input').hide("slide", { direction: "left" }, function(){
    $('#my-location-info').show("slide", { direction: "left" }, function(){
    });
  });
}
// user clicked edit settings button hide company info, show inputs
$('#edit-location-info').on('click', function(){
  hideLocationInfo();
});
// cancel editing
$('#cancel-location-info').on('click', function(){
  hideLocationInput();
});


// MULTIPLE LOCATIONS
$('.edit-multi-location-info').on('click', function(){
  var ltm_id = $(this).data('ltm-id');
  $('.my-multi-location-info_' + ltm_id).hide("slide", { direction: "left" }, function(){
    $('.my-multi-location-input_' + ltm_id).show("slide", { direction: "left" });
  });
});

$('.cancel-multi-location-info').on('click', function(){
  var ltm_id = $(this).data('ltm-id');
  $('.my-multi-location-input_' + ltm_id).hide("slide", { direction: "left" }, function(){
    $('.my-multi-location-info_' + ltm_id+':not(#my-location-info)').show("slide", { direction: "left" });
  });
});


// hide info, show input
hideHoursInfo = function (){
  $('#my-hours-info').hide("slide", { direction: "left" },  function(){
      $('#my-hours-input').show("slide", { direction: "left" }, function(){

      });
  });
}
// hide input, show info
hideHoursInput = function (){
  $('#my-hours-input').hide("slide", { direction: "left" }, function(){
    $('#my-hours-info').show("slide", { direction: "left" }, function(){

    });
  });
}
// user clicked edit settings button hide company info, show inputs
$('#edit-hours').on('click', function(){
  hideHoursInfo();
});
// cancel editing
$('#cancel-hours').on('click', function(){
  hideHoursInput();
});



hideCategoryInfo = function (){
  $('#my-category-info').hide("slide", { direction: "left" }, function(){
    $('#my-category-input').show("slide", { direction: "left" }, function(){
    });
  });
}
hideCategoryInput = function (){
  $('#my-category-input').hide("slide", { direction: "left" }, function(){
    $('#my-category-info').show("slide", { direction: "left" }, function(){
    });
  });
}
// user clicked edit category 
$('#edit-category-keyword').on('click', function(){
  hideCategoryInfo();
});
// cancel editing
$('#cancel-category-info').on('click', function(){
  hideCategoryInput();
});



hideAccountInfo = function (){
  $('#my-acc-info').hide("slide", { direction: "left" }, function(){
    $('#my-acc-input').show("slide", { direction: "left" }, function(){
    });
  });
}
hideAccountInput = function (){
  $('#my-acc-input').hide("slide", { direction: "left" }, function(){
    $('#my-acc-info').show("slide", { direction: "left" }, function(){
    });
  });
}
// user clicked edit category 
$('#edit-acc-info, #change-pw').on('click', function(){
  hideAccountInfo();
});
// cancel editing
$('#cancel-acc-info').on('click', function(){
  hideAccountInput();
});