// mystore category && keywords

var keyword_call_glob = {};
 
$(document).ready(function(){

  var max_key = $('#keyword-wrap').data('max-key');

  // save edited category
  $('#save-category-info').on('click', function(){
    if ($('#category_selection').val() != 0 && $("select[name='keyword_selection[]'] option:selected").length > 0){
      my_data = $("#my-category-form").serializeArray();
      
      $.ajax({
        url: "inc/api.handle-category-keywords.php",
        global: false,
        type: "POST", 
        dataType: "HTML",      
        data:  my_data,
        error: function (response){ console.log(response); },
        success: function (response){
            // console.log(response);
            // window.location.href = window.location.href.replace( /[\?#].*|$/, "?updated=1");
            response = JSON.parse(response);
            // console.log(response.main_category);
            $('.ltm_category').html(response.main_category);
            $('.ltm_sub_category').html(response.sub_category);
            $('.ltm_keywords').html(' ');
            $.each(response.key_word,function(k,v){
              $(".ltm_keywords").append(v+", ");
            });
            my_keywords = $(".ltm_keywords").html().replace(/,\s*$/, "");
            $('.ltm_keywords').html(my_keywords);
            // hide inputs, show info
            hideCompanyInput();
            //reinit map
            setTimeout(function(){
               initialiseMap();
             }, 1000);
            showAlert('<span class="glyphicon glyphicon-thumbs-up"></span> Success! Categories and keywords saved.');
        }
      });
      hideCategoryInput();
    } else { console.log('You must complete all fields before saving.'); }
  });

  var current_keywords = function(cat_id){
    $.ajax({
      url: "inc/get-merchant-keywords.php",
      global: false,
      type: "POST",       
      dataType: "JSON",
      data:  "&cat_id="+cat_id,
      error: function (response){ console.log(response);},
      success: function (response){
        // console.log(response);
        $.each(response,function(k,v){
          $("#keyword_selection").append("<option value='"+v.key_id+"' "+(v.ltb_id != null? 'selected':'')+">"+v.key_word+"</option>");
          if(v.ltb_id != null){
            $(".ltm_keywords").append(v.key_word+", ");
          }
        });
        my_keywords = $(".ltm_keywords").html().replace(/,\s*$/, "");
        $('.ltm_keywords').html(my_keywords);
        $("#keyword_selection").prepend("<option/>").select2({maximumSelectionSize:max_key,placeholder:"Select "+max_key+" Keywords"});
        $('#keyword-wrap').show();
      }
    });
  }
  
  var current_cat_id = $('#my-category-info').data('current-category');
  current_keywords(current_cat_id);

  var category_call = function(par_id){
    $.ajax({
      url: "../api/api.get-categories.php",
      global: false,
      type: "POST",       
      dataType: "JSON",
      data:  "p_category_selection="+par_id,
      error: function (response){ console.log(response);},
      success: function (response){
        //console.log(response);
        //console.log('success');
        //console.log(response);
        var catList = '<option value=0>Choose Sub-category</option>';

        $.each(response, function(index, value){
          catList += '<option value="'+value["cat_id"]+'" '+(current_cat_id==value["cat_id"]?"selected":'')+'>'+value["cat_name"]+'</option>';
		  if (current_cat_id==value["cat_id"]) $('#suggestInCatId').val( value["cat_id"] );
        });
        $('#category_selection').html(catList);
        $('#cat-wrap').show();
      }
    });
  }
  // once a parent category is selected, show child categories
  $("select[name=p_category_selection]").change(function() {
    category_call($("select[name=p_category_selection]").val());
  });
  // if parent category selected, show children categories
  if ($("select[name=p_category_selection]").val() !== null){
    //console.log($("select[name=p_category_selection]").val());
    category_call($("select[name=p_category_selection]").val());
    //console.log('called category_call');
  }

  var keyword_call = function(cat_id){
    $.ajax({
      url: "../api/api.get-keywords.php",
      global: false,
      type: "POST",       
      dataType: "HTML",
      data:  "category_id="+cat_id,
      error: function (response){ console.log(response);},
      success: function (response){
        //console.log(response);
        //console.log('success');
        //console.log(response);
        var keyList = response;
        $('#keyword_selection').html(keyList);
        //console.log($('#keyword-selection'));
        var keywordPlaceholder = "Choose up to "+max_key+" Keywords";
        $('#keyword_selection').select2({maximumSelectionSize: max_key, placeholder: keywordPlaceholder});
        $('#keyword-wrap').show();
		current_keywords(cat_id);
      }
    });
  }
  
  keyword_call_glob = keyword_call;
  
  // once a category is selected, we show available keywords for that category
  $("select[name=category_selection]").change(function() {
    // console.log($("select[name=category_selection]").val());
    keyword_call($("select[name=category_selection]").val());
    // console.log('called keyword_call');
  });
  // if the category has already been chosen, load the keywords for that category.
  if ($("select[name=category_selection]").val() !== null){
    //console.log($("select[name=category_selection]").val());
    keyword_call($("select[name=category_selection]").val());
    //console.log('called keyword_call');
  }
});