  // mystore store hours

  // To disable:    
  document.getElementById('hoursContainer-info').style.pointerEvents = 'none';
  // To re-enable:
  // document.getElementById('id').style.pointerEvents = 'auto'; 

  // save edited company info
  $('#save-hours').on('click', function(){
    
    // get the store hours from obj
    var storeHours = JSON.stringify(businessHoursManager.serialize());
    
    // console.log(storeHours);

    // get ltm id
    var ltm_id = $('#store-hours-ltm-id').val();
    
    $.ajax({
      url: "inc/api.handle-store-hours.php",
      global: false,
      type: "POST", 
      dataType: "HTML",      
      data:  "store-hours="+storeHours+"&ltm_id="+ltm_id,
      error: function (){ alert(response); },
      success: function (response){
          
          response = JSON.parse(response);
          // console.log(response);
          if (response.status === 'success'){
            
            var hours = response.hours;
            
            $('.hours-for-' + response.ltm_id).val(JSON.stringify(hours));
            //initialize store hours for info tab
            initStoreHours(hours, "#hoursContainer-info");
            initStoreHours(hours, "#hoursContainer");

            hideHoursInput();
            
            showAlert('<span class="glyphicon glyphicon-thumbs-up"></span> Success! Store hours updated.');
          } else {
            alert('Error... please contact support.');
            console.error(response);
          }
      }
    });
  });

// on select change, re-init the store hours display with that store's hours
$('#store-hours-ltm-id').on('change', function(){
  var ltm_id = $(this).val();
  var hours = JSON.parse($('.hours-for-' + ltm_id).val());
  initStoreHours(hours, "#hoursContainer-info");
  initStoreHours(hours, "#hoursContainer");
});

// initial hours of the main store
var hours = $('#my-hours-info').data('hours');

// global obj
var businessHoursManager;

// initialize the store hours plugin
initStoreHours(hours, "#hoursContainer-info");
initStoreHours(hours, "#hoursContainer");

function initStoreHours(hours, containerSelector){

  var operationTime = [
    {"isActive":false,"timeFrom":"9:00","timeTill":"5:00 PM","appointmentOnly":false},
    {"isActive":false,"timeFrom":"9:00","timeTill":"5:00 PM","appointmentOnly":false},
    {"isActive":false,"timeFrom":"9:00","timeTill":"5:00 PM","appointmentOnly":false},
    {"isActive":false,"timeFrom":"9:00","timeTill":"5:00 PM","appointmentOnly":false},
    {"isActive":false,"timeFrom":"9:00","timeTill":"5:00 PM","appointmentOnly":false},
    {"isActive":false,"timeFrom":"9:00","timeTill":"5:00 PM","appointmentOnly":false},
    {"isActive":false,"timeFrom":"9:00","timeTill":"5:00 PM","appointmentOnly":false}
  ];

  for (var i=0;i<hours.length;i++){
    for (var i2 = hours[i]['lth_start_day_num']; i2 <= hours[i]['lth_end_day_num']; i2++) {
      switch(parseInt(i2)) {
        case 1: operationTime[0] = {"isActive":true,"timeFrom":hours[i]['lth_open'],"timeTill":hours[i]['lth_close'], "appointmentOnly":hours[i]['lth_appointment_only']};
          break;
        case 2: operationTime[1] = {"isActive":true,"timeFrom":hours[i]['lth_open'],"timeTill":hours[i]['lth_close'], "appointmentOnly":hours[i]['lth_appointment_only']};
          break;
        case 3: operationTime[2] = {"isActive":true,"timeFrom":hours[i]['lth_open'],"timeTill":hours[i]['lth_close'], "appointmentOnly":hours[i]['lth_appointment_only']};
          break;
        case 4: operationTime[3] = {"isActive":true,"timeFrom":hours[i]['lth_open'],"timeTill":hours[i]['lth_close'], "appointmentOnly":hours[i]['lth_appointment_only']};
          break;
        case 5: operationTime[4] = {"isActive":true,"timeFrom":hours[i]['lth_open'],"timeTill":hours[i]['lth_close'], "appointmentOnly":hours[i]['lth_appointment_only']};
          break;
        case 6: operationTime[5] = {"isActive":true,"timeFrom":hours[i]['lth_open'],"timeTill":hours[i]['lth_close'], "appointmentOnly":hours[i]['lth_appointment_only']};
          break;
        case 7: operationTime[6] = {"isActive":true,"timeFrom":hours[i]['lth_open'],"timeTill":hours[i]['lth_close'], "appointmentOnly":hours[i]['lth_appointment_only']};
          break;        
      }
    }
  }

  //initialize store hours plugin for input tab
  var hoursContainer = $(containerSelector);

  // editing global obj
  businessHoursManager = hoursContainer.businessHours({
      operationTime: operationTime, 
      postInit:function(){
          hoursContainer.find('.operationTimeFrom, .operationTimeTill').timepicker({
              'timeFormat': 'h:i A',
              'step': 15
          });
      },
      dayTmpl:'<div class="dayContainer">' +
                '<div data-original-title="" class="colorBox"><input type="checkbox" class="invisible operationState"/></div>' +
                '<div class="weekday"></div>' +
                '<div class="operationDayTimeContainer">' +
                  '<div class="operationTime input-group"><span class="input-group-addon"><i class="icon-sun"></i></span><input type="text" name="startTime" class="mini-time form-control operationTimeFrom" value=""/></div>' +
                  '<div class="operationTime input-group"><span class="input-group-addon"><i class="icon-moon"></i></span><input type="text" name="endTime" class="mini-time form-control operationTimeTill" value=""/></div>' +
                  '<div class="store-hours-checkbox-wrap">'+
                    '<span class="operationTime"><label style="font-size:10px;"><input name="appointmentOnly" class="appointmentOnly" type="checkbox" style="vertical-align: top;"> Appointment Only</label></span>'+
                    '<span class="operationTime"><label style="font-size:10px;"><input name="open24hours" class="open24hours" type="checkbox" style="vertical-align: top;"> Open 24 Hours</label></span>'+
                  '</div>'+
                '</div>'+
              '</div>'
  });

  $('.open24hours').on('change', function(e){
    var thisContainer = $(this).closest('.operationDayTimeContainer');
    var thisFromTime = thisContainer.find('.operationTimeFrom');
    var thisTillTime  = thisContainer.find('.operationTimeTill');
    if ($(this).prop('checked')){
      thisFromTime.prop('disabled', true).val('09:00 AM');
      thisTillTime.prop('disabled', true).val('09:00 AM');
    }
    else {
      thisFromTime.prop('disabled', false);
      thisTillTime.prop('disabled', false).val('05:00 PM');
    }
  });

  $('#my-hours-info').on('click', function(){

  });
}

