// mystore company settings 
$(document).ready(function(){
  var $hideAddressInput = $('#wnu_ltm_hide_address_r');
  $('#hideAddressCtrl').on('change', function(){
    if ($(this).is(':checked')){
      $hideAddressInput.val(1);
    }
    else {
      $hideAddressInput.val(0);
    }
  });

  // save edited company info
  $('#save-location-info').on('click', function(){
	var currentForm = $(this).parents('form'); 
	validForm.inicialiceObj(currentForm);
    if (validForm.validInputs(false)){
      // submit company settings
      $.ajax({
        url: "inc/api.handle-location-settings.php",
        global: false,
        type: "POST", 
        dataType: "HTML",      
        data:  currentForm.serializeArray(),
        error: function (err){ 
			console.log(err)
		},
        success: function (response){
  			if (typeof refresh_TextMessaging == 'function'){ refresh_TextMessaging() };
          console.log(response);
          // window.location.href = window.location.href.replace( /[\?#].*|$/, "?updated=1");
          response = JSON.parse(response);
          // console.log(response.status);
          if (response.status === undefined){
            if (response && response[0])
				alert(response[0]);
          } else {
            // console.log(response);
            $.each(response, function(key, value) {
                // console.log(key, value);
                if (value !== '') {
                  $('#my-location-info .'+key).html(value);
                }
                // console.log('#my-company-info .'+key);
            });
            // hide inputs, show info
            hideLocationInput();
            showAlert('<span class="glyphicon glyphicon-thumbs-up"></span> Success! Settings saved.');
            //reinit map
            setTimeout(function(){
               initialiseMap();
             }, 1000);
          }
        }
      });

    } 
    else { 
      alert('Check error messages.'); 
    }
  });

  $('.save-multi-location-info').on('click', function(){
    var ltm_id = $(this).data('ltm-id');
    var currentForm = $(this).parents('form'); 
    validForm.inicialiceObj(currentForm);
    if (validForm.validInputs(false)){
      // submit company settings
      $.ajax({
        url: "inc/api.handle-location-settings.php",
        global: false,
        type: "POST", 
        dataType: "HTML",      
        data:  currentForm.serializeArray(),
        error: function (){ console.log(response); },
        success: function (response){
        if (typeof refresh_TextMessaging == 'function'){ refresh_TextMessaging() };
          //console.log(response);
          // window.location.href = window.location.href.replace( /[\?#].*|$/, "?updated=1");
          response = JSON.parse(response);
          // console.log(response.status);
          if (response.status === undefined){
			  if (response && response[0])
				alert(response[0]);
          } else {
            // console.log(response);
            $.each(response, function(key, value) {
                // console.log(key, value);
                if (value !== '') {
                  $('.my-multi-location-info_' + ltm_id + ' .'+key).html(value);
                }
                // console.log('#my-company-info .'+key);
            });
            // hide inputs, show info
            $('.my-multi-location-input_' + ltm_id).hide("slide", { direction: "left" }, function(){
              $('.my-multi-location-info_' + ltm_id +':not(#my-location-info)').show("slide", { direction: "left" });
            });

            showAlert('<span class="glyphicon glyphicon-thumbs-up"></span> Success! Settings saved.');
            //reinit map
            setTimeout(function(){
               initialiseMap();
             }, 1000);
          }
        }
      });
    } 
    else { 
      alert('Check error messages.'); 
    }
  });

}); // end doc ready


// verify form inputs
$(".my-locations-form input, .my-locations-form textarea, .my-locations-form select").on("change keyup select", function(){
  //appVerify($(this)); // appVerify() defined in mystore_settings_menu.js
  
  $(".my-locations-form").find(".vCheck").removeClass("vCheck");
  
  $(this).addClass("vCheck");
  
  validForm.inicialiceObj($('.my-locations-form'));
  
  var errArr = validForm.validInputs(true);
  
  if(errArr.length > 0) {$(this).css({"border-color":"#f88"}).next("span.error").text(errArr[0]).fadeIn();}
  
  else $(this).css({"border-color":"#ccc"}).next("span.error").empty().hide();
  
}); 

// states and territories options
function settings_States(){
  $.get("../../api/api.lt.json.options.php",function(data){
    $.each(data.options.state,function(k,v){
      $(".optgroup-states").append("<option value='"+k+"'>"+v+"</option>");
    });
    $.each(data.options.territory,function(k,v){
      $(".optgroup-terries").append("<option value='"+k+"'>"+v+"</option>");
    });
    currentState = $("select.ltm_state").data('current-state');
    $("select.ltm_state option[value='"+currentState+"']").prop("selected",true);
  })
}
settings_States();