// mystore company settings 
$(document).ready(function(){

  // Handle logo update
  // Logo upload
  var logoSrc = $('.main_merchant_logo').attr("src");
  var form = document.getElementById('my-logo-form');
  var fileSelect = document.getElementById('logo-file-input');

  //  LOGO - open choose file dialogue
  $('#my-settings-choose-file').on('click', function(){
    chooseFile();
  });
  function chooseFile() {
    $(fileSelect).click();
  }
    // display selected file name & change opacity of update button to make it clearer to users that they need to click Update
  $(fileSelect).on('change', function(){
    if ($(this).val() != ''){
      $('#file-input-name').html('File selected: '+$('#logo-file-input').val().replace(/C:\\fakepath\\/i, ''));
      $('#my-settings-upload-file').css('opacity','1');
      $('#my-settings-choose-file').css('opacity','0.4');
      // $('#my-settings-upload-file svg').css('color','green');
    }
  });
  // upload logo
  $('#my-settings-upload-file').on('click', function(event){
    if ($(fileSelect).val() === ''){
      alert('Select a file first.');
    } else {
      // Change text
      $('#file-update-status').html('Uploading...');

      // Get file from input
      var file = fileSelect.files[0];
      var formData = new FormData();
      
      if(!file.type.match('image.*')){
        alert('Invalid image format');
      } 
      else {
        // Add the file to the request.
        formData.append('uploaded_img', file, file.name);
        // Set up the request.
        var xhr = new XMLHttpRequest();
        // Open the connection.
        xhr.open('POST', 'inc/api.update_logo.php', true);
        // Set up a handler for when the request finishes.
        xhr.onload = function () {
          if (xhr.status === 200) {
            console.log(xhr.response);
            response = JSON.parse(xhr.response);
            if (response['status'] === 'Success'){
              // hide error, show success
              $('#logo-status').removeClass('alert-danger').addClass('alert-success').html('<span class="glyphicon glyphicon-thumbs-up"></span> Success! Logo updated.').show();
              // update text
              $('#file-update-status').html('Update');
              $('#file-input-name').html('! Image will be resized proportionally. New uploads will delete the former image.');
              // switch opacity on buttons
              $('#my-settings-choose-file').css('opacity','1'); 
            $('#my-settings-upload-file').css('opacity','0.4');
            // update logos in header and settings tab
              $('.main_merchant_logo').attr("src", response['path']+'?newimage='+new Date().getTime()); 
          }
          else {
            // display error
            $('#logo-status').removeClass('alert-success').addClass('alert-danger').html(response['status']).show();
            // switch opacity on buttons
            $('#my-settings-choose-file').css('opacity','1'); 
            $('#my-settings-upload-file').css('opacity','0.4');
            // update text
              $('#file-update-status').html('Update');
              $('#file-input-name').html('! Image will be resized proportionally. New uploads will delete the former image.');
          }
            // console.log(response);
          } else {
            alert('An error occurred! Please try again later.');
          }
        };
        // Send the Data.
        xhr.send(formData);
      }
    }
  });
  // end logo handling

  // save edited company info
  $('#save-company-info').on('click', function(){
	var currentForm = $("#my-settings-form"); 
	validForm.inicialiceObj(currentForm);
    if (validForm.validInputs(false)){
      // submit company settings
      $.ajax({
        url: "inc/api.handle-settings.php",
        global: false,
        type: "POST", 
        dataType: "HTML",      
        data:  currentForm.serializeArray(),
        error: function (){ console.log(response); },
        success: function (response){
			
		  if (typeof refresh_TextMessaging == 'function') refresh_TextMessaging();
		  
          //console.log(response);
          // window.location.href = window.location.href.replace( /[\?#].*|$/, "?updated=1");
          response = JSON.parse(response);
          // console.log(response.status);
          if (response.status === undefined){
            alert(response);
          } else {
            $.each(response, function(key, value) {
                 //console.log(key, value);
                if (value !== '') {
				  if (key === 'tmz_id') {
					$('#my-company-info .'+key).html($( "#tmz_id option:selected" ).text());
					$('div.tmz_id').html($( "#tmz_id option:selected" ).text());
				  }
				  else
					$('#my-company-info .'+key).html(value);
                }
                // console.log('#my-company-info .'+key);
            });
            // hide inputs, show info
            hideCompanyInput();
            showAlert('<span class="glyphicon glyphicon-thumbs-up"></span> Success! Settings saved.');
            //reinit map
            setTimeout(function(){
               initialiseMap();
             }, 1000);
          }
        }
      });

    } 
    else { 
      alert('Check error messages.'); 
    }
  });


}); // end doc ready



// slug handling
// var slug_check = 0;
// function checkSlug(){
//   $.ajax({
//     url: "inc/check-merchant-slug.php",
//     global: false,
//     type: "POST", 
//     dataType: "HTML",      
//     data:  "ltb_slug="+$('#ltb_slug').val(),
//     error: function (){ alert(response); },
//     success: function (response){
//       console.log(response);
//       if (response != 1){
//         $('.ltb_slug.error').html('Slug reserved. Choose a different slug.').show();
//         slug_check = 1;
//       }else{
//         $('.ltb_slug.error').html('').hide();
//         slug_check = 0;
//       }
//     }
//   });
// }
// // check slug while user is typing
// $('#ltb_slug').on('change keyup focus', function() {
//   $(this).val($(this).val().replace(/[\W_]+/g, "-").split(' ').join('-'));
//   $('#slug_preview').html($(this).val());
//   checkSlug();
// });

// verify form inputs
$("#my-settings-form input, #my-settings-form textarea, #my-settings-form select").on("change keyup select", function(){
  //appVerify($(this)); // appVerify() defined in mystore_settings_menu.js
  
  $("#my-settings-form").find(".vCheck").removeClass("vCheck");
  
  $(this).addClass("vCheck");
  
  validForm.inicialiceObj($('#my-settings-form'));
  
  var errArr = validForm.validInputs(true);
  
  if(errArr.length > 0) {$(this).css({"border-color":"#f88"}).next("span.error").text(errArr[0]).fadeIn();}
  
  else $(this).css({"border-color":"#ccc"}).next("span.error").empty().hide();
  
}); 

// states and territories options
// function settings_States(){
//   $.get("../../api/api.lt.json.options.php",function(data){
//     $.each(data.options.state,function(k,v){
//       $("#optgroup-states").append("<option value='"+k+"'>"+v+"</option>");
//     });
//     $.each(data.options.territory,function(k,v){
//       $("#optgroup-terries").append("<option value='"+k+"'>"+v+"</option>");
//     });
//     currentState = $("select.ltm_state").data('current-state');
//     $("select.ltm_state option[value='"+currentState+"']").prop("selected",true);
//   })
// }
// settings_States();