<?php
include 'inc/myi_login_check.php'; // check if user is logged in
//require_once '../app/global.php'; // global constants
$nav_icon_path = 'images/icon-back-office.svg';
$nav_title = 'MyStore';
include 'inc/myi_header.php';
?>

<div id="tutorialOverlay">
	<div id="tutorialControls">
		<div class="container">
			<div class="row">
				<div class="col-xs-12 col-md-8 col-md-push-2">
					<div id="tutorialItemText"></div>
				</div>
				<div class="col-xs-6 col-md-2 col-md-pull-8">
					<a href="#" class="prevTutorialItemBtn tutorial-nav-btn"><img src="images/icon-yellow-arrow.png" style="transform: scale(-1);"></a>
				</div>
				<div class="col-xs-6 col-md-2">
					<a class="nextTutorialItemBtn tutorial-nav-btn"><img src="images/icon-yellow-arrow.png"></a>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="container-fluid mystore-home-topbar">
	<div class="container">
		<div class="row">
			<div class="col-xs-12 col-sm-3">
				<div class="topbar-table">
					<div class="topbar-table-cell ttc-left-side">
						<a href="#" id="beginTutorialBtn">Start Tutorial</a>
						<a href="#" id="endTutorialBtn" style="display:none;">
							<img src="images/icon-x-skip.png" alt="Skip Tutorial" style="max-width: 25px;">
							<span class="skip-close-text">Skip Tutorial</span>
						</a>
					</div>
				</div>
			</div>
			<div class="col-xs-12 col-sm-6">
				<div class="topbar-table">
					<div class="topbar-table-cell">
						<div style="text-align: center;">
							<a class="topbar-mystore-guide" href="../mystore-user-guide.pdf" target="_blank" data-tutorial-item="1" data-tutorial-text="Above is a Link to the <strong>MyStore Manual</strong> that will assist you in using your Local Thanks Platform.">
				            	<img src="images/icon-download_mystore_manual.png" id="mystore-manual-icon" alt="Download the MyStore Manual" style="max-width: 25px;">
				            	<img src="images/icon-download_mystore_manual-yellow.png" id="mystore-manual-icon-yellow" alt="Download the MyStore Manual" style="max-width: 25px;display:none;">
				            	View the <strong>MyStore User Manual</strong>
				            </a>
						</div>
					</div>
				</div>
			</div>	
		</div>
	</div>
</div>

<div id="my-index-wrap" class="my-index-wrap">
	<div class="container">
		<div class="row">
			<div class="col-xs-12">
				<div class="my-index-card-wrap">
					<div class="row">
						<div class="col-md-4 col-sm-6 col-xs-12">
							<div class="my-index-card" data-tutorial-item="2" data-tutorial-text="<strong>Add your customers.</strong> If you need help with a bulk list, please use the Chat or email us at <a href='mailto:customerservice@localthanks.com' style='color:yellow;'>customerservice@LocalThanks.com</a>">
								<a href="<?php echo ($currentMerchantPackage['ppr_price'] == 0?'plan-edit.php?upgrade=1':'my_member_search.php'); ?>">
									<img src="images/index_icon_customers.jpg" alt="Your Customers" class="img-responsive">
									<div class="my-index-card-inner my-index-card-customers">
										Customers
										<div class="my-index-card-icon-wrap">
											<img class="my-index-card-icon" src="images/index_icon_customers.png" alt="Customers Icon">
										</div>
									</div>
								</a>
							</div>
						</div>
					
						<div class="col-md-4 col-sm-6 col-xs-12">
							<div class="my-index-card" data-tutorial-item="3" data-tutorial-text="<strong>Click here to create your promotions.</strong> It only takes 30 seconds! You can refer to Page 7 of the MyStore Manual.">
								<a href="<?php echo ($currentMerchantPackage['ppr_price'] == 0?'plan-edit.php?upgrade=1':'my_promo_list.php'); ?>">
									<img src="images/index_promotions.jpg" alt="Your Promotions" class="img-responsive">
									<div class="my-index-card-inner my-index-card-promotions">
										Promotions
										<div class="my-index-card-icon-wrap">
											<img class="my-index-card-icon" src="images/index_icon_promo.png" alt="Promotions Icon">
										</div>
									</div>
								</a>
							</div>
						</div>

						<div class="col-md-4 col-sm-6 col-xs-12">
							<div class="my-index-card" data-tutorial-item="4" data-tutorial-text="<strong>Communicate with your customers</strong> - Click here to send a text, email or push notification to your customers. You can send them now or schedule them to go out at a later time. You can refer to Page 14 of the MyStore Manual.">
								<a href="<?php echo ($currentMerchantPackage['ppr_price'] == 0?'plan-edit.php?upgrade=1':'text_msg.php'); ?>">
									<img src="images/index_texting.jpg" alt="Your Communicatios" class="img-responsive">
									<div class="my-index-card-inner my-index-card-texting">
										Communications
										<div class="my-index-card-icon-wrap">
											<img class="my-index-card-icon" src="images/index_icon_texting.png" alt="Communicatios Icon">
										</div>
									</div>
								</a>
							</div>
						</div>

						<div class="col-md-4 col-sm-6 col-xs-12">
							<div class="my-index-card" data-tutorial-item="5" data-tutorial-text="<strong>Create your digital punch card</strong> - Click here to create a customized digital punch card that rewards your customers for frequent visits. You can refer to Page 30 of the MyStore Manual.">
								<a href="<?php echo ($currentMerchantPackage['ppr_price'] == 0?'plan-edit.php?upgrade=1':'punch_card.php'); ?>">
									<img src="images/index_punch_card.jpg" alt="Your Punch Card" class="img-responsive">
									<div class="my-index-card-inner my-index-punch-card">
										Punch Card
										<div class="my-index-card-icon-wrap">
											<img class="my-index-card-icon" src="images/index_icon_punch_card.png" alt="Punch Card Icon">
										</div>
									</div>
								</a>
							</div>
						</div>




						
						<div class="col-md-4 col-sm-6 col-xs-12">
							<div class="my-index-card" data-tutorial-item="6" data-tutorial-text="<strong>Performance Analytics</strong> - Click here to view which promotions did well and which ones you want to edit to increase performance. You can refer to Page 31 of the MyStore Manual.">
								<a href="<?php echo ($currentMerchantPackage['ppr_price'] == 0?'plan-edit.php?upgrade=1':'stats.php'); ?>">
									<img src="images/index_analytics.jpg" alt="Your Analytics" class="img-responsive">
									<div class="my-index-card-inner my-index-card-analytics">
										Analytics
										<div class="my-index-card-icon-wrap">
											<img class="my-index-card-icon" src="images/index_icon_analytics.png" alt="Analytics Icon">
										</div>
									</div>
								</a>
							</div>
						</div>
						
						<!--div class="col-md-4 col-sm-6 col-xs-12">
							<div class="my-index-card">
								<a href="emails.php" target="_blank">
									<img src="images/index_emails.jpg" alt="Your Emails" class="img-responsive">
									<div class="my-index-card-inner my-index-card-emails">
										Email Campaigns
										<div class="my-index-card-icon-wrap">
											<img class="my-index-card-icon" src="images/index_icon_emails.png" alt="Emails Icon">
										</div>
									</div>
								</a>
							</div>
						</div-->
						<div class="col-md-4 col-sm-6 col-xs-12">
							<div class="my-index-card" data-tutorial-item="7" data-tutorial-text="<strong>Manage and update your business information</strong>, such as your store name, hours, and keywords. You can refer to Page 5 of the MyStore Manual.">
								<a href="#" class="c-button my-settings-trigger">
									<img src="images/index_settings.jpg" alt="Your Settings" class="img-responsive">
									<div class="my-index-card-inner my-index-card-settings">
										My Business
										<div class="my-index-card-icon-wrap">
											<img class="my-index-card-icon" src="images/index_icon_settings.png" alt="Settings Icon">
										</div>
									</div>
								</a>
							</div>
						</div>
						

						
						<!--div class="col-md-4 col-sm-6 col-xs-12">
							<div class="my-index-card">
								<a href="messages.php">
									<img src="images/index_messages.jpg" alt="Your In App Messages" class="img-responsive">
									<div class="my-index-card-inner my-index-card-messages">
										In App Messaging
										<div class="my-index-card-icon-wrap">
											<img class="my-index-card-icon" src="images/index_icon_messages.png" alt="Messages Icon">
										</div>
									</div>
								</a>
							</div>
						</div-->
						
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script>
$( document ).ready(function() {      
    var isSmallScreen = window.matchMedia("only screen and (max-width: 760px)");

    if (isSmallScreen.matches) {
    	// email feature is not optimized for small screen - show warning before going to email feature
       $('#email-btn').on('click', function(event){
       		event.preventDefault();
       		if (confirm('The email campaigns feature is best utilized on a desktop or laptop, and is not optimized for mobile devices. Press "OK" to continue or "CANCEL" to stay put.')) {
       			window.open = ($(this).attr('href'));
       		}
       }); 
    }
});
</script>
<?php
include 'inc/myi_footer.php';
?>
