<?php
use App\MemberMerchant\Store\Consumer as Consumer;
include 'inc/myi_login_check.php'; //check if user is logged in
//include '../app/global.php';

require_once "../app/class.consumer.php";
$currentConsumer = new Consumer\storeConsumer($dbo, null, $_SESSION['user']['merchant']['ltm_id']);
$members=$currentConsumer->getLoadedRecords();
$member_count = $currentConsumer->getConsumerCount ($_SESSION['user']['merchant']['ltm_id']);	
$nav_icon_path = 'images/icon-back-office.svg';
$nav_title = 'Customers';

include 'inc/myi_header.php';
?>

<div class="container">
	<div class="row">
		<div class="col-xs-12">
			<div class="inner-page-wrap">
				<div class="btn-group " role="group" aria-label="..." >
				  <button type="button" class="mystats_nav_btn btn btn-default" onclick="window.location='/mystore/member.php'">Add Individual Customer</button>	
				  <button type="button" class="active mystats_nav_btn btn btn-default" onclick="window.location='/mystore/member_search.php'">Customer Search</button>
				</div>
			</div>
			<p style="text-align:center;">Tell your customers to text <?php $tmp = $thisMerchant->getCurrent('ltb_text_to_signup'); echo empty( $tmp )? '"LT' . $thisMerchant->getCurrent('ltb_id') . '"': '"'.$tmp.'"'; ?> to <a href="tel:<?php echo $twilioPhone; ?>"><?php echo $twilioPhone; ?></a> to signup today!</p>	
			<h2 class="member-header">Customer Search</h2>
			<h3><span class="label label-primary">Total Customer Count: <?php echo $member_count; ?></span></h3> 	
		</div>
		 <div id="member-table-div" class="col-md-12">
		  <table class="table mystats_table table-striped" id="members_table">
			<thead>
				<th>Edit</th>
				<th>First Name</th>
				<th>Last Name</th>
				<th>Email</th>
				<th>Phone</th>
				<th>Zip</th>
				<th>Date Joined</th>
			</thead>
			<?php
			foreach($members as $key => $value){
				echo '
					<tr id="'.$value['csm_id'].'">
						<td><a class="csm-edit-btn" href="/mystore/member.php?csm_id='.$value['csm_id'].'">view</a></td>
						<td><span class="abc64_f_name_r">'.$value['csm_first_name'].'</span></td>
						<td><span class="abc64_l_name_r">'.$value['csm_last_name'].'</span></td>
						<td><span class="ema64_email_r">'.$value['csm_email'].'</span></td>
						<td><span class="pho_cell_phone">'.$value['csm_cell_number'].'</span></td>
						<td><span class="wnu_zip_code_r">'.$value['csm_zip'].'</span></td>
						<td>'.$value['date_joined'].'</td>
					</tr>
				';
			}
			?>
		  </table>
		 </div> 
	</div>
</div>
<script>
var memberOBJ = {
	searchStr: '',
	table: {},
	currentAmount : <?php echo count($members);?>,
	tempFlag: true,
	runAjax : <?php echo ( count( $members ) < $member_count? "true" : "false" );?>
}
</script>
<script src="js/members_search.js"></script>
<?php
include 'inc/myi_footer.php';
?>