<?php
include 'inc/myi_login_check.php'; //check if user is logged in
//include '../app/global.php'; //global constants
require_once '../app/function.connect.php'; //global functions, contains include to function that connects to database
$nav_icon_path = 'images/icon-inapp-msg.svg';
$nav_title = 'In-App Messaging';

$hasPushMsgs = $thisMerchant->merchantHasProduct ('LT_PUSH_NOTIFICATIONS');

// --- QUERY MESSAGING HISTORY --- //
$sql = 'SELECT DISTINCT msg_id, msg_subject, msg_msg, msg_date FROM tbl_messages WHERE ltb_id = :ltb_id ORDER BY msg_date DESC LIMIT 100';
$qry = $dbo->prepare( $sql );
$qry->bindValue(':ltb_id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_INT);
$qry=execPDO($qry);
$qry = $qry->fetchAll( PDO::FETCH_ASSOC );
if(empty($qry)){
	$noHistory = true;
} else {
	foreach ($qry as $value) {
		$pushHistory[] .= '<tr><td>'.$value['msg_id'].'</td><td><strong>'.$value['msg_subject'].'</strong><br>'.$value['msg_msg'].'</td><td>'.date('M-d-Y h:i A', strtotime($value['msg_date'])).'</td></tr>';
	}
}

if($_SERVER['REQUEST_METHOD'] = $_POST && isset($_POST['txt_msg_content_r']) && isset($_POST['txl128_msg_subject_r']) && isset($_SESSION['user']['merchant']['ltb_id'])){
	if ($hasPushMsgs){
		//CHECK IF FIELDS WERE POSTED - redirect away if any missing
		$fields=array('txl128_msg_subject_r', 'txt_msg_content_r');
		//check the values of passed variables
		//include '../app/class.variables.php';
		$cv = new _variables(); // new instance
		foreach($fields as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop
		$_v=$cv->get_cleaned_variables();
		$errors=$cv->get_bad_variables();
		
		if (!count($errors)){
			$sql = 'INSERT INTO `tbl_messages` (msg_subject, msg_msg, msg_date, ltb_id) VALUES (:msg_subject, :msg_msg, Now(), :ltb_id)';
			$qry = $dbo->prepare($sql);
			$qry->bindValue(':msg_subject', $_v['msg_subject'], PDO::PARAM_STR);
			$qry->bindValue(':msg_msg', $_v['msg_content'], PDO::PARAM_STR);
			$qry->bindValue(':ltb_id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_INT);
			$qry=execPDO($qry);

			// minus one from remaining push msgs
			// $qry = $dbo->prepare("UPDATE lt_feature_cnt SET lfc_count=:remaining WHERE ltb_id=:ltb_id AND lpf_id = 15");
			// $qry->bindValue(':remaining', ($hasPushMsgs - 1), PDO::PARAM_INT);
			// $qry->bindValue(':ltb_id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_INT);
			// $qry = execPDO($qry);

			header('Location: messages.php?success=1');
			
			exit();
		} else {
			// the user has javascript turned off or bypassed the front-end validation in some way
			$error['msg_len'] = 'Your message is either empty or over the character limit. For best results, use a JavaScript enabled browser.';
		} 
	} else {
			$error['remaining_msgs'] = 'Your plan does not include push messaging.';
	}
}

include 'inc/myi_header.php';
?>

<style>
div#msg_character_count, div#subj_character_count {
	margin: 5px 0 10px;
	font-size: 11px;
}
#alert{
	text-align: center;
	position: fixed;
	top: 25%;
	z-index: 10;
	width: 50%;
	left: 25%;
	right: 50%;
	display: none;
	-webkit-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
	-moz-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
	box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
}
#msg_form {
	margin-bottom: 25px;
}
#msg_subject, #msg_content {
	height: 100px;
}
</style>

<div class='container'>
	<div class="inner-page-wrap">
		<div class="btn-group " role="group" aria-label="..." >
		  <button type="button" class="active mystats_nav_btn btn btn-default" onclick="window.location='messages.php'">In App Messages</button>	
		  <button type="button" class="mystats_nav_btn btn btn-default" onclick="window.location='text_msg.php'">Text Messages</button>	
		  <a type="button" class="mystats_nav_btn btn btn-default" href="emails.php" target="_blank">Email Campaigns</a>
		</div>
	</div>
	<div id="alert" class="alert alert-success" role="alert"></div>
	<?php 
		if (is_Array($error)) { 
			echo "<div id='push_errors' class='alert alert-danger'><span class='glyphicon glyphicon-exclamation-sign'></span> <strong>Please check the error messages below:</strong><ul>"; 
			foreach($error as $key => $value) { 
				$error_msg .= '<li>' . $value . '</li>'; 
			} 
			echo $error_msg . "</ul></div>"; 
		} 

if($hasPushMsgs){ ?>
	<div class='row table-body'>
		<div class='col-sm-4 left-side'>
			<div class="side-header-wrap">
				<div class="side-header-top">Message Contents</div>
				<div class="side-header-bottom2"></div>
			</div>
			<br><br>
			<form method='POST' id='msg_form'>
				<label for='msg_subject'>Message subject:</label>
				<textarea name='txl128_msg_subject_r' id='msg_subject' maxlength='128' class='form-control'><?php echo $_POST['txl128_msg_subject_r']; ?></textarea>
				<div id='subj_character_count'></div>
				<br><br>
				<label for='msg_content'>Message body:</label>
				<textarea name='txt_msg_content_r' id='msg_content' maxlength='255' class='form-control'><?php echo $_POST['txt_msg_content_r']; ?></textarea>
				<div id='msg_character_count'></div>
				<br><br>
				<input type='submit' value='Send Message' id='msg_submit' class='form-control btn btn-success'>
			</form>
			<?php //echo 'You can send up to '.number_format($hasPushMsgs).' push messages this billing period'; ?>
		</div>
		<div class='col-sm-8 right-side'>
			<table id='msg_history' class='table table-striped'>
				<thead>
					<tr>
						<th>ID</th>
						<th>Message</th>
						<th>Date</th>
					</tr>
				</thead>
				<tbody>
					<?php if ($noHistory == false) { foreach ($pushHistory as $pushes){ echo $pushes; } } ?>
				</tbody>
			</table>
		</div>
	</div><!--end .row-->
	
<?php } else {
	echo '<h2>Upgrade your plan to use this feature.</h2>';
} ?>
</div><!--end .container-->

<script>
	$(document).ready(function(){
		// access get variables with javascript
		var $_GET = <?php echo json_encode($_GET); ?>;

		function characterCountdown() {
			// 128 character max length - subject
			var subj_remaining = 128 - $.trim($('#msg_subject').val()).length;
			$('#subj_character_count').html(subj_remaining + ' characters remaining.');
			if (subj_remaining < 31) {
				$('#subj_character_count').css('color', 'red');
			} else {
				$('#subj_character_count').css('color', 'inherit');
			}

			// 255 character max length - message
			var msg_remaining = 255 - $.trim($('#msg_content').val()).length;
			$('#msg_character_count').html(msg_remaining + ' characters remaining.');
			if (msg_remaining < 61) {
				$('#msg_character_count').css('color', 'red');
			} else {
				$('#msg_character_count').css('color', 'inherit');
			}
		}

		// initialize character countdown
		characterCountdown();

		// countdown on change & keyup
		$('#msg_content, #msg_subject').on('change keyup', function(){
			characterCountdown();
		});

		// front end form validation && duplicate entry prevention
		$('#msg_form').submit(function(e){
			$('#msg_submit').attr("disabled", true).val('Sending Message...');
			var msgContent = $.trim($('#msg_content').val());
			var msgSubject = $.trim($('#msg_subject').val());
			if (msgContent != '' && msgContent.length <= 255 && msgSubject !='' && msgSubject.length <= 128){
				$('#msg_form').submit();
			} else {
				e.preventDefault();
				if (msgSubject =='' || msgSubject.length > 128){
					alert('Error: Message subject cannot be empty & must be under 128 characters long.');
					$('#msg_submit').attr("disabled", false).val('Send Message');
				} else if (msgContent == '' || msgContent.length > 255) {
					alert('Error: Message contents cannot be empty & must be under 255 characters long.');
					$('#msg_submit').attr("disabled", false).val('Send Message');
				}
			}
		});

		// function for showing alert
		function showAlert (alert_text) {
			$('#alert').html(alert_text);
			$('#alert').show();
	        setTimeout(function() {
			    $('#alert').fadeOut('slow');
			}, 1800); 
		}
		
		// show success alert
		if ($_GET['success'] == 1) {
			showAlert('<span class="glyphicon glyphicon-thumbs-up"></span> Success! Message sent.');
		}

		$('#msg_history').dataTable({
			"columns": [
					null,
					{ "orderable": false, "width":"550px"},
					null
					],
			"order": [[ 0, 'desc' ]],
			"dom": '<"#statsTableWrap"l<"#memberTableTitle">f><t><ip>'
		});
		$('#memberTableTitle').append("<div class='mystats_subhead'>Notification History</div>");
	});
</script>
<?php
include 'inc/myi_footer.php';
?>