<?php
//include '../app/global.php'; //global constants
include 'inc/myi_login_check.php'; // check if user is logged in
require '../app/class.cakemail.php';

function update_MailAmount($_ltmid, $_emailamount){ 
	//updating cakemail email limit	        
	$dbo = connect();
	$CakeAPI = new CakeMail( '828108c6dc7cafe6bac1a669aefe006b' );
	$_found_Flag = $CakeAPI->get_Account( $_Result, $_ltmid, $dbo );
	if ( $_found_Flag && isset( $_Result['cml_client_id'] ) && !empty( $_Result['cml_client_id'] ) ) {
		switch ( _env()['env_name'] ) {
		 case 'LIVE':
		  $_Parent=array('site'=>'com', 'client_id'=>283002, 'client_key'=>'584e5332424e6fb9d90cc4429d77f061', 'user_key'=>'bd27330e079bc35b9af4991e2877d62d', 'user_id'=>320259, 'email'=>'cakemail@localthanks.com', 'password'=>'prod');
		 break; 
		 case 'QA':
		  $_Parent=array('site'=>'org', 'client_id'=>282999, 'client_key'=>'f2a34b4247aac1d62600ea66cf0b7991', 'user_key'=>'d0c315537ba67b9b08a2b0aa422a643a', 'user_id'=>320257, 'email'=>'cakemail@localthanks.org', 'password'=>'qa');
		 break;
		 default:
		  $_Parent=array('site'=>'net', 'client_id'=>282842, 'client_key'=>'5acd8e77e331578797583e8578c54e70', 'user_key'=>'71fc105a95c7a2ee12036088f5b91c72', 'user_id'=>520033, 'email'=>'cakemail@localthanks.net',  'password'=>'dev');
		}
		$_Params=array( 'user_key'=>$_Parent['user_key'], 'client_id'=>$_Result['cml_client_id'], 'month_limit' => $_emailamount );
		try {		   
		   $CakeAPI->call_API( 'Client_SetInfo', $_Params, true );
		} 
		catch (Exception $e){
		   //do nothing
		}
	}
}

function insertPlanFeatures($ltb_id, $lpf_id, $mfc_count, $dbo){
	$qry = $dbo->prepare( "INSERT INTO `lt_feature_cnt` (lfc_count, lpf_id, ltb_id) VALUES (:count, :lpf_id, :ltb_id)" );
	$qry->bindValue(':ltb_id', $ltb_id, PDO::PARAM_INT);
	$qry->bindValue(':lpf_id', $lpf_id, PDO::PARAM_INT);
	$qry->bindValue(':count', $mfc_count, PDO::PARAM_INT);
	$qry = execPDO($qry);    
}

function updatePlanFeatures($ltb_id, $lpf_id, $mfc_count, $dbo){
	$qry = $dbo->prepare("UPDATE `lt_feature_cnt` SET lfc_count=:count WHERE ltb_id=:ltb_id AND lpf_id=:lpf_id LIMIT 1");
	$qry->bindValue(':ltb_id', $ltb_id, PDO::PARAM_INT);
	$qry->bindValue(':lpf_id', $lpf_id, PDO::PARAM_INT);
	$qry->bindValue(':count', $mfc_count, PDO::PARAM_INT);
	$qry = execPDO($qry);    
}

$nav_icon_path = 'images/icon-my-business.svg';
$nav_title = 'Upgrade Plan';

// set variables

$state = '';

$errors = array();

$success = '';

// get current plan

$sql = 'SELECT LTB.ltb_datecreated, LMP.lmp_id, LMP.lmp_name, LMP.lmp_price, LMP.lmp_fee, LMP.lmp_billing_delay, LMP.lmp_custom_terms, LMP.lmp_custom_breakdown, LMP.pty_id

FROM `lt_member_merchants` AS LTB 

INNER JOIN `lt_merchant_plans` AS LMP ON LTB.lmp_id=LMP.lmp_id 

WHERE LTB.ltb_id =:id LIMIT 1';

$qry = $dbo->prepare( $sql );

$qry->bindValue( ':id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_INT );

$qry=execPDO($qry);

$qry = $qry->fetchAll(PDO::FETCH_ASSOC);

if( empty( $qry ) ) {

	$my_plan = array();

} else {

	$my_plan = $qry[0];

}

//echo '<hr>';

// check if there is an active subscription

$sql = "SELECT BILL.bill_name, BILL.bill_orderid, BILL.lmp_id, BILL.bill_date, BILL.bill_cyclestart, BILL.bill_cycleend, BILL.bill_active 

FROM lt_merchant_billing BILL WHERE BILL.ltm_id = :ltm_id AND BILL.bill_active = 1 ORDER BY BILL.bill_date DESC LIMIT 1";

$qry = $dbo->prepare( $sql );

$qry->bindValue(':ltm_id', $_SESSION['user']['merchant']['ltm_id'], PDO::PARAM_INT);

$qry = execPDO($qry); 

$qry = $qry->fetchAll(PDO::FETCH_ASSOC);

if(empty($qry)){

	$my_bill = array();

} else {

	$my_bill = $qry[0];

	//var_dump($my_bill);

}

function getPlans($res_id, $pty_id, $dbo){
  $sql = 'SELECT LMP.lmp_id, LMP.lmp_name, LMP.lmp_admin_name, LMP.pty_id, LMP.lmp_price, LMP.lmp_fee, LMP.lmp_billing_delay,
  LMP.lmp_description, LMP.lmp_custom_terms, LMP.lmp_custom_breakdown, LMP.pty_id, LPF.lpf_feature, LPF.lpf_id, MFC.mfc_count
  FROM lt_merchant_plans LMP 
  INNER JOIN lt_plans2reseller P2R ON LMP.lmp_id = P2R.lmp_id
  INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id 
  LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id
  WHERE P2R.res_id = :res_id AND LMP.pty_id = :pty_id AND LMP.lmp_active = 1 ORDER BY LMP.lmp_price DESC';
  $qry = $dbo->prepare( $sql );
  $qry->bindValue(':res_id', $res_id, PDO::PARAM_INT);
    $qry->bindValue(':pty_id', $pty_id, PDO::PARAM_INT);
  $qry->execute();
  $qry = $qry->fetchAll(PDO::FETCH_ASSOC);
  if(empty($qry)){
    // set array to avoid errors
    $results = array();
  } 
  else {
    foreach ($qry as $k => $v) {
      if (!$results[$v['lmp_id']]){
        $results[$v['lmp_id']] = array(
          'lmp_id'                => $v['lmp_id'],
          'pty_id'        		  => $v['pty_id'],
          'lmp_name'              => $v['lmp_name'],
          'lmp_price'             => $v['lmp_price'],
          'lmp_fee'               => $v['lmp_fee'],
          'lmp_billing_delay'     => $v['lmp_billing_delay'],
          'lmp_description'       => $v['lmp_description'],
          'lmp_custom_terms'      => $v['lmp_custom_terms'],
          'lmp_custom_breakdown'  => $v['lmp_custom_breakdown'],
          'lmp_features'          => array(array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']))
        );
        if ($v['lmp_price'] == 0 && $v['pty_id'] > 1) {
          $results[$v['lmp_id']]['lmp_no_price'] = 1;
        }
      } 
      else {
        $next_feature = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
        array_push($results[$v['lmp_id']]['lmp_features'], $next_feature);
      }
    }
  }
  return $results;
}

$self_service = getPlans($_SESSION['user']['merchant']['res_id'], 3, $dbo); // 3 = self service
$full_service = getPlans($_SESSION['user']['merchant']['res_id'], 4, $dbo); // 4 = full service

// check $_POST
if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ep_plan_id']) && is_numeric($_POST['ep_plan_id']) && isset($_POST['ccnum'])){

	// check if the plan they chose is the same one they are subscribed to

	($_POST['ep_plan_id'] === $my_plan['lmp_id'] ? array_push($errors, 'You\'re already subscribed to the plan you chose.'):'');



	if (!count($errors)){

		// get selected plan details / confirm its a valid input

		$sql = '
		SELECT DISTINCT
		LMP.lmp_id, 
		LMP.lmp_name, 
		LMP.lmp_admin_name, 
		LMP.pty_id, 
		LMP.lmp_price, 
		LMP.lmp_fee, 
		LMP.lmp_billing_delay,
		LMP.lmp_description, 
		LMP.lmp_custom_terms, 
		LMP.lmp_custom_breakdown, 
		LMP.pty_id, 
		LPF.lpf_feature, 
		LPF.lpf_id, 
		MFC.mfc_count
		
		  FROM (	
			SELECT LMP1.*
			FROM lt_merchant_plans LMP1
			INNER JOIN lt_plans2reseller P2R ON LMP1.lmp_id = P2R.lmp_id
			WHERE P2R.res_id = :res_id
		  ) LMP 
		  
		  INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id 
		  LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id
		  WHERE LMP.lmp_id = :lmp_id AND LMP.lmp_active = 1 
		  ORDER BY LMP.lmp_price DESC';

		$qry = $dbo->prepare($sql);

		$qry->bindValue(':lmp_id', $_POST['ep_plan_id'], PDO::PARAM_INT);

		$qry->bindValue(':res_id', $_SESSION['user']['merchant']['res_id'], PDO::PARAM_INT);

		$qry = execPDO($qry);

		$qry = $qry->fetchAll(PDO::FETCH_ASSOC);

		if($qry){
			foreach ($qry as $k => $v) {
		      if (!$results){
		        $results = array(
		          'lmp_id'                => $v['lmp_id'],
		          'pty_id'        		  => $v['pty_id'],
		          'lmp_name'              => $v['lmp_name'],
		          'lmp_price'             => $v['lmp_price'],
		          'lmp_fee'               => $v['lmp_fee'],
		          'lmp_billing_delay'     => $v['lmp_billing_delay'],
		          'lmp_description'       => $v['lmp_description'],
		          'lmp_custom_terms'      => $v['lmp_custom_terms'],
		          'lmp_custom_breakdown'  => $v['lmp_custom_breakdown']
		        );				
		      	$results['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
		      } 
		      else {
		        $results['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
		      }
		    }
			$selected_plan = $results;
			
		} else {

			// user edited the input value to a non-valid entry

			array_push($errors, 'The plan you chose doesn\'t exist.');

		}

		if (!count($errors)){

			// processpayment function

 			require $_SERVER["DOCUMENT_ROOT"].'/app/function.processpayment.php';

			// set credit card payment variables

			$uri = array(

				'action' => 'ns_quicksale_cc',

				'ccname' => $_POST['ccname'],

				'ccnum'  => $_POST['ccnum'],

				'cvv2'   => $_POST['cvv2'],

				'expmon' => $_POST['expmon'],

				'expyear' => $_POST['expyear'],

				'recur_create ' => 1,

				'recur_billingmax' => -1,

				'recur_billingcycle' => 2,//monthly

				'ci_billaddr1' => $_POST['ci_billaddr1'],

				'ci_billcity' => $_POST['ci_billcity'],

				'ci_billzip' => $_POST['ci_billzip'],

				'ci_email' => $_POST['ci_email']

			);

			if ((intval($my_plan['pty_id']) === 1 && intval($selected_plan['pty_id']) === 3) || (intval($my_plan['pty_id']) === 1 && intval($selected_plan['pty_id']) === 4)){

				// normal checkout, the user is going from a free plan to a paid plan

				if(!empty( $_POST['ci_billaddr2'])){ $uri['ci_billaddr2'] = $_POST['ci_billaddr2']; }

				$uri['ci_companyname'] = $_SESSION["user"]["merchant"]["ltm_company_name"];

				$uri['recur_amount'] = floatval($selected_plan['lmp_price']) * 100; // amounts are passed in cents, so we take the price and multiply by 100



				// continue setting payment variables

				if (intval($selected_plan['lmp_billing_delay']) === 0){

					// monthly billing is *not* delayed, charge setup + first month's fee, then begin recurring payments 1 month from today.

					$uri['amount'] = (floatval($selected_plan['lmp_price']) + floatval($selected_plan['lmp_fee'])) * 100; // amounts are passed in cents, so we take the price + fee and multiply by 100

					$startTime = strtotime('now');

					$endTime   = strtotime('now +1 month');

					$timeDiff  = abs($endTime - $startTime);

					$delayDays = $timeDiff/86400; // 86400 seconds in one day

					$startCycle = date('Y-m-d',$endTime);

					$uri['recur_start'] = intval($delayDays);

				} else {

					// monthly billing is delayed -- only charge setup fee

					$startTime = strtotime('now');

					$endTime   = strtotime('now +'.intval($selected_plan['lmp_billing_delay']).' months');

					$timeDiff  = abs($endTime - $startTime);

					$delayDays = $timeDiff/86400; // 86400 seconds in one day

					$startCycle = date('Y-m-d',$endTime);

					$uri['recur_start'] = intval($delayDays);

					// if the monthly bill is delayed && the setup fee is 0, we have to charge a minimum of 1 cent.

					$uri['amount'] = (floatval($selected_plan['lmp_fee']) * 100 == 0 ? 0.01 : floatval($selected_plan['lmp_fee']) * 100); // amounts are passed in cents, so we take the fee and multiply by 100

				}

				// process payment

				$thisPay =  _appProcessPayment( $uri );

				// check payment status

				if( $thisPay['status'] == "Declined" ) {

					$reason = explode( ':', str_replace('..', '', $thisPay['reason']) );

					// show errors

					array_push($errors, 'Transaction Declined: '. $reason[2]);

				} elseif( $thisPay['status'] == "Accepted" ){
					
					//update session so the user doesn't have to re-login to use their upgrade features

					$_SESSION['user']['merchant']['plan'] = $selected_plan;
					
				    //clear ccnum for security purposes

				    $_POST['ccnum'] = '';

				    //update membership level && plan ID

				    $qry = $dbo->prepare( "UPDATE `lt_member_merchants` SET pty_id=:pty_id, lmp_id=:lmp_id WHERE ltb_id=:id LIMIT 1" );
				    $qry->bindValue(':id', $_SESSION["user"]["merchant"]["ltb_id"], PDO::PARAM_INT);
				    $qry->bindValue(':lmp_id', $selected_plan['lmp_id'], PDO::PARAM_INT);
				    $qry->bindValue(':pty_id', $selected_plan['pty_id'], PDO::PARAM_INT);
				    $qry = execPDO($qry); 

				    // update merchant feature counts
				    foreach ($selected_plan['lmp_features'] as $k=>$v){
				        switch ($v['lpf_id']){
				          case 9:  // catalog points
				          case 14: // sms texts
				          case 15: // push notifications
								insertPlanFeatures($_SESSION['user']['merchant']['ltb_id'], $v['lpf_id'], $v['mfc_count'], $dbo);              
				          break;
				          case 13: // monthly emails
				          		insertPlanFeatures($_SESSION['user']['merchant']['ltb_id'], $v['lpf_id'], $v['mfc_count'], $dbo);
				          		update_MailAmount($_SESSION["user"]["merchant"]["ltm_id"], $v['mfc_count']);
				          break;
				          default:
				          break;
				        }
				    }

				    // insert lt_merchant_billing table

				    $dbo = connect();

				    $qry = $dbo->prepare( "INSERT INTO `lt_merchant_billing` (ltm_id, lmp_id, bill_name, bill_address1, bill_address2, bill_state, bill_city, bill_zip, bill_accountnumber, bill_orderid, bill_cyclestart, bill_fee, bill_price) VALUES (:id,:lmp_id,:bill_name,:bill_address1,:bill_address2,:bill_state,:bill_city,:bill_zip,:bill_accountnumber,:orderid, :cyclestart, :fee, :price)" );

				    $qry->bindValue(':id', $_SESSION["user"]["merchant"]["ltm_id"], PDO::PARAM_STR);

				    $qry->bindValue(':lmp_id', $selected_plan['lmp_id'], PDO::PARAM_INT);

				    $qry->bindValue(':bill_name', $_POST["ccname"], PDO::PARAM_STR);

				    $qry->bindValue(':bill_address1', $_POST["ci_billaddr1"], PDO::PARAM_STR);

				    $qry->bindValue(':bill_address2', $_POST["ci_billaddr2"], PDO::PARAM_STR);

				    $qry->bindValue(':bill_state', $_POST["ci_billstate"], PDO::PARAM_STR);

				    $qry->bindValue(':bill_city', $_POST["ci_billcity"], PDO::PARAM_STR);

				    $qry->bindValue(':bill_zip', $_POST["ci_billzip"], PDO::PARAM_STR);

				    $qry->bindValue(':bill_accountnumber', $thisPay["accountnumber"], PDO::PARAM_STR);

				    $qry->bindValue(':orderid', $thisPay['orderid'], PDO::PARAM_STR);

				    $qry->bindValue(':cyclestart', $startCycle, PDO::PARAM_STR);

					$qry->bindValue(':fee', $selected_plan['lmp_fee'], PDO::PARAM_STR);

					$qry->bindValue(':price', $selected_plan['lmp_price'], PDO::PARAM_STR);

				    $qry = execPDO($qry);

				    header('Location: /mystore');

				} else {

					array_push($errors, 'Your transaction could not be completed at this time. Please call '.CSR_PHONE_NUMBER);

				}



			} else if (intval($my_plan['pty_id']) > 1){

				// user is going from paid plan to paid plan

					// start new recurring sub && charge the difference between fees

					if(!empty( $_POST['ci_billaddr2'])){ $uri['ci_billaddr2'] = $_POST['ci_billaddr2']; }

					$uri['ci_companyname'] = $_SESSION["user"]["merchant"]["ltm_company_name"];

					$uri['recur_amount'] = floatval($selected_plan['lmp_price']) * 100; // amounts are passed in cents, so we take the price and multiply by 100



					// continue setting payment variables

					$uri['amount'] = ((floatval($selected_plan['lmp_price']) - floatval($my_plan['lmp_price'])) + (floatval($selected_plan['lmp_fee']) - floatval($my_plan['lmp_fee']))) * 100; // amounts are passed in cents, so we take the difference in price and multiply by 100





					// calculate current bills end date and new bills start date

					$my_bill_date  = explode('-',$my_bill['bill_cyclestart']);

					$my_today_date = explode('-', date('Y-m-d', strtotime('today')));

					$new_bill_date = '';



					if ($my_today_date[2] > $my_bill_date[2]){

						// next month

						$new_bill_date = explode('-', date('Y-m-d', strtotime('next month')));

						$new_bill_date[2] = $my_bill_date[2];

						$new_bill_date = implode('-', $new_bill_date);

						//echo $new_bill_date;

					} else {

						// this month

						$new_bill_date = explode('-', date('Y-m-d', strtotime('today')));

						$new_bill_date[2] = $my_bill_date[2];

						$new_bill_date = implode('-', $new_bill_date);

						//echo $new_bill_date;

					}



					$startTime = strtotime('now');

					$endTime   = strtotime($new_bill_date);

					$timeDiff  = abs($endTime - $startTime);

					$delayDays = $timeDiff/86400; // 86400 seconds in one day

					$startCycle = date('Y-m-d',$endTime);

					$uri['recur_start'] = intval($delayDays);

					

					// process payment

					$thisPay =  _appProcessPayment( $uri );

					// check payment status

					if( $thisPay['status'] == "Declined" ) {

						$reason = explode( ':', str_replace('..', '', $thisPay['reason']) );

						// show errors

						array_push($errors, 'Transaction Declined: '. $reason[2]);

					} elseif( $thisPay['status'] == "Accepted" ){  



						// update session so the user doesn't have to re-login to use their upgrade features

						$_SESSION['user']['merchant']['plan'] = $selected_plan;

	    

					    // clear ccnum for security purposes

					    $_POST['ccnum'] = '';



					    // set current bill to inactive && add end date

					    $dbo = connect();

					    $qry = $dbo->prepare( "UPDATE `lt_merchant_billing` SET bill_active=0, bill_cycleend=:new_bill_date WHERE bill_orderid=:id ORDER BY bill_date DESC LIMIT 1" );

					    $qry->bindValue(':new_bill_date', $new_bill_date, PDO::PARAM_STR);

					    $qry->bindValue(':id', $my_bill['bill_orderid'], PDO::PARAM_INT);

					    $qry = execPDO($qry); 



						// start new bill, active by default

					    $dbo = connect();

					    $qry = $dbo->prepare( "INSERT INTO `lt_merchant_billing` (ltm_id, lmp_id, bill_name, bill_address1, bill_address2, bill_state, bill_city, bill_zip, bill_accountnumber, bill_orderid, bill_cyclestart, bill_fee, bill_price) VALUES (:id,:lmp_id,:bill_name,:bill_address1,:bill_address2,:bill_state,:bill_city,:bill_zip,:bill_accountnumber,:orderid, :cyclestart, :fee, :price)" );

					    $qry->bindValue(':id', $_SESSION["user"]["merchant"]["ltm_id"], PDO::PARAM_STR);

					    $qry->bindValue(':lmp_id', $selected_plan['lmp_id'], PDO::PARAM_INT);

						$qry->bindValue(':price', $selected_plan['lmp_price'], PDO::PARAM_INT);

						$qry->bindValue(':fee', $selected_plan['lmp_fee'], PDO::PARAM_INT);

					    $qry->bindValue(':bill_name', $_POST["ccname"], PDO::PARAM_STR);

					    $qry->bindValue(':bill_address1', $_POST["ci_billaddr1"], PDO::PARAM_STR);

					    $qry->bindValue(':bill_address2', $_POST["ci_billaddr2"], PDO::PARAM_STR);

					    $qry->bindValue(':bill_state', $_POST["ci_billstate"], PDO::PARAM_STR);

					    $qry->bindValue(':bill_city', $_POST["ci_billcity"], PDO::PARAM_STR);

					    $qry->bindValue(':bill_zip', $_POST["ci_billzip"], PDO::PARAM_STR);

					    $qry->bindValue(':bill_accountnumber', $thisPay["accountnumber"], PDO::PARAM_STR);

					    $qry->bindValue(':orderid', $thisPay['orderid'], PDO::PARAM_STR);

					    $qry->bindValue(':cyclestart', $startCycle, PDO::PARAM_STR);

					    $qry = execPDO($qry);  

					    					    

					    // update membership level && plan ID
					    
					    $dbo = connect();

					    $qry = $dbo->prepare( "UPDATE `lt_member_merchants` SET pty_id=:pty_id, lmp_id=:lmp_id WHERE ltb_id=:id LIMIT 1" );

					    $qry->bindValue(':id', $_SESSION["user"]["merchant"]["ltb_id"], PDO::PARAM_INT);

					    $qry->bindValue(':lmp_id', $selected_plan['lmp_id'], PDO::PARAM_INT);

					    $qry->bindValue(':pty_id', $selected_plan['pty_id'], PDO::PARAM_INT);

					    $qry = execPDO($qry);  

					    // update merchant feature counts
					    foreach ($selected_plan['lmp_features'] as $k=>$v){
					        switch ($v['lpf_id']){
					          case 9:  // catalog points
					          case 14: // sms texts
					          case 15: // push notifications
									updatePlanFeatures($_SESSION['user']['merchant']['ltb_id'], $v['lpf_id'], $v['mfc_count'], $dbo);              
					          break;
					          case 13: // monthly emails
					          		updatePlanFeatures($_SESSION['user']['merchant']['ltb_id'], $v['lpf_id'], $v['mfc_count'], $dbo);
					          		update_MailAmount($_SESSION["user"]["merchant"]["ltm_id"], $v['mfc_count']);
					          break;
					          default:
					          break;
					        }
					    }


						// cancel previous recurring sub
					    if ($my_bill['bill_orderid']){
							$uri = array(

								'action' => 'recur_cancel',

								'orderkeyid' => $my_bill['bill_orderid'],

								'canceltype' => 0 // immediate cancelation

							);

							// process cancelation

							$thisPay =  _appProcessPayment( $uri );

							// check cancel status

							if($thisPay['status'] == "Declined") {

								$reason = explode( ':', str_replace('..', '', $thisPay['reason']) );

								// show errors

								array_push($errors, 'There was a problem canceling your current subscription: "'. $reason[2] .'" please call '.CSR_PHONE_NUMBER);

							} elseif ( $thisPay['status'] == "Accepted" ){  

						    header('Location: /mystore');
						    exit();

						} else {
							array_push($errors, 'Your transaction could not be completed at this time. Please call '.CSR_PHONE_NUMBER);
						}	
						header('Location: /mystore');
						exit();
					}				
				}
			}
		}
	}
}

include 'inc/myi_header.php';

?>

<style>

.form25 {

  display: inline-block;

  width: 24.5%;

  vertical-align: top;

}

.form33{

  display:inline-block;

  width: 32.8888888%;

  vertical-align: top;

}

.form50 {

  display: inline-block;

  width: 49.6666666%;

  vertical-align: top;

}

select.form-control, input.form-control, div#s2id_keyword-selection, textarea.form-control  {

  margin-bottom: 15px;

}

</style>

<div class='container'>

	<div class="col-sm-12">

		<div class="row">

			<div class="row">

				<div class="col-sm-10 col-xs-12">

				<?php 

				if (count($errors)) { 

					echo "<div class='alert alert-danger alert-dismissable'>

					<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>

				      &times;

				    </button>

	   				<span class='glyphicon glyphicon-exclamation-sign'></span> <strong>Please check the error messages below:</strong><ul>"; 

					foreach($errors as $key => $value) { 

						$error_msg .= '<li>' . $value . '</li>'; 

					} 

					echo $error_msg . "</ul></div>"; 

				}

				if ($_GET['success']) { 

					echo "<div class='alert alert-success alert-dismissable'>

					<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>

				      &times;

				    </button>

	   				<span class='glyphicon glyphicon-thumbs-up'></span> <strong>Success! You are now subscribed to ".$_GET["lmp_name"].".</strong>"; 

	   				if ($_GET['downgrade']){

	   					echo "<br><strong>You have ".$my_plan["lmp_name"]." access until ".date('m-d-Y', strtotime($my_bill["bill_cycleend"])).".</strong>"; 

	   				}

					echo "</div>"; 

				} 

				if ($_GET['upgrade']) { 

					echo "

					<div class='alert alert-info'>

	   				<span class='glyphicon glyphicon-comment'></span> <strong>Your current plan does not support that feature. In order to create promotions or market to new and existing customers, please upgrade your listing by selecting one of the Plan Options below.</strong>

	   				</div>";

				} 

				if ($state === '' && !isset($_GET['success'])){			?>



					<h2>Plan Options</h2>

					<form method="post" id="cc-input">

						<?php

						if(count($full_service)){

							foreach($full_service as $key => $value){

							  $plan_options = ''; 

							  $plan_options .= '<table><tr>';

							  $plan_options .= '<td style="vertical-align:top;padding-right:4px;">';

							  $plan_options .= '<input type="radio" name="ep_plan_id" data-price="'.$value['lmp_price'].'" data-fee="'.$value['lmp_fee'].'" ';

							  if ($value['lmp_custom_breakdown'] === null) { 

							    $plan_options .= 'data-breakdown="default" ';

							  } else {

							    $plan_options .= 'data-breakdown="custom" '; 

							    $plan_options .= 'data-breakdown-html="'.$value['lmp_custom_breakdown'].'" '; 

							  }

							  $plan_options .= 'value="'.$value['lmp_id'].'" ';

							  $plan_options .= 'id="pl_'.$value['lmp_id'].'" ';

							  $plan_options .= (intval($value['lmp_id']) === intval($my_plan['lmp_id']) ? ' checked="checked" ':'');

							  $plan_options .= '>';

							  $plan_options .= '</td> ';

							  $plan_options .= '<td><label for="pl_'.$value['lmp_id'].'">';

							  $plan_options .= $value['lmp_name'].':'.($my_plan['lmp_id']===$value['lmp_id']?' This is your current plan.':'').'</label><br>';

							  if ($value['lmp_custom_terms'] === null) {

							    $plan_options .= '$'.$value['lmp_price'].'/month '.(intval($my_plan['pty_id'])===1?'+ $'.$value['lmp_fee'].' one time setup fee. ':'');

							  } else {

							    $plan_options .= $value['lmp_custom_terms'];

							  }

							  $plan_options .= ($value['lmp_billing_delay'] > 0 ? '<br>$'.$value['lmp_price'].'/mo. billing will begin on '.date('F d, Y',strtotime('now +'.intval($value['lmp_billing_delay']).' months')):'');

							  $plan_options .= ($value['lmp_billing_delay'] > 0 && floatval($value['lmp_fee']) * 1 == 0 ? '<br>Your credit card will be charged $0.01 today for authentication purposes.':'');

							  $plan_options .= '</td>';

							  $plan_options .= '</tr></table><br>';

							  echo $plan_options;

							}

						}

						if(count($self_service) && intval($_SESSION['user']['merchant']['plan']['pty_id']) < 4){

							foreach($self_service as $key => $value){

								$plan_options = ''; 

								$plan_options .= '<table><tr>';

								$plan_options .= '<td style="vertical-align:top;padding-right:4px;">';

								$plan_options .= '<input type="radio" name="ep_plan_id" data-price="'.$value['lmp_price'].'" data-fee="'.$value['lmp_fee'].'" ';

								if ($value['lmp_custom_breakdown'] === null) { 

								$plan_options .= 'data-breakdown="default" ';

								} else {

								$plan_options .= 'data-breakdown="custom" '; 

								$plan_options .= 'data-breakdown-html="'.$value['lmp_custom_breakdown'].'" '; 

								}

								$plan_options .= 'value="'.$value['lmp_id'].'" ';

								$plan_options .= 'id="pl_'.$value['lmp_id'].'" ';

								$plan_options .= (intval($value['lmp_id']) === intval($my_plan['lmp_id']) ? ' checked="checked" ':'');

								$plan_options .= '>';

								$plan_options .= '</td> ';

								$plan_options .= '<td><label for="pl_'.$value['lmp_id'].'">';

							    $plan_options .= $value['lmp_name'].':'.($my_plan['lmp_id']===$value['lmp_id']?' This is your current plan.':'').'</label><br>';

								if ($value['lmp_custom_terms'] === null) {

								$plan_options .= '$'.$value['lmp_price'].'/month '.(intval($my_plan['pty_id'])===1?'+ $'.$value['lmp_fee'].' one time setup fee. ':'');

								} else {

								$plan_options .= $value['lmp_custom_terms'];

								}

								$plan_options .= ($value['lmp_billing_delay'] > 0 ? '<br>$'.$value['lmp_price'].'/mo. billing will begin on '.date('F d, Y',strtotime('now +'.intval($value['lmp_billing_delay']).' months')):'');

								$plan_options .= ($value['lmp_billing_delay'] > 0 && floatval($value['lmp_fee']) * 1 == 0 ? '<br>Your credit card will be charged $0.01 today for authentication purposes.':'');

								$plan_options .= '</td>';

								$plan_options .= '</tr></table><br>';

								echo $plan_options;

							}

						}



					    // loop through our category, country, states, and territories options.

					    $obj = json_decode( file_get_contents( ROOT_URL."/api/api.lt.json.options.php" ) );

					    $states = $territory = '';



					    foreach( $obj->options->state as $k => $v ) {

					      $state_sel = '';

					      if( isset( $_POST['ci_billstate'] ) ) $_POST['ci_billstate'] != $k ? $state_sel = '' : $state_sel = ' selected';

					      $states.= "<option value='{$k}'{$state_sel}>{$v}</option>";

					    } 

					    foreach( $obj->options->territory as $k => $v ) {

					      $state_sel = '';

					      if( isset( $_POST['ci_billstate'] ) ) $_POST['ci_billstate'] != $k ? $state_sel = '' : $state_sel = ' selected';

					      $territory.= "<option value='{$k}'{$state_sel}>{$v}</option>";

					    }



					    // Current year for credit card

					    $year = date( 'Y' );

					    $yopt = '';

					    for( $i = 0; $i <= 20; ++$i ) {

					      $yopt.= "<option value='{$year}'>{$year}</option>"; 

					      //increase year counter by 1    

					      ++$year;

					    }

					    $email = isset($_POST['ci_email']) ? $_POST['ci_email'] : $_SESSION['msp_signup']['ltb_email'];

						?>

							<h2>Billing Information</h2>

					        <label class="signupLabel" for="ci_email">Email Address</label>

					        <input type="text" class="form-control" id="ci_email" name="ci_email" value="<?php echo $email; ?>" placeholder="Email Address" required>



					        <label class="signupLabel" for="ccname">Name on Card</label>

					        <input type="text" class="form-control" id="ccname" name="ccname" value="<?php echo $_POST['ccname']; ?>" placeholder="Name on Card" required>

					        

					        <div class="form25">

					          <label class="signupLabel" for="ccnum">Credit Card Number</label>

					          <input type="text" class="form-control" id="ccnum" name="ccnum" value="<?php echo $_POST['ccnum']; ?>" placeholder="xxxx-xxxx-xxxx-xxxx" required>

					        </div>

					        <div class="form25">

					          <label for="expmon" class="signupLabel">Expiration Month</label>

					          <select name="expmon" class="form-control" id="expmon">

					            <option selected value=1>1</option>

					            <option value=2>2</option>

					            <option value=3>3</option>

					            <option value=4>4</option>

					            <option value=5>5</option>

					            <option value=6>6</option>

					            <option value=7>7</option>

					            <option value=8>8</option>

					            <option value=9>9</option>

					            <option value=10>10</option>

					            <option value=11>11</option>

					            <option value=12>12</option>

					          </select>

					        </div>

					        <div class="form25">

					          <label for="expyear" class="signupLabel">Expiration Year</label>

					          <select name="expyear" class="form-control" id="expyear">

					            <?php echo $yopt; ?>

					          </select>

					        </div>



					        <div class="form25">

					          <label for="cvv2" class="signupLabel">Security Code</label>

					          <input name="cvv2" type="text" class="form-control" id="cvv2" placeholder="xxx" value='<?php echo $_POST['cvv2']; ?>' required>

					        </div>



					        <label for="ci_billaddr1" class="signupLabel">Billing Address 1</label>

					        <input name="ci_billaddr1"  type="text" class="form-control" id="ci_billaddr1" placeholder="Address 1" value="<?php echo $_POST['ci_billaddr1']; ?>" required>



					        <label for="ci_billaddr2" class="signupLabel">Billing Address 2</label>

					        <input name="ci_billaddr2"  type="text" class="form-control" id="ci_billaddr2" placeholder="Address 2" value="<?php echo $_POST['ci_billaddr2']; ?>">



					        <div class="form33">

					          <label for="ci_billcity" class="signupLabel">Billing City</label>

					          <input name="ci_billcity" type="text" class="form-control" id="ci_billcity" placeholder="City" value="<?php echo $_POST["ci_billcity"]; ?>" required>

					        </div>



					        <div class="form33">

					          <label for="ci_billstate" class="signupLabel">Billing State</label>

					          <select class="form-control" id="ci_billstate" name="ci_billstate" required>

					            <option value="" disabled <?php if($state_sel === '') {echo 'selected';} ?>>Select State</option>

					            <optgroup label='States'><?php echo $states; ?></optgroup>

					            <optgroup label='U.S. Territories'><?php echo $territory; ?></optgroup>

					          </select>

					        </div>



					        <div class="form33">

					          <label for="ci_billzip" class="signupLabel">Billing Zip</label>

					          <input name="ci_billzip" type="text" class="form-control" id="ci_billzip" placeholder="Zipcode" value="<?php echo $_POST["ci_billzip"]; ?>" required>

					        </div>

					        <div id="purchase-total"></div>

							<input type="submit" class="btn btn-primary form-control input-lg" value="Upgrade Plan" id="make-purchase">

					</form>

				<?php } // end if $state === '' ?>

				<div><em>To end your service please call: <?php echo CSR_PHONE_NUMBER; ?></em></div>

				</div>

			</div>

		</div>

	</div>

</div>




<script>

$(document).ready(function () {
	
	function price_template (price, fee) {
        // format price
        var format = function(num){
            var str = num.toString().replace("$", ""), parts = false, output = [], i = 1, formatted = null;
            if(str.indexOf(".") > 0) {
                parts = str.split(".");
                str = parts[0];
            }
            str = str.split("").reverse();
            for(var j = 0, len = str.length; j < len; j++) {
                if(str[j] != ",") {
                    output.push(str[j]);
                    if(i%3 == 0 && j < (len - 1)) {
                        output.push(",");
                    }
                    i++;
                }
            }
            formatted = output.reverse().join("");
            return("$" + formatted + ((parts) ? "." + parts[1].substr(0, 2) : ""));
        };
        totalToday = (parseFloat(price - <?php echo floatval($my_plan['lmp_price']); ?>) + parseFloat(fee - <?php echo floatval($my_plan['lmp_fee']); ?>));
        totalToday = format(totalToday);
        f_price = format(price); 
        f_fee = format(fee);
        html = '<table>\
        <label class="signupLabel">Purchase Total:</label><table class="table table-bordered" style="background:#fff;">\
          <tr>\
            <td>Monthly Membership Fee:</td>\
            <td>'+f_price+'</td>\
          </tr>\
          <tr>\
            <td>One Time Setup Fee:</td>\
            <td>'+f_fee+'</td>\
          </tr>\
          <tr style="color:green;">\
            <td><strong>Total Purchase Today:</strong></td>\
            <td><strong>' + (price + fee == 0 ? '$0.01' : totalToday) + '</strong></td>\
          </tr>\
        </table>';
        $('#purchase-total').html(html);
	}

	$('input:radio[name=ep_plan_id]').on('click change', function(){
		if ($(this).is(':checked') && $(this).data('breakdown') === 'default') {
			price_template($(this).data('price'), $(this).data('fee'));
		} else if ($(this).is(':checked') && $(this).data('breakdown') === 'custom') {
			$('#purchase-total').html($(this).data('breakdown-html'));
		} 
	});

	$('#cc-input').submit(function(event){
		$('#make-purchase').prop('disabled', true).attr('value', 'Please Wait...'); 
	});
});
</script>
<?php include 'inc/myi_footer.php'; ?>