<?php
include 'inc/myi_login_check.php'; //check if user is logged in
//include '../app/global.php'; //global constants
$nav_icon_path = 'images/icon-promos.svg';
$nav_title = 'Edit Promotion';
//require_once '../app/function.get-subdir.php'; //function to get the image subdir of the merchant
use App\MyStore\MemberMerchant as MyStoreMerchant;

if (isset($_SESSION['user']['merchant']['ltb_id'])){
	require_once "app/class.mystore-member-merchant.php";
	//creating MyStoreMerchant object that will handle the promo update
	$promoFormMerchant = new MyStoreMerchant\MyStoreMemberMerchant($dbo, true, $_SESSION['user']['merchant']['ltb_id']);	
}

/*=================================================================================	
  ______ ____  _____  __  __    _____ _    _ ____  __  __ _____ _______ 
 |  ____/ __ \|  __ \|  \/  |  / ____| |  | |  _ \|  \/  |_   _|__   __|
 | |__ | |  | | |__) | \  / | | (___ | |  | | |_) | \  / | | |    | |   
 |  __|| |  | |  _  /| |\/| |  \___ \| |  | |  _ <| |\/| | | |    | |   
 | |   | |__| | | \ \| |  | |  ____) | |__| | |_) | |  | |_| |_   | |   
 |_|    \____/|_|  \_\_|  |_| |_____/ \____/|____/|_|  |_|_____|  |_|
===================================================================================*/
// var_dump($_FILES['uploaded_img']);
// $upload_max = ini_get('upload_max_filesize');
// var_dump($upload_max);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	if (isset($_FILES['uploaded_img']) && is_uploaded_file($_FILES['uploaded_img']['tmp_name'])) {
		$msg='';
		$validImageFileFlag = @exif_imagetype($_FILES['uploaded_img']['tmp_name']);
		if ($validImageFileFlag === false) {
			$msg = ' <span style="color:red;">Incorrect image file.</span>';//<script>alert("Please upload image smaller than 500KB")</script>
		}
		else{
			//check uploaded image && resize, crop, save, etc
			//include 'inc/function.promo-image-upload.php'; //image upload function that works either for logo or promo 		
			list( $orig_w, $orig_h ) = getimagesize( $_FILES['uploaded_img']['tmp_name'] );
			$valid = array('jpeg', 'jpg', 'png', 'gif'); // allowed extensions
			$sizes = array( 600 => 400, 120=>120);
			// if ($orig_w > 1201) {
			// 	$sizes = array(1200=>'auto')+$sizes;
			// }
			// var_dump($sizes);
			
			if ($orig_w < 600 || $orig_h < 400){
				$msg = ' <span style="color:red;">Image must be atleast 600px wide and 400px tall.</span>'; 
			}else{
				$ext = strtolower( pathinfo( $_FILES['uploaded_img']['name'], PATHINFO_EXTENSION ) ); // get file extension
				if( in_array( $ext, $valid ) ){
					$promoFormMerchant->promoImageResize($_FILES['uploaded_img'], $sizes); // resize image function 
				}else{
					$msg = ' <span style="color:red;">Unsupported or empty file.</span>';//<script>alert("Unsupported or empty file")</script>
				}
			}
		}
	}else if (isset($_FILES['uploaded_img']) && $_FILES['uploaded_img']['error'] > 0){
		$msg = ' <span style="color:red;">Image must be smaller than 2MB.</span>';//<script>alert("Please upload image smaller than 500KB")</script>
	}else{
	
	//CHECK IF FIELDS WERE POSTED - redirect away if any missing
	// echo '<pre>';
	// var_dump($_POST);
	// echo '</pre>';
	//still left wnu_ltp_id_r
	$errors = array();
	$promoDataRec = array(
		0 => array('Name'=>'ltp_image', 'Value'=> isset($_POST['img128_image_name']) && !empty($_POST['img128_image_name'])? $_POST['img128_image_name']:null, 'Type'=>'img128_ltp_image', 'PDO_Param'=>\PDO::PARAM_STR),
		1 => array('Name'=>'ltp_disclaimers', 'Value'=> isset($_POST['txt1000_disclaimers']) && !empty($_POST['txt1000_disclaimers'])? $_POST['txt1000_disclaimers']:null, 'Type'=>'txt1000_ltp_disclaimers', 'PDO_Param'=>\PDO::PARAM_STR),
		2 => array('Name'=>'ltp_headline', 'Value'=> isset($_POST['txl64_header_r']) && !empty($_POST['txl64_header_r'])? $_POST['txl64_header_r']:null, 'Type'=>'txl64_ltp_headline_r', 'PDO_Param'=>\PDO::PARAM_STR),
		3 => array('Name'=>'ltp_description', 'Value'=> isset($_POST['txt500_description_r']) && !empty($_POST['txt500_description_r'])? $_POST['txt500_description_r']:null, 'Type'=>'txt500_ltp_description_r', 'PDO_Param'=>\PDO::PARAM_STR),		
		4 => array('Name'=>'ltp_promo_type', 'Value'=> isset($_POST['wnu_lpt_id_r']) && !empty($_POST['wnu_lpt_id_r'])? $_POST['wnu_lpt_id_r']:null, 'Type'=>'wnu_ltp_promo_type_r', 'PDO_Param'=>\PDO::PARAM_INT),		
		
		5 => array('Name'=>'ltp_max_redemptions_global', 'Value'=> (isset($_POST['wnu_max_redemptions_global'])? $_POST['wnu_max_redemptions_global']: (isset($_POST['bit_redeem_switch']) && $_POST['bit_redeem_switch'] == 1? null: 0)), 'Type'=>'wnu_ltp_max_redemptions_global', 'PDO_Param'=>\PDO::PARAM_INT),
		
		6 => array('Name'=>'ltp_max_redemptions_user', 'Value'=> (isset($_POST['wnu_max_redemptions_user'])? $_POST['wnu_max_redemptions_user']: (isset($_POST['bit_redeem_switch']) && $_POST['bit_redeem_switch'] == 1? null: 0)), 'Type'=>'wnu_ltp_max_redemptions_user', 'PDO_Param'=>\PDO::PARAM_INT),
		7 => array('Name'=>'ltb_id', 'Value'=> $_SESSION['user']['merchant']['ltb_id'], 'Type'=>'wnu_ltb_id_r', 'PDO_Param'=>\PDO::PARAM_INT),
		
		8 => array('Name'=>'ltp_punchcard', 'Value'=> (isset($_POST['bit_punch_card']) && $_POST['bit_punch_card'] == 1? 1: 0), 'Type'=>'bit_ltp_punchcard', 'PDO_Param'=>\PDO::PARAM_INT),	

		9 => array('Name'=>'ltp_price', 'Value'=> $_POST['dec_promo_price'], 'Type'=>'dec_ltp_price', 'PDO_Param'=>\PDO::PARAM_STR),
	);	
	if($_POST['wnu_lpt_id_r']!=4 ){ 		
		array_push($promoDataRec, array('Name'=>'ltp_startdate', 'Value'=> isset($_POST['dat_startdate'])? $_POST['dat_startdate']: null, 'Type'=>'dat_ltp_startdate', 'PDO_Param'=>\PDO::PARAM_STR));
		array_push($promoDataRec, array('Name'=>'ltp_enddate', 'Value'=> isset($_POST['dat_enddate'])? $_POST['dat_enddate']: null, 'Type'=>'dat_ltp_enddate', 'PDO_Param'=>\PDO::PARAM_STR));		
	}
	if($_POST['wnu_lpt_id_r']==1 ){
		array_push($promoDataRec, array('Name'=>'ltp_promo_code', 'Value'=> isset($_POST['aon16_couponcode_r'])? $_POST['aon16_couponcode_r']: null, 'Type'=>'aon16_ltp_promo_code_r', 'PDO_Param'=>\PDO::PARAM_STR));
	}
	if($_POST['wnu_lpt_id_r']==5 ){
		if (!is_numeric($_POST['wnu_merchant_search_select']) || intval($_POST['wnu_merchant_search_select']) != $_POST['wnu_merchant_search_select'])
			array_push($errors,'Merchant not found.');
	}
	if($_POST['wnu_lpt_id_r']==3 && !isset($_POST['day_toggle'])){ 
		// loop through promotion days for end of day promotions
		$ltp_weekday  = null;
		if (isset($_POST['wnu1_promotion_days'])){
			$ltp_weekday  = '';
			foreach ($_POST['wnu1_promotion_days'] as $key => $value){
				$ltp_weekday .= $value;		
			}
			array_push($promoDataRec, array('Name'=>'ltp_weekday', 'Value'=> !empty($ltp_weekday)? $ltp_weekday: null, 'Type'=>'wnu_ltp_weekday', 'PDO_Param'=>\PDO::PARAM_STR));
			//unset($_v['promotion_days']);
		}	
	}
	if($_POST['wnu_lpt_id_r']==3 && !isset($_POST['time_toggle'])){ 
		array_push($promoDataRec, array('Name'=>'ltp_time_start', 'Value'=> isset($_POST['tim_starttime'])? $_POST['tim_starttime']: null, 'Type'=>'tim_ltp_time_start', 'PDO_Param'=>\PDO::PARAM_STR));
		array_push($promoDataRec, array('Name'=>'ltp_time_end', 'Value'=> isset($_POST['tim_endtime'])? $_POST['tim_endtime']: null, 'Type'=>'tim_ltp_time_start', 'PDO_Param'=>\PDO::PARAM_STR));
	}		
	// set redemption options
	if (!isset($_REQUEST['bit_redeem_switch'])){
		// no redemptions
		$_REQUEST['bit_redeem_switch'] = 0;
		$redemption_count = 0;
	} else {
		$redemption_count = $promoFormMerchant->promoRedeemptionCount($_REQUEST['wnu_ltp_id_r']);
		if ($_REQUEST['bit_redeem_switch'] == 1 
			&& isset($_POST['wnu_max_redemptions_global'], $_POST['wnu_max_redemptions_user'])
			&& (intval($_POST['wnu_max_redemptions_user']) > intval($_POST['wnu_max_redemptions_global'])) 
			&&  $_POST['wnu_max_redemptions_global'] != 0 ) {
			// redemptions per user is greater than total quantity && total quantity is not unlimited
			$errors['redemption_max'] = 'Redemptions per user is greater than total quantity';
		}
		if ( $_REQUEST['bit_redeem_switch'] == 1
			 && isset($_POST['wnu_max_redemptions_global'])
			 && intval($_POST['wnu_max_redemptions_global']) <= $redemption_count 
			 && $_POST['wnu_max_redemptions_global'] != 0 ){
			// user attempting to set global quantity to a number less than this promo has already been redeemed && is not being set to unlimited
			$errors['redemption_count'] = 'Cannot lower total quantity to '.$_POST['wnu_max_redemptions_global'].'. Promotion has already been redeemed '.$redemption_count.' times.';
		}
	}	
	
	//if no errors, proceed to save to / update database
	if(!count($errors)){
		//EDIT PROMO
		$currentPromoId=$_POST['wnu_ltp_id_r']; $newPromoFlag=false;
		if($currentPromoId!=0) {
			//var_dump($promoFormMerchant);
			
			//var_dump($promoDataRec);
			
			$promoFormMerchant->updateCurrentPromo($promoDataRec, $currentPromoId);
			$urlParam='promo-updated=1';	
		//NEW PROMO
		}else{
	        $currentPromoId = $promoFormMerchant->addPromo($promoDataRec);
			$urlParam='new-promo-created=1';
			$newPromoFlag=true;
		}
		
		if ( $currentPromoId ) {
			$promoFormMerchant->loadThisPromo($currentPromoId, $promoImgType);
			$promoFormMerchant->updateCurrentPromoSlug($_POST['txl64_header_r'], $currentPromoId);
			if ($promoFormMerchant->getCurrentPromo('lpt_id') == 5) {
				if ($newPromoFlag)
					$promoFormMerchant->createCrossPromo($currentPromoId, $_POST['wnu_merchant_search_select']);
				else
					$promoFormMerchant->updateCrossPromo($currentPromoId, $_POST['wnu_merchant_search_select']);
			}
		}
		header('Location: promo_list.php?'.$urlParam);    
		exit();
	}
   } 	
}

/*=================================================================================	
   ____  _    _ ______ _______     __  _____  _____   ____  __  __  ____  
  / __ \| |  | |  ____|  __ \ \   / / |  __ \|  __ \ / __ \|  \/  |/ __ \ 
 | |  | | |  | | |__  | |__) \ \_/ /  | |__) | |__) | |  | | \  / | |  | |
 | |  | | |  | |  __| |  _  / \   /   |  ___/|  _  /| |  | | |\/| | |  | |
 | |__| | |__| | |____| | \ \  | |    | |    | | \ \| |__| | |  | | |__| |
  \___\_\\____/|______|_|  \_\ |_|    |_|    |_|  \_\\____/|_|  |_|\____/ 
=================================================================================*/

//query list of promo types
if( isset( $_GET['ltp_id'], $promoFormMerchant) ){ //promo id passed - editing an existing promo
	$foundFlag = false;
	if ( is_numeric($_GET['ltp_id']) && intval($_GET['ltp_id']) == $_GET['ltp_id'] ) {
		$promoFormMerchant->loadThisPromo($_GET['ltp_id'], $promoImgType);
		$foundFlag = isset($promoFormMerchant->mRecords[$promoFormMerchant->currentMerchantId]['Promo']) && $promoFormMerchant->mRecords[$promoFormMerchant->currentMerchantId]['Promo']->currentPromoId == $_GET['ltp_id'];
	}
	if(!$foundFlag)
		header("location: /mystore/");
	$promoStdDataObj = $promoFormMerchant->mRecords[$promoFormMerchant->currentMerchantId]['Promo']->currentRecordToObject();	
}

if(isset($_GET['lpt_id'])) {	
	// check for promo tracking history
	// if this promo has history, override attempts to change promo type
	if(count($promoFormMerchant->getCurrentPromoTrackingHistory())){ 
		$_GET['lpt_id'] = $promoTypeId; // override promo type
		$errors['promo_history'] = 'Cannot change Promotion Type after a promotion has been active and viewed by users';
	}
	// promo type change, check for valid promo type	
	$promoTypeIdTemp=$promoFormMerchant->checkPromoType($_GET['lpt_id']);
	if($promoTypeIdTemp){$promoTypeId = $promoTypeIdTemp;}
	else{// invalid promo type	
		header("location: /mystore/");
	}
}

if (!isset($promoStdDataObj)) $promoStdDataObj = $promoFormMerchant->getStdPromoObj(isset($promoTypeId)?$promoTypeId:0);
if (!isset($promoTypeId)) $promoTypeId = $promoStdDataObj->lpt_id;
if (!isset($promoImgType)) $promoImgType = 'default';

if ($promoTypeId == 5){
		// $promoImgType = 'cross_promotion';
		$qry = $promoFormMerchant->getCurrentPromo('CrossPromoMerchantId');
		if 	(!empty($qry)){
			$cross_promo_ltb = $qry[0]['ltb_id'];
			$cross_promo_name = $qry[0]['ltm_company_name'];
		}
}

 // echo '<pre>';
 // var_dump($promoStdDataObj);
 // echo '</pre>';
include 'inc/myi_header.php';
// query promo types
$qry = $promoFormMerchant->getAvailablePromoTypes();

if(empty($qry)){
	header("location: /mystore/");
} else {
	foreach ($qry as $value) {
		// $promoTypes .= '<label><input type="radio" name="lpt_id"> '.$value['lpt_name'].'</label>   ';
		if ($value['lpt_id']==6 && !$thisMerchant->merchantHasProduct ('LT_SCRECIALS')){
			// this merchant cannot create screcials
		} else {
			$promoTypes .= '<option value="'.$value['lpt_id'].'" '.($promoTypeId == $value['lpt_id']?'selected':'').'> '.$value['lpt_name'].'</option>';
		}
	}
}

unset($useByDate);
if ($promoStdDataObj->ltp_enddate != null) {					
	$d = ' use by ' . date('M d', strtotime($promoStdDataObj->ltp_enddate));
	$useByDate = '<img style="margin-right: 1px;" width="16" src="/localthanks/images/icon_date_range.svg"/> ' . $d;
}

/*=================================================================================	
   _____ _________     ___      ______  _____ 
  / ____|__   __\ \   / / |    |  ____|/ ____|
 | (___    | |   \ \_/ /| |    | |__  | (___  
  \___ \   | |    \   / | |    |  __|  \___ \ 
  ____) |  | |     | |  | |____| |____ ____) |
 |_____/   |_|     |_|  |______|______|_____/ 
=================================================================================*/
?>
<link rel="stylesheet" href="/mystore/css/promo-form.css"/>
<!-- Modal -->
<div class="modal fade" id="modal" tabindex="-1" role="dialog" aria-labelledby="modalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="modalLabel">Crop/resize image</h4>
      </div>
      <div class="modal-body">
        <div>
          <img id="image" class="img-responsive" src="/mystore/images/logo.png" alt="Picture">
        </div>
      </div>
      <div class="modal-footer">        
      	<button id="crop_it" type="button" class="btn btn-success" data-dismiss="modal">Crop</button>
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<div id='main' class='container'>
	<div class="row table-body">

<?php  /*

===================================================================================	
  ______ ____  _____  __  __  
 |  ____/ __ \|  __ \|  \/  | 
 | |__ | |  | | |__) | \  / | 
 |  __|| |  | |  _  /| |\/| | 
 | |   | |__| | | \ \| |  | | 
 |_|    \____/|_|  \_\_|  |_| 
===================================================================================	*/ 	?>
		<div class="col-md-8 col-xs-12 left-side-2"><!-- open 1st column -->
			<?php 
				if (count($errors)) { 
					echo "<div class='alert alert-danger alert-dismissable'>
					<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>
				      &times;
				    </button>
	   				<span class='glyphicon glyphicon-exclamation-sign'></span> <strong>Error</strong><ul>"; 
					foreach($errors as $key => $value) { 
						$error_msg .= '<li>' . $value . '</li>'; 
					} 
					echo $error_msg . "</ul></div>"; 
				}
			?>
			<form id="promo_form" method="post">
				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label>Promotion Type</label>
						</div>
						<div class="form-cell form-cell-right">
							<select name="lpt_id" class="form-control" id="lpt_control">
								<?php echo $promoTypes; ?>
							</select>
						</div>
					</div>
				</div>
				
				<!-- CROSS PROMOTION ==================================================================== -->
				<?php if($promoTypeId==5){ /* cross promotion */ ?>
					<div id="merchant_search_msg" class="alert alert-info" style="display:none;text-align:center;"></div>
					<div class="form-table">
						<div class="form-row">
							<div class="form-cell form-cell-left">
								<label for="merchant_search">Search Merchants</label>
							</div>
							<div class="form-cell form-cell-right">
								<input name="merchant_search" id="merchant_search" type="text" class="form-control">
							</div>
						</div>
					</div>	
					<div id="merchant_search_results" class="form-table" style="display:none;">
						<div class="form-row">
							<div class="form-cell form-cell-left"><label for="merchant_search_select">Select Merchant</label></div>
							<div class="form-cell form-cell-right">
								<select id="merchant_search_select" name="wnu_merchant_search_select" class="form-control">
									
								</select>
							</div>
						</div>
					</div>			
				<?php } ?>

				<!-- HEADER 1 ======================================================================= -->

				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label id="formfield_0" for="fm_line_0">Title</label>
						</div>
						<div class="form-cell form-cell-right">
							<input value="<?php echo $promoStdDataObj->ltp_headline; ?>" name="txl64_header_r" id="fm_line_0" data-msg='{"required":"required", "max":64}'  maxlength="64" type="text" class="form-control"  aria-describedby="formfield_0">
						</div>
					</div>
				</div>

				<!-- IMAGE ========================================================================== -->
				<input type="hidden" id="image_name" name="img128_image_name" value="<?php echo $promoStdDataObj->ltp_image;?>">

				<!-- COUPON CODE ==================================================================== -->
				<?php if($promoTypeId==1){ /* coupon */ ?>
				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label for="fm_ccode" id="formfield_5">Coupon Code</label>
						</div>
						<div class="form-cell form-cell-right">
							<input value="<?php echo $promoStdDataObj->ltp_promo_code;?>" name="aon16_couponcode_r" id="fm_ccode" data-msg='{"required":"required","max":16,"show_counter":"true","height":34}' maxlength="16" type="text" placeholder="coupon" class="form-control" aria-describedby="formfield_5">
						</div>
					</div>
				</div>				
				<!-- END OF DAY / DAY OF WEEK ======================================================= -->
				<?php } 
				else if($promoTypeId==3){ /* end of day / day of week */ ?>

					<link href="/plugins/bootstrap/switch/bootstrap-switch.css" rel="stylesheet">
					<script src="/plugins/bootstrap/switch/bootstrap-switch.js"></script>
					<link href="/plugins/bootstrap/timepicker/bootstrap-timepicker.css" rel="stylesheet">
					<script src="/plugins/bootstrap/timepicker/bootstrap-timepicker.js"></script>
					<script src='/plugins/bootstrap/select2/select2.js'></script>

					<div class="form-table">
						<div class="form-row">
							<div class="form-cell form-cell-left">
								<label id="formfield_6">Promo Days</label>
							</div>
							<div class="form-cell form-cell-right">
								<input type="checkbox" class="date_switch" id="day_toggle" data-msg='{"required":"required"}' name="day_toggle" data-size="mini" data-handle-width="139" data-on-text="Every Day" data-off-text="Limited to Selected Days" data-on-color="primary" data-off-color="primary"  aria-describedby="formfield_6">
								<select id="fm_days" name="wnu1_promotion_days[]" placeholder="Select day(s)" style="width:300px;" class="form-control" multiple="multiple" aria-describedby="formfield_6">
									<option value="1">Monday</option><option value="2">Tuesday</option><option value="3">Wednesday</option><option value="4">Thursday</option><option value="5">Friday</option><option value="6">Saturday</option><option value="7">Sunday</option>
								</select><br>
								<input type="checkbox" class="date_switch" id="time_toggle" data-msg='{"required":"required"}' name="time_toggle" data-size="mini" data-handle-width="139" data-on-text="All Day" data-off-text="Time Range" data-on-color="primary" data-off-color="primary" checked  aria-describedby="formfield_6">
								<div id="timerangebox" class="fm_2_inputs_in_box" style="display:none;">
									<span>start: <i class="icon-time"></i> 
									<input style="width:75px;" type="text" name="tim_starttime" data-msg='{"required":"required"}' class="input-small timepicker" aria-describedby="formfield_6"></span>
		            				<span style="float:right;">end: <i class="icon-time"></i> 
									<input style="width:75px;" type="text" name="tim_endtime"   data-msg='{"required":"required"}' class="input-small timepicker" aria-describedby="formfield_6"></span>
		            			</div>	            											
							</div>
						</div>
					</div>				
					 


				<?php } 
				/* END | END OF DAY / DAY OF WEEK ================================================== */
				?>

				<!-- DESCRIPTION ==================================================================== -->
				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label for="fm_descrip" id="formfield_7">Description</label>
						</div>
						<div class="form-cell form-cell-right">
							<textarea name="txt500_description_r" id="fm_descrip" data-msg='{"required":"required","max":500,"show_counter":"true","height":71}' class="form-control" maxlength="500" aria-describedby="formfield_7"><?php echo $promoStdDataObj->ltp_description; ?></textarea>
						</div>
					</div>
				</div>

				<!-- DISCLAIMERS ==================================================================== -->
				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label for="fm_disclaim" id="formfield_8">Disclaimers<span class="fm_optional"></span></label>
						</div>
						<div class="form-cell form-cell-right">
							<textarea name="txt1000_disclaimers" id="fm_disclaim" data-msg='{"default":"optional","max":1000,"show_counter":"true","height":71}' class="form-control"  maxlength="1000" aria-describedby="formfield_8"><?php echo $promoStdDataObj->ltp_disclaimers; ?></textarea>
						</div>
					</div>
				</div>

				<!-- DATES ========================================================================== -->
				<?php 

				$startdate=$promoStdDataObj->ltp_startdate;
				$enddate=$promoStdDataObj->ltp_enddate;
				
				$x=0; if($promoTypeId==4){
					$startdate=($startdate!=''?$startdate:date('m/d/Y'));
					$enddate=($enddate!=''?$enddate:date('m/d/Y',mktime(0,0,0,date("m"),date("d")+14, date("Y"))));
					$x=1;

				} /* too shorten embedded code below */ ?>

				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label for="fm_disclaim" id="formfield_9">Valid Dates<?php if($x==0){ echo '<span class="fm_optional"></span>';}?></label>
						</div>
						<div class="form-cell form-cell-right">
							<div id="timerangebox" class="fm_2_inputs_in_box">
								<span>
									start: <i class="icon-calendar"></i>
									<input <?php echo ($x==1?'disabled="disabled"':'').' value="'.$startdate.'"'; ?> class="daterange" name="dat_startdate" id="dat_startdate" data-provide="datepicker" aria-describedby="formfield_9">
								</span>
		        				<span>
		        					end: <i class="icon-calendar"></i> 
		        					<input <?php echo ($x==1?'disabled="disabled"':'').' value="'.$enddate.'"'; ?> class="daterange" name="dat_enddate" id="dat_enddate" data-provide="datepicker" aria-describedby="formfield_9">
		        				</span>
								<?php if($x==1){ echo "<script> $.datepicker({format: 'mm/dd/yyyy'});</script>"; } ?>
		        			</div>
						</div>
					</div>
				</div>
				<input type="hidden" id="ltp_id" name="wnu_ltp_id_r" value="<?php echo $promoStdDataObj->ltp_id; ?>">
				<input type="hidden" name="wnu_lpt_id_r" value="<?php echo $promoTypeId; ?>">
			
				<!-- REDEEM BUTTON ========================================================================== -->
				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label for="bit_redeem_switch">Redeemable?</label>
						</div>
						<div class="form-cell form-cell-right">
							<input type="checkbox" name="bit_redeem_switch" id="bit_redeem_switch" value="1" <?php echo ( is_null($promoStdDataObj->ltp_max_redemptions_global) || $promoStdDataObj->ltp_max_redemptions_global > 0 ? 'checked' : '' ); ?>>
						</div>
					</div>
				</div>
				<div class="redemptionOptions" style="<?php echo ( is_null($promoStdDataObj->ltp_max_redemptions_global) || $promoStdDataObj->ltp_max_redemptions_global > 0 ? '' : 'display:none;' ); ?>">
					<div class="form-table">
						<div class="form-row">
							<div class="form-cell form-cell-left"><label>Total Quantity</label></div>
							<div class="form-cell form-cell-right">
								<div class="form-inline">
									<div class="form-group">
										<input type="radio" name="bit_redemptions_global" id="redemptions_global_unlimited" value="0" <?php echo ( is_null($promoStdDataObj->ltp_max_redemptions_global) || $promoStdDataObj->ltp_max_redemptions_global == 0 ? 'checked':''); ?>> 
										<label for="redemptions_global_unlimited">Unlimited</label> 
										<input type="radio" name="bit_redemptions_global" id="redemptions_global_limit" value="1" <?php echo ( $promoStdDataObj->ltp_max_redemptions_global > 0 ? 'checked':''); ?>> 
										<label for="redemptions_global_limit">Limited:</label>
										<input type="number" min="1" name="wnu_max_redemptions_global" id="wnu_max_redemptions_global" class="form-control" value="<?php echo ( $promoStdDataObj->ltp_max_redemptions_global > 0 ? $promoStdDataObj->ltp_max_redemptions_global : 1); ?>" <?php echo ( $promoStdDataObj->ltp_max_redemptions_global > 0 ? '':'disabled'); ?>>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="form-table">
						<div class="form-row">
							<div class="form-cell form-cell-left"><label>Redemptions Per User</label></div>
							<div class="form-cell form-cell-right">
								<div class="form-inline">
									<div class="form-group">
										<input type="radio" name="bit_redemptions_user" id="redemptions_user_unlimited" value="0" <?php echo ( is_null($promoStdDataObj->ltp_max_redemptions_user) || $promoStdDataObj->ltp_max_redemptions_user == 0  ? 'checked':''); ?>> <label for="redemptions_user_unlimited">Unlimited</label> 
										<input type="radio" name="bit_redemptions_user" id="redemptions_user_limit" value="1" <?php echo ( $promoStdDataObj->ltp_max_redemptions_user > 0 ? 'checked':''); ?>> <label for="redemptions_user_limit">Limited:</label> 
										<input type="number" min="1" name="wnu_max_redemptions_user" id="wnu_max_redemptions_user" class="form-control" value="<?php echo ( $promoStdDataObj->ltp_max_redemptions_user > 0 ? $promoStdDataObj->ltp_max_redemptions_user : 1); ?>" <?php echo ( $promoStdDataObj->ltp_max_redemptions_user > 0 ? '':'disabled'); ?>>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<!-- PRICING -->
				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label for="bit_pricing_switch">Pricing</label>
						</div>
						<div class="form-cell form-cell-right">
							<input type="checkbox" name="bit_pricing_switch" id="bit_pricing_switch" value="1" <?php echo ($promoStdDataObj->ltp_price > 0 ? 'checked' : '' ); ?>>
						</div>
					</div>
				</div>
				<div class="pricingOptions" style="display: none;">
					<div class="form-table">
						<div class="form-row">
							<div class="form-cell form-cell-left">&nbsp;</div>
							<div class="form-cell form-cell-right">
								<div class="form-inline">
									<span class="pricingInputWrap">
										<input class="form-control pricingInput" style="max-width: 94px;" type="text" name="dec_promo_price" id="dec_promo_price" value="<?php echo ($promoStdDataObj->ltp_price > 0 ? $promoStdDataObj->ltp_price : '' ); ?>" placeholder="0.00">
									</span>
								</div>
							</div>
						</div>
					</div>					
				</div>

				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label for="bit_punch_card">Count as Digital Punch?</label>
						</div>
						<div class="form-cell form-cell-right">
							<input type="checkbox" name="bit_punch_card" id="bit_punch_card" value="1" <?php echo isset($promoStdDataObj->ltp_punchcard) && $promoStdDataObj->ltp_punchcard == '1'? 'checked' : '' ; ?>>
						</div>
					</div>
				</div>
				
			</form>

			<!-- image gallery -->
				<div style="text-align:center;margin: 5px 0;"><?php echo $msg; ?></div>
				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label>Gallery</label>
						</div>
						<div class="form-cell form-cell-right">
							<ul class="nav nav-tabs" role="tablist" id="gallery_upload">
								<li role="presentation" class="active"><a href="#gallery" aria-controls="gallery" role="tab" data-toggle="tab">My Gallery</a></li>
								<li role="presentation"><a href="#unv_library" aria-controls="#unv_library" role="tab" data-toggle="tab" id="library_btn">Library</a></li>
								<li role="presentation"><a href="#upload_img" aria-controls="upload_img" role="tab" data-toggle="tab">Add Image</a></li>
							</ul>
							<div class="tab-content">				    
								<div role="tabpanel" class="tab-pane active" id="gallery">					
								<?php
									// load this merchants uploaded/used images
									$list   = 'source_*';
									$list   = glob( "../merchant-custom-files/".$promoFormMerchant->getMerchantSubDir('')."/_files/img/{$list}" );
									usort($list, create_function('$a,$b', 'return filemtime($a) - filemtime($b);'));
									for ($_i=count($list)-1; $_i>=0 ;$_i--) {
					 					echo '<img class="promo_thumbnail gallery_img" src="'.$list[$_i].'">';
									}						
								?>
								</div>
								<div role="tabpanel" class="tab-pane" id="unv_library">			
									Fetching images...
								</div>
								<div role="tabpanel" class="tab-pane" id="upload_img">
									<form enctype="multipart/form-data" action="/mystore/promo_form.php?<?php echo (isset($_GET["ltp_id"])?'ltp_id='.$_GET["ltp_id"].'&':''); echo (isset($_GET['lpt_id'])?'lpt_id='.$_GET['lpt_id']:'');?>" enctype="" method="post"> 						    
										<input type="file" name="uploaded_img" id="uploaded_img" accept="image/x-png, image/gif, image/jpeg, image/jpg">
										<br>
										<input type="submit" value="Upload It">
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
		</div><!-- close 1st column -->

<?php /*
===================================================================================	
  _____  _____  ________      _______ ________          _______ 
 |  __ \|  __ \|  ____\ \    / /_   _|  ____\ \        / / ____|
 | |__) | |__) | |__   \ \  / /  | | | |__   \ \  /\  / / (___  
 |  ___/|  _  /|  __|   \ \/ /   | | |  __|   \ \/  \/ / \___ \ 
 | |    | | \ \| |____   \  /   _| |_| |____   \  /\  /  ____) |
 |_|    |_|  \_\______|   \/   |_____|______|   \/  \/  |_____/ 
===================================================================================	*/?>

		<div class="col-md-4 col-xs-12 right-side-2"><!-- open 2nd column THIS COLUMN IS BROKEN INTO FURTHER COLUMNS-->
			<!-- PREVIEW ================================================================ -->			
			<div class="preview-title">Preview</div>
			<div class="promo_row">
				<div class="promo_wrap">			
					<div id="mobile_promo" class="mp_promo_image promo_image">	
						<img src="../images/trans_3x2.gif" class="img-responsive">
					</div>
					<div class="promo_details">
						<div class="promo_headline"></div>
						<div class="promo_use_by">
							<?php echo (isset($useByDate) ? $useByDate : ''); ?>
						</div>
						<div class="promo_punchcard">
							<?php echo (isset($promoStdDataObj->ltp_punchcard) && $promoStdDataObj->ltp_punchcard == 1? '<img width="15" height="15" alt="Punch Card Icon" src="/localthanks/images/icon-punchcard.svg"/> Count as a punch' : ''); ?>
						</div>
						<div class="promo_merchant">
							<?php echo (isset($promoStdDataObj->ltm_company_name) ? $promoStdDataObj->ltm_company_name : $_SESSION['user']['merchant']['ltm_company_name']); ?>
						</div>
						<div class="promo_city">
							<span class="glyphicon glyphicon-globe"></span> <?php echo (isset($promoStdDataObj->ltm_city) ? ucwords($promoStdDataObj->ltm_city) : 'City Name'); ?>
						</div>
						<div class="promo_price">
							
						</div>
					</div>
				</div>
				<div class="preview-title">Click image to resize/crop</div>
				<div style="text-align:center;"><button id="submit_button" type="button" class="btn btn-success"><?php echo ($promoStdDataObj->ltp_id>0?'Save':'Create Promo');?></button></div>
			</div>
		</div>
	</div>
</div>

<?php
/*
===================================================================================	
   _____  _____ _____  _____ _____ _______ _____ 
  / ____|/ ____|  __ \|_   _|  __ \__   __/ ____|
 | (___ | |    | |__) | | | | |__) | | | | (___  
  \___ \| |    |  _  /  | | |  ___/  | |  \___ \ 
  ____) | |____| | \ \ _| |_| |      | |  ____) |
 |_____/ \_____|_|  \_\_____|_|      |_| |_____/ 
===================================================================================	*/?>

<!-- <script src="/plugins/jquery/ui/jquery-ui-1.11.1.min.js"></script> -->
<script>
_scriptObj = {
	promoTypeId: "<?php echo $promoTypeId; ?>",
	crossPromMerchantId: "<?php echo $cross_promo_ltb; ?>",
	crossPromoName: "<?php echo $cross_promo_name; ?>",
	promoImgType: "<?php echo $promoImgType; ?>",
	merchantSubDir: "<?php echo $promoFormMerchant->getMerchantSubDir('');?>"
}
</script>
<script src="/mystore/js/promo-form.js?v=1.0.0"></script>

<?php
include 'inc/myi_footer.php';
?>