<?php
include 'inc/myi_login_check.php';
//include '../app/global.php';
$nav_icon_path = 'images/icon-punch-card-top.svg';
$nav_title = 'Punch Card';

use App\MyStore\MemberMerchant as MyStoreMerchant;


require_once "app/class.mystore-member-merchant.php";	
$promoFormMerchant = new MyStoreMerchant\MyStoreMemberMerchant($dbo, true, $_SESSION['user']['merchant']['ltb_id']);
$errors = array();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	if ( isset(
			$_POST['txt1000_dpc_disclaimer'], 
			$_POST['txt70_dpc_intro'], 
			$_POST['txl50_dpc_header_r'], 
			$_POST['img128_dpc_image'], 
			$_POST['wnu_dpc_required_punches'], 
			$_POST['wnu4_dpc_pincode_r']) 
		) {
			
		$punchCardData = $promoFormMerchant->callStoreFunction('getPunchCard', array());
		
		$params = $_POST;
		if ( isset( $punchCardData['dpc_id'] ) ) {
			$params['wnu_dpc_id_r'] = $punchCardData['dpc_id'];	
			//update punch card of the store
			$tmp = $promoFormMerchant->callStoreFunction('updatePunchCard', $params);
			if (is_array($tmp)) {$errors = $tmp;}			
		}
		else {				
			$tmp = $promoFormMerchant->callStoreFunction('createPunchCard', $params);				
			if (is_array($tmp)) {$errors = $tmp;}
		}			
	}
	
	if (isset($_FILES['uploaded_img']) && is_uploaded_file($_FILES['uploaded_img']['tmp_name'])) {		
		$validImageFileFlag = @exif_imagetype($_FILES['uploaded_img']['tmp_name']);
		if ($validImageFileFlag === false) {			
			array_push($errors, 'Incorrect image file.');
		}
		else{
			list( $orig_w, $orig_h ) = getimagesize( $_FILES['uploaded_img']['tmp_name'] );
			$valid = array('jpeg', 'jpg', 'png', 'gif');
			$sizes = array( 600 => 400, 120=>120);
			if ($orig_w < 600 || $orig_h < 400){				
				array_push($errors, 'Image must be atleast 600px wide and 400px tall.');
			}else{
				$ext = strtolower( pathinfo( $_FILES['uploaded_img']['name'], PATHINFO_EXTENSION ) );
				if( in_array( $ext, $valid ) ){
					$promoFormMerchant->promoImageResize($_FILES['uploaded_img'], $sizes);
				}else{					
					array_push($errors, 'Unsupported or empty file.');
				}
			}
		}
	}else if (isset($_FILES['uploaded_img']) && $_FILES['uploaded_img']['error'] > 0){		
		array_push($errors, 'Image must be smaller than 2MB.');
	}	
		
}

$punchCardData = $promoFormMerchant->callStoreFunction('getPunchCard', array(true));
$punchCardData = $promoFormMerchant->callStoreFunction('getPunchCardHistory', array());	

include 'inc/myi_header.php';
?>

<link rel="stylesheet" href="/mystore/css/promo-form.css"/>
<link rel="stylesheet" href="/mystore/css/punch-card-form.css"/>

<!-- Modal -->
<div class="modal fade" id="modal" tabindex="-1" role="dialog" aria-labelledby="modalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="modalLabel">Crop/resize image</h4>
      </div>
      <div class="modal-body">
        <div>
          <img id="image" class="img-responsive" src="/mystore/images/logo.png" alt="Picture">
        </div>
      </div>
      <div class="modal-footer">        
      	<button id="crop_it" type="button" class="btn btn-success" data-dismiss="modal">Crop</button>
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<div id='main' class='container'>

	<div class="modal fade" id="modalConfirm" tabindex="-1" role="dialog" aria-labelledby="modalConfirmLabel">
	  <div class="modal-dialog modal-md" role="document">
		<div class="modal-content">
		  
		  <div class="modal-body">
			<div class="row">
				<div style="width: 16.66666667%; float: left;">
					<img class="img-responsive exclamation-sign-img" src="images/icon-exclamation.png" alt="Exclamation sign"/>
				</div>
				<div style="width: 83.33333333%; float: left; padding: 0 5px;">
					<p><strong>Your Punch Card cannot be made completely Inactive at this time</strong>, as you have customers using the card who have not yet completed the card. By making the Punch Card Inactive, your existing customers using the card can still complete it.New customers will not be able to use the card.</p>
					<p class="confirmQuestion"><em>Do you wish to continue?<span class="confirm-popup-btn" id="confirmAccepted">Yes</span><span class="confirm-popup-btn" data-dismiss="modal">No</span></em></p>
				</div>
			</div>			
			
		  </div>      
		</div>
	  </div>
	</div>
	
	<div class="row table-body">

		<div class="col-lg-8 col-xs-12 left-side-2"><!-- open 1st column -->			
			<?php 
				if (count($errors)) { 
					echo "<div class='alert alert-danger alert-dismissable'>
					<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>
				      &times;
				    </button>
	   				<span class='glyphicon glyphicon-exclamation-sign'></span> <strong>Error</strong><ul>"; 
					foreach($errors as $key => $value) { 
						$error_msg .= '<li>' . $value . '</li>'; 
					} 
					echo $error_msg . "</ul></div>"; 
				}
			?>
			<form id="punch_card_form" method="post">
				
				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							
						</div>
						<div class="form-cell form-cell-right">
							<div class="row">
								<div class="col-md-10">									
									<h1 class="punch-cardH1">Welcome to your Digital Punch Card Setup</h1>
									<p  class="punch-cardP1"><strong>Important note:</strong><br>Once a punch card is set up, there can be no changes until all customers have completed redemption and there are no outstanding punches remaining for customers.</p>
								</div>	
							</div>	
						</div>
					</div>
				</div>				
				
				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label for="punch_card_active">Punch Card</label>
						</div>
						<div class="form-cell form-cell-right">
							<div class="row">
								<div class="col-md-10">
									<input type="checkbox" name="bit_dpc_active" id="punch_card_active" value="1" <?php echo isset($punchCardData['dpc_active']) && $punchCardData['dpc_active'] == 1? 'checked' : ''; ?>>									
								</div>	
							</div>	
						</div>
					</div>
				</div>				
				
				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label id="formfield_0" for="fm_title">Title</label>
						</div>
						<div class="form-cell form-cell-right">
							<div class="row">
								<div class="col-md-10">
									<input value="<?php echo isset($punchCardData['dpc_header'])? $punchCardData['dpc_header'] : (isset($_POST['txl50_dpc_header_r'])? $_POST['txl50_dpc_header_r'] : "Punch Card Title"); ?>" name="txl50_dpc_header_r" id="fm_title" data-msg='{"required":"required","show_counter":"true", "max":50}'  maxlength="50" type="text" class="form-control" aria-describedby="formfield_0">									
									<p><small>(Maximum 50 characters)</small></p>									
								</div>	
							</div>	
						</div>
					</div>
				</div>
				
				<!-- DESCRIPTION ==================================================================== -->
				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label for="fm_description" id="formfield_7">Description<span class="fm_optional"></span></label>
						</div>
						<div class="form-cell form-cell-right">
							<div class="row">
								<div class="col-md-10">									
									<input name="txt70_dpc_intro" id="fm_description" data-msg='{"default":"optional","max":70,"show_counter":"true","height":120}' class="form-control" maxlength="70" aria-describedby="formfield_7" value="<?php echo isset($punchCardData['dpc_intro'])? $punchCardData['dpc_intro'] : (isset($_POST['txt70_dpc_intro'])? $_POST['txt70_dpc_intro'] : "Punch Card Description"); ?>"/>
									<p><small>(Maximum 70 characters)</small></p>
								</div>	
							</div>	
						</div>
					</div>
				</div>
				
				<!-- IMAGE ========================================================================== -->
				<input type="hidden" id="image_name" name="img128_dpc_image" value="<?php echo isset($punchCardData['dpc_image'])? $punchCardData['dpc_image'] : (isset($_POST['img128_dpc_image'])? $_POST['img128_dpc_image'] : ""); ?>">				
				
				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label for="image_switch">Image</label>
						</div>
						<div class="form-cell form-cell-right">
							<div class="row">
								<div class="col-md-10">
									<input type="checkbox" name="bit_image_switch" id="image_switch" value="1" <?php echo isset($punchCardData['dpc_image']) || (isset($_POST['img128_dpc_image']) && !empty($_POST['img128_dpc_image']))? 'checked' : ''; ?>>
									<p class="punch-cardP1">If you wish to have an image for your customers on your punch card, you can turn that on here and select an image below, or upload an image of your own for use.</p>
								</div>
							</div>	
						</div>
					</div>
				</div>				
				
			</form>

			<!-- image gallery -->
				<div class="form-table" data-msg='{"required":"required"}'aria-describedby="formfield_10" id="punchcardGallery" <?php echo isset($punchCardData['dpc_image']) || (isset($_POST['img128_dpc_image']) && !empty($_POST['img128_dpc_image']))? '' : 'style="display:none;"'; ?>>
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label id="formfield_10">Gallery</label>
						</div>
						<div class="form-cell form-cell-right">
							<ul class="nav nav-tabs" role="tablist" id="gallery_upload">
								<li role="presentation" class="active"><a href="#gallery" aria-controls="gallery" role="tab" data-toggle="tab">My Gallery</a></li>
								<li role="presentation"><a href="#unv_library" aria-controls="#unv_library" role="tab" data-toggle="tab" id="library_btn">Library</a></li>
								<li role="presentation"><a href="#upload_img" aria-controls="upload_img" role="tab" data-toggle="tab">Add Image</a></li>
							</ul>
							<div class="tab-content">				    
								<div role="tabpanel" class="tab-pane active" id="gallery">					
								<?php
									// load this merchants uploaded/used images
									$list   = 'source_*';
									$list   = glob( "../merchant-custom-files/".$promoFormMerchant->getMerchantSubDir('')."/_files/img/{$list}" );
									usort($list, create_function('$a,$b', 'return filemtime($a) - filemtime($b);'));
									for ($_i=count($list)-1; $_i>=0 ;$_i--) {
					 					echo '<img class="promo_thumbnail gallery_img" src="'.$list[$_i].'">';
									}						
								?>
								</div>
								<div role="tabpanel" class="tab-pane" id="unv_library">			
									Fetching images...
								</div>
								<div role="tabpanel" class="tab-pane" id="upload_img">
									<form enctype="multipart/form-data" action="/mystore/my_punch_card.php?<?php echo (isset($_GET["ltp_id"])?'ltp_id='.$_GET["ltp_id"].'&':''); echo (isset($_GET['lpt_id'])?'lpt_id='.$_GET['lpt_id']:'');?>" enctype="" method="post"> 						    
										<input type="file" name="uploaded_img" id="uploaded_img" accept="image/x-png, image/gif, image/jpeg, image/jpg">
										<br>
										<input type="submit" value="Upload It">
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label id="formfield_12" for="max_punches">Total Number of Digital Punches</label>
						</div>
						<div class="form-cell form-cell-right">
							
								<div class="form-group">																				
									<div class="row">
										<div class="col-md-3">
											<input style="max-width: 100px;" type="number" name="wnu_dpc_required_punches" id="max_punches" maxlength="2" form="punch_card_form" min="1" max="20" data-msg='{"required":"required"}' class="form-control pin-code-inp"<?php echo isset($punchCardData['History']) && !empty($punchCardData['History'])? " readonly title='The Punch Card has a history already, the total number of digital punches of your card cannot be changed.'" : ""; ?> value="<?php echo isset($punchCardData['dpc_required_punches'])? $punchCardData['dpc_required_punches'] : "10"; ?>"   aria-describedby="formfield_12">											
										</div>
										<div class="col-md-9"></div>	
										<div class="col-md-12">
											<p class="punch-cardP1">You can set up your Digital Punch card for customers to gain anywhere from <strong>1-20 punches on the card</strong>, before being rewarded.</p>
										</div>
									</div>		
								</div>
							
						</div>
					</div>
				</div>
				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label id="formfield_13" for="pin_code">Punch Card Pin Code</label>
						</div>
						<div class="form-cell form-cell-right">
							
								<div class="form-group">										
									<div class="row">
										<div class="col-md-3">
											<input data-msg='{"number": "1","min":"4","max":"4","required":"required"}' type="password" form="punch_card_form" name="wnu4_dpc_pincode_r" id="pin_code" maxlength="4" class="form-control pin-code" value="<?php echo isset($punchCardData['dpc_pincode'])? $punchCardData['dpc_pincode'] : (isset($_POST['wnu4_dpc_pincode_r'])? $_POST['wnu4_dpc_pincode_r'] : ""); ?>"  aria-describedby="formfield_13">											
										</div>	
										<div class="col-md-9"><a href="javascript:void(0);" id="viewPinCode">View Code</a></div>
									</div>	
								</div>
							
						</div>
					</div>
				</div>
				
				<div class="form-table">
					<div class="form-row">
						<div class="form-cell form-cell-left">
							<label for="fm_disclaimer" id="formfield_8">Disclaimers<span class="fm_optional"></span></label>
						</div>
						<div class="form-cell form-cell-right">
							<div class="row">
								<div class="col-md-10">
									<textarea name="txt1000_dpc_disclaimer" form="punch_card_form" id="fm_disclaimer" data-msg='{"default":"optional","max":1000,"show_counter":"true"}' class="form-control height2"  maxlength="1000" aria-describedby="formfield_8"><?php echo isset($punchCardData['dpc_disclaimer'])? $punchCardData['dpc_disclaimer'] : (isset($_POST['txt1000_dpc_disclaimer'])? $_POST['txt1000_dpc_disclaimer'] : ""); ?></textarea>
									<p><small>(Maximum 1000 characters)</small></p>									
								</div>	
							</div>	
						</div>
					</div>
				</div>
				
		</div>


		<div class="col-lg-3 col-xs-12 right-side-parent">
			<div class="right-side-2">			
				<div class="preview-title">Preview</div>
				<div class="punch_card">
					<div class="punch_card_wrap">								    
					    <div class="punch_card_details">
							<div class="row">
								<div id="punchCardlogoDiv" class="col-sm-12">
									<div class="punch_card_mname_logo">
									
										<div class="punch_card_logo_div">
											<img alt="Marchant Logo" class="punch_card_logo" src="<?php echo $promoFormMerchant->getHeaderImage().'?'.time(); ?>" class="img-responsive"/>
										</div>	
									
										<div class="punch_card_mname">
											<?php echo $promoFormMerchant->callStoreFunction('getCurrent', 'ltm_company_name'); ?>
										</div>
										
									</div>
								</div>
								<div class="col-sm-12">
									<div id="punchCardTitle" class="punch_card_title">
										<?php echo isset($punchCardData['dpc_header'])? $punchCardData['dpc_header'] : "Punch Card Title"; ?>
									</div>									
								</div>	
									
								<div class="col-sm-12">	
								
									<div id="punchCardDesc" class="punch_card_desc">
										<?php echo isset($punchCardData['dpc_intro'])? $punchCardData['dpc_intro'] : "Punch Card Description"; ?>
									</div>
									
									<div class="punch_card_image">	
										<img id="punchCardImage"  src="images/clear_pix.gif" class="img-responsive"/>
									</div>
									<div id="punchCardPunches" class="punch_card_punches"> 	
										
									</div>
								</div>		
							</div>		
						</div>						
						<p class="pin-code-desc">Please, show to the employee at register so they can input your redemption code:</p>
						<div class="pin-code-div">|</div>
					</div>							
					<div class="punch_card_disclaimers">
						<p><strong>Disclaimers: </strong><br><span id="punchCardDisclaimers"><?php echo isset($punchCardData['dpc_disclaimer'])? $punchCardData['dpc_disclaimer'] : "Punch Card Disclaimer"; ?></span></p>
					</div>	
				</div>
			
				<div style="text-align:center;"><button id="submitPunchCard" type="button" class="btn btn-success">Save</button></div>
			</div>	
		</div>
	</div>
</div>

<script>

_scriptObj = {
	confirmIfActiveChanges: <?php echo isset($punchCardData['dpc_active']) && $punchCardData['dpc_active'] == 1 && isset($punchCardData['History']) && !empty($punchCardData['History'])? "1" : "0"; ?>,
	promoImgType: "<?php echo isset($punchCardData['Img_Type'])? $punchCardData['Img_Type'] : (isset($_POST['img128_dpc_image'])? $promoFormMerchant->callStoreFunction('findImageType', $_POST['img128_dpc_image']) : ""); ?>",
	merchantSubDir: "<?php echo $promoFormMerchant->getMerchantSubDir('');?>"
}
</script>
<script src="/mystore/js/promo-form.js"></script>
<script src="/mystore/js/punch-card-form.js"></script>
<?php
include 'inc/myi_footer.php';
?>