<?php
include 'inc/myi_login_check.php'; //check if user is logged in
require_once '../app/function.connect.php'; //global functions, contains include to function that connects to database

$nav_icon_path = 'images/icon-text-msg.svg';
$nav_title = 'Text Messaging';


$sql = 'SELECT lfc_count FROM lt_feature_cnt WHERE lpf_id = 14 AND ltb_id = :ltb_id LIMIT 1';
$q = $dbo->prepare( $sql );
$q->bindValue(':ltb_id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_INT);
$q=execPDO($q);
$q=$q->fetch( PDO::FETCH_ASSOC );
$remaining_sms_texts = intval($q['lfc_count']);


$sql = 'SELECT TMZ.*
FROM lt_member_merchants MMC
INNER JOIN tbl_timezone TMZ ON MMC.tmz_id=TMZ.tmz_id
WHERE MMC.ltb_id = :ltb_id LIMIT 1';
$q = $dbo->prepare( $sql );
$q->bindValue(':ltb_id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_INT);
$q->execute();
$q=$q->fetch( PDO::FETCH_ASSOC );
$current_timezone = array('tmz_id'=>$q['tmz_id'], 'tmz_name'=>$q['tmz_name'], 'tmz_hours_offset'=>$q['tmz_hours_offset']);

$sql = '
SELECT DISTINCT TMS.txt_id, TMS.txt_msg, TMS.txt_date, CSM.csm_first_name, CSM.csm_last_name 
FROM tbl_text2cust T2C 
INNER JOIN tbl_consumer CSM ON T2C.csm_id = CSM.csm_id 
INNER JOIN tbl_text_msgs TMS ON TMS.txt_id = T2C.txt_id
WHERE TMS.ltb_id = :ltb_id ORDER BY TMS.txt_date DESC LIMIT 100';

$qry = $dbo->prepare( $sql );

$qry->bindValue(':ltb_id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_INT);

$qry=execPDO($qry);

$qry = $qry->fetchAll( PDO::FETCH_ASSOC );

$textHistory = array();

$full_textHistory = '';

if(!empty($qry)) {

	foreach ( $qry as $key => $value ) {
		
		if (!isset($textHistory[$value['txt_id']]))	
			$textHistory[$value['txt_id']] = array(
				'txt_id'     => $value['txt_id'],
				'txt_msg'    => $value['txt_msg'],
				'txt_date'   => $value['txt_date'],
				'recipients' => array()
			);
		
		if (!in_array($value['csm_first_name'] . ' ' . $value['csm_last_name'], $textHistory[$value['txt_id']]['recipients']))
			array_push($textHistory[$value['txt_id']]['recipients'], $value['csm_first_name'] .' '. $value['csm_last_name']);        
		
	}

}

foreach ($textHistory as $key => $value) {

	$full_textHistory .= '<tr><td>'.$value['txt_id'].'</td><td><strong>'.$value['txt_msg'].'</strong></td>';

	$full_textHistory .= '<td>';
    
	//echo count($value['recipients']);
    $_i = 0;
	foreach ( $value['recipients'] as $key2 => $value2 ) {
    
		$full_textHistory .= ($_i++ == 0?'':', ') . $value2;		

	}

	$full_textHistory .= '</td>';

	$full_textHistory .= '<td>'.date('M-d-Y h:i A',  strtotime(((int)(($current_timezone['tmz_hours_offset']))>=0?'+' . (int)(($current_timezone['tmz_hours_offset'])): (int)(($current_timezone['tmz_hours_offset']))) . " hours", strtotime($value['txt_date']) ) ).'</td>';

	$full_textHistory .= '</tr>';

}

// --- QUERY POTENTIAL RECIPIENTS --- //

$sql = '
SELECT csm_id, csm_first_name, csm_last_name, csm_cell_number
FROM tbl_consumer 
WHERE ltm_pick_id=:ltm_id 
	AND csm_cell_number IS NOT NULL 
	AND csm_cell_number != "" 
	AND csm_active=1
	AND csm_txt_status=1
ORDER BY csm_id
LIMIT 100'; //

$qry = $dbo->prepare( $sql );

$qry->bindValue(':ltm_id', $_SESSION['user']['merchant']['ltm_id'], PDO::PARAM_INT);

$qry=execPDO($qry);

$qry = $qry->fetchAll( PDO::FETCH_ASSOC );

$recipientList = array();

if(!empty($qry)) {
	//require_once '../app/function.check_txt_status.php'; //check_txt_status($phone,$csm_id);
	foreach ($qry as $value) {
		//$txt_status = check_txt_status($value['csm_cell_number'],$value['csm_id']);
		$recipientList[] .= '<tr><td class="first_col"><label for="'.$value['csm_id'].'"><div class="custom-check unchecked '.$value['csm_id'].'"></div></label><input style="display:none;" type="checkbox" id="'.$value['csm_id'].'" value="'.$value['csm_cell_number'].'_'.$value['csm_id'].'" name="recipient[]"></td><td><label for="'.$value['csm_id'].'">'.$value['csm_first_name'].' '.$value['csm_last_name'].'</label></td></tr>';		
	}
}

include 'inc/myi_header.php';

?>
<style>
   .well{
	   position: relative;
   }
   
   .icon-time, .icon-calendar{
	   cursor: pointer; 
   }
   
   .well input{ padding-left: 30px; }
   
   .add-on{
	   position: absolute !important;
	   left: 30px;
	   top: 54px;
   }
   ul{ -webkit-padding-start: 0 !important;
       padding: 0 !important;}
</style>
<div id='main' class='container'>
	<div class="inner-page-wrap">
		<div class="btn-group " role="group" aria-label="..." >
		  <button type="button" class="mystats_nav_btn btn btn-default" onclick="window.location='messages.php'">In App Messages</button>	
		  <button type="button" class="active mystats_nav_btn btn btn-default" onclick="window.location='text_msg.php'">Text Messages</button>	
		  <a type="button" class="mystats_nav_btn btn btn-default" href="emails.php" target="_blank">Email Campaigns</a>
		</div>
	</div>
	<?php 
		echo '<div id="message_div">';
		if (count($errors)) { 

			echo "<div class='alert alert-danger alert-dismissable'>

			<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>

		      &times;

		    </button>

				<span class='glyphicon glyphicon-exclamation-sign'></span> <strong>Please check the error messages below:</strong><ul>"; 

			foreach($errors as $key => $value) { 

				$error_msg .= '<li>' . $value . '</li>'; 

			} 

			echo $error_msg . "</ul></div>"; 

		}

		if ($_GET['success']) { 

			echo "<div class='alert alert-success alert-dismissable'>

			<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>

		      &times;

		    </button>

				<span class='glyphicon glyphicon-thumbs-up'></span> <strong>Success! Message sent.</strong></div>"; 

		} 
		echo '</div>';
	if(intval($_SESSION['user']['merchant']['plan']['pty_id']) > 1 && count($recipientList)){  ?>
	
	<link href="/plugins/datetimepicker/css/bootstrap-datetimepicker.min.css" rel="stylesheet">	
	
	<script src="/plugins/datetimepicker/js/bootstrap-datetimepicker.min.js"></script>

	<div class='row table-body'>

		<div class='col-md-4 col-sm-12 left-side'>			

			<form method='POST' id='msg_form'>
			
				<div class="side-header-wrap">
			
					<div class="side-header-top">Select Recipients</div>
					
					<div class="side-header-bottom"><table class="table" style="margin: 0; display: flex;"><thead><th class="col-md-1 first_col"><label for="check_toggle" style="margin:0;"><div class="custom-check unchecked check_toggle"></div></label><input type="checkbox" id="check_toggle" class="check_toggle" style="margin:0;display:none;"></th> <th><label for="check_toggle" style="margin:0;">Select All</label></th></thead></table></div>
					
				</div>
					
				<table id='recipients_list' class='table'>
					
					<tbody>

						<?php if ( count( $recipientList ) ) { foreach ( $recipientList as $recipients ){ echo $recipients; } } ?>

					</tbody>

				</table>
				
				<input type='hidden' name='action' id='action_set' value='send_text'>
				
				<label for='msg_content'>Text Message:</label>

				<textarea name='txt138_msg_content_r' id='msg_content' maxlength='' placeholder='' class='form-control'><?php echo $_POST['txt138_msg_content_r']; ?></textarea>

				<div id='msg_character_count'></div><div id="msg_disclaimer">Disclaimer: Reply STOP to end msgs</div>
								
				<label><input name="group1" id="hide-datetime" checked type="radio"> Send this Text Message now</label>
				
				<label><input name="group1" id="show-datetime" type="radio"> Schedule this Text Message for later</label>				
				
				<div class="well" style="display:none;">				  
				  <div id="datetimepicker1" class="input-append date">
				    <label>Select Date and Time</label>					
					<input name="scheduled-time" id="scheduled-time" class="form-control" type="text">
					<span class="add-on">
					  <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
					</span>
				  </div><br>
				  <small><p>Current Time Zone: <span id="current-tz"><?php echo $current_timezone['tmz_name']; ?></span>.<a href="#" class="my-settings-trigger"> Change <span class="glyphicon glyphicon-globe"></span> Time Zone</a></p></small>
				  <input value="<?php echo (-1 * $current_timezone['tmz_hours_offset']); ?>" type="hidden" name="timezone" id="timezone-picker">				  
				</div>
				
				<input type = 'submit' value = 'Send Message' id = 'msg_submit' class = 'form-control btn btn-success'>

			</form>
			
			<?php echo 'You can send up to <span id="remaining_sms">'.number_format($remaining_sms_texts).'</span> text messages this billing period'; ?>
			
		</div>

		<div class='col-md-8 col-sm-12 right-side'>

			<table id='msg_history' class='table table-striped'>

				<thead>

					<tr>

						<th class="col-sm-1">ID</th>

						<th>Message</th>

						<th>Recipients</th>

						<th>Date</th>

					</tr>

				</thead>

				<tbody>

					<?php if (count($textHistory)) { echo $full_textHistory; } ?>

				</tbody>

			</table>

		</div>

	</div><!--end .row-->

<?php } else {

	echo '<div style="padding:20px;">You currently have no eligible recipients. By law, users must opt-in to receive SMS text messages.<br>You may use the <a href="messages.php">In App Messaging</a> feature to get your message to your users or to invite them to opt-in to Text Message Alerts through their "My Account" General Settings tab.</p></div>';

} ?>

</div><!--end #main .container-->

<script src="js/mystore_text_msg-v1.js"></script>

<?php

include 'inc/myi_footer.php';

?>