/*!
 * @copyright Copyright &copy; Kartik Visweswaran, Krajee.com, 2014 - 2015
 * @version 4.1.8
 *
 * File input styled for Bootstrap 3.0 that utilizes HTML5 File Input's advanced 
 * features including the FileReader API. 
 * 
 * The plugin drastically enhances the HTML file input to preview multiple files on the client before
 * upload. In addition it provides the ability to preview content of images, text, videos, audio, html, 
 * flash and other objects. It also offers the ability to upload and delete files using AJAX, and add 
 * files in batches (i.e. preview, append, or remove before upload).
 * 
 * Author: Kartik Visweswaran
 * Copyright: 2015, Kartik Visweswaran, Krajee.com
 * For more JQuery plugins visit http://plugins.krajee.com
 * For more Yii related demos visit http://demos.krajee.com
 */!function(e){"use strict";String.prototype.repl=function(e,i){return this.split(e).join(i)};var i=function(e){var i,t=document.createElement("div");return t.innerHTML="<!--[if IE "+e+"]><i></i><![endif]-->",i=1===t.getElementsByTagName("i").length,document.body.appendChild(t),t.parentNode.removeChild(t),i},t=function(e,i){return i=i||0,"number"==typeof e?e:("string"==typeof e&&(e=parseFloat(e)),isNaN(e)?i:e)},a=function(){return window.File&&window.FileReader},n=function(){var e=document.createElement("div");return!i(9)&&(void 0!==e.draggable||void 0!==e.ondragstart&&void 0!==e.ondrop)},r=function(){return a&&window.FormData},l=function(e,i){e.removeClass(i).addClass(i)},o='style="width:{width};height:{height};"',s='      <param name="controller" value="true" />\n      <param name="allowFullScreen" value="true" />\n      <param name="allowScriptAccess" value="always" />\n      <param name="autoPlay" value="false" />\n      <param name="autoStart" value="false" />\n      <param name="quality" value="high" />\n',d='<div class="file-preview-other">\n       {previewFileIcon}\n   </div>',p={removeIcon:'<i class="glyphicon glyphicon-trash text-danger"></i>',removeClass:"btn btn-xs btn-default",removeTitle:"Remove file",uploadIcon:'<i class="glyphicon glyphicon-upload text-info"></i>',uploadClass:"btn btn-xs btn-default",uploadTitle:"Upload file",indicatorNew:'<i class="glyphicon glyphicon-hand-down text-warning"></i>',indicatorSuccess:'<i class="glyphicon glyphicon-ok-sign file-icon-large text-success"></i>',indicatorError:'<i class="glyphicon glyphicon-exclamation-sign text-danger"></i>',indicatorLoading:'<i class="glyphicon glyphicon-hand-up text-muted"></i>',indicatorNewTitle:"Not uploaded yet",indicatorSuccessTitle:"Uploaded",indicatorErrorTitle:"Upload Error",indicatorLoadingTitle:"Uploading ..."},c='{preview}\n<div class="kv-upload-progress hide"></div>\n<div class="input-group {class}">\n   {caption}\n   <div class="input-group-btn">\n       {remove}\n       {cancel}\n       {upload}\n       {browse}\n   </div>\n</div>',f='{preview}\n<div class="kv-upload-progress hide"></div>\n{remove}\n{cancel}\n{upload}\n{browse}\n',u='<div class="file-preview {class}">\n    <div class="close fileinput-remove">&times;</div>\n    <div class="{dropClass}">\n    <div class="file-preview-thumbnails">\n    </div>\n    <div class="clearfix"></div>    <div class="file-preview-status text-center text-success"></div>\n    <div class="kv-fileinput-error"></div>\n    </div>\n</div>',v='<span class="glyphicon glyphicon-file kv-caption-icon"></span>',h='<div tabindex="-1" class="form-control file-caption {class}">\n   <span class="file-caption-ellipsis">&hellip;</span>\n   <div class="file-caption-name"></div>\n</div>',m='<div id="{id}" class="modal fade">\n  <div class="modal-dialog modal-lg">\n    <div class="modal-content">\n      <div class="modal-header">\n        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\n        <h3 class="modal-title">Detailed Preview <small>{title}</small></h3>\n      </div>\n      <div class="modal-body">\n        <textarea class="form-control" style="font-family:Monaco,Consolas,monospace; height: {height}px;" readonly>{body}</textarea>\n      </div>\n    </div>\n  </div>\n</div>',g='<div class="progress">\n    <div class="{class}" role="progressbar" aria-valuenow="{percent}" aria-valuemin="0" aria-valuemax="100" style="width:{percent}%;">\n        {percent}%\n     </div>\n</div>',w='<div class="file-thumbnail-footer">\n    <div class="file-caption-name">{caption}</div>\n    {actions}\n</div>',b='<div class="file-actions">\n    <div class="file-footer-buttons">\n        {upload}{delete}{other}    </div>\n    <div class="file-upload-indicator" tabindex="-1" title="{indicatorTitle}">{indicator}</div>\n    <div class="clearfix"></div>\n</div>',C='<button type="button" class="kv-file-remove {removeClass}" title="{removeTitle}"{dataUrl}{dataKey}{dataIndex}>{removeIcon}</button>\n',x='<button type="button" class="kv-file-upload {uploadClass}" title="{uploadTitle}">   {uploadIcon}\n</button>\n',y='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}">\n   {content}\n   {footer}\n</div>\n',$='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}">\n    <object data="{data}" type="{type}" width="{width}" height="{height}">\n       '+d+"\n    </object>\n   {footer}\n</div>",k='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}">\n   <img src="{data}" class="file-preview-image" title="{caption}" alt="{caption}" '+o+">\n   {footer}\n</div>\n",T='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}">\n   <div class="file-preview-text" title="{caption}" '+o+">\n       {data}\n   </div>\n   {footer}\n</div>",E='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" '+o+'>\n   <video width="{width}" height="{height}" controls>\n       <source src="{data}" type="{type}">\n       '+d+"\n   </video>\n   {footer}\n</div>\n",F='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" '+o+'>\n   <audio controls>\n       <source src="{data}" type="{type}">\n       '+d+"\n   </audio>\n   {footer}\n</div>",P='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" '+o+'>\n   <object type="application/x-shockwave-flash" width="{width}" height="{height}" data="{data}">\n'+s+"       "+d+"\n   </object>\n   {footer}\n</div>\n",I='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" '+o+'>\n   <object data="{data}" type="{type}" width="{width}" height="{height}">\n       <param name="movie" value="{caption}" />\n'+s+"         "+d+"\n   </object>\n   {footer}\n</div>",D='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" '+o+">\n   "+d+"\n   {footer}\n</div>",S={main1:c,main2:f,preview:u,icon:v,caption:h,modal:m,progress:g,footer:w,actions:b,actionDelete:C,actionUpload:x},U={generic:y,html:$,image:k,text:T,video:E,audio:F,flash:P,object:I,other:D},j=["image","html","text","video","audio","flash","object"],A={image:{width:"auto",height:"160px"},html:{width:"213px",height:"160px"},text:{width:"160px",height:"160px"},video:{width:"213px",height:"160px"},audio:{width:"213px",height:"80px"},flash:{width:"213px",height:"160px"},object:{width:"160px",height:"160px"},other:{width:"160px",height:"160px"}},L={image:function(e,i){return void 0!==e?e.match("image.*"):i.match(/\.(gif|png|jpe?g)$/i)},html:function(e,i){return void 0!==e?"text/html"===e:i.match(/\.(htm|html)$/i)},text:function(e,i){return void 0!==e&&e.match("text.*")||i.match(/\.(txt|md|csv|nfo|php|ini)$/i)},video:function(e,i){return void 0!==e&&e.match(/\.video\/(ogg|mp4|webm)$/i)||i.match(/\.(og?|mp4|webm)$/i)},audio:function(e,i){return void 0!==e&&e.match(/\.audio\/(ogg|mp3|wav)$/i)||i.match(/\.(ogg|mp3|wav)$/i)},flash:function(e,i){return void 0!==e&&"application/x-shockwave-flash"===e||i.match(/\.(swf)$/i)},object:function(){return!0},other:function(){return!0}},O=function(i,t){return null===i||void 0===i||0===i.length||t&&""===e.trim(i)},R=function(e){return Array.isArray(e)||"[object Array]"===Object.prototype.toString.call(e)},z=function(e,i){return"object"==typeof i&&e in i},B=function(i,t,a){return O(i)||O(i[t])?a:e(i[t])},M=function(){return Math.round((new Date).getTime()+100*Math.random())},N=function(e){return String(e).repl("&","&amp;").repl('"',"&quot;").repl("'","&#39;").repl("<","&lt;").repl(">","&gt;")},Z=function(i,t){var a=i;return e.each(t,function(e,i){"function"==typeof i&&(i=i()),a=a.repl(e,i)}),a},_=window.URL||window.webkitURL,q=function(t,n){this.$element=e(t),a()||i(9)?(this.init(n),this.listen()):this.$element.removeClass("file-loading")};q.prototype={constructor:q,init:function(a){var o,s,d=this,c=d.$element;e.each(a,function(e,i){("maxFileCount"===e||"maxFileSize"===e||"initialPreviewCount"===e)&&(d[e]=t(i)),d[e]=i}),d.fileInputCleared=!1,d.fileBatchCompleted=!0,O(d.allowedPreviewTypes)&&(d.allowedPreviewTypes=j),d.uploadFileAttr=O(c.attr("name"))?"file_data":c.attr("name"),d.reader=null,d.formdata={},d.isIE9=i(9),d.isIE10=i(10),d.filestack=[],d.ajaxRequests=[],d.isError=!1,d.dropZoneEnabled=n()&&d.dropZoneEnabled,d.isDisabled=d.$element.attr("disabled")||d.$element.attr("readonly"),d.isUploadable=r&&!O(d.uploadUrl),d.slug="function"==typeof a.slugCallback?a.slugCallback:d.slugDefault,d.mainTemplate=d.getLayoutTemplate(d.showCaption?"main1":"main2"),d.captionTemplate=d.getLayoutTemplate("caption"),d.previewGenericTemplate=d.getPreviewTemplate("generic"),O(d.$element.attr("id"))&&d.$element.attr("id",M()),void 0===d.$container?d.$container=d.createContainer():d.refreshContainer(),d.$progress=d.$container.find(".kv-upload-progress"),d.$btnUpload=d.$container.find(".kv-fileinput-upload"),d.$captionContainer=B(a,"elCaptionContainer",d.$container.find(".file-caption")),d.$caption=B(a,"elCaptionText",d.$container.find(".file-caption-name")),d.$previewContainer=B(a,"elPreviewContainer",d.$container.find(".file-preview")),d.$preview=B(a,"elPreviewImage",d.$container.find(".file-preview-thumbnails")),d.$previewStatus=B(a,"elPreviewStatus",d.$container.find(".file-preview-status")),d.$errorContainer=B(a,"elErrorContainer",d.$previewContainer.find(".kv-fileinput-error")),O(d.msgErrorClass)||l(d.$errorContainer,d.msgErrorClass),d.$errorContainer.hide(),d.initialPreviewContent="",o=d.initialPreview,d.initialPreviewCount=R(o)?o.length:o.length>0?o.split(d.initialPreviewDelimiter).length:0,d.fileActionSettings=e.extend(p,a.fileActionSettings),d.previewInitId="preview-"+M(),d.initPreview(),d.initPreviewDeletes(),d.original={preview:d.$preview.html(),caption:d.$caption.html()},d.options=a,d.setFileDropZoneTitle(),d.uploadCount=0,d.uploadPercent=0,d.$element.removeClass("file-loading"),s=d.getLayoutTemplate("progress"),d.progressTemplate=s.replace("{class}",d.progressClass),d.progressCompleteTemplate=s.replace("{class}",d.progressCompleteClass),d.setEllipsis()},raise:function(e,i){var t=this;void 0!==i?t.$element.trigger(e,i):t.$element.trigger(e)},getLayoutTemplate:function(e){var i=this,t=z(e,i.layoutTemplates)?i.layoutTemplates[e]:S[e];return O(i.customLayoutTags)?t:Z(t,i.customLayoutTags)},getPreviewTemplate:function(e){var i=this,t=z(e,i.previewTemplates)?i.previewTemplates[e]:U[e];return t=t.repl("{previewFileIcon}",i.previewFileIcon),O(i.customPreviewTags)?t:Z(t,i.customPreviewTags)},getOutData:function(e,i,t){var a=this;return e=e||{},i=i||{},t=t||a.filestack.slice(0)||{},{form:a.formdata,files:t,extra:a.getExtraData(),response:i,reader:a.reader,jqXHR:e}},setEllipsis:function(){var e=this,i=e.$captionContainer,t=e.$caption,a=t.clone().css("height","auto").hide();i.parent().before(a),i.removeClass("kv-has-ellipsis"),a.outerWidth()>t.outerWidth()&&i.addClass("kv-has-ellipsis"),a.remove()},listen:function(){var i=this,t=i.$element,a=i.$captionContainer,n=i.$btnFile;t.on("change",e.proxy(i.change,i)),e(window).on("resize",function(){i.setEllipsis()}),n.off("click").on("click",function(){i.raise("filebrowse"),i.isError&&!i.isUploadable&&i.clear(!0),a.focus()}),t.closest("form").off("reset").on("reset",e.proxy(i.reset,i)),i.$container.off("click").on("click",".fileinput-remove:not([disabled])",e.proxy(i.clear,i)).on("click",".fileinput-cancel",e.proxy(i.cancel,i)),i.isUploadable&&i.dropZoneEnabled&&i.showPreview&&i.initDragDrop(),i.isUploadable&&i.$container.find(".kv-fileinput-upload").off("click").on("click",function(t){i.isUploadable&&(t.preventDefault(),!e(this).hasClass("disabled")&&O(e(this).attr("disabled"))&&i.upload())})},setProgress:function(e){var i=this,t=Math.min(e,100),a=100>t?i.progressTemplate:i.progressCompleteTemplate;i.$progress.html(a.repl("{percent}",t))},upload:function(){var i,t,a,n=this,r=n.getFileStack().length,l=!e.isEmptyObject(n.getExtraData());if(n.isUploadable&&!n.isDisabled&&(0!==r||l)){if(n.resetUpload(),n.$progress.removeClass("hide"),n.uploadCount=0,n.uploadPercent=0,n.lock(),n.setProgress(0),0===r&&l)return void n.uploadExtraOnly();if(a=n.filestack.length,!n.uploadAsync&&1!==r||!n.showPreview)n.uploadBatch();else for(t=n.getOutData(),n.raise("filebatchpreupload",[t]),n.fileBatchCompleted=!1,i=0;a>i;i+=1)void 0!==n.filestack[i]&&n.uploadSingle(i,n.filestack,!0)}},lock:function(){var e=this;e.resetErrors(),e.disable(),e.showRemove&&l(e.$container.find(".fileinput-remove"),"hide"),e.showCancel&&e.$container.find(".fileinput-cancel").removeClass("hide"),e.raise("filelock",[e.filestack,e.getExtraData()])},unlock:function(e){var i=this;void 0===e&&(e=!0),i.enable(),i.showCancel&&l(i.$container.find(".fileinput-cancel"),"hide"),i.showRemove&&i.$container.find(".fileinput-remove").removeClass("hide"),e&&i.resetFileStack(),i.raise("fileunlock",[i.filestack,i.getExtraData()])},resetFileStack:function(){var i=this,t=0,a=[];i.$preview.find(".file-preview-frame").each(function(){var n=e(this),r=n.attr("data-fileindex"),l=i.filestack[r];-1!==r&&(void 0!==l?(a[t]=l,n.attr({id:i.previewInitId+"-"+t,"data-fileindex":t}),t+=1):n.attr({id:"uploaded-"+M(),"data-fileindex":"-1"}))}),i.filestack=a},refresh:function(i){var t,a=this,n=a.$element,r=arguments.length?e.extend(a.options,i):a.options;n.off(),a.init(r),t=a.$container.find(".file-drop-zone"),t.off("dragenter dragover drop"),e(document).off("dragenter dragover drop"),a.listen(),a.setFileDropZoneTitle()},initDragDrop:function(){var i=this,t=i.$container.find(".file-drop-zone");t.off("dragenter dragover drop"),e(document).off("dragenter dragover drop"),t.on("dragenter dragover",function(t){t.stopPropagation(),t.preventDefault(),i.isDisabled||l(e(this),"highlighted")}),t.on("dragleave",function(t){t.stopPropagation(),t.preventDefault(),i.isDisabled||e(this).removeClass("highlighted")}),t.on("drop",function(t){t.preventDefault(),i.isDisabled||(i.change(t,"dragdrop"),e(this).removeClass("highlighted"))}),e(document).on("dragenter dragover drop",function(e){e.stopPropagation(),e.preventDefault()})},setFileDropZoneTitle:function(){var e=this,i=e.$container.find(".file-drop-zone");i.find("."+e.dropZoneTitleClass).remove(),e.isUploadable&&e.showPreview&&0!==i.length&&!(e.getFileStack().length>0)&&e.dropZoneEnabled&&(0===i.find(".file-preview-frame").length&&i.prepend('<div class="'+e.dropZoneTitleClass+'">'+e.dropZoneTitle+"</div>"),e.$container.removeClass("file-input-new"),l(e.$container,"file-input-ajax-new"))},initFileActions:function(){var i=this;i.$preview.find(".kv-file-remove").each(function(){var t,a,n=e(this),r=n.closest(".file-preview-frame"),l=r.attr("data-fileindex");n.off("click").on("click",function(){r.fadeOut("slow",function(){i.filestack[l]=void 0,i.clearObjects(r),r.remove(),i.clearFileInput();var e=i.getFileStack(),n=e.length,o=i.$container.find(".file-preview-initial").length;0===n&&0===o?(i.original.preview="",i.reset()):(t=i.initialPreviewCount+n,a=t>1?i.msgSelected.repl("{n}",t):e[0].name,i.setCaption(a))})})}),i.$preview.find(".kv-file-upload").each(function(){var t=e(this);t.off("click").on("click",function(){var e=t.closest(".file-preview-frame"),a=e.attr("data-fileindex");i.uploadSingle(a,i.filestack,!1)})})},renderInitFileFooter:function(e){if(0===this.initialPreviewConfig.length||O(this.initialPreviewConfig[e]))return"";var i=this,t=i.getLayoutTemplate("footer"),a=i.initialPreviewConfig[e],n=z("caption",a)?a.caption:"",r=z("width",a)?a.width:"auto",l=z("url",a)?a.url:!1,o=z("key",a)?a.key:null,s=l===!1,d=i.initialPreviewShowDelete?i.renderFileActions(!1,!0,s,l,o,e):"",p=t.repl("{actions}",d);return p.repl("{caption}",n).repl("{width}",r).repl("{indicator}","").repl("{indicatorTitle}","")},renderFileFooter:function(e,i){var t,a=this,n=a.fileActionSettings,r=a.getLayoutTemplate("footer");return a.isUploadable?(t=r.repl("{actions}",a.renderFileActions(!0,!0,!1,!1,!1,!1)),t.repl("{caption}",e).repl("{width}",i).repl("{indicator}",n.indicatorNew).repl("{indicatorTitle}",n.indicatorNewTitle)):r.repl("{actions}","").repl("{caption}",e).repl("{width}",i).repl("{indicator}","").repl("{indicatorTitle}","")},renderFileActions:function(e,i,t,a,n,r){if(!e&&!i)return"";var l=this,o=a===!1?"":' data-url="'+a+'"',s=r===!1?"":' data-index="'+r+'"',d=n===!1?"":' data-key="'+n+'"',p=l.getLayoutTemplate("actionDelete"),c="",f=l.getLayoutTemplate("actions"),u=l.otherActionButtons.repl("{dataKey}",d),v=l.fileActionSettings,h=t?v.removeClass+" disabled":v.removeClass;return p=p.repl("{removeClass}",h).repl("{removeIcon}",v.removeIcon).repl("{removeTitle}",v.removeTitle).repl("{dataUrl}",o).repl("{dataKey}",d).repl("{dataIndex}",s),e&&(c=l.getLayoutTemplate("actionUpload").repl("{uploadClass}",v.uploadClass).repl("{uploadIcon}",v.uploadIcon).repl("{uploadTitle}",v.uploadTitle)),f.repl("{delete}",p).repl("{upload}",c).repl("{other}",u)},getInitialPreview:function(e,i,t){var a=this,n="init_"+t,r=a.previewInitId+"-"+n,l=a.renderInitFileFooter(t,!1);return e.repl("{previewId}",r).repl("{frameClass}"," file-preview-initial").repl("{fileindex}",n).repl("{content}",i).repl("{footer}",l)},initPreview:function(){var e,i,t=this,a="",n=t.initialPreview,r=t.initialPreviewCount,l=t.initialCaption.length,o=l>0?t.initialCaption:t.msgSelected.repl("{n}",r);if(R(n)&&r>0){for(e=0;r>e;e+=1)a+=t.getInitialPreview(t.previewGenericTemplate,n[e],e);r>1&&0===l&&(o=t.msgSelected.repl("{n}",r))}else{if(!(r>0))return void(l>0&&t.setCaption(o));for(i=n.split(t.initialPreviewDelimiter),e=0;r>e;e+=1)a+=t.getInitialPreview(t.previewGenericTemplate,i[e],e);r>1&&0===l&&(o=t.msgSelected.repl("{n}",r))}t.initialPreviewContent=a,t.$preview.html(a),t.setCaption(o),t.$container.removeClass("file-input-new")},initPreviewDeletes:function(){var i,t,a=this,n=a.deleteExtraData||{},r=function(){0===a.$preview.find(".kv-file-remove").length&&a.reset()};a.$preview.find(".kv-file-remove").each(function(){var o,s,d=e(this),p=d.closest(".file-preview-frame"),c=d.data("index"),f=O(a.initialPreviewConfig[c])?null:a.initialPreviewConfig[c],u=O(f)||O(f.extra)?n:f.extra,v=d.data("url")||a.deleteUrl,h=d.data("key");"function"==typeof u&&(u=u()),void 0!==v&&void 0!==h&&(s=e.extend({url:v,type:"POST",dataType:"json",data:e.extend({key:h},u),beforeSend:function(e){l(p,"file-uploading"),l(d,"disabled"),a.raise("filepredelete",[h,e,u])},success:function(n,l,s){return void 0!==n.error?(a.showError(n.error,u,d.attr("id"),h,"filedeleteerror",s),p.removeClass("file-uploading"),d.removeClass("disabled"),void r()):(a.raise("filedeleted",[h,s,u]),p.removeClass("file-uploading").addClass("file-deleted"),void p.fadeOut("slow",function(){a.clearObjects(p),p.remove(),o=e(document.createElement("div")).html(a.original.preview),o.find(".file-preview-frame").each(function(){t=e(this),t.find(".kv-file-remove").attr("data-key")==h&&t.remove()}),a.initialPreviewContent=o.html(),a.initialPreviewCount>0&&(a.initialPreviewCount-=1),i=a.initialCaption,0===a.initialCaption.length&&(i=a.msgSelected.repl("{n}",a.initialPreviewCount)),a.original.preview=o.html(),a.setCaption(i),a.original.caption=a.$caption.html(),o.remove(),r()}))},error:function(e,i,t){a.showError(t,u,d.attr("id"),h,"filedeleteerror",e),p.removeClass("file-uploading"),r()}},a.ajaxDeleteSettings),d.off("click").on("click",function(){e.ajax(s)}))})},clearObjects:function(i){i.find("video audio").each(function(){this.pause(),e(this).remove()}),i.find("img object div").each(function(){e(this).remove()})},clearFileInput:function(){var i,t,a,n=this,r=n.$element;O(r.val())||(n.isIE9||n.isIE10?(i=r.closest("form"),t=e(document.createElement("form")),a=e(document.createElement("div")),r.before(a),i.length?i.after(t):a.after(t),t.append(r).trigger("reset"),a.before(r).remove(),t.remove()):r.val(""),n.fileInputCleared=!0)},resetUpload:function(){var e=this;e.uploadCount=0,e.uploadPercent=0,e.$btnUpload.removeAttr("disabled"),e.setProgress(0),l(e.$progress,"hide"),e.resetErrors(!1),e.ajaxRequests=[]},cancel:function(){var i,t=this,a=t.ajaxRequests,n=a.length;if(n>0)for(i=0;n>i;i+=1)a[i].abort();t.$preview.find(".file-preview-frame").each(function(){var i=e(this),a=i.attr("data-fileindex");i.removeClass("file-uploading"),void 0!==t.filestack[a]&&(i.find(".kv-file-upload").removeClass("disabled").removeAttr("disabled"),i.find(".kv-file-remove").removeClass("disabled").removeAttr("disabled")),t.unlock()})},clear:function(i){var t,a=this;!a.isIE9&&a.reader instanceof FileReader&&a.reader.abort(),a.$btnUpload.removeAttr("disabled"),a.resetUpload(),a.filestack=[],a.clearFileInput(),a.resetErrors(!0),i!==!0&&(a.raise("change"),a.raise("fileclear")),a.overwriteInitial&&(a.initialPreviewCount=0,a.initialPreviewContent=""),!a.overwriteInitial&&a.initialPreviewContent.length>0?(a.showFileIcon(),a.$preview.html(a.original.preview),a.$caption.html(a.original.caption),a.setEllipsis(),a.initPreviewDeletes(),a.$container.removeClass("file-input-new")):(a.$preview.find(".file-preview-frame").each(function(){a.clearObjects(e(this))}),a.$preview.html(""),t=!a.overwriteInitial&&a.initialCaption.length>0?a.original.caption:"",a.$caption.html(t),a.setEllipsis(),a.$caption.attr("title",""),l(a.$container,"file-input-new")),0===a.$container.find(".file-preview-frame").length&&(a.initialCaption="",a.original.caption="",a.$caption.html(""),a.setEllipsis(),a.$captionContainer.find(".kv-caption-icon").hide()),a.hideFileIcon(),a.raise("filecleared"),a.$captionContainer.focus(),a.setFileDropZoneTitle()},reset:function(){var e=this;e.clear(!0),e.$preview.html(e.original.preview),e.$caption.html(e.original.caption),e.setEllipsis(),e.$container.find(".fileinput-filename").text(""),e.raise("filereset"),e.initialPreview.length>0&&e.$container.removeClass("file-input-new"),e.setFileDropZoneTitle(),e.isUploadable&&e.resetUpload(),e.filestack=[],e.formdata={}},disable:function(){var e=this;e.isDisabled=!0,e.raise("filedisabled"),e.$element.attr("disabled","disabled"),e.$container.find(".kv-fileinput-caption").addClass("file-caption-disabled"),e.$container.find(".btn-file, .fileinput-remove, .kv-fileinput-upload").attr("disabled",!0),e.initDragDrop()},enable:function(){var e=this;e.isDisabled=!1,e.raise("fileenabled"),e.$element.removeAttr("disabled"),e.$container.find(".kv-fileinput-caption").removeClass("file-caption-disabled"),e.$container.find(".btn-file, .fileinput-remove, .kv-fileinput-upload").removeAttr("disabled"),e.initDragDrop()},getExtraData:function(){var e=this,i=e.uploadExtraData;return"function"==typeof e.uploadExtraData&&(i=e.uploadExtraData()),i},uploadExtra:function(){var i=this,t=i.getExtraData();0!==t.length&&e.each(t,function(e,t){i.formdata.append(e,t)})},initXhr:function(e,i){var t=this;return e.upload&&e.upload.addEventListener("progress",function(e){var a=0,n=e.loaded||e.position,r=e.total;e.lengthComputable&&(a=Math.ceil(n/r*i)),t.uploadPercent=Math.max(a,t.uploadPercent),t.setProgress(t.uploadPercent)},!1),e},ajaxSubmit:function(i,t,a,n){var r,l=this;l.uploadExtra(),r=e.extend({xhr:function(){var i=e.ajaxSettings.xhr();return l.initXhr(i,98)},url:l.uploadUrl,type:"POST",dataType:"json",data:l.formdata,cache:!1,processData:!1,contentType:!1,beforeSend:i,success:t,complete:a,error:n},l.ajaxSettings),l.ajaxRequests.push(e.ajax(r))},uploadSingle:function(i,t,a){var n,r,o,s,d,p,c,f,u,v,h,m=this,g=m.getFileStack().length,w=new FormData,b=m.previewInitId+"-"+i,C=e("#"+b),x=C.find(".kv-file-upload"),y=C.find(".kv-file-remove"),$=C.find(".file-upload-indicator"),k=m.fileActionSettings,T=m.filestack.length>0||!e.isEmptyObject(m.uploadExtraData);m.formdata=w,0!==g&&T&&!x.hasClass("disabled")&&(s=function(){var e=m.$preview.find(".file-preview-frame.file-uploading");e.length>0&&m.fileBatchCompleted||(m.setProgress(100),m.unlock(),m.clearFileInput(),m.raise("filebatchuploadcomplete",[m.filestack,m.getExtraData()]),m.fileBatchCompleted=!0)},d=function(e,i){$.html(k[e]),$.attr("title",k[i])},p=function(){!a||0===g||m.uploadPercent>=100||(m.uploadCount+=1,o=80+Math.ceil(20*m.uploadCount/g),m.uploadPercent=Math.max(o,m.uploadPercent),m.setProgress(m.uploadPercent),m.initPreviewDeletes())},c=function(){x.removeAttr("disabled"),y.removeAttr("disabled"),C.removeClass("file-uploading")},f=function(e){n=m.getOutData(e),d("indicatorLoading","indicatorLoadingTitle"),l(C,"file-uploading"),x.attr("disabled",!0),y.attr("disabled",!0),a||m.lock(),m.raise("filepreupload",[n,b,i])},u=function(e,t,r){n=m.getOutData(r,e),setTimeout(function(){void 0===e.error?(d("indicatorSuccess","indicatorSuccessTitle"),x.hide(),y.hide(),m.filestack[i]=void 0,a||m.resetFileStack(),m.raise("fileuploaded",[n,b,i])):(d("indicatorError","indicatorErrorTitle"),m.showUploadError(e.error,n,b,i))},100)},v=function(){setTimeout(function(){p(),c(),a?s():m.unlock(!1)},100)},h=function(e,l,o){d("indicatorError","indicatorErrorTitle"),n=m.getOutData(e),a?(r=t[i].name,m.showUploadError("<b>"+r+"</b>: "+o,n,b,i)):m.showUploadError(o,n,b,i)},w.append(m.uploadFileAttr,t[i]),w.append("file_id",i),m.ajaxSubmit(f,u,v,h))},uploadBatch:function(){var i,t,a,n,r,o,s,d,p=this,c=p.filestack,f=c.length,u=p.filestack.length>0||!e.isEmptyObject(p.uploadExtraData);p.formdata=new FormData,0!==f&&u&&(i=p.fileActionSettings,t=function(t,a,n){var r=e("#"+p.previewInitId+"-"+t).find(".file-upload-indicator");r.html(i[a]),r.attr("title",i[n])},n=function(i){var t=e("#"+p.previewInitId+"-"+i),a=t.find(".kv-file-upload"),n=t.find(".kv-file-delete");t.removeClass("file-uploading"),a.removeAttr("disabled"),n.removeAttr("disabled")},a=function(){e.each(c,function(e){p.filestack[e]=void 0}),p.clearFileInput()},r=function(i){p.lock();var t=p.getOutData(i);p.showPreview&&p.$preview.find(".file-preview-frame").each(function(){var i=e(this),t=i.find(".kv-file-upload"),a=i.find(".kv-file-remove");l(i,"file-uploading"),t.attr("disabled",!0),a.attr("disabled",!0)}),p.raise("filebatchpreupload",[t])},o=function(i,r,l){var o=p.getOutData(l,i),s=O(i.errorkeys)?[]:i.errorkeys;void 0===i.error||O(i.error)?(p.raise("filebatchuploadsuccess",[o]),a(),p.showPreview?(p.$preview.find(".kv-file-upload").hide(),p.$preview.find(".kv-file-remove").hide(),p.$preview.find(".file-preview-frame").each(function(){var i=e(this),a=i.attr("data-fileindex");t(a,"indicatorSuccess","indicatorSuccessTitle"),n(a)})):p.reset()):(p.showPreview&&p.$preview.find(".file-preview-frame").each(function(){var i=e(this),a=parseInt(i.attr("data-fileindex"),10);return n(a),0===s.length?void t(a,"indicatorError","indicatorErrorTitle"):void(-1!==e.inArray(a,s)?t(a,"indicatorError","indicatorErrorTitle"):(i.find(".kv-file-upload").hide(),i.find(".kv-file-remove").hide(),t(a,"indicatorSuccess","indicatorSuccessTitle"),p.filestack[a]=void 0))}),p.showUploadError(i.error,o,null,null,"filebatchuploaderror"))},s=function(){p.setProgress(100),p.unlock(),p.raise("filebatchuploadcomplete",[p.filestack,p.getExtraData()]),p.clearFileInput()},d=function(i,a,n){var r=p.getOutData(i);p.showUploadError(n,r,null,null,"filebatchuploaderror"),p.uploadFileCount=f-1,p.showPreview&&(p.$preview.find(".file-preview-frame").each(function(){var i=e(this),a=i.attr("data-fileindex");i.removeClass("file-uploading"),void 0!==p.filestack[a]&&t(a,"indicatorError","indicatorErrorTitle")}),p.$preview.find(".file-preview-frame").removeClass("file-uploading"),p.$preview.find(".file-preview-frame kv-file-upload").removeAttr("disabled"),p.$preview.find(".file-preview-frame kv-file-delete").removeAttr("disabled"))},e.each(c,function(e,i){O(c[e])||p.formdata.append(p.uploadFileAttr,i)}),p.ajaxSubmit(r,o,s,d))},uploadExtraOnly:function(){var e,i,t,a,n=this;n.formdata=new FormData,e=function(e){n.lock();var i=n.getOutData(e);n.raise("filebatchpreupload",[i]),n.setProgress(50)},i=function(e,i,t){{var a=n.getOutData(t,e);O(e.errorkeys)?[]:e.errorkeys}void 0===e.error||O(e.error)?(n.raise("filebatchuploadsuccess",[a]),n.clearFileInput()):n.showUploadError(e.error,a,null,null,"filebatchuploaderror")},t=function(){n.setProgress(100),n.unlock(),n.raise("filebatchuploadcomplete",[n.filestack,n.getExtraData()]),n.clearFileInput()},a=function(e,i,t){var a=n.getOutData(e);n.showUploadError(t,a,null,null,"filebatchuploaderror")},n.ajaxSubmit(e,i,t,a)},hideFileIcon:function(){this.overwriteInitial&&this.$captionContainer.find(".kv-caption-icon").hide()},showFileIcon:function(){this.$captionContainer.find(".kv-caption-icon").show()},resetErrors:function(e){var i=this,t=i.$errorContainer;i.isError=!1,i.$container.removeClass("has-error"),t.html(""),e?t.fadeOut("slow"):t.hide()},showUploadError:function(e,i,t,a,n){var r=this,o=r.$errorContainer;return n=n||"fileuploaderror",0===o.find("ul").length?o.html('<ul class="text-left"><li>'+e+"</li></ul>"):o.find("ul").append("<li>"+e+"</li>"),o.fadeIn(800),r.raise(n,[i,t,a,r.reader]),l(r.$container,"has-error"),!0},showError:function(e,i,t,a,n,r){var o=this,s=o.$errorContainer;return n=n||"fileerror",r=r||{},s.html(e),s.fadeIn(800),o.raise(n,[i,t,a,o.reader,r]),o.isUploadable||o.clearFileInput(),l(o.$container,"has-error"),o.$btnUpload.attr("disabled",!0),!0},errorHandler:function(e,i){var t=this,a=e.target.error;switch(a.code){case a.NOT_FOUND_ERR:t.addError(t.msgFileNotFound.repl("{name}",i));break;case a.SECURITY_ERR:t.addError(t.msgFileSecured.repl("{name}",i));break;case a.NOT_READABLE_ERR:t.addError(t.msgFileNotReadable.repl("{name}",i));break;case a.ABORT_ERR:t.addError(t.msgFilePreviewAborted.repl("{name}",i));break;default:t.addError(t.msgFilePreviewError.repl("{name}",i))}},parseFileType:function(e){var i,t,a,n,r=this;for(n=0;n<j.length;n+=1)if(a=j[n],i=z(a,r.fileTypeSettings)?r.fileTypeSettings[a]:L[a],t=i(e.type,e.name)?a:"",!O(t))return t;return"other"},previewDefault:function(i,t,a){if(this.showPreview){var n=this,r=_.createObjectURL(i),l=e("#"+t),o=n.previewSettings.other,s=n.renderFileFooter(i.name,o.width),d=n.getPreviewTemplate("other"),p=t.slice(t.lastIndexOf("-")+1),c="";a===!0&&(c=" btn disabled",s+='<div class="file-other-error text-danger"><i class="glyphicon glyphicon-exclamation-sign"></i></div>'),n.$preview.append("\n"+d.repl("{previewId}",t).repl("{frameClass}",c).repl("{fileindex}",p).repl("{caption}",n.slug(i.name)).repl("{width}",o.width).repl("{height}",o.height).repl("{type}",i.type).repl("{data}",r).repl("{footer}",s)),l.on("load",function(){_.revokeObjectURL(l.attr("data"))})}},previewFile:function(e,i,t,a){if(this.showPreview){var n,r,l,o,s=this,d=s.parseFileType(e),p=s.slug(e.name),c=s.allowedPreviewTypes,f=s.allowedPreviewMimeTypes,u=s.getPreviewTemplate(d),v=z(d,s.previewSettings)?s.previewSettings[d]:A[d],h=parseInt(s.wrapTextLength,10),m=s.wrapIndicator,g=c.indexOf(d)>=0,w=O(f)||!O(f)&&z(e.type,f),b=s.renderFileFooter(p,v.width),C="",x=t.slice(t.lastIndexOf("-")+1);g&&w?("text"===d?(r=N(i.target.result),_.revokeObjectURL(a),r.length>h&&(l="text-"+M(),o=.75*window.innerHeight,C=s.getLayoutTemplate("modal").repl("{id}",l).repl("{title}",p).repl("{height}",o).repl("{body}",r),m=m.repl("{title}",p).repl("{dialog}","$('#"+l+"').modal('show')"),r=r.substring(0,h-1)+m),n=u.repl("{previewId}",t).repl("{caption}",p).repl("{frameClass}","").repl("{type}",e.type).repl("{width}",v.width).repl("{height}",v.height).repl("{data}",r).repl("{footer}",b).repl("{fileindex}",x)+C):n=u.repl("{previewId}",t).repl("{caption}",p).repl("{frameClass}","").repl("{type}",e.type).repl("{data}",a).repl("{width}",v.width).repl("{height}",v.height).repl("{footer}",b).repl("{fileindex}",x),s.$preview.append("\n"+n),s.autoSizeImage(t)):s.previewDefault(e,t)}},slugDefault:function(e){return O(e)?"":e.split(/(\\|\/)/g).pop().replace(/[^\w\-.\\\/ ]+/g,"")},getFileStack:function(){var e=this;return e.filestack.filter(function(e){return void 0!==e})},readFiles:function(e){function i(h){if(O(a.attr("multiple"))&&(c=1),h>=c)return l.removeClass("loading"),void o.html("");var m,g,w,b,C,x,y=u+h,$=p+"-"+y,k=e[h],T=t.slug(k.name),E=(k.size||0)/1e3,F="",P=_.createObjectURL(k),I=0,D=t.allowedFileTypes,S=O(D)?"":D.join(", "),U=t.allowedFileExtensions,j=O(U)?"":U.join(", ");
if(O(U)||(F=new RegExp("\\.("+U.join("|")+")$","i")),E=E.toFixed(2),t.maxFileSize>0&&E>t.maxFileSize)return b=t.msgSizeTooLarge.repl("{name}",T).repl("{size}",E).repl("{maxSize}",t.maxFileSize),void(t.isError=v(b,k,$,h));if(!O(D)&&R(D)){for(w=0;w<D.length;w+=1)C=D[w],g=f[C],x=void 0!==g&&g(k.type,T),I+=O(x)?0:x.length;if(0===I)return b=t.msgInvalidFileType.repl("{name}",T).repl("{types}",S),void(t.isError=v(b,k,$,h))}return 0!==I||O(U)||!R(U)||O(F)||(x=T.match(F),I+=O(x)?0:x.length,0!==I)?t.showPreview?(n.length>0&&void 0!==FileReader?(o.html(s.repl("{index}",h+1).repl("{files}",c)),l.addClass("loading"),r.onerror=function(e){t.errorHandler(e,T)},r.onload=function(e){t.previewFile(k,e,$,P),t.initFileActions()},r.onloadend=function(){b=d.repl("{index}",h+1).repl("{files}",c).repl("{percent}",50).repl("{name}",T),setTimeout(function(){o.html(b),_.revokeObjectURL(P)},100),setTimeout(function(){i(h+1),t.updateFileDetails(c)},100),t.raise("fileloaded",[k,$,h,r])},r.onprogress=function(e){if(e.lengthComputable){var i=e.loaded/e.total*100,t=Math.ceil(i);b=d.repl("{index}",h+1).repl("{files}",c).repl("{percent}",t).repl("{name}",T),setTimeout(function(){o.html(b)},100)}},m=z("text",f)?f.text:L.text,m(k.type,T)?r.readAsText(k,t.textEncoding):r.readAsArrayBuffer(k)):(t.previewDefault(k,$),setTimeout(function(){i(h+1),t.updateFileDetails(c)},100),t.raise("fileloaded",[k,$,h,r])),void t.filestack.push(k)):(t.filestack.push(k),setTimeout(i(h+1),100),void t.raise("fileloaded",[k,$,h,r])):(b=t.msgInvalidFileExtension.repl("{name}",T).repl("{extensions}",j),void(t.isError=v(b,k,$,h)))}this.reader=new FileReader;var t=this,a=t.$element,n=t.$preview,r=t.reader,l=t.$previewContainer,o=t.$previewStatus,s=t.msgLoading,d=t.msgProgress,p=t.previewInitId,c=e.length,f=t.fileTypeSettings,u=t.filestack.length,v=function(i,a,n,r){t.previewDefault(a,n,!0);var l=t.getOutData({},{},e);return t.isUploadable?t.showUploadError(i,l,n,r):t.showError(i,a,n,r)};i(0),t.updateFileDetails(c,!1)},updateFileDetails:function(e){var i=this,t=i.msgSelected,a=i.$element,n=i.getFileStack(),r=a.val()||n.length&&n[0].name||"",l=i.slug(r),o=i.isUploadable?n.length:e,s=i.initialPreviewCount+o,d=o>1?t.repl("{n}",s):l;i.isError?(i.$previewContainer.removeClass("loading"),i.$previewStatus.html(""),i.$captionContainer.find(".kv-caption-icon").hide(),d=i.msgValidationError):i.showFileIcon(),i.setCaption(d),i.$container.removeClass("file-input-new file-input-ajax-new"),1===arguments.length&&i.raise("fileselect",[e,l]),i.initialPreviewContent.length>0&&i.initPreviewDeletes()},change:function(e){var i=this,t=i.$element;if(!i.isUploadable&&O(t.val())&&i.fileInputCleared)return void(i.fileInputCleared=!1);i.fileInputCleared=!1;var a,n,r,l=i.$preview,o=arguments.length>1,s=o?e.originalEvent.dataTransfer.files:t.get(0).files,d=O(t.attr("multiple")),p=i.filestack.length,c=i.isUploadable&&0!==p,f=function(e,t,a,n){var r=i.getOutData({},{},s);return i.isUploadable?i.showUploadError(e,r,a,n):i.showError(e,t,a,n)};return i.resetUpload(),i.hideFileIcon(),i.isUploadable&&i.$container.find(".file-drop-zone ."+i.dropZoneTitleClass).remove(),a=o?s:void 0===e.target.files?e.target&&e.target.value?[{name:e.target.value.replace(/^.+\\/,"")}]:[]:e.target.files,O(a)||0===a.length?(c||i.clear(!0),void i.raise("fileselectnone")):(i.resetErrors(),(!c||d&&p>0)&&(i.overwriteInitial?l.html(""):(l.html(i.initialPreviewContent),i.initialPreviewContent.length>0&&i.initPreviewDeletes()),d&&p>0&&(i.filestack=[])),r=i.isUploadable?i.getFileStack().length+a.length:a.length,i.maxFileCount>0&&r>i.maxFileCount?(n=i.msgFilesTooMany.repl("{m}",i.maxFileCount).repl("{n}",r),i.isError=f(n,null,null,null),i.$captionContainer.find(".kv-caption-icon").hide(),i.$caption.html(i.msgValidationError),i.setEllipsis(),void i.$container.removeClass("file-input-new file-input-ajax-new")):(i.isIE9?i.updateFileDetails(1):i.readFiles(a),c?i.raise("filebatchselected",[i.getFileStack()]):i.raise("filebatchselected",[a]),void(i.reader=null)))},autoSizeImage:function(e){var i,t,a,n=this,r=n.$preview,l=r.find("#"+e),o=l.find("img");o.length&&o.on("load",function(){i=l.width(),t=r.width(),i>t&&(o.css("width","100%"),l.css("width","97%")),a=o.closest(".file-preview-frame").find(".file-caption-name"),a.length&&(a.width(o.width()),a.attr("title",a.text())),n.raise("fileimageloaded",e)})},setCaption:function(i){var t=this,a=e("<div>"+i+"</div>").text(),n=t.getLayoutTemplate("icon"),r=n+a;0!==t.$caption.length&&(t.$caption.html(r),t.$caption.attr("title",a),t.$captionContainer.find(".file-caption-ellipsis").attr("title",a),t.setEllipsis())},initBrowse:function(e){var i=this;i.$btnFile=e.find(".btn-file"),i.$btnFile.append(i.$element)},createContainer:function(){var i=this,t=e(document.createElement("span")).attr({"class":"file-input file-input-new"}).html(i.renderMain());return i.$element.before(t),i.initBrowse(t),t},refreshContainer:function(){var e=this,i=e.$container;i.before(e.$element),i.html(e.renderMain()),e.initBrowse(i)},renderMain:function(){var e=this,i=e.isUploadable&&e.dropZoneEnabled?" file-drop-zone":"",t=e.showPreview?e.getLayoutTemplate("preview").repl("{class}",e.previewClass).repl("{dropClass}",i):"",a=e.isDisabled?e.captionClass+" file-caption-disabled":e.captionClass,n=e.captionTemplate.repl("{class}",a+" kv-fileinput-caption");return e.mainTemplate.repl("{class}",e.mainClass).repl("{preview}",t).repl("{caption}",n).repl("{upload}",e.renderUpload()).repl("{remove}",e.renderRemove()).repl("{cancel}",e.renderCancel()).repl("{browse}",e.renderBrowse())},renderBrowse:function(){var e=this,i=e.browseClass+" btn-file",t="";return e.isDisabled&&(t=" disabled "),'<div class="'+i+'"'+t+"> "+e.browseIcon+e.browseLabel+" </div>"},renderRemove:function(){var e=this,i=e.removeClass+" fileinput-remove fileinput-remove-button",t="";return e.showRemove?(e.isDisabled&&(t=" disabled "),'<button type="button" title="'+e.removeTitle+'" class="'+i+'"'+t+">"+e.removeIcon+e.removeLabel+"</button>"):""},renderCancel:function(){var e=this,i=e.cancelClass+" fileinput-cancel fileinput-cancel-button";return e.showCancel?'<button type="button" title="'+e.cancelTitle+'" class="hide '+i+'">'+e.cancelIcon+e.cancelLabel+"</button>":""},renderUpload:function(){var e=this,i=e.uploadClass+" kv-fileinput-upload fileinput-upload-button",t="",a="";return e.showUpload?(e.isDisabled&&(a=" disabled "),t=!e.isUploadable||e.isDisabled?'<button type="submit" title="'+e.uploadTitle+'"class="'+i+'"'+a+">"+e.uploadIcon+e.uploadLabel+"</button>":'<a href="'+e.uploadUrl+'" title="'+e.uploadTitle+'" class="'+i+'"'+a+">"+e.uploadIcon+e.uploadLabel+"</a>"):""}},e.fn.fileinput=function(t){if(a()||i(9)){var n=Array.apply(null,arguments);return n.shift(),this.each(function(){var i=e(this),a=i.data("fileinput"),r="object"==typeof t&&t;a||(a=new q(this,e.extend({},e.fn.fileinput.defaults,r,e(this).data())),i.data("fileinput",a)),"string"==typeof t&&a[t].apply(a,n)})}},e.fn.fileinput.defaults={showCaption:!0,showPreview:!0,showRemove:!0,showUpload:!0,showCancel:!0,mainClass:"",previewClass:"",captionClass:"",mainTemplate:null,initialCaption:"",initialPreview:"",initialPreviewCount:0,initialPreviewDelimiter:"*$$*",initialPreviewConfig:[],initialPreviewShowDelete:!0,deleteUrl:"",deleteExtraData:{},overwriteInitial:!0,layoutTemplates:S,previewTemplates:U,allowedPreviewTypes:j,allowedPreviewMimeTypes:null,allowedFileTypes:null,allowedFileExtensions:null,customLayoutTags:{},customPreviewTags:{},previewSettings:A,fileTypeSettings:L,previewFileIcon:'<i class="glyphicon glyphicon-file"></i>',browseLabel:"Browse &hellip;",browseIcon:'<i class="glyphicon glyphicon-folder-open"></i> &nbsp;',browseClass:"btn btn-primary",removeLabel:"Remove",removeTitle:"Clear selected files",removeIcon:'<i class="glyphicon glyphicon-trash"></i> ',removeClass:"btn btn-default",cancelLabel:"Cancel",cancelTitle:"Abort ongoing upload",cancelIcon:'<i class="glyphicon glyphicon-ban-circle"></i> ',cancelClass:"btn btn-default",uploadLabel:"Upload",uploadTitle:"Upload selected files",uploadIcon:'<i class="glyphicon glyphicon-upload"></i> ',uploadClass:"btn btn-default",uploadUrl:null,uploadAsync:!0,uploadExtraData:{},maxFileSize:0,maxFileCount:0,msgSizeTooLarge:'File "{name}" (<b>{size} KB</b>) exceeds maximum allowed upload size of <b>{maxSize} KB</b>. Please retry your upload!',msgFilesTooMany:"Number of files selected for upload <b>({n})</b> exceeds maximum allowed limit of <b>{m}</b>. Please retry your upload!",msgFileNotFound:'File "{name}" not found!',msgFileSecured:'Security restrictions prevent reading the file "{name}".',msgFileNotReadable:'File "{name}" is not readable.',msgFilePreviewAborted:'File preview aborted for "{name}".',msgFilePreviewError:'An error occurred while reading the file "{name}".',msgInvalidFileType:'Invalid type for file "{name}". Only "{types}" files are supported.',msgInvalidFileExtension:'Invalid extension for file "{name}". Only "{extensions}" files are supported.',msgValidationError:'<span class="text-danger"><i class="glyphicon glyphicon-exclamation-sign"></i> File Upload Error</span>',msgErrorClass:"file-error-message",msgLoading:"Loading  file {index} of {files} &hellip;",msgProgress:"Loading file {index} of {files} - {name} - {percent}% completed.",msgSelected:"{n} files selected",progressClass:"progress-bar progress-bar-success progress-bar-striped active",progressCompleteClass:"progress-bar progress-bar-success",previewFileType:"image",wrapTextLength:250,wrapIndicator:' <span class="wrap-indicator" title="{title}" onclick="{dialog}">[&hellip;]</span>',elCaptionContainer:null,elCaptionText:null,elPreviewContainer:null,elPreviewImage:null,elPreviewStatus:null,elErrorContainer:null,slugCallback:null,dropZoneEnabled:!0,dropZoneTitle:"Drag & drop files here &hellip;",dropZoneTitleClass:"file-drop-zone-title",fileActionSettings:{},otherActionButtons:"",textEncoding:"UTF-8",ajaxSettings:{},ajaxDeleteSettings:{}},e.fn.fileinput.Constructor=q,e(document).ready(function(){var i=e("input.file[type=file]"),t=i.attr("type")?i.length:0;t>0&&i.fileinput()})}(window.jQuery);