/*global define*/
define(['lodash', 'metadata'], function(_, metadata) {

  function getDetectObjByAmdPath(amdPath) {
    return _.find(metadata, function (detect) {
      return detect.amdPath == amdPath || detect.amdPath == 'test/' + amdPath;
    });
  }

  return function generateBuildHash(config) {
    // Format:
    // #-<prop1>-<prop2>-…-<propN>-<option1>-<option2>-…<optionN>[-dontmin][-cssclassprefix:<prefix>]
    // where prop1…N and option1…N are sorted alphabetically (for consistency)
    var setClasses = false;
    var dontmin = !config.minify;

    // Config uses amdPaths, but build hash uses property names
    var props = _.map(config['feature-detects'], function (amdPath) {
      var detect = getDetectObjByAmdPath(amdPath);
      var property = detect && detect.property;
      property = _.isArray(property) ?
        property.join('_').replace('-', '_') :
        property.replace('-', '_');
      return property;
    });

    // Config uses amdPaths, but the option's just use their names.
    // A few of the values have to be massaged in order to match
    // the `value`
    var opts = _.map(config.options, function (opt) {
      if (opt == 'setClasses') {
        setClasses = true;
        return 'cssclasses';
      }
      if (opt.indexOf('html5') === 0) {
        opt = opt.replace('html5','');
      }
      return opt.toLowerCase();
    });

    var sortedProps = props.sort();
    var sortedOpts = opts.sort();

    // Options are AMD paths in the config, but need to be converted to
    var buildHash = '#-' + sortedProps.concat(sortedOpts).join('-') +
        ( dontmin ? '-dontmin' : '' ) +
        ( (setClasses && config.classPrefix) ?
          '-cssclassprefix:' + config.classPrefix : '' );

    return buildHash;
  };
});
