<?php 
namespace App\Reseller\DiscountCode {
	require_once $_SERVER['DOCUMENT_ROOT']."/app/class.discount-code.php";
	require_once $_SERVER['DOCUMENT_ROOT']."/app/class.variables.php";
	
	use App\DiscountCode as DiscountCode;
	
	class ResellerDiscountCode extends DiscountCode\DiscountCode {
		private $mDbo;
		private $discountCode;

		function validateDiscountCode() {

			// $codeObj = $this->discountCode;

			if (!$this->discountCode->dsc_code){
				// promo code does not exist
				return false;
			}
			else {
				// check quantity
				$this->discountCode->hasQuantity = $this->hasQuantity();

				// check for expired
				$this->discountCode->hasNotExpired = $this->hasNotExpired();

				// check for belongs to reseller
				$this->discountCode->hasValidReseller = $this->hasValidReseller();

				if ($this->discountCode->hasQuantity && $this->discountCode->hasNotExpired && $this->discountCode->hasValidReseller){
					return true;
				} else {
					return false;
				}
			}
		}

		function hasQuantity(){
			if ($this->discountCode->dsc_quantity > 0 || is_null($this->discountCode->dsc_quantity)){
				return true;
			} 
			else {
				return false;
			}
		}

		function hasNotExpired(){
			if ($this->discountCode->dsc_expire_date > date("Y-m-d") || is_null($this->discountCode->dsc_expire_date)){
				return true;
			} 
			else {
				return false;
			}
		}

		function hasValidReseller(){
			if ($this->discountCode->res_id == $_SESSION['reseller']['id']){
				return true;
			}
			else {
				return false;
			}
		}

		function getDiscountId(){
			if (!empty($this->discountCode->dsc_id)){
				return $this->discountCode->dsc_id;
			}
			return null;
		}

		function getDiscountSetupFee($planSetupFee){
			if (!empty($this->discountCode->dsc_setup_fee)){
				$discountSetupFee = $this->discountCode->dsc_setup_fee;
				return ($discountSetupFee < $planSetupFee ? $discountSetupFee : $planSetupFee);
			}
			return $planSetupFee;
		}

		function getDiscountEndDate(){
			if (!empty($this->discountCode->dsc_discount_months)){
				$numOfMonths = $this->discountCode->dsc_discount_months;
				$date = new \DateTime("+".$numOfMonths." months");
				$date = $date->format('Y-m-d');
				return $date;
			}
			return null;
		}

		function getDiscountMonthlyFee($planMonthlyFee){
			
			if (!empty($this->discountCode->dsc_monthly_percent_off)){
				$percentOff = $this->discountCode->dsc_monthly_percent_off;
				return round($planMonthlyFee * ((100 - $percentOff) / 100), 2);
			}

			if (!empty($this->discountCode->dsc_monthly_dollar_off)){
				$dollarOff = $this->discountCode->dsc_monthly_dollar_off;
				return round($planMonthlyFee - $dollarOff);
			}

			return null;
		}

		function getDiscountLengthMonths(){
			if (!empty($this->discountCode->dsc_discount_months)){
				return $this->discountCode->dsc_discount_months;
			}
			return null;
		}

		function getDiscountCode(){
			if (!empty($this->discountCode->dsc_code)){
				return $this->discountCode->dsc_code;
			}
			return null;
		}

		function getDiscountCodeObject($discountCode){
			$sql = 'SELECT * FROM tbl_discount_code DSC WHERE dsc_code = :dsc_code LIMIT 1';
			$qry = $this->mDbo->prepare($sql);
			$qry->bindValue( ':dsc_code', $discountCode, \PDO::PARAM_STR );
			$qry->execute();
			$codeObj = $qry->fetch(\PDO::FETCH_OBJ);

			return $codeObj;
		}

		function __construct( $dbObj, $discountCode ) {
			$this->mDbo=$dbObj;
			$this->discountCode = $this->getDiscountCodeObject($discountCode);
 		}
	}	
}

?>