<?php 
 namespace App\Reseller {
 	require_once $_SERVER['DOCUMENT_ROOT']."/app/class.variables.php";
	
 	class Reseller {
 		private $mDbo;
		private $currentResId = 0;
		private $resellerRecords = array();
		
 		private function loadRecords($res_id){

			 $sql = '
			  SELECT RES.*, RSW.rss_id, RSW.rss_name
			  FROM tbl_reseller	RES		  
			  LEFT JOIN tbl_reseller2switch R2S ON R2S.res_id = RES.res_id
			  LEFT JOIN tbl_reseller_switches RSW ON RSW.rss_id = R2S.rss_id
			  WHERE RES.res_id=:res_id';
			  $qry = $this->mDbo->prepare( $sql );
			  $qry->bindValue(':res_id', $res_id, \PDO::PARAM_INT);			  
			  $qry->execute();
			  
			  while ( $resulSet = $qry->fetch( \PDO::FETCH_ASSOC ) ) {				
				if ( !isset( $this->resellerRecords[$resulSet['res_id']] ) ) {
					$tmpArr = $resulSet;
					unset($resulSet['rss_id'], $resulSet['rss_name']);
					$this->resellerRecords[$resulSet['res_id']] = $resulSet;
					$this->resellerRecords[$resulSet['res_id']]['Switches'][$tmpArr['rss_id']] = $tmpArr['rss_name'];
				}
				else {
					if ( !$this->hasSwitch ( $resulSet['rss_id'] ) )
						$this->resellerRecords[$resulSet['res_id']]['Switches'][$resulSet['rss_id']] = $resulSet['rss_name'];
				}
			  }
			  if (empty($this->currentResId)) $this->currentResId = $res_id;
			  
 		}

 		protected function validData(&$cleanData, $fieldValue, $fieldName='wnu_res_id_r' ){
 			$_tempArr[$fieldName] = $fieldValue;
 			$cv= new \_variables($_tempArr); // new instance
 			$cv_array=array($fieldName); //list all varibles to be check in array
 			foreach($cv_array as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop
 			$clean=$cv->get_cleaned_variables();
 			$errors=$cv->get_bad_variables();
 			if (!count($errors)) {
 				$cleanData = $clean;
 				return true;								
 			} 			
 			return false;
		}
		
		function getFieldValue ($fieldName) {
			if (isset($this->resellerRecords[$this->currentResId][$fieldName])) {
				return $this->resellerRecords[$this->currentResId][$fieldName];
			}
			return '';
		}
		
		function hasSwitch ($switchId = null, $switchName = null) {
			
			if ($switchId !== null)
				return isset($this->resellerRecords[$this->currentResId]['Switches'][$switchId]);
			elseif ($switchName !== null) 
				return is_array($this->resellerRecords[$this->currentResId]['Switches']) && in_array($switchName, $this->resellerRecords[$this->currentResId]['Switches']);
			return false;	
		}
		
		function saveDbFile($resId, $fileDbName, $fileDbDesc) {
		    $_tempArr['nam_rdc_name_r'] = $fileDbName;
			$_tempArr['wnu_res_id_r'] = $resId;
			$_tempArr['wnu_rdc_description_r'] = $fileDbDesc;
			$cv= new \_variables($_tempArr); // new instance
			$cv_array=array($fieldName); //list all varibles to be check in array
			foreach($cv_array as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop
			$clean=$cv->get_cleaned_variables();
			$errors=$cv->get_bad_variables();
			if (!count($errors)) {	
				$sql = 'INSERT INTO tbl_reseller_docs (res_id, rdc_name, rdc_description) VALUES (:res_id, :rdc_name, :rdc_description)';
			  $qry = $this->mDbo->prepare( $sql );
			  $qry->bindValue(':res_id', $clean['res_id'], \PDO::PARAM_INT);
			  $qry->bindValue(':rdc_name', $clean['rdc_name'], \PDO::PARAM_STR);
			  $qry->bindValue(':rdc_description', $clean['rdc_description'], \PDO::PARAM_STR);
			  
			  $qry->execute();
			  $qry = $this->mDbo->lastInsertId(); 
			  
			  if($qry){
				return $qry;
			  }
			}
		    return 0;
		}
		
		function getPlans($res_id, $pty_id){
		  $sql = 'SELECT LMP.lmp_id, LMP.lmp_name, LMP.lmp_admin_name, LMP.pty_id, LMP.lmp_price, LMP.lmp_fee, LMP.lmp_billing_delay,
		  LMP.lmp_description, LMP.lmp_custom_terms, LMP.lmp_custom_breakdown, LMP.pty_id, LMP.lmp_featured, LPF.lpf_feature, LPF.lpf_id, MFC.mfc_count
		  FROM lt_merchant_plans LMP
		  INNER JOIN lt_plans2reseller P2R ON LMP.lmp_id = P2R.lmp_id
		  INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id
		  LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id
		  WHERE P2R.res_id = :res_id AND LMP.pty_id = :pty_id AND LMP.lmp_active = 1 AND LPF.lpf_active = 1 AND MFC.ltb_id IS NULL ORDER BY LMP.lmp_price ASC';
		  $qry = $this->mDbo->prepare( $sql );
		  $qry->bindValue(':res_id', $res_id, \PDO::PARAM_INT);
		  $qry->bindValue(':pty_id', $pty_id, \PDO::PARAM_INT);
		  $qry->execute();
		  $qry = $qry->fetchAll(\PDO::FETCH_ASSOC);
		  if(empty($qry)){
			// set array to avoid errors
			$results = array();
		  }
		  else {
			foreach ($qry as $k => $v) {
			  if (!$results[$v['lmp_id']]){
				$results[$v['lmp_id']] = array(
				  'lmp_id'                => $v['lmp_id'],
				  'pty_id'                => $v['pty_id'],
				  'lmp_name'              => $v['lmp_name'],
				  'lmp_price'             => $v['lmp_price'],
				  'lmp_fee'               => $v['lmp_fee'],
				  'lmp_billing_delay'     => $v['lmp_billing_delay'],
				  'lmp_description'       => $v['lmp_description'],
				  'lmp_custom_terms'      => $v['lmp_custom_terms'],
				  'lmp_featured'          => $v['lmp_featured'],
				  'lmp_custom_breakdown'  => $v['lmp_custom_breakdown'],
				  'lmp_features'          => array(array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']))
				);
				if ($v['lmp_price'] == 0 && $v['pty_id'] > 1) {
				  $results[$v['lmp_id']]['lmp_no_price'] = 1;
				}
			  }
			  else {
				$next_feature = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
				array_push($results[$v['lmp_id']]['lmp_features'], $next_feature);
			  }
			}
		  }
		  return $results;
		}
		
		function getPlansFromId($res_id, $lmp_id){
          $results = array();		  
		  
		  if (is_numeric($lmp_id) && is_numeric($res_id) && intval($lmp_id) && intval($res_id)) {
			  
			  $sql = 'SELECT LMP.lmp_id, LMP.lmp_name, LMP.lmp_admin_name, LMP.pty_id, LMP.lmp_price, LMP.lmp_fee, LMP.lmp_billing_delay,
				LMP.lmp_description, LMP.lmp_custom_terms, LMP.lmp_custom_breakdown, LMP.pty_id, LMP.lmp_featured, LPF.lpf_feature, LPF.lpf_id, MFC.mfc_count, LMP.tem_id, TEM.tem_path
				FROM lt_merchant_plans LMP 
				INNER JOIN lt_plans2reseller P2R ON LMP.lmp_id = P2R.lmp_id
				INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id 
				LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id
				LEFT JOIN tbl_emails TEM ON LMP.tem_id = TEM.tem_id
				WHERE P2R.res_id = :res_id AND LMP.lmp_id = :lmp_id AND LMP.lmp_active = 1 AND LPF.lpf_active = 1 AND MFC.ltb_id IS NULL';
				$qry = $this->mDbo->prepare( $sql );
				$qry->bindValue( ':lmp_id', $lmp_id, \PDO::PARAM_INT );
				$qry->bindValue( ':res_id', $res_id, \PDO::PARAM_INT );
				$qry->execute(  );
				$qry = $qry->fetchAll( \PDO::FETCH_ASSOC );
				if( !empty( $qry ) ) {
					foreach ( $qry as $k => $v ) {
					  if ( !$results ) {
						$results = array(
						  'lmp_id'                => $v['lmp_id'],
						  'pty_id'                => $v['pty_id'],
						  'lmp_name'              => $v['lmp_name'],
						  'lmp_price'             => $v['lmp_price'],
						  'lmp_fee'               => $v['lmp_fee'],
						  'lmp_billing_delay'     => $v['lmp_billing_delay'],
						  'tem_id'				  => $v['tem_id'],
						  'tem_path'			  => $v['tem_path'],
						  'lmp_features'      	  => array()
						);
						
						$results['lmp_features'][$v['lpf_id']] = array( 'lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count'] );
					  } 
					  else {
						$results['lmp_features'][$v['lpf_id']] = array( 'lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count'] );
					  }
					}
				}
			  
		  }
		  
		  return $results;
		}
		
		/*
		function getPackages($res_id = null, $pack_id = null){
			// use $this reseller if no reseller is specified
			if ($res_id === NULL){
				$res_id = $this->currentResId;
			}

			// if pack_id is set, use it
			if ($pack_id !== NULL && is_numeric($pack_id)){
				$wherePackId = 'AND PACK.prod_id = '.$pack_id;
			}

			$sql = 'SELECT 
			  PPR.ppr_id
			, PPR.ppr_price AS pack_price 
			, PPR.ppr_setup AS pack_setup
			, PPR.ppr_price_delay AS pack_price_delay
			, PPR.ppr_setup_delay AS pack_setup_delay
			, PACK.prod_id AS pack_id
			, PACK.prod_name AS pack_name
			, PACK.prod_descript AS pack_descript

			, PKI.pac_terms
			, PKI.pac_more_info
			, PKI.pac_itemizable

			, OFR.ofr_company
			, OFR.ofr_logo

			, PROD.prod_id
			, PROD.prod_name
			, PROD.prod_descript
			, PROD.prod_keyword
			, PROD.prod_count_type

			, PPK2.ppk_count

			FROM `tbl_pack2reseller` P2R 

			INNER JOIN `tbl_prod_package` PPK ON P2R.prod_id = PPK.prod_c_id
			INNER JOIN `tbl_product` PACK ON PPK.prod_c_id = PACK.prod_id
			INNER JOIN `tbl_prod_price` PPR ON PACK.prod_id = PPR.prod_id
			INNER JOIN `tbl_package_info` PKI ON PACK.prod_id = PKI.prod_id
			INNER JOIN `tbl_prod_offerer` OFR ON PACK.ofr_id = OFR.ofr_id

			INNER JOIN `tbl_prod_package` PPK2 ON PACK.prod_id = PPK2.prod_p_id
			INNER JOIN `tbl_product` PROD ON PROD.prod_id = PPK2.prod_c_id
			INNER JOIN `tbl_prod_price` PPR2 ON PROD.prod_id = PPK2.prod_c_id

			WHERE P2R.res_id = :id
			-- AND P2R.res_placement = "msp"

			AND PPK.ppk_show_in_pack = 1
			AND PPK2.ppk_show_in_pack = 1

			AND PPR.ppr_current_price = 1
			AND PPR2.ppr_current_price = 1
			
			'.(isset($wherePackId) ? $wherePackId : '').'

			ORDER BY 
			  PPK.ppk_display_order
			, PPK2.ppk_display_order
			';
			$qry = $this->mDbo->prepare( $sql );
			$qry->bindValue( ':id', $res_id, \PDO::PARAM_INT );
			$qry->execute();
			$qry = $qry->fetchAll(\PDO::FETCH_ASSOC);

			$package = array();

			foreach ($qry as $k=>$v) {
				if (empty($package[$v["pack_id"]])){
					// create initial package array
					$package[$v["pack_id"]] = array(
						'ppr_id'=>$v["ppr_id"],
						'pack_id'=>$v["pack_id"],
						'pack_name'=>$v["pack_name"],
						'pack_desc'=>$v["pack_descript"],
						'pack_price'=>$v["pack_price"],
						'pack_setup'=>$v["pack_setup"],
						'pack_setup_delay'=>$v["pack_setup_delay"],
						'pack_price_delay'=>$v["pack_price_delay"],
						'pack_terms'=>$v['pac_terms'],
						'pack_more_info'=>$v['pac_more_info'],
					);
					// add first product to package
					$package[$v["pack_id"]] = $this->addProductToPackageArray($package[$v["pack_id"]], $v);
				} else {
					// add product to package
			 		$package[$v["pack_id"]] = $this->addProductToPackageArray($package[$v["pack_id"]], $v);
				}
			}

			return $package; 
		}
		
		private function addProductToPackageArray($package, $product) {
			$v = $product;
			$package["products"][$v["prod_id"]] = array(
				'prod_id'=>$v["prod_id"],
				'prod_name'=>$v["prod_name"],
				'prod_descript'=>$v["prod_descript"],
				'prod_count'=>$v["ppk_count"],
				'prod_keyword'=>$v["prod_keyword"]
			);
			return $package;
		}
		*/
		
		
		public function doesPackBelognToReseller ( $packId, $resId, $placement = 'msp' ) {			
			switch ($placement) {
				case '4my.store': 
					$p2r_placement = $placement;
				break;	
				default: 
					$p2r_placement = 'msp';
			}

			if ( $this->validData($clean, $resId, $fieldName='wnu_res_id_r' ) && $this->validData($clean, $packId, $fieldName='wnu_pk_id_r' ) ) {
				//good to go
				$stmt = $this->mDbo->prepare("
					SELECT DISTINCT PIN.*
					FROM tbl_prod2reseller P2R 
					INNER JOIN tbl_reseller RES ON RES.res_id = P2R.res_id
					INNER JOIN tbl_product PRD ON PRD.prod_id = P2R.prod_id 			
					INNER JOIN tbl_package PIN ON PRD.prod_id = PIN.pk_id 
					WHERE 
						PIN.pk_id = :pk_id 
						AND RES.res_id = :res_id 
						AND P2R.p2r_placement = :plac
					LIMIT 1
				");
							
				$stmt->bindValue( ':res_id', $resId, \PDO::PARAM_INT );
				$stmt->bindValue( ':pk_id', $packId, \PDO::PARAM_INT );
				$stmt->bindValue( ':plac', $p2r_placement, \PDO::PARAM_STR );
				$stmt->execute();
				return $Results = $stmt->fetch( \PDO::FETCH_ASSOC );
			}
			return false;
		}
		
		function getRecords ( $resId = 0 ) {
			return isset( $this->resellerRecords[$resId] )? $this->resellerRecords[$resId]: [];
		}
		
		public function getId () {
			return $this->currentResId;
		}
		
		function getFiles ($fullPath = true) {
			
			if( file_exists( 'merchant-custom-files/' . $this->getSubdirFromId(  ) . '/_reseller_files/marketing' ) ) {				
				
				if ($fullPath) {
					return array_merge(glob('merchant-custom-files/' . $this->getSubdirFromId(  ) . '/_reseller_files/marketing/*.pdf'), glob('merchant-custom-files/' . $this->getSubdirFromId(  ) . '/_reseller_files/marketing/*.html'));			
				}	
				else {
					$filesArr = array();
					$filesArrTmp = array_merge(glob('merchant-custom-files/' . $this->getSubdirFromId(  ) . '/_reseller_files/marketing/*.pdf'), glob('merchant-custom-files/' . $this->getSubdirFromId(  ) . '/_reseller_files/marketing/*.html'));
					foreach ($filesArrTmp as $k => $v1) {
						$v = explode ('/', $v1);
						if ( count($v) > 0 ) {
							$filesArr[$k] = array('Path' => $v1, 'Name' => preg_replace("/[^0-9a-zA-Z]/", " ", explode('.', $v[count($v) - 1])[0]), 'Name_Ext' => $v[count($v) - 1]);
							$sql = 'SELECT rdc_description FROM tbl_reseller_docs WHERE res_id=:res_id AND rdc_name=:rdc_name';
							$qry = $this->mDbo->prepare( $sql );
							$qry->bindValue(':res_id', $this->currentResId, \PDO::PARAM_INT);
							$qry->bindValue(':rdc_name', $filesArr[$k]['Name'], \PDO::PARAM_STR);														  
							$qry->execute();
							$filesArr[$k]['Description'] = '';
							if ($qry = $qry->fetch(\PDO::FETCH_ASSOC)) {
								$filesArr[$k]['Description'] = $qry['rdc_description'];
							}
						}	
					}
					return array_values($filesArr);
				}
				
			}
			return array();
		}
		
		function getSubdirFromId(  ) {
			$_i = 0; $subId = substr( $this->currentResId, $_i, 2 ); $tmpResult = '';
			if ( !empty( $subId ) ) {
				do {			
					$tmpResult .= ( $tmpResult == ''? '': '/' ) . $subId;
					$_i+=2;
					$subId = substr( $resId, $_i, 2 );
				}
				while ( $subId != '' );
			}
			return	$tmpResult;
		}
		
		function __construct($dbObj, $res_id){
			$this->mDbo=$dbObj;
			
 			if ($this->validData($clean, $res_id, $fieldName='wnu_res_id_r' )){
 				$this->loadRecords($clean['res_id']);
 			}
			
 		}
	}

 }
?>