<?php 
$response = [];
$response['status'] = '';

if ( $_SERVER['REQUEST_METHOD'] == 'POST' ) {
	require $_SERVER['DOCUMENT_ROOT'] . '/app/function.connect.php';
	require $_SERVER['DOCUMENT_ROOT'] . '/app/start_session.php';
	require $_SERVER['DOCUMENT_ROOT'] . '/app/global.php';
	require $_SERVER['DOCUMENT_ROOT'] . '/app/class.variables.php';

	require $_SERVER['DOCUMENT_ROOT'] . '/reseller/app/model/class.reseller.php';
	require $_SERVER['DOCUMENT_ROOT'] . '/app/class.discount-code.php';
	//require $_SERVER['DOCUMENT_ROOT'] . '/app/class.prismpay.php';	
	require $_SERVER['DOCUMENT_ROOT'] . '/app/class.member-merchant.php';
	
	$memberMerchant = new App\MemberMerchant\MemberMerchant ($dbo, false);
	
	$discountCode = new App\DiscountCode\discountCode ( $dbo );
	
	// class variables
	$cv = new _variables();
	$fields=array(
	    'adn64_discountCode',
		'abc_cc_ltm_state',
		'abc_ltm_state_r',
		'adn_ccnum_r',
		'ema_ltb_email_r',
		'dec2_cc_expmon_r',
		'dec4_cc_expyear_r',
		'dec_cc_ccv_r',
		'nam_cc_cardholder_r',
		'nam_cc_ltm_city',
		'nam_ltb_contact_first_name_r',
		'nam_ltb_contact_last_name_r',
		'nam_ltm_city_r',
		'pho_ltm_phone_number_r',
		'psw_ltb_password2_r',
		'psw_ltb_password_r',
		'txt64_ltm_company_name_r',
		'txt64_ltm_google_id',
		'txt_cc_ltm_address',
		'txt_ltm_address_r',
		'zip_cc_ltm_zipcode',
		'zip_ltm_zipcode_r',
		'dec_lmp_id_r',
		'dec_ltm_lat_r',
		'dec_ltm_lng_r',
		'dec_res_id_r',
		'nam_referring_agent',
		'nam_sales_agent'
	);

	if (isset($_POST['bit_ltm_hide_address'])){
		array_push($fields, 'bit_ltm_hide_address');
	}

	foreach( $fields as $name=>$value ) { $cv->varible_in($value); }
	$_v = $cv->get_cleaned_variables(  );
	$errors = $cv->get_bad_variables(  );
	
	if ( $_POST['psw_ltb_password_r'] !== $_POST['psw_ltb_password2_r'] ) {
		array_push($errors, array('psw_ltb_password_r' => 'Passwords must match'));
	}
	
	if (!$errors){
		//checking if the new merchant's email exists
		if ( $memberMerchant->merchantExists( $_v['ltb_email'], $errorMsg ) && empty( $errorMsg ) ) {
			array_push($errors, array('ema_ltb_email_r' => 'Email already registered'));
		}
		
		if ( isset( $_v['discountCode'], $_v['res_id'] ) && !empty($_v['discountCode']) ) {
			$tmpDisCode = $discountCode->getResellerCode( $_v['discountCode'], $_v['res_id'] );
			
			if ( !isset( $tmpDisCode[0]['dsc_id'] ) ) {
				array_push($errors, array('adn64_discountCode' => 'Promotion code not found or expired'));
			}
		}
		
	}

	if ( !$errors ) {
		//checking for the selected plan values
		$resellerObj = new App\Reseller\Reseller ($dbo, $_v['res_id']);
		$chosen_plan = $resellerObj->getPlansFromId($_v['res_id'], $_v['lmp_id']);
		
		if( empty( $chosen_plan ) ) {
			$response['status'] = 'error';
			$response['error']  = array('dec_lmp_id_r'=>'Plan Does Not Exist'); // this error should only appear if someone changes the hidden form field
			echo json_encode($response);
			exit();
		} 

		// require processpayment function
  		require $_SERVER["DOCUMENT_ROOT"].'/app/function.processpayment.php';
		// set credit card payment variables
		$uri = array(
			'action' => 'ns_quicksale_cc',
			'emailto'=> CSR_FORM_EMAIL, // ALL RECEIPTS goto CSR_FORM_EMAIL
			'emailsubject' => 'Local Thanks Receipt',
			'ccname' => $_v['cc_cardholder'],
			'ccnum'  => $_v['ccnum'],
			'cvv2'   => $_v['cc_ccv'],
			'expmon' => $_v['cc_expmon'],
			'expyear'=> $_v['cc_expyear'],
			'recur_create ' => 1,
			'recur_billingmax' => -1,
			'recur_billingcycle' => 2,//monthly
			'ci_email' => $_v['ltb_email'],
			'ci_billaddr1' => $_v['ltm_address'],
			'ci_billcity' => $_v['ltm_city'],
			'ci_billzip' => $_v['ltm_zipcode'],
			'ci_billstate' => $_v['ltm_state']
		);
		
		// billing address is the same as business address?
		if ( isset($_v['use_biz_addr']) == false ) {
			$uri['ci_billaddr1'] = $_v['cc_ltm_address'];
			$uri['ci_billcity']  = $_v['cc_ltm_city'];
			$uri['ci_billzip']	 = $_v['cc_ltm_zipcode'];
			$uri['ci_billstate'] = $_v['cc_ltm_state'];
		}
		
		$uri['recur_amount'] = floatval( $chosen_plan['lmp_price'] ) * 100; // amounts are passed in cents, so we take the price and multiply by 100
		
		if ( isset( $tmpDisCode[0]['dsc_id'] ) ) {
			
			$discountCode->applyDiscountCode( $tmpDisCode[0], $chosen_plan, $uri, $uri1/*In case another billing needs to be checked*/, $datesArr, $chargesArr );
			
			/*
			$response['error']  = $uri1;
			echo json_encode($response);
			exit();
			*/
			
			
			$startTime = $datesArr[0]['startTime'];
			$endTime   = $datesArr[0]['endTime'];
			$timeDiff  = $datesArr[0]['timeDiff'];
			$delayDays = $datesArr[0]['delayDays'];
			$startCycle = $datesArr[0]['startCycle'];
			$discCodeId = $datesArr[0]['codeId'];
			$endCycle = $datesArr[0]['endCycle'];
			
		}
		elseif ( intval($chosen_plan['lmp_billing_delay']) === 0 ) {
			//there isn't any discount code entered, procede as usual
			
			// monthly billing is *not* delayed, charge setup + first month's fee, then begin recurring payments 1 month from today.
			$uri['amount'] = ( floatval( $chosen_plan['lmp_price'] ) + floatval($chosen_plan['lmp_fee'])) * 100; // amounts are passed in cents, so we take the price + fee and multiply by 100
			$startTime = strtotime('now');
			$endTime   = strtotime('now +1 month');
			$timeDiff  = abs($endTime - $startTime);
			$delayDays = $timeDiff/86400; // 86400 seconds in one day
			$startCycle = date('Y-m-d',$endTime);
			$uri['recur_start'] = intval($delayDays);
			$endCycle = null;
			$discCodeId = null;
		} 
		else {
			//there isn't any discount code entered, procede as usual
			
			$startTime = strtotime('now');
			$endTime   = strtotime('now +'.intval($chosen_plan['lmp_billing_delay']).' months');
			$timeDiff  = abs($endTime - $startTime);
			$delayDays = $timeDiff/86400; // 86400 seconds in one day
			$startCycle = date('Y-m-d',$endTime);
			$uri['recur_start'] = intval($delayDays);
			// if the monthly bill is delayed && the setup fee is 0, we have to charge a minimum of 1 cent.
			$uri['amount'] = (floatval($chosen_plan['lmp_fee']) * 100 == 0 ? 0.01 : floatval($chosen_plan['lmp_fee']) * 100); // amounts are passed in cents, so we take the fee and multiply by 100
			$endCycle = null;
			$discCodeId = null;
		}
		// process payment
		 
		if ( isset( $tmpDisCode[0]['dsc_id'] ) ) {
			$discountCode->reduceQuantity($_v['discountCode'], $_v['res_id']);
		}
		
		$thisPay =  _appProcessPayment( $uri );
		
		if (isset($uri1)) {
			
			$thisPay1 =  _appProcessPayment( $uri1 );
			
			$startTime1 = $datesArr[1]['startTime'];
			$endTime1  = $datesArr[1]['endTime'];
			$timeDiff1  = $datesArr[1]['timeDiff'];
			$delayDays1 = $datesArr[1]['delayDays'];
			$startCycle1 = $datesArr[1]['startCycle'];
			$endCycle1 = $datesArr[1]['endCycle'];
			$discCodeId1 = $datesArr[1]['codeId'];
			
			
		}
		
		// check payment status
		if ( $thisPay['status'] == "Declined" ) {
			/*
			$response['uri'] = $uri;
			$response['uri1'] = isset($uri1)? $uri1: null;
			$response['chargesArr'] = $chargesArr;
			$response['datesArr'] = $datesArr;
			*/
			$reason = explode( ':', str_replace('..', '', $thisPay['reason']) );
			$response['status'] = 'error';
			$response['error']  = array('adn_ccnum_r'=>' Credit Card Declined: '.$reason[2]);
			
			echo json_encode($response);
			exit();
			
		}
		else if ( $thisPay['status'] == "Accepted" ) {
			
			if ( isset( $tmpDisCode[0]['dsc_id'] ) ) {
				$discountCode->reduceQuantity($_v['discountCode'], $_v['res_id']);
			}
			
			// encrypt the password
			require $_SERVER["DOCUMENT_ROOT"].'/app/model/crypt.php';
			$crypt   = new Crypt( $_v['ltb_email'] );
			$cryptck = $crypt->encode( $_v['ltb_password'] );

		    $sql = "INSERT INTO `lt_member_merchants`(res_id,lmp_id,pty_id,ltb_slug,ltb_phone_number,ltb_contact_name,ltb_email,ltb_password,ltb_datecreated,ltb_timestamp,ltb_active, ltb_referring_agent, ltb_salesperson) 
		    VALUES (:res_id,:lmp_id,:pty_id,:slug,:ltm_phone_number,:ltb_contact_name,:ltb_email,:ltb_password,now(),now(),1, :ltb_referring_agent, :ltb_salesperson)";
		    $qry = $dbo->prepare( $sql );
		    $qry->bindValue(':res_id', $_v['res_id'], PDO::PARAM_INT);
		    $qry->bindValue(':pty_id', $chosen_plan['pty_id'], PDO::PARAM_INT);
		    $qry->bindValue(':lmp_id', $chosen_plan['lmp_id'], PDO::PARAM_INT);
		
		    $qry->bindValue(':ltm_phone_number', $_v['ltm_phone_number'], PDO::PARAM_STR);
		    $qry->bindValue(':ltb_referring_agent', ($_v['referring_agent'] ? $_v['referring_agent'] : NULL), PDO::PARAM_STR);
		    $qry->bindValue(':ltb_salesperson', ($_v['sales_agent'] ? $_v['sales_agent'] : NULL), PDO::PARAM_STR);
		    $qry->bindValue(':ltb_contact_name', ucwords( strtolower( $_v['ltb_contact_first_name'].' '.$_v['ltb_contact_last_name'] ) ), PDO::PARAM_STR);
		    $qry->bindValue(':ltb_email', $_v['ltb_email'], PDO::PARAM_STR);
		    $qry->bindValue(':slug', strtolower(preg_replace("/[^A-Za-z0-9 ]/", '', $_v['ltb_email'])), PDO::PARAM_STR); // momentary placeholder until we get lastInsertId();
		    $qry->bindValue(':ltb_password', $cryptck, PDO::PARAM_STR);
		    $qry=execPDO($qry);
		    $ltb_id = $dbo->lastInsertId();

			// add store
			$sql = "INSERT INTO `lt_merchants` (ltm_hide_address,ltb_id,ltm_google_id,ltm_company_name,ltm_lat,ltm_long,ltm_address,ltm_city,ltm_state,ltm_zipcode,ltm_phone_number,ltm_registerdate,ltm_active) VALUES (:ltm_hide_address,:ltb_id,:ltm_google_id,:ltm_company_name,:ltm_lat,:ltm_long,:ltm_address,:ltm_city,:ltm_state,:ltm_zipcode,:ltm_phone_number,now(),1)";
			$qry = $dbo->prepare( $sql );
			$qry->bindValue(':ltb_id', $ltb_id, PDO::PARAM_STR);
			$qry->bindValue(':ltm_hide_address', isset($_POST['ltm_hide_address'])? 1: 0, PDO::PARAM_INT );
			$qry->bindValue(':ltm_google_id', $_v['ltm_google_id'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_company_name', $_v['ltm_company_name'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_lat', $_v['ltm_lat'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_long', $_v['ltm_lng'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_address', $_v['ltm_address'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_city', $_v['ltm_city'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_state', $_v['ltm_state'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_zipcode', $_v['ltm_zipcode'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_phone_number', $_v['ltm_phone_number'], PDO::PARAM_STR);    
			$qry=execPDO($qry);
			$ltm_id = $dbo->lastInsertId();

			// begin slug creation
			function checkMerchantSlug($_slug, $dbo){
			  // check if URL slug already exists in our system
			  // global $dbo;
			  $sql = "SELECT LTB.ltb_slug, BS.bs_slug FROM `lt_member_merchants` LTB, `lt_bad_slugs` BS WHERE ltb_slug=:slug OR bs_slug=:slug LIMIT 1";
			  $qry = $dbo->prepare( $sql );
			  $qry->bindValue(':slug', $_slug, PDO::PARAM_STR);
			  $qry=execPDO($qry);
			  $qry = $qry->fetchAll( PDO::FETCH_ASSOC );
			  if(empty($qry)){
			    return true; // available
			  } else {
			    return false; // taken
			  }
			}
			$our_slug = strtolower(preg_replace("/[^A-Za-z0-9 ]/", '', $_v['ltm_company_name']));
			$our_slug = str_replace(" ","-",$our_slug);
			$check_slug = checkMerchantSlug($our_slug, $dbo);
			if ($check_slug===false){
			  // duplicate slug, add ltb_id to end, check if under 64 characters, if not, minus ltb_id.length from slug then add ltb_id
			  $new_slug = $our_slug.'-'.$ltb_id;
			  if (strlen($new_slug)>64){
			    // new slug is over 64 characters long, trim it
			    $slug_overlap = strlen($new_slug)-64;
			    $new_slug = substr($our_slug, 0, ($slug_overlap*-1)); // remove the # of overlap characters from the initial slug to make it fit into 64 characters
			    $our_slug = $new_slug.'-'.$ltb_id;
			  } else {
			    $our_slug = $new_slug;
			  }
			}

			// update slug
			$qry = $dbo->prepare( "UPDATE `lt_member_merchants` SET ltb_slug=:slug WHERE ltb_id=:id LIMIT 1" );
			$qry->bindValue(':id', $ltb_id, PDO::PARAM_INT);
			$qry->bindValue(':slug', $our_slug, PDO::PARAM_STR);
			$qry = execPDO($qry);
		    
		    // set a default category
		    $sql = "INSERT INTO `lt_m2cat` (ltb_id,cat_id) VALUES (:ltb_id, 543)";
		    $qry = $dbo->prepare( $sql );
		    $qry->bindValue(':ltb_id', $ltb_id, PDO::PARAM_STR);  
		    $qry=execPDO($qry);

			// update merchant feature counts
			foreach ($chosen_plan['lmp_features'] as $k=>$v){
			    switch ($v['lpf_id']){
			      //case 9:  // catalog points
			      case 13: // monthly emails
			      case 14: // sms texts
			      case 15: // push notifications
			        $qry = $dbo->prepare( "INSERT INTO `lt_feature_cnt` (lfc_count, lpf_id, ltb_id) VALUES (:count, :lpf_id, :ltb_id)" );
			        $qry->bindValue(':ltb_id', $ltb_id, PDO::PARAM_INT);
			        $qry->bindValue(':lpf_id', $v['lpf_id'], PDO::PARAM_INT);
			        $qry->bindValue(':count', $v['mfc_count'], PDO::PARAM_INT);
			        $qry = execPDO($qry);           
			      break;
			      default:
			      break;
			    }
			}

			// insert lt_merchant_billing table
			$qry = $dbo->prepare( "INSERT INTO `lt_merchant_billing` (bill_cycleend, dsc_id, ltm_id, lmp_id, bill_name, bill_address1, bill_state, bill_city, bill_zip, bill_accountnumber, bill_orderid, bill_cyclestart, bill_fee, bill_price) VALUES (:cycleend, :codeId, :id,:lmp_id,:bill_name,:bill_address1,:bill_state,:bill_city,:bill_zip,:bill_accountnumber,:orderid, :cyclestart, :bill_fee, :bill_price)" );
			$qry->bindValue(':id', $ltm_id, PDO::PARAM_STR);
			$qry->bindValue(':lmp_id', $chosen_plan['lmp_id'], PDO::PARAM_INT);
			$qry->bindValue(':bill_fee', isset($chargesArr[0]['setupFee'])?$chargesArr[0]['setupFee']:$chosen_plan['lmp_fee'], PDO::PARAM_STR);
			$qry->bindValue(':bill_price', isset($chargesArr[0]['price'])?$chargesArr[0]['price']:$chosen_plan['lmp_price'], PDO::PARAM_STR);
			$qry->bindValue(':bill_name', $_v['cc_cardholder'], PDO::PARAM_STR);
			$qry->bindValue(':bill_address1', $uri['ci_billaddr1'], PDO::PARAM_STR);
			$qry->bindValue(':bill_state', $uri['ci_billstate'], PDO::PARAM_STR);
			$qry->bindValue(':bill_city', $uri['ci_billcity'], PDO::PARAM_STR);
			$qry->bindValue(':bill_zip', $uri['ci_billzip'], PDO::PARAM_STR);
			$qry->bindValue(':bill_accountnumber', $thisPay["accountnumber"], PDO::PARAM_STR);
			$qry->bindValue(':orderid', $thisPay['orderid'], PDO::PARAM_STR);
			$qry->bindValue(':cyclestart', $startCycle, PDO::PARAM_STR);
			$qry->bindValue(':cycleend', $endCycle, PDO::PARAM_STR);
			$qry->bindValue(':codeId', $discCodeId, PDO::PARAM_INT);
			$qry = execPDO($qry);
			
			//here we have to check if uri1 is set and make another entry for it in "lt_merchant_billing"
			if ( isset( $uri1 ) ) {
				//save the other bill to db
				$qry = $dbo->prepare( "INSERT INTO `lt_merchant_billing` (bill_active, bill_cycleend, dsc_id, ltm_id, lmp_id, bill_name, bill_address1, bill_state, bill_city, bill_zip, bill_accountnumber, bill_orderid, bill_cyclestart, bill_fee, bill_price) VALUES (0, :cycleend, :codeId, :id,:lmp_id,:bill_name,:bill_address1,:bill_state,:bill_city,:bill_zip,:bill_accountnumber,:orderid, :cyclestart, :bill_fee, :bill_price)" );
				$qry->bindValue(':id', $ltm_id, PDO::PARAM_STR);
				$qry->bindValue(':lmp_id', $chosen_plan['lmp_id'], PDO::PARAM_INT);
				$qry->bindValue(':bill_fee', isset($chargesArr[1]['setupFee'])?$chargesArr[1]['setupFee']:$chosen_plan['lmp_fee'], PDO::PARAM_STR);
				$qry->bindValue(':bill_price', isset($chargesArr[1]['price'])?$chargesArr[1]['price']:$chosen_plan['lmp_price'], PDO::PARAM_STR);
				$qry->bindValue(':bill_name', $_v['cc_cardholder'], PDO::PARAM_STR);
				$qry->bindValue(':bill_address1', $uri1['ci_billaddr1'], PDO::PARAM_STR);
				$qry->bindValue(':bill_state', $uri1['ci_billstate'], PDO::PARAM_STR);
				$qry->bindValue(':bill_city', $uri1['ci_billcity'], PDO::PARAM_STR);
				$qry->bindValue(':bill_zip', $uri1['ci_billzip'], PDO::PARAM_STR);
				$qry->bindValue(':bill_accountnumber', $thisPay1["accountnumber"], PDO::PARAM_STR);
				$qry->bindValue(':orderid', $thisPay1['orderid'], PDO::PARAM_STR);
				$qry->bindValue(':cyclestart', $startCycle1, PDO::PARAM_STR);
				$qry->bindValue(':cycleend', $endCycle1, PDO::PARAM_STR);
				$qry->bindValue(':codeId', $discCodeId1, PDO::PARAM_INT);
				$qry = execPDO($qry);
			}
					
			// welcome merchant email
			// if ($chosen_plan['tem_id'] == NULL){
			// 	$ema_body = file_get_contents($_SERVER["DOCUMENT_ROOT"].'/mail/localthanks/website/merchant_payment_welcome/merchant_payment_welcome.html');
			// }
			// else {
			// 	$ema_body = file_get_contents($_SERVER["DOCUMENT_ROOT"].$chosen_plan['tem_path']);	
			// }
			
			// $ema_email = $_v['ltb_email'];
			// $ema_ltm_id = $ltm_id;
			// $amountCharged = $uri['amount'] == 0.01? $uri['amount'] : $uri['amount'] / 100;
			// $amountCharged = strpos( $amountCharged , '.' ) === false? $amountCharged.'.00' : ( strlen($amountCharged) - 2 == strpos($amountCharged , '.')? $amountCharged . '.0' : $amountCharged);
			// $ema_message = '<p>Your payment of <span style="color: #0079FE; font-weight: bold;">$' . $amountCharged . '</span> was processesd.<p><p>Your <span style="color: #0079FE; font-weight: bold;">'.$chosen_plan['lmp_name'].' Membership</span> is now active under the following email address:</p><p style="margin: 0;"><span style="color: #0079FE; font-weight: bold;">'.$_v['ltb_email'].'</span></p>';
			// include $_SERVER["DOCUMENT_ROOT"].'/app/build-email.php';
			// $to       = $ema_email;
			// $subject  = 'Welcome to Local Thanks!';
			// $message  = $ema_body;
			// $headers  = "From: noreply@localthanks.com\r\n";
			// $headers .= "Reply-To: noreply@localthanks.com\r\n";
			// $headers .= "MIME-Version: 1.0\r\n";
			// $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
			// mail($to, $subject, $message, $headers);


			// welcome merchant email
			$email_settings = array();

			if ($chosen_plan['tem_id'] == NULL){
				$email_settings['ema_body'] = file_get_contents($_SERVER["DOCUMENT_ROOT"].'/mail/localthanks/website/merchant_payment_welcome/merchant_payment_welcome.html');
			}
			else {
				$email_settings['ema_body'] = file_get_contents($_SERVER["DOCUMENT_ROOT"].$chosen_plan['tem_path']);	
			}

			$email_settings['ema_email'] =  $_v['ltb_email'];
			$email_settings['ema_ltm_id'] = $ltm_id;

			$amountCharged = $uri['amount'] == 0.01 ? $uri['amount'] : $uri['amount'] / 100;
			$amountCharged = strpos( $amountCharged , '.' ) === false ? $amountCharged.'.00' : ( strlen($amountCharged) - 2 == strpos($amountCharged , '.') ? $amountCharged . '.0' : $amountCharged);

			$email_settings['ema_message'] = '<p>Your payment of <span style="color: #0079FE; font-weight: bold;">$' . $amountCharged . '</span> was processesd.<p><p>Your <span style="color: #0079FE; font-weight: bold;">'.$chosen_plan['lmp_name'].' Membership</span> is now active under the following email address:</p><p style="margin: 0;"><span style="color: #0079FE; font-weight: bold;">'.$_v['ltb_email'].'</span></p>';

			$email_settings['ema_subject'] = 'Welcome to Local Thanks!';
			require_once $_SERVER['DOCUMENT_ROOT'] . '/app/class.mailgun.php';
			$mailgun = new App\Mailgun\mailgun($dbo);
			$mailgun->sendEmail($email_settings);

			// set sessions so user can set their business settings on the next page and go directly to MyStore after
			$_SESSION['user']['merchant']['ltb_id'] = $ltb_id;
			$_SESSION['user']['merchant']['ltm_id']	= $ltm_id;
			$_SESSION['user']['merchant']['ltb_email']	= $_v['ltb_email'];
			$_SESSION['user']['merchant']['ltm_company_name'] = $_v['ltm_company_name'];
			$_SESSION['user']['merchant']['res_id'] = $_v['res_id'];
			$_SESSION['user']['merchant']['promo_count'] = "0";
			$_SESSION['user']['merchant']['tmp_id'] = "1";
			$_SESSION['user']['merchant']['plan']	= $chosen_plan;
			$_SESSION['user']['merchant']['date']	= date('m/d/Y');

			$response['status'] = 'success';
			echo json_encode($response);
			exit();
		}
	} 
	else {
		$response['status'] = 'error';
		$response['error']  = $errors;
		echo json_encode($response);
		exit();
	}
}
?>