<?php 
$tmpl_url = ROOT_URL;
$obj = json_decode( file_get_contents( "{$tmpl_url}/api/api.lt.json.options.php" ) );
$states = $territory = '';

foreach( $obj->options->state as $k => $v ) {
	$states.= "<option value='{$k}'>{$v}</option>";
}

foreach( $obj->options->territory as $k => $v ) {
	$territory.= "<option value='{$k}'>{$v}</option>";
}

// Current year for credit card
$year = date( 'Y' );
$yearOpt = '';
for( $i = 0; $i <= 20; ++$i ) {
	$yearOpt.= "<option value='{$year}'>{$year}</option>";   
	$year++;
}

?>
<div class="container signup__wrap signup__height">
	<div class="row">
		<div class="col-xs-12">
			<div id="formErrors"></div>
		</div>
	</div>

	<div class="row">
		<div class="col-xs-12" id="searchBusinessWrap">
			<div class="row">
				<div class="col-xs-12">
					<div class="signup__heading" id="search-prog">Business Information</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xs-12">
					<form id="searchBusinessForm">
						<div class="row">
							<div class="col-xs-12">
								<div class="form-group">
									<label>All fields are required.</label><br>
									<label for="ltm_company_name">Business Name</label>
									<input type="text" name="txt64_ltm_company_name_r" id="ltm_company_name" class="vCheck form-control" required>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-xs-12 col-sm-6">
								<div class="form-group">
									<label for="ltb_email">Email Address</label>&nbsp;&nbsp;&nbsp;<span id="emailMatchError" style="display:none;color: tomato;"><span class="glyphicon glyphicon-exclamation-sign"></span> This email is registered already.</span>
									<input type="email" id="ltb_email" name="ema_ltb_email_r" class="vCheck form-control" required>
								</div>
							</div>
							<div class="col-xs-12 col-sm-6">
								<div class="form-group">
									<label for="ltb_email2">Confirm Email Address</label>&nbsp;&nbsp;&nbsp;<span id="emailMatchError2" style="display:none; color:tomato;"><span class="glyphicon glyphicon-exclamation-sign"></span> Email fields must match</span>
									<input type="email" id="ltb_email2" name="ema_ltb_email2_r" class="vCheck form-control" required>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-xs-12 col-sm-6">
								<div class="form-group">
									<label for="ltb_contact_first_name">Owner First Name</label>
									<input type="text" id="ltb_contact_first_name" name="nam_ltb_contact_first_name_r" class="vCheck form-control" required>
								</div>
							</div>
							<div class="col-xs-12 col-sm-6">
								<div class="form-group">
									<label for="ltb_contact_last_name">Owner Last Name</label>
									<input type="text" id="ltb_contact_last_name" name="nam_ltb_contact_last_name_r" class="vCheck form-control" required>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-xs-12 col-sm-6">
								<div class="form-group">
									<label for="ltm_phone_number">Business Phone Number</label>
									<input type="text" id="ltm_phone_number" name="pho_ltm_phone_number_r" class="vCheck form-control" required>
								</div>
							</div>
							<div class="col-xs-12 col-sm-6">
								<div class="form-group">
									<label for="ltm_zipcode">Business Zip Code</label>
									<input type="text" name="zip_ltm_zipcode_r" class="vCheck form-control" id="ltm_zipcode" required>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-xs-12">
								<div class="form-group">
									<button type="submit" class="btn btn-success" id="searchBusinessSubmit">Continue</button>
								</div>
							</div>
						</div>
					</form>
					<div id="search-results"></div>
					<div id="map-canvas"></div>
				</div>
			</div>
		</div>
		<div class="col-xs-12">
			<form id="businessAddressForm" style="display:none;" method="POST" action='/signup?step=3'>
				<input type="hidden" name="txt64_ltm_google_id">
				<input type="hidden" name="dec_ltm_lat_r">
				<input type="hidden" name="dec_ltm_lng_r">
				<input type="hidden" name="nam_ltb_contact_first_name_r">
				<input type="hidden" name="nam_ltb_contact_last_name_r">
				<span style="display:none" id="chosenPlanSetupFee"><?php echo $chosen_plan['lmp_fee']; ?></span>
				<input type="hidden" id="selectedPlanId" name="dec_lmp_id_r" value="<?php echo htmlspecialchars(intval($_GET['lmp_id'])); ?>">
				<input type="hidden" name="dec_res_id_r" value="<?php echo htmlspecialchars(intval($_SESSION['reseller']['id'])); ?>">
				<div class="row">
					<div class="col-xs-12">
						<div class="signup__heading">Business Information</div>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12 col-sm-7">
						<div class="form-group">
							<label for="txt64_ltm_company_name_r">Business Name</label>
							<input type="text" name="txt64_ltm_company_name_r" id="txt64_ltm_company_name_r" class="vCheck form-control" required>
						</div>
					</div>
					<div class="col-xs-12 col-sm-5">
						<div class="form-group">
							<label for="pho_ltm_phone_number_r">Business Phone Number</label>
							<input type="text" name="pho_ltm_phone_number_r" id="pho_ltm_phone_number_r" class="vCheck form-control" required>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12 col-sm-4">
						<div class="form-group">
							<label for="txt_ltm_address_r">Street Address</label>
							<input type="text" name="txt_ltm_address_r" id="txt_ltm_address_r" class="vCheck form-control" required>
						</div>
					</div>
					<div class="col-xs-12 col-sm-3">
						<div class="form-group">
							<label for="nam_ltm_city_r">City</label>
							<input type="text" id="nam_ltm_city_r" name="nam_ltm_city_r" class="vCheck form-control" required>
						</div>
					</div>
					<div class="col-xs-12 col-sm-3">
						<div class="form-group">
							<label for="abc_ltm_state_r">State</label>
							<select id="abc_ltm_state_r" name="abc_ltm_state_r" class="vCheck form-control" required>
								<option value="" selected disabled>Select State</option>
								<optgroup label='States'><?php echo $states; ?></optgroup>
								<optgroup label='U.S. Territories'><?php echo $territory; ?></optgroup>
							</select>
						</div>
					</div>
					<div class="col-xs-12 col-sm-2">
						<div class="form-group">
							<label for="zip_ltm_zipcode_r">Postal Code</label>
							<input type="text" name="zip_ltm_zipcode_r" id="zip_ltm_zipcode_r" class="vCheck form-control" required>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12">
						<div class="form-group">
							<label>
								<input type="checkbox" name="ltm_hide_address">
								Hide My Business Address to Consumers
							</label>							
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12">
						<div class="form-group">
							<label>
								<input type="checkbox" name="bit_use_biz_addr" id="useBusinessAddress" value="1" checked>
								My Business Address and Billing Address are the same
							</label>
						</div>
					</div>
				</div>
				<div id="billingAddressForm" style="display:none;">
					<div class="row">
						<div class="col-xs-12">
							<div class="signup__heading">Billing Address</div>
						</div>
					</div>
						<div class="row">
							<div class="col-xs-12 col-sm-4">
								<div class="form-group">
									<label for="txt_cc_ltm_address">Street Address</label>
									<input type="text" name="txt_cc_ltm_address" id="txt_cc_ltm_address" class="vCheck form-control">
								</div>
							</div>
							<div class="col-xs-12 col-sm-3">
								<div class="form-group">
									<label for="nam_cc_ltm_city_r">City</label>
									<input type="text" id="nam_cc_ltm_city" name="nam_cc_ltm_city" class="vCheck form-control">
								</div>
							</div>
							<div class="col-xs-12 col-sm-3">
								<div class="form-group">
									<label for="abc_cc_ltm_state">State</label>
									<select id="abc_cc_ltm_state" name="abc_cc_ltm_state" class="vCheck form-control">
										<option value="" disabled>Select State</option>
										<optgroup label='States'><?php echo $states; ?></optgroup>
										<optgroup label='U.S. Territories'><?php echo $territory; ?></optgroup>
									</select>
								</div>
							</div>
							<div class="col-xs-12 col-sm-2">
								<div class="form-group">
									<label for="zip_cc_ltm_zipcode">Postal Code</label>
									<input type="text" name="zip_cc_ltm_zipcode" id="zip_cc_ltm_zipcode" class="vCheck form-control">
								</div>
							</div>
						</div>
					</div> <!-- END  #billingAddressForm -->
					
					<!-- referral agent, salesperson -->
					<div class="row" style="margin-bottom:20px;">
						<div class="col-xs-12 col-sm-6" <?php echo ($_SESSION['reseller']['subdomain'] == 'merchant' ? '' : 'style="display:none"'); ?>>
							<label for="nam_referring_agent">Referring Agent</label>
							<input type="text" name="nam_referring_agent" id="nam_referring_agent" placeholder="Enter Referring Agent Name" class="form-control">
						</div>

						<div class="col-xs-12 col-sm-6">
							<label for="nam_sales_agent">Salesperson</label>
							<input type="text" name="nam_sales_agent" id="nam_sales_agent" placeholder="Enter Salesperson Name" class="form-control">
						</div>
					</div>

					<div class="signup__form-highlight" id="creditCardInput">
						<div class="row">
							<div class="col-xs-12">
								<div class="signup__heading"><img src="/reseller/images/icon_lock_secure_48px.svg" class="lock-icon">Billing Information</div>
								<label>All fields are required.</label>
								<div class="row">
									<div class="col-xs-12 col-sm-6">
										<div class="form-group">
											<label for="adn_ccnum_r">Card Number</label>
											<input type="text" name="adn_ccnum_r" id="adn_ccnum_r" class="form-control" required>
										</div>
									</div>
									<div class="col-xs-12 col-sm-6">
										<div class="form-group">
											<label for="nam_cc_cardholder_r">Cardholder Name</label>
											<input type="text" name="nam_cc_cardholder_r" id="nam_cc_cardholder_r" class="vCheck form-control" required>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12 col-sm-6">
										<div class="form-group">
											<label for="dec2_cc_expmon_r">Expiration Month</label>
											<select name="dec2_cc_expmon_r" id="dec2_cc_expmon_r" class="form-control vCheck" required>
												<option selected value=1>1</option>
												<option value=2>2</option>
												<option value=3>3</option>
												<option value=4>4</option>
												<option value=5>5</option>
												<option value=6>6</option>
												<option value=7>7</option>
												<option value=8>8</option>
												<option value=9>9</option>
												<option value=10>10</option>
												<option value=11>11</option>
												<option value=12>12</option>
											</select>
										</div>
									</div>
									<div class="col-xs-12 col-sm-6">
										<div class="form-group">
											<label for="dec4_cc_expyear_r">Expiration Year</label>
											<select name="dec4_cc_expyear_r" id="dec4_cc_expyear_r" class="form-control vCheck" required>
												<?php echo $yearOpt; ?>
											</select>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12 col-sm-6">
										<div class="form-group">
											<label for="dec_cc_ccv_r">CVV/CVV2</label>
											<input id="dec_cc_ccv_r" name="dec_cc_ccv_r" type="text" class="form-control vCheck" required>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12 col-sm-6">
										<div class="form-group">
											<label><em>Accepted Payment Methods</em></label>
											<img src="/reseller/images/credit-cards.png" class="img-responsive">
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="signup__form-highlight" id="accountCreateInput">
						<div class="row">
							<div class="col-xs-12">
								<div class="signup__heading"><img src="/reseller/images/icon_lock_secure_48px.svg" class="lock-icon">Create Password</div>
								<div class="row">
									<div class="col-xs-12">
										<div class="form-group">
											<label for="ema_ltb_email_r">Login Email</label>
											<input type="email" name="ema_ltb_email_r" id="ema_ltb_email_r" class="vCheck form-control" required>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12 col-xs-6">
										<div class="form-group">
											<label for="psw_ltb_password_r">Password</label>&nbsp;&nbsp;&nbsp;<span id="pwMatchError" style="display:none; color:tomato;"><span class="glyphicon glyphicon-exclamation-sign"></span> Passwords must match</span>
											<input type="password" name="psw_ltb_password_r" id="psw_ltb_password_r" class="vCheck form-control" required pattern=".{3,}" title="3 characters minimum">
										</div>
									</div>
									<div class="col-xs-12 col-xs-6">
										<div class="form-group">
											<label for="psw_ltb_password2_r">Confirm Password</label>&nbsp;&nbsp;&nbsp;<span id="pwMatchError2" style="display:none; color:tomato;"><span class="glyphicon glyphicon-exclamation-sign"></span> Passwords must match</span>
											<input type="password" name="psw_ltb_password2_r" id="psw_ltb_password2_r" class="vCheck form-control" required pattern=".{3,}" title="3 characters minimum">
										</div>
									</div>									
								</div>
							</div>
						</div>
					</div>

					<div class="row">
						<div class="col-xs-12">
							<div class="signup__heading">Confirm and Place Order</div>
							<label>Membership Type</label>
							<div class="signup__form-highlight" id="accountCreateInput">
								<div class="row">
									<div class="col-xs-12">
										<strong><?php echo $chosen_plan['lmp_name']; ?></strong><br>
										<?php  if ($chosen_plan['lmp_custom_terms'] === null) {
											echo '$'.$chosen_plan['lmp_price'].'/mo. + $'.$chosen_plan['lmp_fee'].' one time setup fee'; 
										} else {
											echo $chosen_plan['lmp_custom_terms'];
										} ?>
									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="row" style="margin-bottom:20px;">
						<div class="col-xs-12 col-sm-6">
							<label for="adn64_discountCode">Promo Code</label>
							<div id="discountCodeMsgDiv"></div>
							<button id="discountCodeReset" style="display:none;margin-bottom: 10px;" type="button" class="btn btn-primary btn-xs">Reset Promo Code</button>
							<div class="input-group">
								<input type="text" name="adn64_discountCode" id="discountCodeVal" placeholder="Enter Promo Code" class="form-control">
								<span class="input-group-btn">
									<button class="btn btn-primary" type="button" id="applyDiscountCode">Apply</button>
								</span>
							</div>
							<div id="discountCodeTerms">
								<h5 class="freeDiscountCodeTrial">Try Local Thanks for Free</h5>
								<ul>
									<li class="freeDiscountCodeTrial">You'll have to input a credit card number to get the free trial.</li>
									<li class="freeDiscountCodeTrial">Your free trial will convert to a paid subscription and your card will be charged two months after you redeemed the free trial.</li>
									<li>In order to avoid getting charged for the next billing period, you need to cancel at least 24 hours before the free trial period ends</li>
									<li>If you've already taken a free trial, you may not be eligible to try one again.</li>
								</ul>	
							</div>
						</div>
					</div>						

					<div class="row">
						<div class="col-xs-12">
						<?php if ($chosen_plan['lmp_custom_breakdown']){ ?>
							<div class="row">
								<div class="col-xs-12">
									<?php echo $chosen_plan['lmp_custom_breakdown']; ?>
									<?php echo ($chosen_plan['lmp_billing_delay'] > 0 && floatval($chosen_plan['lmp_fee']) * 1 == 0 ? 'Your credit card will be charged $0.01 today for authentication purposes.<br><br>':''); ?>
								</div>
							</div>
						<?php } else { ?>
							<div class="row">
								<div class="col-xs-12">
									<label class="signupLabel">Purchase Total</label>
							        <div class="signup__form-highlight">
								        <table class="purchase-breakdown" style="background:#fff;">
								          <tr>
								            <td>
								            	Monthly Membership Fee:
												<div id="discountCodeMonthlyMsg"></div>
								            </td>
								            <td id="chosenPlanMonthlyFeeDiv"><?php echo '$'.$chosen_plan['lmp_price']; ?></td>
								          </tr>
								          <?php if ($chosen_plan['lmp_billing_delay'] > 0) { ?>
								          <tr>
								          	<?php 
								          		echo '<td>$'.$chosen_plan['lmp_price'].'/mo. billing will begin on
								          		'.($chosen_plan['lmp_billing_delay'] > 0 && floatval($chosen_plan['lmp_fee']) * 1 == 0 ? '<br>Your credit card will be charged $0.01 today for authentication purposes.':'').'
								          		</td>';
							          			echo '<td>'.date('F d, Y', strtotime('now +'.intval($chosen_plan['lmp_billing_delay']).' months')).'</td>';
							          		?>
								          </tr>
								          <?php } ?>								          
								          <tr>
								            <td>
								            	One Time Setup Fee:
								            	<div id="discountCodeSetupMsg"></div>
								            </td>
								            <td id="chosenPlanSetupFeeDiv"><?php echo '$'.$chosen_plan['lmp_fee']; ?></td>
								          </tr>
								          <tr style="color:green;">
								            <td>
								            	<strong>Total Purchase Today:</strong>
								            	<div id="discountCodeTotalMsg"></div>
								            </td>
								            <td>
									            <strong id="originalTotalToday">
									            	<?php echo '$'.($chosen_plan['lmp_billing_delay'] > 0 && floatval($chosen_plan['lmp_fee']) * 1 == 0  ? '0.01' : 
									            	   ($chosen_plan['lmp_billing_delay'] > 0 ? $chosen_plan['lmp_fee'] : $chosen_plan['lmp_price'] + $chosen_plan['lmp_fee'])); ?>
									            </strong>
									            <div id="discountCodeTotalToday" style="font-weight: bold;"></div>
								            </td>
								          </tr>
								        </table>
							        </div>
								</div>
							</div>
						<?php } ?>
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<label><input type="checkbox" name="" required> I acknowledge that I have read and agree to the <a href="/terms" target="_blank">Terms and Conditions</a> and <a href="/privacy" target="_blank">Privacy Policy</a></label>
							</div>
						</div>
					</div>	
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<button type="submit" class="btn btn-success">Confirm Purchase</button>
							</div>
						</div>
					</div>							
				</form>
			</div>
		</div>
	</div>
</div>
</div>

<script src="/reseller/js/signup-step2-v1.js?v1.0.0"></script>