<?php
// this file is used in the merchant checkout process to validate a promo code
// and return the updated plan setup fee & monthly price

require_once $_SERVER['DOCUMENT_ROOT'].'/app/start_session.php';

use App\Reseller\DiscountCode as DiscountCode;

$response = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['adn64_discountCode'], $_POST['dec_pk_id_r'], $_SESSION['reseller']['id'])){
	require_once $_SERVER['DOCUMENT_ROOT'].'/app/function.connect.php';
	require_once $_SERVER['DOCUMENT_ROOT'].'/app/global.php';
	require_once $_SERVER['DOCUMENT_ROOT'].'/app/class.variables.php';
	
	$cv = new _variables(); // new clean variables instance
	$cv_array = array('adn64_discountCode','dec_pk_id_r'); // list all variables to be check in array
	foreach ($cv_array as $name=>$value) $cv->varible_in($value); //each variable is added to class by array loop
	$clean  = $cv->get_cleaned_variables();
	$errors = $cv->get_bad_variables();

	if (empty($errors)){
		require_once $_SERVER['DOCUMENT_ROOT']."/reseller/app/model/class.reseller-discount-code.php";
		require_once $_SERVER['DOCUMENT_ROOT'].'/app/class.package.php';
		$packageObject = new App\Package\package( $dbo, 0 );
		$discountCode = new DiscountCode\ResellerDiscountCode($dbo, $clean['discountCode']);

		// is it a valid code?
		$response['isValidCode'] = $discountCode->validateDiscountCode(  );
		$response['status']	     = 'success';

		// get the rest of the info if it is a valid code
		if ( $response['isValidCode'] ) {
			
			// get the plan the user would like to purchase
			
			$packRec = $packageObject->getPackageInfo($clean['pk_id']);
			
			if (!$packRec){
				// invalid plan ID was passed
				$response['status'] = 'error';
				$response['error']  = array('invalid_plan_id'=>'There was a problem with the plan you selected. Please contact support.');
			} 
			else {
				// return the discounted monthly fee
				$response['discountMonthlyFee'] = $discountCode->getDiscountMonthlyFee( $packRec['ppr_price'] );

				// return the date the discount ends
				$response['discountEndDate'] = $discountCode->getDiscountEndDate();

				// return the discounted setup fee
				$response['discountSetupFee'] = $discountCode->getDiscountSetupFee( $packRec['ppr_setup'] );

				// return the code formatted how it was entered in the DB
				$response['discountCode'] = $discountCode->getDiscountCode();
			}
		}
	}
	else {
		$response['status'] = 'error';
		$response['error']  = $errors;
	}

}

echo json_encode($response);
?>