<?php
include 'header.php';
include 'inc/functions.php';

function getPlanFeatures($dbo){
  // get all possible plan features
  $sql = 'SELECT lpf_feature, lpf_description, lpf_id FROM lt_plan_features LMP WHERE lpf_active = 1 AND lpf_display = 1 AND rpo_id = 1';
  $qry = $dbo->prepare( $sql );
  $qry->execute();
  $qry = $qry->fetchAll(PDO::FETCH_ASSOC);
  if(empty($qry)){
    // set array to avoid errors
    $results = array();
  } else {
    $results = $qry;
  }
  return $results;
}

function formatPlanFeatureValue($featureId, $planFeatures){
  foreach ($planFeatures as $k=>$v){
    if ($v['lpf_id'] == $featureId){
      switch ($featureId){
        case 7: // format customer service time from minutes to hours
          $display_val = round(($v['mfc_count'] / 60), 2);
          ($display_val == 0 ? $display_val = '' : 
          ($display_val == 1 ? $display_val = $display_val.' hour/mo.' : $display_val = $display_val.' hours/mo.'));
        break;

        default:
          $display_val = (is_null($v['mfc_count']) ? '<img src="/reseller/images/icon_checkmark_pricing_18px.svg" style="max-width: 20px;">' : number_format($v['mfc_count']));
        break;
      }
      echo $display_val;
    }
  }
}

$plan_features = getPlanFeatures($dbo);

$qry = $dbo->prepare( 'SELECT * FROM `tbl_reseller` WHERE res_id=:res_id' );
$qry->bindValue( ':res_id', $_SESSION['reseller']['id'], PDO::PARAM_INT );
$qry=execPDO($qry);
$currentReseller = $qry->fetch( PDO::FETCH_ASSOC );
?>
<link href="/reseller/css/pricing.css?v=1.0.0" rel="stylesheet">

<div class="pricing-hero">
  <div class="container">
    <div class="row">
      <div class="col-md-6">
        <div class="pricing-hero__text">
        <h1>
          <?php echo ( isset($currentReseller["res_pricing_header"]) ? $currentReseller["res_pricing_header"] : "Which plan is right for you?");  ?>
        </h1>
        <p>
          <?php echo ( isset($currentReseller["res_pricing_text"]) ? $currentReseller["res_pricing_text"] : "
            
              At Local Thanks<sup>sm</sup>, we share your businesses journey and have crafted our software to match where you are and anticipate where you want to be.
            
            "); 
          ?>
        </p>
        </div>
      </div>
      <?php if (isset($currentReseller["res_contact_youtube"])){ ?>
        <div class="col-md-6">
          <div class='embed-container'><iframe src='https://www.youtube.com/embed/<?php echo $currentReseller["res_contact_youtube"]; ?>?autoplay=0&amp;loop=0&amp;showinfo=0&amp;theme=dark&amp;color=red&amp;controls=1&amp;modestbranding=0&amp;start=0&amp;fs=1&amp;iv_load_policy=1&amp;wmode=transparent&amp;rel=0' frameborder='0' allowfullscreen></iframe></div>
        </div>
      <?php } ?>
    </div>
  </div>
</div>

<!-- <?php if (isset($currentReseller["res_contact_youtube"])){ ?>
  <div class="container" id="videoWrap">
    <div class="row">
      <div class="col-md-7 col-md-push-5">
        <div class='embed-container'><iframe src='https://www.youtube.com/embed/<?php echo $currentReseller["res_contact_youtube"]; ?>?autoplay=0&amp;loop=0&amp;showinfo=0&amp;theme=dark&amp;color=red&amp;controls=1&amp;modestbranding=0&amp;start=0&amp;fs=1&amp;iv_load_policy=1&amp;wmode=transparent&amp;rel=0' frameborder='0' allowfullscreen></iframe></div>
      </div>
    </div>
  </div>
<?php } ?> -->

<div class="container">
  <div class="row">
    <div class="col-xs-12">
      <div class="pricing-head">Choose the plan that best matches your goals today and helps you bring your vision to life tomorrow.</div>
      
      <!-- BEGIN DESKTOP PRICING TABLE -->
      <div class="pricing-table__fixed-head hidden-xs hidden-sm" id="fixedTableHeader" style="display:none;">
        <div class="container">
          <div class="row">
            <div class="col-xs-12">
              <div class="pricing-table clearfix">
                <div class="pricing-table__head">
                  <strong>Choose the plan<br>that best matches<br>your goals</strong>
                </div>
                <?php foreach($all_plans as $k=>$v){ ?>
                <div class="pricing-table__head <?php if ($v['lmp_featured']) { echo 'pricing-table__head--special'; } ?>">
                  <?php if ($v['lmp_featured']) { ?>
                  <div class="pricing-table__plan-special--text">
                    Most Popular
                  </div>
                  <div class="pricing-table__plan-special--ribbon-wrap">
                    <div class="pricing-table__plan-special--ribbon">
                      <!-- special plan indicator ribbon -->
                    </div>
                  </div>
                  <?php } ?>
                  <div class="pricing-table__plan-title">
                    <?php echo $v['lmp_name']; ?>
                  </div>
                  <div class="pricing-table__plan-detail <?php if ($v['lmp_featured']) { echo 'pricing-table__plan-detail--special'; } ?>">
                    <div class="pricing-table__plan-price">
                      <div class="pricing-table__plan-price__sign">$</div>
                      <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['lmp_price']); ?></div>
                      <div class="pricing-table__plan-price__mon">/mo</div>
                    </div>
                  </div>
                  <div class="pricing-table__plan-btn">
                    <a href="signup?step=1&amp;lmp_id=<?php echo $v['lmp_id']; ?>" class="btn btn-success">Buy Now</a>
                  </div>
                </div>
                <?php } ?>
              </div>
            </div>
          </div>
        </div>
      </div>  
          
      <div class="pricing-table clearfix hidden-xs hidden-sm" id="desktopPricing">
        <div class="pricing-table__head">
          <strong>Choose the plan<br>that best matches<br>your goals</strong>
        </div>
        <?php foreach($all_plans as $k=>$v){ ?>
        <div class="pricing-table__head <?php if ($v['lmp_featured']) { echo 'pricing-table__head--special'; } ?>">
          <?php if ($v['lmp_featured']) { ?>
          <div class="pricing-table__plan-special--text">
            Most Popular
          </div>
          <div class="pricing-table__plan-special--ribbon-wrap">
            <div class="pricing-table__plan-special--ribbon">
              <!-- special plan indicator ribbon -->
            </div>
          </div>
          <?php } ?>
          <div class="pricing-table__plan-title">
            <?php echo $v['lmp_name']; ?>
          </div>
          <div class="pricing-table__plan-detail <?php if ($v['lmp_featured']) { echo 'pricing-table__plan-detail--special'; } ?>">
            <div class="pricing-table__plan-price">
              <div class="pricing-table__plan-price__sign">$</div>
              <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['lmp_price']); ?></div>
              <div class="pricing-table__plan-price__mon">/mo</div>
            </div>
            <div class="pricing-table__plan-desc">
              <?php echo $v['lmp_description']; ?>
            </div>
          </div>
          <div class="pricing-table__plan-btn">
            <a href="signup?step=1&amp;lmp_id=<?php echo $v['lmp_id']; ?>" class="btn btn-success">Buy Now</a>
          </div>
        </div>
        <?php } ?>
        <div class="pricing-table__body" id="pricingTableBody">
          <div class="pricing-table__row">
            <div class="pricing-table__col">
              <div class="pricing-table__cell">
                Set Up
              </div>
            </div>
            <?php foreach($all_plans as $k=>$v){ ?>
            <div class="pricing-table__col <?php if ($v['lmp_featured']) { echo 'pricing-table__col--special';} ?>">
              <div class="pricing-table__cell">
                <?php echo ($v['lmp_fee'] == 0 ? '' : '$'.trimTrailingZeroes($v['lmp_fee'])); ?>
              </div>
            </div>
            <?php } ?>
          </div>
          <?php foreach($plan_features as $k=>$v){ ?>
          <div class="pricing-table__row">
            <div class="pricing-table__col">
              <div class="pricing-table__cell">
                <?php echo $v['lpf_feature']; ?>
                <?php if ($v['lpf_description']) { ?>
                <img src="/reseller/images/icon_tooltip_questionmark_pricing_18px.svg" style="max-width: 20px;" data-toggle="popover" data-content="<?php echo $v['lpf_description']; ?>">
                <?php } ?>
              </div>
            </div>
            <?php foreach($all_plans as $k1=>$v1){ ?>
            <div class="pricing-table__col <?php if ($v1['lmp_featured']) { echo 'pricing-table__col--special';} ?>">
              <div class="pricing-table__cell">
                <?php formatPlanFeatureValue($v['lpf_id'], $v1['lmp_features']); ?>
              </div>
            </div>
            <?php } ?>
          </div>
          <?php } ?>
        </div>
      </div>
      <!-- END DESKTOP PRICING TABLE -->

      <!-- BEGIN MOBILE PRICING TABLE -->
      <div class="mobile-pricing-table__fixed-head visible-xs visible-sm hidden" id="mobileFixedTableHeader" style="display:none;">
        <div class="container">
          <div class="row">
            <div class="col-xs-12">
              <div class="mobile-pricing clearfix">
              <?php
              $featured_flag = false;
              foreach($all_plans as $k=>$v){ ?>
              <div class="pricing-table__head <?php echo ($v['lmp_featured'] || ($k == count($all_plans) - 1 && $featured_flag == false) ? 'active' : ''); 
                                                    ($v['lmp_featured'] ? $featured_flag = true : '' );  ?>" 
                                                    id="fixed_lmp_id_<?php echo $v['lmp_id']; ?>">
                <div class="pricing-table__plan-title">
                  <?php echo $v['lmp_name']; ?>
                </div>
                <div class="pricing-table__plan-detail">
                  <div class="pricing-table__plan-price">
                    <div class="pricing-table__plan-price__sign">$</div>
                    <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['lmp_price']); ?></div>
                    <div class="pricing-table__plan-price__mon">/mo</div>
                  </div>
                </div>
                <div class="pricing-table__plan-btn">
                  <a href="signup?step=1&amp;lmp_id=<?php echo $v['lmp_id']; ?>" class="btn btn-success">Buy Now</a>
                </div>
              </div>
              <?php } ?>
              </div>
            </div>
          </div>
        </div>
      </div>     

      <div class="mobile-pricing clearfix visible-xs visible-sm" id="mobilePricing">
        <div class="btn-group btn-group-justified" data-toggle="buttons">
          <?php
          $featured_flag = false;
          foreach($all_plans as $k=>$v){ ?>
          <label class="btn btn-default mobile-pricing__opt <?php echo ($v['lmp_featured'] ? 'mobile-pricing__opt--special' : ''); ?> <?php echo ($v['lmp_featured'] || ($k == count($all_plans) - 1 && $featured_flag == false) ? 'active' : ''); ($v['lmp_featured'] ? $featured_flag = true : '' ); ?>" data-id="<?php echo $v['lmp_id']; ?>">
            <input type="radio" name="mobile-pricing-opt" autocomplete="off" <?php echo ($v['lmp_featured'] || ($k == count($all_plans) - 1 && $featured_flag == false) ? 'checked' : ''); ($v['lmp_featured'] ? $featured_flag = true : '' ); ?>> <?php echo $v['lmp_name']; ?>
          </label>
          <?php } ?>
        </div>
        <?php
        $featured_flag = false;
        foreach($all_plans as $k=>$v){ ?>
        <div class="pricing-table__head <?php echo ($v['lmp_featured'] || ($k == count($all_plans) - 1 && $featured_flag == false) ? 'active' : ''); ($v['lmp_featured'] ? $featured_flag = true : '' ); ?>" id="lmp_id_<?php echo $v['lmp_id']; ?>">
          <div class="pricing-table__plan-title">
            <?php echo $v['lmp_name']; ?>
          </div>
          <div class="pricing-table__plan-detail">
            <div class="pricing-table__plan-price">
              <div class="pricing-table__plan-price__sign">$</div>
              <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['lmp_price']); ?></div>
              <div class="pricing-table__plan-price__mon">/mo</div>
            </div>
            <div class="pricing-table__plan-desc">
              <?php echo $v['lmp_description']; ?>
            </div>
          </div>
          <div class="pricing-table__plan-btn">
            <a href="signup?step=1&amp;lmp_id=<?php echo $v['lmp_id']; ?>" class="btn btn-success">Buy Now</a>
          </div>
          <div class="pricing-table__body <?php echo ($v['lmp_featured'] || ($k == count($all_plans) - 1 && $featured_flag == false) ? 'active' : ''); 
                                                    ($v['lmp_featured'] ? $featured_flag = true : '' );  ?>">
            <div class="pricing-table__row">
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  Set Up
                </div>
              </div>
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  <?php echo ($v['lmp_fee'] == 0 ? '' : '$'.trimTrailingZeroes($v['lmp_fee'])); ?>
                </div>
              </div>
            </div>
            <?php foreach($plan_features as $k1=>$v1){ ?>
            <div class="pricing-table__row">
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  <?php echo $v1['lpf_feature']; ?>
                  <?php if ($v1['lpf_description']) { ?>
                  <a tabindex="<?php echo $k1; ?>" role="button" data-toggle="popover" data-content="<?php echo $v1['lpf_description']; ?>"><img src="/reseller/images/icon_tooltip_questionmark_pricing_18px.svg" style="max-width: 20px;"></a>
                  <?php } ?>
                </div>
              </div>
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  <?php formatPlanFeatureValue($v1['lpf_id'], $v['lmp_features']); ?>
                </div>
              </div>
            </div>
            <?php } ?>
          </div>
        </div>
        <?php } ?>
      </div>
      <!-- END MOBILE PRICING TABLE -->

      <div class="pricing-head">
        Local Thanks<sup>sm</sup> gives businesses the advantage of affordable, easy to use marketing technology that increases sales, customer loyalty, and profitability!
      </div>
    </div>
  </div>
</div>

<script src="/reseller/js/pricing.js?v=1.0.1"></script>

<?php include 'footer.php'; ?>