<?php
include 'header.php';
include 'inc/functions.php';

function formatPlanFeatureValue ( $value ) {
	$display_val = '';
	if (isset($value['prod_id']) && ( isset($value['prod_keyword']) || is_null($value['prod_keyword']) ) && ( isset($value['p2p_count']) || is_null($value['p2p_count']) )) {
		//echo $value['prod_id'];
		switch ( $value["prod_keyword"] ) {
			case "LT_FULL_SERVICE" : //format customer service time from minutes to hours
				$display_val = round(($value['p2p_count'] / 60), 2);
				($display_val == 0 ? $display_val = '' : 
				($display_val == 1 ? $display_val = $display_val . ' hour/mo.' : $display_val = $display_val . ' hours/mo.'));
			break;
			default:
				if ( is_null( $value['p2p_count'] ) ){
					$display_val = '<img src="/reseller/images/icon_checkmark_pricing_18px.svg" style="max-width: 20px;">';
				}
				else if ( $value['p2p_count'][0] === "$" ) {
					$display_val = $value['p2p_count'];
				}
				else {
					$display_val = number_format( $value['p2p_count'] );
				}
		}
	}
  	echo $display_val;
}

$currentReseller = $resellerObject->getRecords($_SESSION['reseller']['id']);

?>
<link href="/reseller/css/pricing.css?v=1.0.0" rel="stylesheet">

<div class="pricing-hero">
  <div class="container">
    <div class="row">
      <div class="col-md-6">
        <div class="pricing-hero__text">
        <h1>
          <?php echo ( isset($currentReseller["res_pricing_header"]) ? $currentReseller["res_pricing_header"] : "Which plan is right for you?");  ?>
        </h1>
        <p>
          <?php echo ( isset($currentReseller["res_pricing_text"]) ? $currentReseller["res_pricing_text"] : "
            
              At Local Thanks<sup>sm</sup>, we share your businesses journey and have crafted our software to match where you are and anticipate where you want to be.
            
            "); 
          ?>
        </p>
        </div>
      </div>
      <?php if (isset($currentReseller["res_contact_youtube"])){ ?>
        <div class="col-md-6">
          <div class='embed-container'><iframe src='https://www.youtube.com/embed/<?php echo $currentReseller["res_contact_youtube"]; ?>?autoplay=0&amp;loop=0&amp;showinfo=0&amp;theme=dark&amp;color=red&amp;controls=1&amp;modestbranding=0&amp;start=0&amp;fs=1&amp;iv_load_policy=1&amp;wmode=transparent&amp;rel=0' frameborder='0' allowfullscreen></iframe></div>
        </div>
      <?php } ?>
    </div>
  </div>
</div>

<!-- <?php if (isset($currentReseller["res_contact_youtube"])){ ?>
  <div class="container" id="videoWrap">
    <div class="row">
      <div class="col-md-7 col-md-push-5">
        <div class='embed-container'><iframe src='https://www.youtube.com/embed/<?php echo $currentReseller["res_contact_youtube"]; ?>?autoplay=0&amp;loop=0&amp;showinfo=0&amp;theme=dark&amp;color=red&amp;controls=1&amp;modestbranding=0&amp;start=0&amp;fs=1&amp;iv_load_policy=1&amp;wmode=transparent&amp;rel=0' frameborder='0' allowfullscreen></iframe></div>
      </div>
    </div>
  </div>
<?php } ?> -->

<div class="container">
  <div class="row">
    <div class="col-xs-12">
      <div class="pricing-head">Choose the plan that best matches your goals today and helps you bring your vision to life tomorrow.</div>
      
      <!-- BEGIN DESKTOP PRICING TABLE -->
      <div class="pricing-table__fixed-head hidden-xs hidden-sm" id="fixedTableHeader" style="display:none;">
        <div class="container">
          <div class="row">
            <div class="col-xs-12">
              <div class="pricing-table clearfix">
                <div class="pricing-table__head">
                  <strong>Choose the plan<br>that best matches<br>your goals</strong>
                </div>
                <?php foreach($all_plans as $k=>$v){ ?>
                <div class="pricing-table__head <?php if (intval($v['p2r_featured']) === 1) { echo 'pricing-table__head--special'; } ?>">
                  <?php if (intval($v['p2r_featured']) === 1) { ?>
                  <div class="pricing-table__plan-special--text">
                    Most Popular
                  </div>
                  <div class="pricing-table__plan-special--ribbon-wrap">
                    <div class="pricing-table__plan-special--ribbon">
                      <!-- special plan indicator ribbon -->
                    </div>
                  </div>
                  <?php } ?>
                  <div class="pricing-table__plan-title">
                    <?php echo $v['prod_name']; ?>
                  </div>
                  <div class="pricing-table__plan-detail <?php if (intval($v['p2r_featured']) === 1) { echo 'pricing-table__plan-detail--special'; } ?>">
                    <div class="pricing-table__plan-price">
                      <div class="pricing-table__plan-price__sign">$</div>
                      <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['ppr_price']); ?></div>
                      <div class="pricing-table__plan-price__mon">/mo</div>
                    </div>
                  </div>
                  <div class="pricing-table__plan-btn">
                    <a href="signup?step=1&amp;pk_id=<?php echo $v['pk_id']; ?>" class="btn btn-success">Buy Now</a>
                  </div>
                </div>
                <?php } ?>
              </div>
            </div>
          </div>
        </div>
      </div>  
          
      <div class="pricing-table clearfix hidden-xs hidden-sm" id="desktopPricing">
        <div class="pricing-table__head">
          <strong>Choose the plan<br>that best matches<br>your goals</strong>
        </div>
        <?php foreach($all_plans as $k=>$v){ ?>
        <div class="pricing-table__head <?php if (intval($v['p2r_featured']) === 1) { echo 'pricing-table__head--special'; } ?>">
          <?php if (intval($v['p2r_featured']) === 1) { ?>
          <div class="pricing-table__plan-special--text">
            Most Popular
          </div>
          <div class="pricing-table__plan-special--ribbon-wrap">
            <div class="pricing-table__plan-special--ribbon">
              <!-- special plan indicator ribbon -->
            </div>
          </div>
          <?php } ?>
          <div class="pricing-table__plan-title">
            <?php echo $v['prod_name']; ?>
          </div>
          <div class="pricing-table__plan-detail <?php if (intval($v['p2r_featured']) === 1) { echo 'pricing-table__plan-detail--special'; } ?>">
            <div class="pricing-table__plan-price">
              <div class="pricing-table__plan-price__sign">$</div>
              <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['ppr_price']); ?></div>
              <div class="pricing-table__plan-price__mon">/mo</div>
            </div>
            <div class="pricing-table__plan-desc">
              <?php echo $v['prod_descript']; ?>
            </div>
          </div>
          <div class="pricing-table__plan-btn">
            <a href="signup?step=1&amp;pk_id=<?php echo $v['pk_id']; ?>" class="btn btn-success">Buy Now</a>
          </div>
        </div>
        <?php } ?>
        <div class="pricing-table__body" id="pricingTableBody">
          <div class="pricing-table__row">
            <div class="pricing-table__col">
              <div class="pricing-table__cell">
                Set Up
              </div>
            </div>
            <?php foreach($all_plans as $k=>$v){ ?>
            <div class="pricing-table__col <?php if (intval($v['p2r_featured']) === 1) { echo 'pricing-table__col--special';} ?>">
              <div class="pricing-table__cell">
                <?php echo ($v['ppr_setup'] == 0 ? '' : '$'.trimTrailingZeroes($v['ppr_setup'])); ?>
              </div>
            </div>
            <?php } ?>
          </div>
          <?php 		  
		  
		  foreach( $packagesRecsAll as $k => $v ) {
		  ?>
          <div class="pricing-table__row">
            <div class="pricing-table__col">
              <div class="pricing-table__cell">
                <?php echo $v['prod_name']; ?>
                <?php if ($v['prod_descript']) { ?>
                <img src="/reseller/images/icon_tooltip_questionmark_pricing_18px.svg" style="max-width: 20px;" data-toggle="popover" data-content="<?php echo $v['prod_descript']; ?>">
                <?php } ?>
              </div>
            </div>
            <?php foreach( $all_plans as $k1 => $v1 ) { ?>
            <div class="pricing-table__col <?php if ( intval( $v1['p2r_featured'] ) === 1 ) { echo 'pricing-table__col--special';} ?>">
              <div class="pricing-table__cell">
                <?php formatPlanFeatureValue( $packagesRecs[$v1['pk_id']][$v['prod_id']]['Data'] ); ?>
              </div>
            </div>
            <?php } ?>
          </div>
          <?php } ?>
        </div>
      </div>
      <!-- END DESKTOP PRICING TABLE -->

      <!-- BEGIN MOBILE PRICING TABLE -->
      <div class="mobile-pricing-table__fixed-head visible-xs visible-sm hidden" id="mobileFixedTableHeader" style="display:none;">
        <div class="container">
          <div class="row">
            <div class="col-xs-12">
              <div class="mobile-pricing clearfix">
              <?php
              $featured_flag = false;
              foreach($all_plans as $k=>$v){ ?>
              <div class="pricing-table__head <?php echo ($v['lmp_featured'] || ($k == count($all_plans) - 1 && $featured_flag == false) ? 'active' : ''); 
                                                    ($v['lmp_featured'] ? $featured_flag = true : '' );  ?>" 
                                                    id="fixed_lmp_id_<?php echo $v['lmp_id']; ?>">
                <div class="pricing-table__plan-title">
                  <?php echo $v['lmp_name']; ?>
                </div>
                <div class="pricing-table__plan-detail">
                  <div class="pricing-table__plan-price">
                    <div class="pricing-table__plan-price__sign">$</div>
                    <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['lmp_price']); ?></div>
                    <div class="pricing-table__plan-price__mon">/mo</div>
                  </div>
                </div>
                <div class="pricing-table__plan-btn">
                  <a href="signup?step=1&amp;lmp_id=<?php echo $v['lmp_id']; ?>" class="btn btn-success">Buy Now</a>
                </div>
              </div>
              <?php } ?>
              </div>
            </div>
          </div>
        </div>
      </div>     

      <div class="mobile-pricing clearfix visible-xs visible-sm" id="mobilePricing">
        <div class="btn-group btn-group-justified" data-toggle="buttons">
          <?php
          $featured_flag = false;
          foreach($all_plans as $k=>$v){ ?>
          <label class="btn btn-default mobile-pricing__opt <?php echo ($v['lmp_featured'] ? 'mobile-pricing__opt--special' : ''); ?> <?php echo ($v['lmp_featured'] || ($k == count($all_plans) - 1 && $featured_flag == false) ? 'active' : ''); ($v['lmp_featured'] ? $featured_flag = true : '' ); ?>" data-id="<?php echo $v['lmp_id']; ?>">
            <input type="radio" name="mobile-pricing-opt" autocomplete="off" <?php echo ($v['lmp_featured'] || ($k == count($all_plans) - 1 && $featured_flag == false) ? 'checked' : ''); ($v['lmp_featured'] ? $featured_flag = true : '' ); ?>> <?php echo $v['lmp_name']; ?>
          </label>
          <?php } ?>
        </div>
        <?php
        $featured_flag = false;
        foreach($all_plans as $k=>$v){ ?>
        <div class="pricing-table__head <?php echo ($v['lmp_featured'] || ($k == count($all_plans) - 1 && $featured_flag == false) ? 'active' : ''); ($v['lmp_featured'] ? $featured_flag = true : '' ); ?>" id="lmp_id_<?php echo $v['lmp_id']; ?>">
          <div class="pricing-table__plan-title">
            <?php echo $v['lmp_name']; ?>
          </div>
          <div class="pricing-table__plan-detail">
            <div class="pricing-table__plan-price">
              <div class="pricing-table__plan-price__sign">$</div>
              <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['lmp_price']); ?></div>
              <div class="pricing-table__plan-price__mon">/mo</div>
            </div>
            <div class="pricing-table__plan-desc">
              <?php echo $v['lmp_description']; ?>
            </div>
          </div>
          <div class="pricing-table__plan-btn">
            <a href="signup?step=1&amp;lmp_id=<?php echo $v['lmp_id']; ?>" class="btn btn-success">Buy Now</a>
          </div>
          <div class="pricing-table__body <?php echo ($v['lmp_featured'] || ($k == count($all_plans) - 1 && $featured_flag == false) ? 'active' : ''); 
                                                    ($v['lmp_featured'] ? $featured_flag = true : '' );  ?>">
            <div class="pricing-table__row">
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  Set Up
                </div>
              </div>
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  <?php echo ($v['lmp_fee'] == 0 ? '' : '$'.trimTrailingZeroes($v['lmp_fee'])); ?>
                </div>
              </div>
            </div>
            <?php foreach($plan_features as $k1=>$v1){ ?>
            <div class="pricing-table__row">
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  <?php echo $v1['lpf_feature']; ?>
                  <?php if ($v1['lpf_description']) { ?>
                  <a tabindex="<?php echo $k1; ?>" role="button" data-toggle="popover" data-content="<?php echo $v1['lpf_description']; ?>"><img src="/reseller/images/icon_tooltip_questionmark_pricing_18px.svg" style="max-width: 20px;"></a>
                  <?php } ?>
                </div>
              </div>
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  <?php formatPlanFeatureValue($v1['lpf_id'], $v['lmp_features']); ?>
                </div>
              </div>
            </div>
            <?php } ?>
          </div>
        </div>
        <?php } ?>
      </div>
      <!-- END MOBILE PRICING TABLE -->

      <div class="pricing-head">
        Local Thanks<sup>sm</sup> gives businesses the advantage of affordable, easy to use marketing technology that increases sales, customer loyalty, and profitability!
      </div>
    </div>
  </div>
</div>

<script src="/reseller/js/pricing.js?v=1.0.1"></script>

<?php include 'footer.php'; ?>