$(document).ready(function(){

  // check if we need to display the fixed table header on desktop
  (function () {
    var whenToShow = $('#pricingTableBody').offset().top - 100;
    $(window).on('resize', function(){
      whenToShow = $('#pricingTableBody').offset().top - 100; // fixes users playing with their browsers like accordions
    });
    var fixedTableHeader = $('#fixedTableHeader');
    var desktopPricing = $('#desktopPricing');

    setInterval(function(){
      if ($(window).scrollTop() > whenToShow && desktopPricing.is(":hidden") == false){
        fixedTableHeader.slideDown('fast');
      } else {
        fixedTableHeader.slideUp('fast');
      }
    }, 200);
  })();


  // check if we need to display the fixed table header on mobile
  (function () {
    var whenToShow = $('.pricing-table__body.active').offset().top - 100;
    var fixedTableHeader = $('#mobileFixedTableHeader');
    var mobilePricing = $('#mobilePricing');

    $(window).on('resize', function(){
      whenToShow = $('.pricing-table__body.active').offset().top - 100; // fixes users playing with their browsers like accordions
    });

    setInterval(function(){
      if ($(window).scrollTop() > whenToShow && mobilePricing.is(":hidden") == false){
        fixedTableHeader.removeClass('hidden');
      } else {
        fixedTableHeader.addClass('hidden');
      }
    }, 200);
  })();

  // handle mobile pricing tabs
  (function () {
    var mobilePricingOpt = $('.mobile-pricing__opt');
    $('.mobile-pricing__opt').on('click', function(e){
      $('.pricing-table__head.active').removeClass('active');
      $('#lmp_id_'+$(this).data('id')).addClass('active');
      $('#fixed_lmp_id_'+$(this).data('id')).addClass('active');
    });
  })();

  // initialize popovers
  (function () {
    var is_touch_device = ("ontouchstart" in window) || window.DocumentTouch && document instanceof DocumentTouch;
    $('[data-toggle="popover"]').popover({
      placement: 'right',
      trigger: is_touch_device ? "click focus" : "hover focus"
    });
  })();

});