$(document).ready(function(){

  var $applyDiscountCode = $('#applyDiscountCode');
  var $discountCodeVal   = $('#discountCodeVal');
  var $selectedPlanId = $('#selectedPlanId');
  var $discountCodeMsgDiv = $('#discountCodeMsgDiv');
  var $discountCodeReset = $('#discountCodeReset');

  var $discountCodeMonthlyMsg = $('#discountCodeMonthlyMsg');
  var $discountCodeSetupMsg   = $('#discountCodeSetupMsg');
  var $discountCodeTotalToday = $('#discountCodeTotalToday');

  var $chosenPlanSetupFee = $('#chosenPlanSetupFee');
  var $chosenPlanSetupFeeDiv = $('#chosenPlanSetupFeeDiv');

  var $chosenPlanMonthlyFeeDiv = $('#chosenPlanMonthlyFeeDiv');

  var $discountCodeTotalToday = $('#discountCodeTotalToday');
  var $originalTotalToday     = $('#originalTotalToday');
  
  var $discountCodeTerms = $('#discountCodeTerms');
  var $freeDiscountCodeTrial = $('.freeDiscountCodeTrial');
  
  $discountCodeReset.on('click', function(){
    $discountCodeMonthlyMsg.html("");
    $discountCodeSetupMsg.html("");
    $chosenPlanMonthlyFeeDiv.removeClass('strikethrough');
    $chosenPlanSetupFeeDiv.removeClass('strikethrough');
    $applyDiscountCode.prop('disabled', false);
    $discountCodeVal.prop('readonly', false).val("");
    $discountCodeReset.hide();
    $discountCodeMsgDiv.html("");
    $originalTotalToday.show();
    $discountCodeTotalToday.html("").hide();
	$discountCodeTerms.hide();
	$freeDiscountCodeTrial.hide();
  });


  // listen for ENTER button pressed in the discount code input
  $discountCodeVal.on('keypress', function (e) {
    if (e.keyCode == 13) {
      e.preventDefault();
      runDiscountCodeCall();
    }
  });

  // apply discount code button
  $applyDiscountCode.on('click', function(){
    runDiscountCodeCall();
  });


  function runDiscountCodeCall(){
    var data = {
      'adn64_discountCode': $discountCodeVal.val(),
      'dec_lmp_id_r': $selectedPlanId.val()
    }

    $.ajax({
      url: "reseller/app/view/inc/validate-promo-code-v1.php",
      type: "POST", 
      dataType: "json",      
      data:  data,
      error: function (response){ console.error('ERROR:', response); },
      success: function (response){
        //console.log(response);
        if (response.status === 'success'){
          // clear error div
          $discountCodeMsgDiv.html('');
          if (response.isValidCode){
            // display code is valid msg
            outputDiscountMsg({'valid_code':'Promo code applied!'}, 'success');

            $applyDiscountCode.prop('disabled', true);
            $discountCodeVal.prop('readonly', true).val(response.discountCode);
            $discountCodeReset.show();
			
            var monthlyFlag = response.discountMonthlyFee * 100 == 0;
			
            if (response.discountMonthlyFee != null){
              // update the checkout total display table
              $discountCodeMonthlyMsg.html(
                '<div class="alert alert-success">\
                  Promo code <strong>'+response.discountCode+'</strong> applied!\
                  <br />\
                  A discounted monthly fee of <strong>'+formatPrice(response.discountMonthlyFee)+'</strong>\
                  will apply until <strong>'+formatDate(response.discountEndDate)+'</strong>\
                </div>'
              );
              $chosenPlanMonthlyFeeDiv.addClass('strikethrough');
            }
			
			var setupFeeFlag = response.discountSetupFee * 100 == 0;
			
            if (+$chosenPlanSetupFee.text() != response.discountSetupFee){
              $discountCodeSetupMsg.html(
                '<div class="alert alert-success">\
                  Promo code <strong>'+response.discountCode+'</strong> applied!\
                  <br />\
                  You will be charged a discounted setup fee of <strong>'+formatPrice(response.discountSetupFee)+'</strong> today.\
                </div>'
              );
              $chosenPlanSetupFeeDiv.addClass('strikethrough');
            }
			
            if (response.discountMonthlyFee || response.discountSetupFee){
              // total price has changed, update display table
              $originalTotalToday.hide();
              var newTotal = (((response.discountMonthlyFee? response.discountMonthlyFee: Number($chosenPlanMonthlyFeeDiv.text().replace(/[^0-9\.]/g, '')) ) * 100) + (Number(response.discountSetupFee) * 100) ) / 100;
              $discountCodeTotalToday.html(formatPrice(newTotal)).show();
            }
			
			$discountCodeTerms.show();
			$freeDiscountCodeTrial.hide();
			if (setupFeeFlag && monthlyFlag) {
				$freeDiscountCodeTrial.show(); 
			}
			else {
				$discountCodeTerms.css('margin-top', '10px');
			}
			
          } 
          else {
            outputDiscountMsg({'invalid_code':'Invalid promo code.'}, 'danger');
          }
        } else {
            // error validating params
            outputDiscountMsg(response.error, 'danger');
        }
      }
    });  
  }

  function outputDiscountMsg(errorObj, alertClass){
    var errorHTML = '<div class="alert alert-'+alertClass+'">';
    for (var key in errorObj) {
      if (errorObj.hasOwnProperty(key)) {
        errorHTML += errorObj[key];
      }
    }
    errorHTML += '</div>';
    $discountCodeMsgDiv.html(errorHTML);   
  }

  function formatPrice(num){
    return '$' + Number(num).toFixed(2);
  }

  function formatDate(inputDate) {
      var date = new Date(inputDate);
      if (!isNaN(date.getTime())) {
          // Months use 0 index.
          return date.getMonth() + 1 + '/' + date.getDate() + '/' + date.getFullYear();
      }
  } 

});